/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.documentstore.collection;

import java.io.IOException;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetricOperation;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.DocumentStoreTestUtils;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.entity.TimelineEntityDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.entity.TimelineMetricSubDoc;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.flowactivity.FlowActivityDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.flowrun.FlowRunDocument;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDocumentOperations {
    private static final String MEMORY_ID = "MEMORY";
    private static final String FLOW_NAME = "DistributedShell";
    private static final String FLOW_VERSION = "1";

    @Test
    public void testTimelineEntityDocMergeOperation() throws IOException {
        TimelineEntityDocument actualEntityDoc = new TimelineEntityDocument();
        TimelineEntityDocument expectedEntityDoc = DocumentStoreTestUtils.bakeTimelineEntityDoc();
        Assertions.assertEquals((int)1, (int)actualEntityDoc.getInfo().size());
        Assertions.assertEquals((int)0, (int)actualEntityDoc.getMetrics().size());
        Assertions.assertEquals((int)0, (int)actualEntityDoc.getEvents().size());
        Assertions.assertEquals((int)0, (int)actualEntityDoc.getConfigs().size());
        Assertions.assertEquals((int)0, (int)actualEntityDoc.getIsRelatedToEntities().size());
        Assertions.assertEquals((int)0, (int)actualEntityDoc.getRelatesToEntities().size());
        actualEntityDoc.merge(expectedEntityDoc);
        Assertions.assertEquals((int)expectedEntityDoc.getInfo().size(), (int)actualEntityDoc.getInfo().size());
        Assertions.assertEquals((int)expectedEntityDoc.getMetrics().size(), (int)actualEntityDoc.getMetrics().size());
        Assertions.assertEquals((int)expectedEntityDoc.getEvents().size(), (int)actualEntityDoc.getEvents().size());
        Assertions.assertEquals((int)expectedEntityDoc.getConfigs().size(), (int)actualEntityDoc.getConfigs().size());
        Assertions.assertEquals((int)expectedEntityDoc.getRelatesToEntities().size(), (int)actualEntityDoc.getIsRelatedToEntities().size());
        Assertions.assertEquals((int)expectedEntityDoc.getRelatesToEntities().size(), (int)actualEntityDoc.getRelatesToEntities().size());
    }

    @Test
    public void testFlowActivityDocMergeOperation() throws IOException {
        FlowActivityDocument actualFlowActivityDoc = new FlowActivityDocument();
        FlowActivityDocument expectedFlowActivityDoc = DocumentStoreTestUtils.bakeFlowActivityDoc();
        Assertions.assertEquals((long)0L, (long)actualFlowActivityDoc.getDayTimestamp());
        Assertions.assertEquals((int)0, (int)actualFlowActivityDoc.getFlowActivities().size());
        Assertions.assertNull((Object)actualFlowActivityDoc.getFlowName());
        Assertions.assertEquals((Object)TimelineEntityType.YARN_FLOW_ACTIVITY.toString(), (Object)actualFlowActivityDoc.getType());
        Assertions.assertNull((Object)actualFlowActivityDoc.getUser());
        Assertions.assertNull((Object)actualFlowActivityDoc.getId());
        actualFlowActivityDoc.merge(expectedFlowActivityDoc);
        Assertions.assertEquals((long)expectedFlowActivityDoc.getDayTimestamp(), (long)actualFlowActivityDoc.getDayTimestamp());
        Assertions.assertEquals((int)expectedFlowActivityDoc.getFlowActivities().size(), (int)actualFlowActivityDoc.getFlowActivities().size());
        Assertions.assertEquals((Object)expectedFlowActivityDoc.getFlowName(), (Object)actualFlowActivityDoc.getFlowName());
        Assertions.assertEquals((Object)expectedFlowActivityDoc.getType(), (Object)actualFlowActivityDoc.getType());
        Assertions.assertEquals((Object)expectedFlowActivityDoc.getUser(), (Object)actualFlowActivityDoc.getUser());
        Assertions.assertEquals((Object)expectedFlowActivityDoc.getId(), (Object)actualFlowActivityDoc.getId());
        expectedFlowActivityDoc.addFlowActivity(FLOW_NAME, FLOW_VERSION, System.currentTimeMillis());
        actualFlowActivityDoc.merge(expectedFlowActivityDoc);
        Assertions.assertEquals((long)expectedFlowActivityDoc.getDayTimestamp(), (long)actualFlowActivityDoc.getDayTimestamp());
        Assertions.assertEquals((int)expectedFlowActivityDoc.getFlowActivities().size(), (int)actualFlowActivityDoc.getFlowActivities().size());
        Assertions.assertEquals((Object)expectedFlowActivityDoc.getFlowName(), (Object)actualFlowActivityDoc.getFlowName());
        Assertions.assertEquals((Object)expectedFlowActivityDoc.getType(), (Object)actualFlowActivityDoc.getType());
        Assertions.assertEquals((Object)expectedFlowActivityDoc.getUser(), (Object)actualFlowActivityDoc.getUser());
        Assertions.assertEquals((Object)expectedFlowActivityDoc.getId(), (Object)actualFlowActivityDoc.getId());
    }

    @Test
    public void testFlowRunDocMergeAndAggOperation() throws IOException {
        FlowRunDocument actualFlowRunDoc = new FlowRunDocument();
        FlowRunDocument expectedFlowRunDoc = DocumentStoreTestUtils.bakeFlowRunDoc();
        long timestamp = System.currentTimeMillis();
        long value = 0x5E05000L;
        TimelineMetric timelineMetric = new TimelineMetric();
        timelineMetric.setId(MEMORY_ID);
        timelineMetric.setType(TimelineMetric.Type.SINGLE_VALUE);
        timelineMetric.setRealtimeAggregationOp(TimelineMetricOperation.SUM);
        timelineMetric.addValue(timestamp, (Number)0x5E05000L);
        TimelineMetricSubDoc metricSubDoc = new TimelineMetricSubDoc(timelineMetric);
        expectedFlowRunDoc.getMetrics().put(MEMORY_ID, metricSubDoc);
        Assertions.assertNull((Object)actualFlowRunDoc.getClusterId());
        Assertions.assertNull((Object)actualFlowRunDoc.getFlowName());
        Assertions.assertNull((Object)actualFlowRunDoc.getFlowRunId());
        Assertions.assertNull((Object)actualFlowRunDoc.getFlowVersion());
        Assertions.assertNull((Object)actualFlowRunDoc.getId());
        Assertions.assertNull((Object)actualFlowRunDoc.getUsername());
        Assertions.assertEquals((Object)actualFlowRunDoc.getType(), (Object)TimelineEntityType.YARN_FLOW_RUN.toString());
        Assertions.assertEquals((long)0L, (long)actualFlowRunDoc.getMinStartTime());
        Assertions.assertEquals((long)0L, (long)actualFlowRunDoc.getMaxEndTime());
        Assertions.assertEquals((int)0, (int)actualFlowRunDoc.getMetrics().size());
        actualFlowRunDoc.merge(expectedFlowRunDoc);
        Assertions.assertEquals((Object)expectedFlowRunDoc.getClusterId(), (Object)actualFlowRunDoc.getClusterId());
        Assertions.assertEquals((Object)expectedFlowRunDoc.getFlowName(), (Object)actualFlowRunDoc.getFlowName());
        Assertions.assertEquals((Long)expectedFlowRunDoc.getFlowRunId(), (Long)actualFlowRunDoc.getFlowRunId());
        Assertions.assertEquals((Object)expectedFlowRunDoc.getFlowVersion(), (Object)actualFlowRunDoc.getFlowVersion());
        Assertions.assertEquals((Object)expectedFlowRunDoc.getId(), (Object)actualFlowRunDoc.getId());
        Assertions.assertEquals((Object)expectedFlowRunDoc.getUsername(), (Object)actualFlowRunDoc.getUsername());
        Assertions.assertEquals((Object)expectedFlowRunDoc.getType(), (Object)actualFlowRunDoc.getType());
        Assertions.assertEquals((long)expectedFlowRunDoc.getMinStartTime(), (long)actualFlowRunDoc.getMinStartTime());
        Assertions.assertEquals((long)expectedFlowRunDoc.getMaxEndTime(), (long)actualFlowRunDoc.getMaxEndTime());
        Assertions.assertEquals((int)expectedFlowRunDoc.getMetrics().size(), (int)actualFlowRunDoc.getMetrics().size());
        actualFlowRunDoc.merge(expectedFlowRunDoc);
        Assertions.assertEquals((Object)197173248L, (Object)((TimelineMetricSubDoc)actualFlowRunDoc.getMetrics().get(MEMORY_ID)).getSingleDataValue());
    }
}

