/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.documentstore;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntities;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorContext;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.DocumentStoreTestUtils;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.DocumentStoreTimelineWriterImpl;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.DocumentStoreUtils;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.TimelineDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.lib.DocumentStoreFactory;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.writer.DocumentStoreWriter;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.writer.DummyDocumentStoreWriter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestDocumentStoreTimelineWriterImpl {
    private final DocumentStoreWriter<TimelineDocument> documentStoreWriter = new DummyDocumentStoreWriter<TimelineDocument>();
    private final Configuration conf = new Configuration();
    private MockedStatic<DocumentStoreFactory> mockedFactory;

    @BeforeEach
    public void setUp() throws YarnException {
        this.conf.set("yarn.timeline-service.document-store.db-name", "TestDB");
        this.conf.set("yarn.timeline-service.document-store.cosmos-db.endpoint", "https://localhost:443");
        this.conf.set("yarn.timeline-service.document-store.cosmos-db.masterkey", "1234567");
        this.mockedFactory = Mockito.mockStatic(DocumentStoreFactory.class);
        this.mockedFactory.when(() -> DocumentStoreFactory.createDocumentStoreWriter((Configuration)((Configuration)ArgumentMatchers.any(Configuration.class)))).thenReturn(this.documentStoreWriter);
    }

    @AfterEach
    public void tearDown() {
        if (this.mockedFactory != null) {
            this.mockedFactory.close();
        }
    }

    @Test
    public void testFailOnNoCosmosDBConfigs() throws Exception {
        Assertions.assertThrows(YarnException.class, () -> DocumentStoreUtils.validateCosmosDBConf((Configuration)new Configuration()));
    }

    @Test
    public void testWritingToCosmosDB() throws Exception {
        DocumentStoreTimelineWriterImpl timelineWriter = new DocumentStoreTimelineWriterImpl();
        timelineWriter.serviceInit(this.conf);
        TimelineEntities entities = new TimelineEntities();
        entities.addEntities(DocumentStoreTestUtils.bakeTimelineEntities());
        entities.addEntity(DocumentStoreTestUtils.bakeTimelineEntityDoc().fetchTimelineEntity());
        this.mockedFactory.verify(() -> DocumentStoreFactory.createDocumentStoreWriter((Configuration)((Configuration)ArgumentMatchers.any(Configuration.class))), Mockito.times((int)4));
        TimelineCollectorContext context = new TimelineCollectorContext();
        context.setFlowName("TestFlow");
        context.setAppId("DUMMY_APP_ID");
        context.setClusterId("yarn_cluster");
        context.setUserId("test_user");
        timelineWriter.write(context, entities, UserGroupInformation.createRemoteUser((String)"test_user"));
    }
}

