/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.documentstore;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.DocumentStoreCollectionCreator;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.TimelineDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.lib.DocumentStoreFactory;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.writer.DocumentStoreWriter;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.writer.DummyDocumentStoreWriter;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestDocumentStoreCollectionCreator {
    private final DocumentStoreWriter<TimelineDocument> documentStoreWriter = new DummyDocumentStoreWriter<TimelineDocument>();
    private final Configuration conf = new Configuration();

    @BeforeEach
    public void setUp() throws YarnException {
        this.conf.set("yarn.timeline-service.document-store.db-name", "TestDB");
        this.conf.set("yarn.timeline-service.document-store.cosmos-db.endpoint", "https://localhost:443");
        this.conf.set("yarn.timeline-service.document-store.cosmos-db.masterkey", "1234567");
        Mockito.mockStatic(DocumentStoreFactory.class);
        Mockito.when((Object)DocumentStoreFactory.createDocumentStoreWriter((Configuration)((Configuration)ArgumentMatchers.any(Configuration.class)))).thenReturn(this.documentStoreWriter);
    }

    @Test
    public void collectionCreatorTest() {
        new DocumentStoreCollectionCreator().createTimelineSchema(new String[0]);
    }
}

