/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcachemanager;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ClientSCMProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.ReleaseSharedCacheResourceRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UseSharedCacheResourceRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.sharedcachemanager.AppChecker;
import org.apache.hadoop.yarn.server.sharedcachemanager.ClientProtocolService;
import org.apache.hadoop.yarn.server.sharedcachemanager.DummyAppChecker;
import org.apache.hadoop.yarn.server.sharedcachemanager.TestSharedCacheUploaderService;
import org.apache.hadoop.yarn.server.sharedcachemanager.metrics.ClientSCMMetrics;
import org.apache.hadoop.yarn.server.sharedcachemanager.store.InMemorySCMStore;
import org.apache.hadoop.yarn.server.sharedcachemanager.store.SCMStore;
import org.apache.hadoop.yarn.server.sharedcachemanager.store.SharedCacheResourceReference;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestClientSCMProtocolService {
    private static File testDir = null;
    private ClientProtocolService service;
    private ClientSCMProtocol clientSCMProxy;
    private SCMStore store;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    @BeforeAll
    public static void setupTestDirs() throws IOException {
        testDir = new File("target", TestSharedCacheUploaderService.class.getCanonicalName());
        testDir.delete();
        testDir.mkdirs();
        testDir = testDir.getAbsoluteFile();
    }

    @AfterAll
    public static void cleanupTestDirs() throws IOException {
        if (testDir != null) {
            testDir.delete();
        }
    }

    @BeforeEach
    public void startUp() {
        Configuration conf = new Configuration();
        conf.set("yarn.sharedcache.store.class", InMemorySCMStore.class.getName());
        conf.set("yarn.sharedcache.root-dir", testDir.getPath());
        AppChecker appChecker = (AppChecker)Mockito.spy((Object)((Object)new DummyAppChecker()));
        this.store = new InMemorySCMStore(appChecker);
        this.store.init(conf);
        this.store.start();
        this.service = new ClientProtocolService(this.store);
        this.service.init(conf);
        this.service.start();
        YarnRPC rpc = YarnRPC.create((Configuration)new Configuration());
        InetSocketAddress scmAddress = conf.getSocketAddr("yarn.sharedcache.client-server.address", "0.0.0.0:8045", 8045);
        this.clientSCMProxy = (ClientSCMProtocol)rpc.getProxy(ClientSCMProtocol.class, scmAddress, conf);
    }

    @AfterEach
    public void cleanUp() {
        if (this.store != null) {
            this.store.stop();
            this.store = null;
        }
        if (this.service != null) {
            this.service.stop();
            this.service = null;
        }
        if (this.clientSCMProxy != null) {
            RPC.stopProxy((Object)this.clientSCMProxy);
            this.clientSCMProxy = null;
        }
    }

    @Test
    void testUse_MissingEntry() throws Exception {
        long misses = ClientSCMMetrics.getInstance().getCacheMisses();
        UseSharedCacheResourceRequest request = (UseSharedCacheResourceRequest)this.recordFactory.newRecordInstance(UseSharedCacheResourceRequest.class);
        request.setResourceKey("key1");
        request.setAppId(this.createAppId(1, 1L));
        Assertions.assertNull((Object)this.clientSCMProxy.use(request).getPath());
        Assertions.assertEquals((long)1L, (long)(ClientSCMMetrics.getInstance().getCacheMisses() - misses), (String)"Client SCM metrics aren't updated.");
    }

    @Test
    void testUse_ExistingEntry_NoAppIds() throws Exception {
        this.store.addResource("key1", "foo.jar");
        long hits = ClientSCMMetrics.getInstance().getCacheHits();
        UseSharedCacheResourceRequest request = (UseSharedCacheResourceRequest)this.recordFactory.newRecordInstance(UseSharedCacheResourceRequest.class);
        request.setResourceKey("key1");
        request.setAppId(this.createAppId(2, 2L));
        String expectedPath = testDir.getAbsolutePath() + "/k/e/y/key1/foo.jar";
        Assertions.assertEquals((Object)expectedPath, (Object)this.clientSCMProxy.use(request).getPath());
        Assertions.assertEquals((int)1, (int)this.store.getResourceReferences("key1").size());
        Assertions.assertEquals((long)1L, (long)(ClientSCMMetrics.getInstance().getCacheHits() - hits), (String)"Client SCM metrics aren't updated.");
    }

    @Test
    void testUse_ExistingEntry_OneId() throws Exception {
        this.store.addResource("key1", "foo.jar");
        this.store.addResourceReference("key1", new SharedCacheResourceReference(this.createAppId(1, 1L), "user"));
        Assertions.assertEquals((int)1, (int)this.store.getResourceReferences("key1").size());
        long hits = ClientSCMMetrics.getInstance().getCacheHits();
        UseSharedCacheResourceRequest request = (UseSharedCacheResourceRequest)this.recordFactory.newRecordInstance(UseSharedCacheResourceRequest.class);
        request.setResourceKey("key1");
        request.setAppId(this.createAppId(2, 2L));
        String expectedPath = testDir.getAbsolutePath() + "/k/e/y/key1/foo.jar";
        Assertions.assertEquals((Object)expectedPath, (Object)this.clientSCMProxy.use(request).getPath());
        Assertions.assertEquals((int)2, (int)this.store.getResourceReferences("key1").size());
        Assertions.assertEquals((long)1L, (long)(ClientSCMMetrics.getInstance().getCacheHits() - hits), (String)"Client SCM metrics aren't updated.");
    }

    @Test
    void testUse_ExistingEntry_DupId() throws Exception {
        this.store.addResource("key1", "foo.jar");
        UserGroupInformation testUGI = UserGroupInformation.getCurrentUser();
        this.store.addResourceReference("key1", new SharedCacheResourceReference(this.createAppId(1, 1L), testUGI.getShortUserName()));
        Assertions.assertEquals((int)1, (int)this.store.getResourceReferences("key1").size());
        long hits = ClientSCMMetrics.getInstance().getCacheHits();
        UseSharedCacheResourceRequest request = (UseSharedCacheResourceRequest)this.recordFactory.newRecordInstance(UseSharedCacheResourceRequest.class);
        request.setResourceKey("key1");
        request.setAppId(this.createAppId(1, 1L));
        String expectedPath = testDir.getAbsolutePath() + "/k/e/y/key1/foo.jar";
        Assertions.assertEquals((Object)expectedPath, (Object)this.clientSCMProxy.use(request).getPath());
        Assertions.assertEquals((int)1, (int)this.store.getResourceReferences("key1").size());
        Assertions.assertEquals((long)1L, (long)(ClientSCMMetrics.getInstance().getCacheHits() - hits), (String)"Client SCM metrics aren't updated.");
    }

    @Test
    void testRelease_ExistingEntry_NonExistantAppId() throws Exception {
        this.store.addResource("key1", "foo.jar");
        this.store.addResourceReference("key1", new SharedCacheResourceReference(this.createAppId(1, 1L), "user"));
        Assertions.assertEquals((int)1, (int)this.store.getResourceReferences("key1").size());
        long releases = ClientSCMMetrics.getInstance().getCacheReleases();
        ReleaseSharedCacheResourceRequest request = (ReleaseSharedCacheResourceRequest)this.recordFactory.newRecordInstance(ReleaseSharedCacheResourceRequest.class);
        request.setResourceKey("key1");
        request.setAppId(this.createAppId(2, 2L));
        this.clientSCMProxy.release(request);
        Assertions.assertEquals((int)1, (int)this.store.getResourceReferences("key1").size());
        Assertions.assertEquals((long)0L, (long)(ClientSCMMetrics.getInstance().getCacheReleases() - releases), (String)"Client SCM metrics were updated when a release did not happen");
    }

    @Test
    void testRelease_ExistingEntry_WithAppId() throws Exception {
        this.store.addResource("key1", "foo.jar");
        UserGroupInformation testUGI = UserGroupInformation.getCurrentUser();
        this.store.addResourceReference("key1", new SharedCacheResourceReference(this.createAppId(1, 1L), testUGI.getShortUserName()));
        Assertions.assertEquals((int)1, (int)this.store.getResourceReferences("key1").size());
        long releases = ClientSCMMetrics.getInstance().getCacheReleases();
        ReleaseSharedCacheResourceRequest request = (ReleaseSharedCacheResourceRequest)this.recordFactory.newRecordInstance(ReleaseSharedCacheResourceRequest.class);
        request.setResourceKey("key1");
        request.setAppId(this.createAppId(1, 1L));
        this.clientSCMProxy.release(request);
        Assertions.assertEquals((int)0, (int)this.store.getResourceReferences("key1").size());
        Assertions.assertEquals((long)1L, (long)(ClientSCMMetrics.getInstance().getCacheReleases() - releases), (String)"Client SCM metrics aren't updated.");
    }

    @Test
    void testRelease_MissingEntry() throws Exception {
        long releases = ClientSCMMetrics.getInstance().getCacheReleases();
        ReleaseSharedCacheResourceRequest request = (ReleaseSharedCacheResourceRequest)this.recordFactory.newRecordInstance(ReleaseSharedCacheResourceRequest.class);
        request.setResourceKey("key2");
        request.setAppId(this.createAppId(2, 2L));
        this.clientSCMProxy.release(request);
        Assertions.assertNotNull((Object)this.store.getResourceReferences("key2"));
        Assertions.assertEquals((int)0, (int)this.store.getResourceReferences("key2").size());
        Assertions.assertEquals((long)0L, (long)(ClientSCMMetrics.getInstance().getCacheReleases() - releases), (String)"Client SCM metrics were updated when a release did not happen.");
    }

    private ApplicationId createAppId(int id, long timestamp) {
        return ApplicationId.newInstance((long)timestamp, (int)id);
    }
}

