/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebAppUtil;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ApplicationStatisticsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeLabelInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeLabelsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeToLabelsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.PartitionInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.StatisticsItemInfo;
import org.apache.hadoop.yarn.server.router.webapp.HTTPMethods;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.ConflictException;
import org.apache.hadoop.yarn.webapp.ForbiddenException;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RouterWebServiceUtil {
    private static String user = "YarnRouter";
    private static final Logger LOG = LoggerFactory.getLogger((String)RouterWebServiceUtil.class.getName());
    private static final String PARTIAL_REPORT = "Partial Report ";

    private RouterWebServiceUtil() {
    }

    protected static <T> T genericForward(String webApp, HttpServletRequest hsr, Class<T> returnType, HTTPMethods method, String targetPath, Object formParam, Map<String, String[]> additionalParam, Configuration conf, Client client) {
        UserGroupInformation callerUGI = hsr != null ? RMWebAppUtil.getCallerUserGroupInformation((HttpServletRequest)hsr, (boolean)true) : UserGroupInformation.createRemoteUser((String)user);
        if (callerUGI == null) {
            LOG.error("Unable to obtain user name, user not authenticated");
            return null;
        }
        try {
            return (T)callerUGI.doAs(() -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            });
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Response invokeRMWebService(String webApp, String path, HTTPMethods method, String additionalPath, Map<String, String[]> queryParams, Object formParam, String mediaType, Configuration conf, Client client) {
        InetSocketAddress socketAddress = NetUtils.getConnectAddress((InetSocketAddress)NetUtils.createSocketAddr((String)webApp));
        String scheme = YarnConfiguration.useHttps((Configuration)conf) ? "https://" : "http://";
        String webAddress = scheme + socketAddress.getHostName() + ":" + socketAddress.getPort();
        Client client1 = ClientBuilder.newClient();
        WebTarget webResource = client1.target(webAddress);
        webResource = additionalPath != null && !additionalPath.isEmpty() ? webResource.path(additionalPath) : webResource.path(path);
        LOG.info("webApp:{}, path:{}, method:{}, additionalPath:{}, queryParams:{}, formParam:{}, mediaType:{}, conf:{}", new Object[]{webApp, path, method, additionalPath, queryParams, formParam, mediaType, conf});
        if (queryParams != null && !queryParams.isEmpty()) {
            for (Map.Entry<String, String[]> param : queryParams.entrySet()) {
                String[] values = param.getValue();
                for (int i = 0; i < values.length; webResource = webResource.queryParam(param.getKey(), new Object[]{values[i]}), ++i) {
                }
            }
        }
        Invocation.Builder builder = webResource.request(new String[]{mediaType});
        Response response = null;
        try {
            switch (method) {
                case DELETE: {
                    response = (Response)builder.delete(Response.class);
                    return response;
                }
                case GET: {
                    response = (Response)builder.get(Response.class);
                    return response;
                }
                case POST: {
                    response = builder.post(Entity.entity((Object)formParam, (String)mediaType));
                    return response;
                }
                case PUT: {
                    response = (Response)builder.put(Entity.entity((Object)formParam, (String)mediaType), Response.class);
                    return response;
                }
            }
            return response;
        }
        finally {
            client.close();
        }
    }

    public static void retrieveException(Response response) {
        String serverErrorMsg = (String)response.readEntity(String.class);
        int status = response.getStatus();
        if (status == 400) {
            throw new BadRequestException(serverErrorMsg);
        }
        if (status == 403) {
            throw new ForbiddenException(serverErrorMsg);
        }
        if (status == 404) {
            throw new NotFoundException(serverErrorMsg);
        }
        if (status == 409) {
            throw new ConflictException(serverErrorMsg);
        }
    }

    public static AppsInfo mergeAppsInfo(ArrayList<AppInfo> appsInfo, boolean returnPartialResult) {
        AppsInfo allApps = new AppsInfo();
        HashMap<String, AppInfo> federationAM = new HashMap<String, AppInfo>();
        HashMap<String, AppInfo> federationUAMSum = new HashMap<String, AppInfo>();
        for (AppInfo a : appsInfo) {
            if (a.getAMHostHttpAddress() != null) {
                federationAM.put(a.getAppId(), a);
                if (!federationUAMSum.containsKey(a.getAppId())) continue;
                RouterWebServiceUtil.mergeAMWithUAM(a, (AppInfo)federationUAMSum.get(a.getAppId()));
                federationUAMSum.remove(a.getAppId());
                continue;
            }
            if (federationAM.containsKey(a.getAppId())) {
                RouterWebServiceUtil.mergeAMWithUAM((AppInfo)federationAM.get(a.getAppId()), a);
                continue;
            }
            if (federationUAMSum.containsKey(a.getAppId())) {
                federationUAMSum.put(a.getAppId(), RouterWebServiceUtil.mergeUAMWithUAM((AppInfo)federationUAMSum.get(a.getAppId()), a));
                continue;
            }
            federationUAMSum.put(a.getAppId(), a);
        }
        for (AppInfo a : federationUAMSum.values()) {
            if (!returnPartialResult && (a.getName() == null || a.getName().startsWith("UnmanagedAM") || a.getName().startsWith(PARTIAL_REPORT))) continue;
            federationAM.put(a.getAppId(), a);
        }
        allApps.addAll(new ArrayList(federationAM.values()));
        return allApps;
    }

    protected static Client createJerseyClient(Configuration conf) {
        Client client = ClientBuilder.newClient();
        long checkConnectTimeOut = conf.getLong("yarn.router.webapp.connect-timeout", 0L);
        int connectTimeOut = (int)conf.getTimeDuration("yarn.router.webapp.connect-timeout", YarnConfiguration.DEFAULT_ROUTER_WEBAPP_CONNECT_TIMEOUT, TimeUnit.MILLISECONDS);
        if (checkConnectTimeOut <= 0L || checkConnectTimeOut > Integer.MAX_VALUE) {
            LOG.warn("Configuration {} = {} ms error. We will use the default value({} ms).", new Object[]{"yarn.router.webapp.connect-timeout", connectTimeOut, YarnConfiguration.DEFAULT_ROUTER_WEBAPP_CONNECT_TIMEOUT});
            connectTimeOut = (int)TimeUnit.MILLISECONDS.convert(YarnConfiguration.DEFAULT_ROUTER_WEBAPP_CONNECT_TIMEOUT, TimeUnit.MILLISECONDS);
        }
        client.property("jersey.config.client.connectTimeout", (Object)connectTimeOut);
        long checkReadTimeout = conf.getLong("yarn.router.webapp.read-timeout", 0L);
        int readTimeout = (int)conf.getTimeDuration("yarn.router.webapp.read-timeout", YarnConfiguration.DEFAULT_ROUTER_WEBAPP_READ_TIMEOUT, TimeUnit.MILLISECONDS);
        if (checkReadTimeout < 0L || checkReadTimeout > Integer.MAX_VALUE) {
            LOG.warn("Configuration {} = {} ms error. We will use the default value({} ms).", new Object[]{"yarn.router.webapp.connect-timeout", connectTimeOut, YarnConfiguration.DEFAULT_ROUTER_WEBAPP_CONNECT_TIMEOUT});
            readTimeout = (int)TimeUnit.MILLISECONDS.convert(YarnConfiguration.DEFAULT_ROUTER_WEBAPP_CONNECT_TIMEOUT, TimeUnit.MILLISECONDS);
        }
        client.property("jersey.config.client.readTimeout", (Object)readTimeout);
        return client;
    }

    private static AppInfo mergeUAMWithUAM(AppInfo uam1, AppInfo uam2) {
        AppInfo partialReport = new AppInfo();
        partialReport.setAppId(uam1.getAppId());
        partialReport.setName(PARTIAL_REPORT + uam1.getAppId());
        partialReport.setState(uam1.getState());
        RouterWebServiceUtil.mergeAMWithUAM(partialReport, uam1);
        RouterWebServiceUtil.mergeAMWithUAM(partialReport, uam2);
        return partialReport;
    }

    private static void mergeAMWithUAM(AppInfo am, AppInfo uam) {
        am.setPreemptedResourceMB(am.getPreemptedResourceMB() + uam.getPreemptedResourceMB());
        am.setPreemptedResourceVCores(am.getPreemptedResourceVCores() + uam.getPreemptedResourceVCores());
        am.setNumNonAMContainerPreempted(am.getNumNonAMContainerPreempted() + uam.getNumNonAMContainerPreempted());
        am.setNumAMContainerPreempted(am.getNumAMContainerPreempted() + uam.getNumAMContainerPreempted());
        am.setPreemptedMemorySeconds(am.getPreemptedMemorySeconds() + uam.getPreemptedMemorySeconds());
        am.setPreemptedVcoreSeconds(am.getPreemptedVcoreSeconds() + uam.getPreemptedVcoreSeconds());
        if (am.getState() == YarnApplicationState.RUNNING && uam.getState() == am.getState()) {
            am.getResourceRequests().addAll(uam.getResourceRequests());
            am.setAllocatedMB(am.getAllocatedMB() + uam.getAllocatedMB());
            am.setAllocatedVCores(am.getAllocatedVCores() + uam.getAllocatedVCores());
            am.setReservedMB(am.getReservedMB() + uam.getReservedMB());
            am.setReservedVCores(am.getReservedVCores() + uam.getReservedMB());
            am.setRunningContainers(am.getRunningContainers() + uam.getRunningContainers());
            am.setMemorySeconds(am.getMemorySeconds() + uam.getMemorySeconds());
            am.setVcoreSeconds(am.getVcoreSeconds() + uam.getVcoreSeconds());
        }
    }

    public static NodesInfo deleteDuplicateNodesInfo(ArrayList<NodeInfo> nodes) {
        NodesInfo nodesInfo = new NodesInfo();
        LinkedHashMap<String, NodeInfo> nodesMap = new LinkedHashMap<String, NodeInfo>();
        for (NodeInfo node : nodes) {
            String nodeId = node.getNodeId();
            if (nodesMap.containsKey(nodeId)) {
                if (((NodeInfo)nodesMap.get(nodeId)).getLastHealthUpdate() >= node.getLastHealthUpdate()) continue;
                nodesMap.put(node.getNodeId(), node);
                continue;
            }
            nodesMap.put(node.getNodeId(), node);
        }
        nodesInfo.addAll(new ArrayList(nodesMap.values()));
        return nodesInfo;
    }

    public static void mergeMetrics(ClusterMetricsInfo metrics, ClusterMetricsInfo metricsResponse) {
        metrics.setAppsSubmitted(metrics.getAppsSubmitted() + metricsResponse.getAppsSubmitted());
        metrics.setAppsCompleted(metrics.getAppsCompleted() + metricsResponse.getAppsCompleted());
        metrics.setAppsPending(metrics.getAppsPending() + metricsResponse.getAppsPending());
        metrics.setAppsRunning(metrics.getAppsRunning() + metricsResponse.getAppsRunning());
        metrics.setAppsFailed(metrics.getAppsFailed() + metricsResponse.getAppsFailed());
        metrics.setAppsKilled(metrics.getAppsKilled() + metricsResponse.getAppsKilled());
        metrics.setReservedMB(metrics.getReservedMB() + metricsResponse.getReservedMB());
        metrics.setAvailableMB(metrics.getAvailableMB() + metricsResponse.getAvailableMB());
        metrics.setAllocatedMB(metrics.getAllocatedMB() + metricsResponse.getAllocatedMB());
        metrics.setReservedVirtualCores(metrics.getReservedVirtualCores() + metricsResponse.getReservedVirtualCores());
        metrics.setAvailableVirtualCores(metrics.getAvailableVirtualCores() + metricsResponse.getAvailableVirtualCores());
        metrics.setAllocatedVirtualCores(metrics.getAllocatedVirtualCores() + metricsResponse.getAllocatedVirtualCores());
        metrics.setContainersAllocated(metrics.getContainersAllocated() + metricsResponse.getContainersAllocated());
        metrics.setContainersReserved(metrics.getReservedContainers() + metricsResponse.getReservedContainers());
        metrics.setContainersPending(metrics.getPendingContainers() + metricsResponse.getPendingContainers());
        metrics.setTotalMB(metrics.getTotalMB() + metricsResponse.getTotalMB());
        metrics.setUtilizedMB(metrics.getUtilizedMB() + metricsResponse.getUtilizedMB());
        metrics.setTotalVirtualCores(metrics.getTotalVirtualCores() + metricsResponse.getTotalVirtualCores());
        metrics.setTotalNodes(metrics.getTotalNodes() + metricsResponse.getTotalNodes());
        metrics.setUtilizedVirtualCores(metrics.getUtilizedVirtualCores() + metricsResponse.getUtilizedVirtualCores());
        metrics.setLostNodes(metrics.getLostNodes() + metricsResponse.getLostNodes());
        metrics.setUnhealthyNodes(metrics.getUnhealthyNodes() + metricsResponse.getUnhealthyNodes());
        metrics.setDecommissioningNodes(metrics.getDecommissioningNodes() + metricsResponse.getDecommissioningNodes());
        metrics.setDecommissionedNodes(metrics.getDecommissionedNodes() + metricsResponse.getDecommissionedNodes());
        metrics.setRebootedNodes(metrics.getRebootedNodes() + metricsResponse.getRebootedNodes());
        metrics.setActiveNodes(metrics.getActiveNodes() + metricsResponse.getActiveNodes());
        metrics.setShutdownNodes(metrics.getShutdownNodes() + metricsResponse.getShutdownNodes());
        int utilizedVirtualCoresPercent = metrics.getTotalVirtualCores() <= 0L ? 0 : (int)(metrics.getUtilizedVirtualCores() * 100L / metrics.getTotalVirtualCores());
        metrics.setUtilizedVirtualCoresPercent(utilizedVirtualCoresPercent);
        int utilizedMBPercent = metrics.getTotalMB() <= 0L ? 0 : (int)(metrics.getUtilizedMB() * 100L / metrics.getTotalMB());
        metrics.setUtilizedMBPercent(utilizedMBPercent);
    }

    protected static <T> String getMediaTypeFromHttpServletRequest(HttpServletRequest request, Class<T> returnType) {
        if (request == null) {
            return "application/xml";
        }
        if (!returnType.equals(Response.class)) {
            return "application/xml";
        }
        String header = request.getHeader("Accept");
        if (header == null || header.equals("*")) {
            return "application/json";
        }
        return header;
    }

    public static NodeToLabelsInfo mergeNodeToLabels(Map<SubClusterInfo, NodeToLabelsInfo> nodeToLabelsInfoMap) {
        HashMap nodeToLabels = new HashMap();
        Collection<NodeToLabelsInfo> nodeToLabelsInfos = nodeToLabelsInfoMap.values();
        nodeToLabelsInfos.stream().forEach(nodeToLabelsInfo -> {
            for (Map.Entry item : nodeToLabelsInfo.getNodeToLabels().entrySet()) {
                String key = (String)item.getKey();
                NodeLabelsInfo itemValue = (NodeLabelsInfo)item.getValue();
                NodeLabelsInfo nodeToLabelsValue = nodeToLabels.getOrDefault(item.getKey(), null);
                HashSet hashSet = new HashSet();
                if (itemValue != null) {
                    hashSet.addAll(itemValue.getNodeLabels());
                }
                if (nodeToLabelsValue != null) {
                    hashSet.addAll(nodeToLabelsValue.getNodeLabels());
                }
                nodeToLabels.put(key, new NodeLabelsInfo(hashSet));
            }
        });
        return new NodeToLabelsInfo(nodeToLabels);
    }

    public static ApplicationStatisticsInfo mergeApplicationStatisticsInfo(Collection<ApplicationStatisticsInfo> appStatistics) {
        ApplicationStatisticsInfo result = new ApplicationStatisticsInfo();
        HashMap statisticsItemMap = new HashMap();
        appStatistics.stream().forEach(appStatistic -> {
            ArrayList statisticsItemInfos = appStatistic.getStatItems();
            for (StatisticsItemInfo statisticsItemInfo : statisticsItemInfos) {
                StatisticsItemInfo statisticsItemValue;
                String statisticsItemKey = statisticsItemInfo.getType() + "_" + statisticsItemInfo.getState().toString();
                if (statisticsItemMap.containsKey(statisticsItemKey)) {
                    statisticsItemValue = (StatisticsItemInfo)statisticsItemMap.get(statisticsItemKey);
                    long statisticsItemValueCount = statisticsItemValue.getCount();
                    long statisticsItemInfoCount = statisticsItemInfo.getCount();
                    long newCount = statisticsItemValueCount + statisticsItemInfoCount;
                    statisticsItemValue.setCount(newCount);
                } else {
                    statisticsItemValue = new StatisticsItemInfo(statisticsItemInfo);
                }
                statisticsItemMap.put(statisticsItemKey, statisticsItemValue);
            }
        });
        if (!statisticsItemMap.isEmpty()) {
            result.getStatItems().addAll(statisticsItemMap.values());
        }
        return result;
    }

    public static NodeLabelsInfo mergeNodeLabelsInfo(Map<SubClusterInfo, NodeLabelsInfo> paramMap) {
        HashMap resultMap = new HashMap();
        paramMap.values().stream().flatMap(nodeLabelsInfo -> nodeLabelsInfo.getNodeLabelsInfo().stream()).forEach(nodeLabelInfo -> {
            String keyLabelName = nodeLabelInfo.getName();
            if (resultMap.containsKey(keyLabelName)) {
                NodeLabelInfo mapNodeLabelInfo = (NodeLabelInfo)resultMap.get(keyLabelName);
                mapNodeLabelInfo = RouterWebServiceUtil.mergeNodeLabelInfo(mapNodeLabelInfo, nodeLabelInfo);
                resultMap.put(keyLabelName, mapNodeLabelInfo);
            } else {
                resultMap.put(keyLabelName, nodeLabelInfo);
            }
        });
        NodeLabelsInfo nodeLabelsInfo2 = new NodeLabelsInfo();
        nodeLabelsInfo2.getNodeLabelsInfo().addAll(resultMap.values());
        return nodeLabelsInfo2;
    }

    private static NodeLabelInfo mergeNodeLabelInfo(NodeLabelInfo left, NodeLabelInfo right) {
        NodeLabelInfo resultNodeLabelInfo = new NodeLabelInfo();
        resultNodeLabelInfo.setName(left.getName());
        int newActiveNMs = left.getActiveNMs() + right.getActiveNMs();
        resultNodeLabelInfo.setActiveNMs(Integer.valueOf(newActiveNMs));
        boolean newExclusivity = left.getExclusivity() && right.getExclusivity();
        resultNodeLabelInfo.setExclusivity(newExclusivity);
        PartitionInfo leftPartition = left.getPartitionInfo();
        PartitionInfo rightPartition = right.getPartitionInfo();
        PartitionInfo newPartitionInfo = PartitionInfo.addTo((PartitionInfo)leftPartition, (PartitionInfo)rightPartition);
        resultNodeLabelInfo.setPartitionInfo(newPartitionInfo);
        return resultNodeLabelInfo;
    }

    public static void initForWritableEndpoints(Configuration conf, UserGroupInformation callerUGI) throws AuthorizationException {
        if (callerUGI == null) {
            String msg = "Unable to obtain user name, user not authenticated";
            throw new AuthorizationException(msg);
        }
        if (UserGroupInformation.isSecurityEnabled() && RouterWebServiceUtil.isStaticUser(conf, callerUGI)) {
            String msg = "The default static user cannot carry out this operation.";
            throw new ForbiddenException(msg);
        }
    }

    private static boolean isStaticUser(Configuration conf, UserGroupInformation callerUGI) {
        String staticUser = conf.get("hadoop.http.staticuser.user", "dr.who");
        return staticUser.equals(callerUGI.getUserName());
    }

    public static void createKerberosUserGroupInformation(HttpServletRequest hsr) throws YarnException {
        String authType = hsr.getAuthType();
        if (!"kerberos".equalsIgnoreCase(authType)) {
            String msg = "Delegation token operations can only be carried out on a Kerberos authenticated channel. Expected auth type is kerberos, got type " + authType;
            throw new YarnException(msg);
        }
        Object ugiAttr = hsr.getAttribute("hadoop.security.delegation-token.ugi");
        if (ugiAttr != null) {
            String msg = "Delegation token operations cannot be carried out using delegation token authentication.";
            throw new YarnException(msg);
        }
    }

    public static Token<RMDelegationTokenIdentifier> extractToken(String encodedToken) {
        Token token = new Token();
        try {
            token.decodeFromUrlString(encodedToken);
        }
        catch (Exception ie) {
            throw new BadRequestException("Could not decode encoded token");
        }
        return token;
    }

    public static Token<RMDelegationTokenIdentifier> extractToken(HttpServletRequest request) {
        String encodedToken = request.getHeader("Hadoop-YARN-RM-Delegation-Token");
        if (encodedToken == null) {
            String msg = "Header 'Hadoop-YARN-RM-Delegation-Token' containing encoded token not found";
            throw new BadRequestException(msg);
        }
        return RouterWebServiceUtil.extractToken(encodedToken);
    }

    public static UserGroupInformation getKerberosUserGroupInformation(Configuration conf, HttpServletRequest request) throws AuthorizationException, YarnException {
        UserGroupInformation callerUGI = RMWebAppUtil.getCallerUserGroupInformation((HttpServletRequest)request, (boolean)true);
        RouterWebServiceUtil.initForWritableEndpoints(conf, callerUGI);
        RouterWebServiceUtil.createKerberosUserGroupInformation(request);
        callerUGI.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.KERBEROS);
        return callerUGI;
    }

    public static String generateWebTitle(String title, String msg) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(title);
        stringBuilder.append(" (");
        stringBuilder.append(msg);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

