/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp;

import javax.servlet.Filter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.router.Router;
import org.apache.hadoop.yarn.server.router.webapp.RouterController;
import org.apache.hadoop.yarn.server.router.webapp.RouterWebServices;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.YarnWebParams;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;

public class RouterWebApp
extends WebApp
implements YarnWebParams {
    private Router router;

    public RouterWebApp(Router router) {
        this.router = router;
    }

    public void setup() {
        if (this.router != null) {
            this.bind(Router.class).toInstance((Object)this.router);
        }
        this.route("/", RouterController.class);
        this.route("/cluster", RouterController.class, "about");
        this.route("/about", RouterController.class, "about");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/apps", "app.subcluster", "app.state"}), RouterController.class, "apps");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/nodes", "node.subcluster"}), RouterController.class, "nodes");
        this.route("/federation", RouterController.class, "federation");
        this.route(StringHelper.pajoin((Object[])new Object[]{"/nodelabels", "node.subcluster"}), RouterController.class, "nodeLabels");
    }

    public ResourceConfig resourceConfig() {
        ResourceConfig config = new ResourceConfig();
        config.packages(new String[]{"org.apache.hadoop.yarn.server.router.webapp"});
        config.register((Object)new JerseyBinder());
        config.register(RouterWebServices.class);
        config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        return config;
    }

    protected Class<? extends Filter> getWebAppFilterClass() {
        return null;
    }

    private class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            ((InstanceBinding)this.bind((Object)RouterWebApp.this.router).to(Router.class)).named("router");
            ((InstanceBinding)this.bind(RouterWebApp.this.router.getConfig()).to(Configuration.class)).named("conf");
        }
    }
}

