/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.apache.hadoop.yarn.server.router.Router;
import org.apache.hadoop.yarn.server.router.webapp.HTTPMethods;
import org.apache.hadoop.yarn.server.router.webapp.MetricsOverviewTable;
import org.apache.hadoop.yarn.server.router.webapp.RouterWebServiceUtil;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.glassfish.jersey.jettison.JettisonJaxbContext;
import org.glassfish.jersey.jettison.JettisonMarshaller;

public abstract class RouterBlock
extends HtmlBlock {
    private final Router router;
    private final View.ViewContext ctx;
    private final FederationStateStoreFacade facade;
    private final Configuration conf;
    public static final String ROUTER = "router";

    public RouterBlock(Router router, View.ViewContext ctx) {
        super(ctx);
        this.ctx = ctx;
        this.router = router;
        this.facade = FederationStateStoreFacade.getInstance((Configuration)router.getConfig());
        this.conf = this.router.getConfig();
    }

    protected ClusterMetricsInfo getRouterClusterMetricsInfo() {
        boolean isEnabled = this.isYarnFederationEnabled();
        String webAppAddress = isEnabled ? WebAppUtils.getRouterWebAppURLWithScheme((Configuration)this.conf) : WebAppUtils.getRMWebAppURLWithScheme((Configuration)this.conf);
        return this.getClusterMetricsInfo(webAppAddress);
    }

    protected ClusterMetricsInfo getClusterMetricsInfo(String webAppAddress) {
        if (StringUtils.isBlank((CharSequence)webAppAddress)) {
            return null;
        }
        Client client = RouterWebServiceUtil.createJerseyClient(this.conf);
        ClusterMetricsInfo metrics = RouterWebServiceUtil.genericForward(webAppAddress, null, ClusterMetricsInfo.class, HTTPMethods.GET, "/ws/v1/cluster/metrics", null, null, this.conf, client);
        client.close();
        return metrics;
    }

    protected List<SubClusterInfo> getSubClusterInfoList() {
        ArrayList<SubClusterInfo> subClusters = new ArrayList<SubClusterInfo>();
        try {
            Map subClustersInfo = this.facade.getSubClusters(true);
            subClusters.addAll(subClustersInfo.values());
            Comparator<SubClusterInfo> cmp = Comparator.comparing(o -> o.getSubClusterId());
            Collections.sort(subClusters, cmp);
            return subClusters;
        }
        catch (YarnException e) {
            LOG.error("getSubClusterInfoList error.", (Throwable)e);
            return subClusters;
        }
    }

    protected boolean isYarnFederationEnabled() {
        boolean isEnabled = this.conf.getBoolean("yarn.federation.enabled", false);
        return isEnabled;
    }

    protected List<String> getActiveSubClusterIds() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Map subClustersInfo = this.facade.getSubClusters(true);
            subClustersInfo.values().stream().forEach(subClusterInfo -> result.add(subClusterInfo.getSubClusterId().getId()));
        }
        catch (Exception e) {
            LOG.error("getActiveSubClusters error.", (Throwable)e);
        }
        return result;
    }

    protected void initSubClusterMetricsOverviewTable(HtmlBlock.Block html, String subclusterId) {
        MetricsOverviewTable metricsOverviewTable = new MetricsOverviewTable(this.router, this.ctx);
        metricsOverviewTable.render(html, subclusterId);
    }

    protected ClusterMetricsInfo getClusterMetricsInfoBySubClusterId(String subclusterId) {
        try {
            SubClusterId subClusterId = SubClusterId.newInstance((String)subclusterId);
            SubClusterInfo subClusterInfo = this.facade.getSubCluster(subClusterId);
            if (subClusterInfo != null) {
                Client client = RouterWebServiceUtil.createJerseyClient(this.conf);
                String webAppAddress = WebAppUtils.getHttpSchemePrefix((Configuration)this.conf) + subClusterInfo.getRMWebServiceAddress();
                ClusterMetricsInfo metrics = RouterWebServiceUtil.genericForward(webAppAddress, null, ClusterMetricsInfo.class, HTTPMethods.GET, "/ws/v1/cluster/metrics", null, null, this.conf, client);
                client.close();
                return metrics;
            }
        }
        catch (Exception e) {
            LOG.error("getClusterMetricsInfoBySubClusterId subClusterId = {} error.", (Object)subclusterId, (Object)e);
        }
        return null;
    }

    protected Collection<SubClusterInfo> getSubClusterInfoList(String subclusterId) {
        try {
            SubClusterId subClusterId = SubClusterId.newInstance((String)subclusterId);
            SubClusterInfo subClusterInfo = this.facade.getSubCluster(subClusterId);
            return Collections.singletonList(subClusterInfo);
        }
        catch (Exception e) {
            LOG.error("getSubClusterInfoList subClusterId = {} error.", (Object)subclusterId, (Object)e);
            return null;
        }
    }

    public FederationStateStoreFacade getFacade() {
        return this.facade;
    }

    protected void initNodesMenu(Hamlet.UL<Hamlet.DIV<Hamlet>> mainList, List<String> subClusterIds) {
        if (CollectionUtils.isNotEmpty(subClusterIds)) {
            Hamlet.UL nodesList = mainList.li().a(this.url(new String[]{"nodes"}), "Nodes").ul().$style("padding:0.3em 1em 0.1em 2em");
            nodesList.li().__();
            for (String subClusterId : subClusterIds) {
                nodesList.li().a(this.url(new String[]{"nodes", subClusterId}), subClusterId).__();
            }
            ((Hamlet.LI)nodesList.__()).__();
        } else {
            mainList.li().a(this.url(new String[]{"nodes"}), "Nodes").__();
        }
    }

    protected void initApplicationsMenu(Hamlet.UL<Hamlet.DIV<Hamlet>> mainList, List<String> subClusterIds) {
        if (CollectionUtils.isNotEmpty(subClusterIds)) {
            Hamlet.UL apps = mainList.li().a(this.url(new String[]{"apps"}), "Applications").ul();
            apps.li().__();
            for (String subClusterId : subClusterIds) {
                Hamlet.LI subClusterList = apps.li().a(this.url(new String[]{"apps", subClusterId}), subClusterId);
                Hamlet.UL subAppStates = subClusterList.ul().$style("padding:0.3em 1em 0.1em 2em");
                subAppStates.li().__();
                for (YarnApplicationState state : YarnApplicationState.values()) {
                    subAppStates.li().a(this.url(new String[]{"apps", subClusterId, state.toString()}), state.toString()).__();
                }
                ((Hamlet.UL)subAppStates.li().__()).__();
                subClusterList.__();
            }
            ((Hamlet.LI)apps.__()).__();
        } else {
            mainList.li().a(this.url(new String[]{"apps"}), "Applications").__();
        }
    }

    protected void initNodeLabelsMenu(Hamlet.UL<Hamlet.DIV<Hamlet>> mainList, List<String> subClusterIds) {
        if (CollectionUtils.isNotEmpty(subClusterIds)) {
            Hamlet.UL nodesList = mainList.li().a(this.url(new String[]{"nodelabels"}), "Node Labels").ul().$style("padding:0.3em 1em 0.1em 2em");
            nodesList.li().__();
            for (String subClusterId : subClusterIds) {
                nodesList.li().a(this.url(new String[]{"nodelabels", subClusterId}), subClusterId).__();
            }
            ((Hamlet.LI)nodesList.__()).__();
        } else {
            mainList.li().a(this.url(new String[]{"nodelabels"}), "Node Labels").__();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SubClusterInfo getSubClusterInfoByLocalCluster(Configuration config) {
        try (Client client = null;){
            SubClusterInfo subClusterInfo;
            String localClusterName = config.get("yarn.resourcemanager.cluster-id", "N/A");
            String webAppAddress = WebAppUtils.getRMWebAppURLWithScheme((Configuration)config);
            String rmWebAppURLWithoutScheme = WebAppUtils.getRMWebAppURLWithoutScheme((Configuration)config);
            client = RouterWebServiceUtil.createJerseyClient(config);
            ClusterMetricsInfo clusterMetricsInfos = RouterWebServiceUtil.genericForward(webAppAddress, null, ClusterMetricsInfo.class, HTTPMethods.GET, "/ws/v1/cluster/metrics", null, null, config, client);
            if (clusterMetricsInfos == null) {
                SubClusterInfo subClusterInfo2 = null;
                return subClusterInfo2;
            }
            ClusterInfo clusterInfo = RouterWebServiceUtil.genericForward(webAppAddress, null, ClusterInfo.class, HTTPMethods.GET, "/ws/v1/cluster/info", null, null, config, client);
            if (clusterInfo == null) {
                SubClusterInfo subClusterInfo3 = null;
                return subClusterInfo3;
            }
            JettisonJaxbContext jc = new JettisonJaxbContext(new Class[]{ClusterMetricsInfo.class});
            JettisonMarshaller marshaller = jc.createJsonMarshaller();
            StringWriter writer = new StringWriter();
            marshaller.marshallToJSON((Object)clusterMetricsInfos, (Writer)writer);
            String capability = writer.toString();
            SubClusterId subClusterId = SubClusterId.newInstance((String)localClusterName);
            SubClusterInfo subClusterInfo4 = subClusterInfo = SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)rmWebAppURLWithoutScheme, (SubClusterState)SubClusterState.SC_RUNNING, (long)clusterInfo.getStartedOn(), (long)Time.now(), (String)capability);
            return subClusterInfo4;
        }
        return null;
    }
}

