/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.client.Client;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerOverviewInfo;
import org.apache.hadoop.yarn.server.router.Router;
import org.apache.hadoop.yarn.server.router.webapp.HTTPMethods;
import org.apache.hadoop.yarn.server.router.webapp.RouterBlock;
import org.apache.hadoop.yarn.server.router.webapp.RouterWebServiceUtil;
import org.apache.hadoop.yarn.server.router.webapp.dao.RouterClusterMetrics;
import org.apache.hadoop.yarn.server.router.webapp.dao.RouterSchedulerMetrics;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class MetricsOverviewTable
extends RouterBlock {
    private final Router router;

    @Inject
    MetricsOverviewTable(Router router, View.ViewContext ctx) {
        super(router, ctx);
        this.router = router;
    }

    protected void render(HtmlBlock.Block html) {
        html.style(new Object[]{".metrics {margin-bottom:5px}"});
        ClusterMetricsInfo routerClusterMetricsInfo = this.getRouterClusterMetricsInfo();
        RouterClusterMetrics routerClusterMetrics = new RouterClusterMetrics(routerClusterMetricsInfo);
        Hamlet.DIV div = html.div().$class("metrics");
        try {
            this.initFederationClusterAppsMetrics((Hamlet.DIV<Hamlet>)div, routerClusterMetrics);
            this.initFederationClusterNodesMetrics((Hamlet.DIV<Hamlet>)div, routerClusterMetrics);
            List<SubClusterInfo> subClusters = this.getSubClusterInfoList();
            this.initFederationClusterSchedulersMetrics((Hamlet.DIV<Hamlet>)div, routerClusterMetrics, subClusters);
        }
        catch (Exception e) {
            LOG.error("MetricsOverviewTable init error.", (Throwable)e);
        }
        div.__();
    }

    protected void render(HtmlBlock.Block html, String subClusterId) {
        html.style(new Object[]{".metrics {margin-bottom:5px}"});
        ClusterMetricsInfo clusterMetricsInfo = this.getClusterMetricsInfoBySubClusterId(subClusterId);
        RouterClusterMetrics routerClusterMetrics = new RouterClusterMetrics(clusterMetricsInfo, subClusterId);
        Hamlet.DIV div = html.div().$class("metrics");
        try {
            this.initFederationClusterAppsMetrics((Hamlet.DIV<Hamlet>)div, routerClusterMetrics);
            this.initFederationClusterNodesMetrics((Hamlet.DIV<Hamlet>)div, routerClusterMetrics);
            Collection<SubClusterInfo> subClusters = this.getSubClusterInfoList(subClusterId);
            this.initFederationClusterSchedulersMetrics((Hamlet.DIV<Hamlet>)div, routerClusterMetrics, subClusters);
        }
        catch (Exception e) {
            LOG.error("MetricsOverviewTable init error.", (Throwable)e);
        }
        div.__();
    }

    private void initFederationClusterAppsMetrics(Hamlet.DIV<Hamlet> div, RouterClusterMetrics metrics) {
        ((Hamlet.TABLE)((Hamlet.TBODY)((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)div.h3(metrics.getWebPageTitlePrefix() + " Cluster Metrics").table("#metricsoverview").thead().$class("ui-widget-header").tr().th().$class("ui-state-default").__(new Object[]{"Apps Submitted"}).__()).th().$class("ui-state-default").__(new Object[]{"Apps Pending"}).__()).th().$class("ui-state-default").__(new Object[]{"Apps Running"}).__()).th().$class("ui-state-default").__(new Object[]{"Apps Completed"}).__()).th().$class("ui-state-default").__(new Object[]{"Containers Running"}).__()).th().$class("ui-state-default").__(new Object[]{"Used Resources"}).__()).th().$class("ui-state-default").__(new Object[]{"Total Resources"}).__()).th().$class("ui-state-default").__(new Object[]{"Reserved Resources"}).__()).th().$class("ui-state-default").__(new Object[]{"Physical Mem Used %"}).__()).th().$class("ui-state-default").__(new Object[]{"Physical VCores Used %"}).__()).__()).__()).tbody().$class("ui-widget-content").tr().td(metrics.getAppsSubmitted()).td(metrics.getAppsPending()).td(String.valueOf(metrics.getAppsRunning())).td(metrics.getAppsCompleted()).td(metrics.getAllocatedContainers()).td(metrics.getUsedResources()).td(metrics.getTotalResources()).td(metrics.getReservedResources()).td(metrics.getUtilizedMBPercent()).td(metrics.getUtilizedVirtualCoresPercent()).__()).__()).__();
    }

    private void initFederationClusterNodesMetrics(Hamlet.DIV<Hamlet> div, RouterClusterMetrics metrics) {
        ((Hamlet.TABLE)((Hamlet.TBODY)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)div.h3(metrics.getWebPageTitlePrefix() + " Cluster Nodes Metrics").table("#nodemetricsoverview").thead().$class("ui-widget-header").tr().th().$class("ui-state-default").__(new Object[]{"Active Nodes"}).__()).th().$class("ui-state-default").__(new Object[]{"Decommissioning Nodes"}).__()).th().$class("ui-state-default").__(new Object[]{"Decommissioned Nodes"}).__()).th().$class("ui-state-default").__(new Object[]{"Lost Nodes"}).__()).th().$class("ui-state-default").__(new Object[]{"Unhealthy Nodes"}).__()).th().$class("ui-state-default").__(new Object[]{"Rebooted Nodes"}).__()).th().$class("ui-state-default").__(new Object[]{"Shutdown Nodes"}).__()).__()).__()).tbody().$class("ui-widget-content").tr().td().a(this.url(new String[]{"nodes"}), String.valueOf(metrics.getActiveNodes())).__()).td().a(this.url(new String[]{"nodes/router/?node.state=decommissioning"}), String.valueOf(metrics.getDecommissioningNodes())).__()).td().a(this.url(new String[]{"nodes/router/?node.state=decommissioned"}), String.valueOf(metrics.getDecommissionedNodes())).__()).td().a(this.url(new String[]{"nodes/router/?node.state=lost"}), String.valueOf(metrics.getLostNodes())).__()).td().a(this.url(new String[]{"nodes/router/?node.state=unhealthy"}), String.valueOf(metrics.getUnhealthyNodes())).__()).td().a(this.url(new String[]{"nodes/router/?node.state=rebooted"}), String.valueOf(metrics.getRebootedNodes())).__()).td().a(this.url(new String[]{"nodes/router/?node.state=shutdown"}), String.valueOf(metrics.getShutdownNodes())).__()).__()).__()).__();
    }

    private void initFederationClusterSchedulersMetrics(Hamlet.DIV<Hamlet> div, RouterClusterMetrics metrics, Collection<SubClusterInfo> subclusters) throws YarnException, IOException, InterruptedException {
        Hamlet.TBODY fsMetricsScheduleTr = ((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)div.h3(metrics.getWebPageTitlePrefix() + " Scheduler Metrics").table("#schedulermetricsoverview").thead().$class("ui-widget-header").tr().th().$class("ui-state-default").__(new Object[]{"SubCluster"}).__()).th().$class("ui-state-default").__(new Object[]{"Scheduler Type"}).__()).th().$class("ui-state-default").__(new Object[]{"Scheduling Resource Type"}).__()).th().$class("ui-state-default").__(new Object[]{"Minimum Allocation"}).__()).th().$class("ui-state-default").__(new Object[]{"Maximum Allocation"}).__()).th().$class("ui-state-default").__(new Object[]{"Maximum Cluster Application Priority"}).__()).th().$class("ui-state-default").__(new Object[]{"Scheduler Busy %"}).__()).th().$class("ui-state-default").__(new Object[]{"RM Dispatcher EventQueue Size"}).__()).th().$class("ui-state-default").__(new Object[]{"Scheduler Dispatcher EventQueue Size"}).__()).__()).__()).tbody().$class("ui-widget-content");
        boolean isEnabled = this.isYarnFederationEnabled();
        if (!isEnabled) {
            this.initLocalClusterOverViewTable((Hamlet.TBODY<Hamlet.TABLE<Hamlet.DIV<Hamlet>>>)fsMetricsScheduleTr);
        } else if (subclusters != null && !subclusters.isEmpty()) {
            this.initSubClusterOverViewTable(metrics, (Hamlet.TBODY<Hamlet.TABLE<Hamlet.DIV<Hamlet>>>)fsMetricsScheduleTr, subclusters);
        } else {
            this.showRouterSchedulerMetricsData("N/A", (Hamlet.TBODY<Hamlet.TABLE<Hamlet.DIV<Hamlet>>>)fsMetricsScheduleTr);
        }
        ((Hamlet.TABLE)fsMetricsScheduleTr.__()).__();
    }

    private void initLocalClusterOverViewTable(Hamlet.TBODY<Hamlet.TABLE<Hamlet.DIV<Hamlet>>> fsMetricsScheduleTr) {
        Configuration config = this.router.getConfig();
        Client client = RouterWebServiceUtil.createJerseyClient(config);
        String webAppAddress = WebAppUtils.getRMWebAppURLWithScheme((Configuration)config);
        String localClusterName = config.get("yarn.resourcemanager.cluster-id", "N/A");
        SchedulerOverviewInfo schedulerOverviewInfo = this.getSchedulerOverviewInfo(webAppAddress, config, client);
        if (schedulerOverviewInfo != null) {
            RouterSchedulerMetrics rsMetrics = new RouterSchedulerMetrics(localClusterName, schedulerOverviewInfo);
            this.showRouterSchedulerMetricsData(rsMetrics, fsMetricsScheduleTr);
        } else {
            this.showRouterSchedulerMetricsData(localClusterName, fsMetricsScheduleTr);
        }
    }

    private void initSubClusterOverViewTable(RouterClusterMetrics metrics, Hamlet.TBODY<Hamlet.TABLE<Hamlet.DIV<Hamlet>>> fsMetricsScheduleTr, Collection<SubClusterInfo> subClusters) {
        Configuration config = this.router.getConfig();
        Client client = RouterWebServiceUtil.createJerseyClient(config);
        for (SubClusterInfo subcluster : subClusters) {
            String webAppAddress;
            SchedulerOverviewInfo schedulerOverviewInfo;
            if (subcluster == null || subcluster.getSubClusterId() == null || (schedulerOverviewInfo = this.getSchedulerOverviewInfo(webAppAddress = WebAppUtils.getHttpSchemePrefix((Configuration)config) + subcluster.getRMWebServiceAddress(), config, client)) == null) continue;
            RouterSchedulerMetrics rsMetrics = new RouterSchedulerMetrics(subcluster, metrics, schedulerOverviewInfo);
            this.showRouterSchedulerMetricsData(rsMetrics, fsMetricsScheduleTr);
        }
        client.close();
    }

    private SchedulerOverviewInfo getSchedulerOverviewInfo(String webAppAddress, Configuration config, Client client) {
        try {
            SchedulerOverviewInfo schedulerOverviewInfo = RouterWebServiceUtil.genericForward(webAppAddress, null, SchedulerOverviewInfo.class, HTTPMethods.GET, "/ws/v1/cluster/scheduler-overview", null, null, config, client);
            return schedulerOverviewInfo;
        }
        catch (Exception e) {
            LOG.error("get SchedulerOverviewInfo from webAppAddress = {} error.", (Object)webAppAddress, (Object)e);
            return null;
        }
    }

    private void showRouterSchedulerMetricsData(RouterSchedulerMetrics rsMetrics, Hamlet.TBODY<Hamlet.TABLE<Hamlet.DIV<Hamlet>>> fsMetricsScheduleTr) {
        fsMetricsScheduleTr.tr().td(rsMetrics.getSubCluster()).td(rsMetrics.getSchedulerType()).td(rsMetrics.getSchedulingResourceType()).td(rsMetrics.getMinimumAllocation()).td(rsMetrics.getMaximumAllocation()).td(rsMetrics.getApplicationPriority()).td(rsMetrics.getSchedulerBusy()).td(rsMetrics.getRmDispatcherEventQueueSize()).td(rsMetrics.getSchedulerDispatcherEventQueueSize()).__();
    }

    private void showRouterSchedulerMetricsData(String subClusterId, Hamlet.TBODY<Hamlet.TABLE<Hamlet.DIV<Hamlet>>> fsMetricsScheduleTr) {
        String subCluster = StringUtils.isNotBlank((CharSequence)subClusterId) ? subClusterId : "N/A";
        fsMetricsScheduleTr.tr().td(subCluster).td("N/A").td("N/A").td("N/A").td("N/A").td("N/A").td("N/A").td("N/A").td("N/A").__();
    }
}

