/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.clientrm;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FailApplicationAttemptRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FailApplicationAttemptResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceProfilesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceProfilesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceTypeInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceTypeInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetAttributesToNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAttributesToNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeAttributesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeAttributesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToAttributesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToAttributesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetResourceProfileRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetResourceProfileResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationPriorityRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationPriorityResponse;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.federation.failover.FederationProxyProviderUtil;
import org.apache.hadoop.yarn.server.federation.policies.RouterPolicyFacade;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.retry.FederationActionRetry;
import org.apache.hadoop.yarn.server.federation.store.records.ApplicationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.ReservationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.router.RouterAuditLogger;
import org.apache.hadoop.yarn.server.router.RouterMetrics;
import org.apache.hadoop.yarn.server.router.RouterServerUtil;
import org.apache.hadoop.yarn.server.router.clientrm.AbstractClientRequestInterceptor;
import org.apache.hadoop.yarn.server.router.clientrm.ClientMethod;
import org.apache.hadoop.yarn.server.router.clientrm.ClientRequestInterceptor;
import org.apache.hadoop.yarn.server.router.clientrm.RouterYarnClientUtils;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.MonotonicClock;
import org.apache.hadoop.yarn.util.Records;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationClientInterceptor
extends AbstractClientRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(FederationClientInterceptor.class);
    private int numSubmitRetries;
    private Map<SubClusterId, ApplicationClientProtocol> clientRMProxies;
    private FederationStateStoreFacade federationFacade;
    private Random rand;
    private RouterPolicyFacade policyFacade;
    private RouterMetrics routerMetrics;
    private ThreadPoolExecutor executorService;
    private final Clock clock = new MonotonicClock();
    private boolean returnPartialReport;
    private long submitIntervalTime;
    private boolean allowPartialResult;

    @Override
    public void init(String userName) {
        super.init(userName);
        this.federationFacade = FederationStateStoreFacade.getInstance((Configuration)this.getConf());
        this.rand = new Random(System.currentTimeMillis());
        int numMinThreads = this.getNumMinThreads(this.getConf());
        int numMaxThreads = this.getNumMaxThreads(this.getConf());
        long keepAliveTime = this.getConf().getTimeDuration("yarn.router.interceptor.user-thread-pool.keep-alive-time", YarnConfiguration.DEFAULT_ROUTER_USER_CLIENT_THREAD_POOL_KEEP_ALIVE_TIME, TimeUnit.SECONDS);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("RPC Router Client-" + userName + "-%d ").build();
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
        this.executorService = new ThreadPoolExecutor(numMinThreads, numMaxThreads, keepAliveTime, TimeUnit.MILLISECONDS, workQueue, threadFactory);
        boolean allowCoreThreadTimeOut = this.getConf().getBoolean("yarn.router.interceptor.user-thread-pool.allow-core-thread-time-out", false);
        if (keepAliveTime > 0L && allowCoreThreadTimeOut) {
            this.executorService.allowCoreThreadTimeOut(allowCoreThreadTimeOut);
        }
        Configuration conf = this.getConf();
        try {
            this.policyFacade = new RouterPolicyFacade(conf, this.federationFacade, this.federationFacade.getSubClusterResolver(), null);
        }
        catch (FederationPolicyInitializationException e) {
            LOG.error(e.getMessage());
        }
        this.numSubmitRetries = conf.getInt("yarn.router.submit.retry", 3);
        this.submitIntervalTime = conf.getTimeDuration("yarn.router.submit.interval.time", YarnConfiguration.DEFAULT_CLIENTRM_SUBMIT_INTERVAL_TIME, TimeUnit.MILLISECONDS);
        this.clientRMProxies = new ConcurrentHashMap<SubClusterId, ApplicationClientProtocol>();
        this.routerMetrics = RouterMetrics.getMetrics();
        this.returnPartialReport = conf.getBoolean("yarn.router.partial-result.enabled", false);
        this.allowPartialResult = conf.getBoolean("yarn.router.interceptor.allow-partial-result.enable", false);
    }

    @Override
    public void setNextInterceptor(ClientRequestInterceptor next) {
        throw new YarnRuntimeException("setNextInterceptor is being called on FederationClientRequestInterceptor, which should be the last one in the chain. Check if the interceptor pipeline configuration is correct");
    }

    @VisibleForTesting
    protected ApplicationClientProtocol getClientRMProxyForSubCluster(SubClusterId subClusterId) throws YarnException {
        if (this.clientRMProxies.containsKey(subClusterId)) {
            return this.clientRMProxies.get(subClusterId);
        }
        ApplicationClientProtocol clientRMProxy = null;
        try {
            boolean serviceAuthEnabled = this.getConf().getBoolean("hadoop.security.authorization", false);
            UserGroupInformation realUser = this.user;
            if (serviceAuthEnabled) {
                realUser = UserGroupInformation.createProxyUser((String)this.user.getShortUserName(), (UserGroupInformation)UserGroupInformation.getLoginUser());
            }
            clientRMProxy = (ApplicationClientProtocol)FederationProxyProviderUtil.createRMProxy((Configuration)this.getConf(), ApplicationClientProtocol.class, (SubClusterId)subClusterId, (UserGroupInformation)realUser);
        }
        catch (Exception e) {
            RouterServerUtil.logAndThrowException("Unable to create the interface to reach the SubCluster " + subClusterId, e);
        }
        this.clientRMProxies.put(subClusterId, clientRMProxy);
        return clientRMProxy;
    }

    private SubClusterId getRandomActiveSubCluster(Map<SubClusterId, SubClusterInfo> activeSubClusters) throws YarnException {
        if (activeSubClusters == null || activeSubClusters.isEmpty()) {
            RouterServerUtil.logAndThrowException("No active SubCluster available to submit the request.", null);
        }
        ArrayList<SubClusterId> list = new ArrayList<SubClusterId>(activeSubClusters.keySet());
        return (SubClusterId)list.get(this.rand.nextInt(list.size()));
    }

    public GetNewApplicationResponse getNewApplication(GetNewApplicationRequest request) throws YarnException, IOException {
        if (request == null) {
            this.routerMetrics.incrAppsFailedCreated();
            String errMsg = "Missing getNewApplication request.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get New App", "UNKNOWN", "RouterClientRMService", errMsg);
            RouterServerUtil.logAndThrowException(errMsg, null);
        }
        long startTime = this.clock.getTime();
        Map subClustersActive = this.federationFacade.getSubClusters(true);
        ArrayList blacklist = new ArrayList();
        int activeSubClustersCount = this.federationFacade.getActiveSubClustersCount();
        int actualRetryNums = Math.min(activeSubClustersCount, this.numSubmitRetries);
        try {
            GetNewApplicationResponse response = (GetNewApplicationResponse)((FederationActionRetry)retryCount -> this.invokeGetNewApplication(subClustersActive, blacklist, request, retryCount)).runWithRetries(actualRetryNums, this.submitIntervalTime);
            if (response != null) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededAppsCreated(stopTime - startTime);
                return response;
            }
        }
        catch (Exception e) {
            this.routerMetrics.incrAppsFailedCreated();
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get New App", "UNKNOWN", "RouterClientRMService", e.getMessage());
            RouterServerUtil.logAndThrowException(e.getMessage(), e);
        }
        this.routerMetrics.incrAppsFailedCreated();
        String errMsg = "Failed to create a new application.";
        RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get New App", "UNKNOWN", "RouterClientRMService", errMsg);
        throw new YarnException(errMsg);
    }

    private GetNewApplicationResponse invokeGetNewApplication(Map<SubClusterId, SubClusterInfo> subClustersActive, List<SubClusterId> blackList, GetNewApplicationRequest request, int retryCount) throws YarnException, IOException {
        SubClusterId subClusterId = FederationStateStoreFacade.getRandomActiveSubCluster(subClustersActive, blackList);
        LOG.info("getNewApplication try #{} on SubCluster {}.", (Object)retryCount, (Object)subClusterId);
        ApplicationClientProtocol clientRMProxy = this.getClientRMProxyForSubCluster(subClusterId);
        try {
            GetNewApplicationResponse response = clientRMProxy.getNewApplication(request);
            if (response != null) {
                RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Get New App", "RouterClientRMService", response.getApplicationId(), subClusterId);
                return response;
            }
        }
        catch (Exception e) {
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get New App", "UNKNOWN", "RouterClientRMService", e.getMessage(), subClusterId);
            LOG.warn("Unable to create a new ApplicationId in SubCluster {}.", (Object)subClusterId.getId(), (Object)e);
            blackList.add(subClusterId);
            throw e;
        }
        String msg = String.format("Unable to create a new ApplicationId in SubCluster %s.", subClusterId.getId());
        throw new YarnException(msg);
    }

    public SubmitApplicationResponse submitApplication(SubmitApplicationRequest request) throws YarnException, IOException {
        if (request == null || request.getApplicationSubmissionContext() == null || request.getApplicationSubmissionContext().getApplicationId() == null) {
            this.routerMetrics.incrAppsFailedSubmitted();
            String errMsg = "Missing submitApplication request or applicationSubmissionContext information.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Submit New App", "UNKNOWN", "RouterClientRMService", errMsg);
            RouterServerUtil.logAndThrowException(errMsg, null);
        }
        long startTime = this.clock.getTime();
        ApplicationId applicationId = request.getApplicationSubmissionContext().getApplicationId();
        ArrayList blacklist = new ArrayList();
        try {
            int activeSubClustersCount = this.federationFacade.getActiveSubClustersCount();
            int actualRetryNums = Math.min(activeSubClustersCount, this.numSubmitRetries);
            SubmitApplicationResponse response = (SubmitApplicationResponse)((FederationActionRetry)retryCount -> this.invokeSubmitApplication(blacklist, request, retryCount)).runWithRetries(actualRetryNums, this.submitIntervalTime);
            if (response != null) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededAppsSubmitted(stopTime - startTime);
                return response;
            }
        }
        catch (Exception e) {
            this.routerMetrics.incrAppsFailedSubmitted();
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Submit New App", "UNKNOWN", "RouterClientRMService", e.getMessage(), applicationId);
            RouterServerUtil.logAndThrowException(e.getMessage(), e);
        }
        this.routerMetrics.incrAppsFailedSubmitted();
        String msg = String.format("Application %s with appId %s failed to be submitted.", request.getApplicationSubmissionContext().getApplicationName(), applicationId);
        RouterAuditLogger.logFailure(this.user.getShortUserName(), "Submit New App", "UNKNOWN", "RouterClientRMService", msg, applicationId);
        throw new YarnException(msg);
    }

    private SubmitApplicationResponse invokeSubmitApplication(List<SubClusterId> blackList, SubmitApplicationRequest request, int retryCount) throws YarnException, IOException {
        ApplicationSubmissionContext appSubmissionContext = request.getApplicationSubmissionContext();
        ApplicationId applicationId = appSubmissionContext.getApplicationId();
        SubClusterId subClusterId = null;
        try {
            subClusterId = this.policyFacade.getHomeSubcluster(appSubmissionContext, blackList);
            LOG.info("submitApplication appId {} try #{} on SubCluster {}.", new Object[]{applicationId, retryCount, subClusterId});
            ApplicationSubmissionContext trimmedAppSubmissionContext = RouterServerUtil.getTrimmedAppSubmissionContext(appSubmissionContext);
            this.federationFacade.addOrUpdateApplicationHomeSubCluster(applicationId, subClusterId, retryCount, trimmedAppSubmissionContext);
            ApplicationClientProtocol clientRMProxy = this.getClientRMProxyForSubCluster(subClusterId);
            SubmitApplicationResponse response = clientRMProxy.submitApplication(request);
            if (response != null) {
                LOG.info("Application {} submitted on subCluster {}.", (Object)applicationId, (Object)subClusterId);
                RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Submit New App", "RouterClientRMService", applicationId, subClusterId);
                return response;
            }
        }
        catch (Exception e) {
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Submit New App", "UNKNOWN", "RouterClientRMService", e.getMessage(), applicationId, subClusterId);
            LOG.warn("Unable to submitApplication appId {} try #{} on SubCluster {}.", new Object[]{applicationId, retryCount, subClusterId, e});
            if (subClusterId != null) {
                blackList.add(subClusterId);
            }
            throw e;
        }
        String msg = String.format("Application %s failed to be submitted.", applicationId);
        throw new YarnException(msg);
    }

    public KillApplicationResponse forceKillApplication(KillApplicationRequest request) throws YarnException, IOException {
        if (request == null || request.getApplicationId() == null) {
            this.routerMetrics.incrAppsFailedKilled();
            String msg = "Missing forceKillApplication request or ApplicationId.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Force Kill App", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, null);
        }
        long startTime = this.clock.getTime();
        ApplicationId applicationId = request.getApplicationId();
        SubClusterId subClusterId = null;
        try {
            subClusterId = this.federationFacade.getApplicationHomeSubCluster(request.getApplicationId());
        }
        catch (YarnException e) {
            this.routerMetrics.incrAppsFailedKilled();
            String msg = String.format("Application %s does not exist in FederationStateStore.", applicationId);
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Force Kill App", "UNKNOWN", "RouterClientRMService", msg, applicationId);
            RouterServerUtil.logAndThrowException(msg, e);
        }
        ApplicationClientProtocol clientRMProxy = this.getClientRMProxyForSubCluster(subClusterId);
        KillApplicationResponse response = null;
        try {
            LOG.info("forceKillApplication {} on SubCluster {}.", (Object)applicationId, (Object)subClusterId);
            response = clientRMProxy.forceKillApplication(request);
            if (response != null) {
                try {
                    ClientMethod remoteMethod = new ClientMethod("forceKillApplication", new Class[]{KillApplicationRequest.class}, request);
                    this.invokeConcurrent(remoteMethod, KillApplicationResponse.class, subClusterId);
                }
                catch (YarnException e) {
                    LOG.warn("The execution of forceKillApplication failed in the sub-cluster.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.routerMetrics.incrAppsFailedKilled();
            String msg = "Unable to kill the application report.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Force Kill App", "UNKNOWN", "RouterClientRMService", msg, applicationId, subClusterId);
            RouterServerUtil.logAndThrowException(msg, e);
        }
        if (response == null) {
            LOG.error("No response when attempting to kill the application {} to SubCluster {}.", (Object)applicationId, (Object)subClusterId.getId());
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededAppsKilled(stopTime - startTime);
        RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Force Kill App", "RouterClientRMService", applicationId);
        return response;
    }

    public GetApplicationReportResponse getApplicationReport(GetApplicationReportRequest request) throws YarnException, IOException {
        if (request == null || request.getApplicationId() == null) {
            this.routerMetrics.incrAppsFailedRetrieved();
            String errMsg = "Missing getApplicationReport request or applicationId information.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get Application Report", "UNKNOWN", "RouterClientRMService", errMsg);
            RouterServerUtil.logAndThrowException(errMsg, null);
        }
        long startTime = this.clock.getTime();
        SubClusterId subClusterId = null;
        try {
            subClusterId = this.federationFacade.getApplicationHomeSubCluster(request.getApplicationId());
        }
        catch (YarnException e) {
            this.routerMetrics.incrAppsFailedRetrieved();
            String errMsg = String.format("Application %s does not exist in FederationStateStore.", request.getApplicationId());
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get Application Report", "UNKNOWN", "RouterClientRMService", errMsg, request.getApplicationId());
            RouterServerUtil.logAndThrowException(errMsg, e);
        }
        ApplicationClientProtocol clientRMProxy = this.getClientRMProxyForSubCluster(subClusterId);
        GetApplicationReportResponse response = null;
        try {
            response = clientRMProxy.getApplicationReport(request);
        }
        catch (Exception e) {
            this.routerMetrics.incrAppsFailedRetrieved();
            String errMsg = String.format("Unable to get the application report for %s to SubCluster %s.", request.getApplicationId(), subClusterId.getId());
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get Application Report", "UNKNOWN", "RouterClientRMService", errMsg, request.getApplicationId(), subClusterId);
            RouterServerUtil.logAndThrowException(errMsg, e);
        }
        if (response == null) {
            LOG.error("No response when attempting to retrieve the report of the application {} to SubCluster {}.", (Object)request.getApplicationId(), (Object)subClusterId.getId());
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededAppsRetrieved(stopTime - startTime);
        RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Get Application Report", "RouterClientRMService", request.getApplicationId());
        return response;
    }

    public GetApplicationsResponse getApplications(GetApplicationsRequest request) throws YarnException, IOException {
        if (request == null) {
            this.routerMetrics.incrMultipleAppsFailedRetrieved();
            String msg = "Missing getApplications request.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get Applications", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, null);
        }
        long startTime = this.clock.getTime();
        ClientMethod remoteMethod = new ClientMethod("getApplications", new Class[]{GetApplicationsRequest.class}, request);
        Collection<GetApplicationsResponse> applications = null;
        try {
            applications = this.invokeConcurrent(remoteMethod, GetApplicationsResponse.class);
        }
        catch (Exception ex) {
            this.routerMetrics.incrMultipleAppsFailedRetrieved();
            String msg = "Unable to get applications due to exception.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get Applications", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, ex);
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededMultipleAppsRetrieved(stopTime - startTime);
        RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Get Applications", "RouterClientRMService");
        return RouterYarnClientUtils.mergeApplications(applications, this.returnPartialReport);
    }

    public GetClusterMetricsResponse getClusterMetrics(GetClusterMetricsRequest request) throws YarnException, IOException {
        if (request == null) {
            this.routerMetrics.incrGetClusterMetricsFailedRetrieved();
            String msg = "Missing getClusterMetrics request.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get ClusterMetrics", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, null);
        }
        long startTime = this.clock.getTime();
        ClientMethod remoteMethod = new ClientMethod("getClusterMetrics", new Class[]{GetClusterMetricsRequest.class}, request);
        Collection<GetClusterMetricsResponse> clusterMetrics = null;
        try {
            clusterMetrics = this.invokeConcurrent(remoteMethod, GetClusterMetricsResponse.class);
        }
        catch (Exception ex) {
            this.routerMetrics.incrGetClusterMetricsFailedRetrieved();
            String msg = "Unable to get cluster metrics due to exception.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get ClusterMetrics", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, ex);
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededGetClusterMetricsRetrieved(stopTime - startTime);
        RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Get ClusterMetrics", "RouterClientRMService");
        return RouterYarnClientUtils.merge(clusterMetrics);
    }

    <R> Collection<R> invokeConcurrent(ClientMethod request, Class<R> clazz) throws YarnException {
        Map subClusterInfo = this.federationFacade.getSubClusters(true);
        Set<SubClusterId> subClusterIds = subClusterInfo.keySet();
        return this.invokeConcurrent(request, clazz, subClusterIds);
    }

    <R> Collection<R> invokeConcurrent(ClientMethod request, Class<R> clazz, SubClusterId homeSubclusterId) throws YarnException {
        Map subClusterInfo = this.federationFacade.getSubClusters(true);
        Set<SubClusterId> subClusterIds = subClusterInfo.keySet();
        subClusterIds.remove(homeSubclusterId);
        return this.invokeConcurrent(request, clazz, subClusterIds);
    }

    <R> Collection<R> invokeConcurrent(ClientMethod request, Class<R> clazz, Collection<SubClusterId> subClusterIds) throws YarnException {
        ArrayList<Callable<Pair>> callables = new ArrayList<Callable<Pair>>();
        ArrayList futures = new ArrayList();
        TreeMap exceptions = new TreeMap();
        for (SubClusterId subClusterId : subClusterIds) {
            callables.add(() -> {
                try {
                    ApplicationClientProtocol protocol = this.getClientRMProxyForSubCluster(subClusterId);
                    String methodName = request.getMethodName();
                    Class<?>[] types = request.getTypes();
                    Object[] params = request.getParams();
                    Method method = ApplicationClientProtocol.class.getMethod(methodName, types);
                    Object result = method.invoke((Object)protocol, params);
                    return Pair.of((Object)subClusterId, (Object)result);
                }
                catch (Exception e) {
                    Throwable cause = e.getCause();
                    if (cause != null && cause instanceof InvocationTargetException) {
                        cause = cause.getCause();
                    }
                    String errMsg = cause.getMessage() != null ? cause.getMessage() : "UNKNOWN";
                    YarnException yarnException = new YarnException(String.format("subClusterId %s exec %s error %s.", subClusterId, request.getMethodName(), errMsg), (Throwable)e);
                    return Pair.of((Object)subClusterId, (Object)((Object)yarnException));
                }
            });
        }
        TreeMap results = new TreeMap();
        try {
            futures.addAll(this.executorService.invokeAll(callables));
            futures.stream().forEach(future -> {
                SubClusterId subClusterId = null;
                try {
                    Pair pair = (Pair)future.get();
                    subClusterId = (SubClusterId)pair.getKey();
                    Object result = pair.getValue();
                    if (result instanceof YarnException) {
                        throw (YarnException)((Object)((Object)YarnException.class.cast(result)));
                    }
                    results.put(subClusterId, clazz.cast(result));
                }
                catch (InterruptedException | ExecutionException | YarnException e) {
                    Throwable cause = e.getCause();
                    LOG.error("Cannot execute {} on {} : {}", new Object[]{request.getMethodName(), subClusterId.getId(), cause.getMessage()});
                    exceptions.put(subClusterId, e);
                }
            });
        }
        catch (InterruptedException e) {
            throw new YarnException("invokeConcurrent Failed.", (Throwable)e);
        }
        if (!(exceptions == null || exceptions.isEmpty() || this.allowPartialResult && exceptions.keySet().size() != subClusterIds.size())) {
            throw new YarnException("invokeConcurrent Failed = " + StringUtils.join(exceptions.values(), (String)","));
        }
        return results.values();
    }

    <R> Collection<R> invoke(ClientMethod request, Class<R> clazz, String subClusterId) throws YarnException {
        SubClusterId subClusterIdKey;
        Map subClusterInfoMap = this.federationFacade.getSubClusters(true);
        if (!subClusterInfoMap.containsKey(subClusterIdKey = SubClusterId.newInstance((String)subClusterId))) {
            throw new YarnException("subClusterId = " + subClusterId + " is not an active subCluster.");
        }
        try {
            ApplicationClientProtocol protocol = this.getClientRMProxyForSubCluster(subClusterIdKey);
            String methodName = request.getMethodName();
            Class<?>[] types = request.getTypes();
            Object[] params = request.getParams();
            Method method = ApplicationClientProtocol.class.getMethod(methodName, types);
            Object result = method.invoke((Object)protocol, params);
            if (result != null) {
                return Collections.singletonList(clazz.cast(result));
            }
        }
        catch (Exception e) {
            throw new YarnException("invoke Failed, An exception occurred in subClusterId = " + subClusterId, (Throwable)e);
        }
        throw new YarnException("invoke Failed, An exception occurred in subClusterId = " + subClusterId);
    }

    public GetClusterNodesResponse getClusterNodes(GetClusterNodesRequest request) throws YarnException, IOException {
        if (request == null) {
            this.routerMetrics.incrClusterNodesFailedRetrieved();
            String msg = "Missing getClusterNodes request.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get ClusterNodes", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, null);
        }
        long startTime = this.clock.getTime();
        ClientMethod remoteMethod = new ClientMethod("getClusterNodes", new Class[]{GetClusterNodesRequest.class}, request);
        try {
            Collection<GetClusterNodesResponse> clusterNodes = this.invokeConcurrent(remoteMethod, GetClusterNodesResponse.class);
            long stopTime = this.clock.getTime();
            this.routerMetrics.succeededGetClusterNodesRetrieved(stopTime - startTime);
            RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Get ClusterNodes", "RouterClientRMService");
            return RouterYarnClientUtils.mergeClusterNodesResponse(clusterNodes);
        }
        catch (Exception ex) {
            this.routerMetrics.incrClusterNodesFailedRetrieved();
            String msg = "Unable to get cluster nodes due to exception.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get ClusterNodes", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, ex);
            throw new YarnException("Unable to get cluster nodes.");
        }
    }

    public GetQueueInfoResponse getQueueInfo(GetQueueInfoRequest request) throws YarnException, IOException {
        if (request == null || request.getQueueName() == null) {
            this.routerMetrics.incrGetQueueInfoFailedRetrieved();
            String msg = "Missing getQueueInfo request or queueName.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get QueueInfo", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, null);
        }
        String rSubCluster = request.getSubClusterId();
        long startTime = this.clock.getTime();
        ClientMethod remoteMethod = new ClientMethod("getQueueInfo", new Class[]{GetQueueInfoRequest.class}, request);
        Collection<GetQueueInfoResponse> queues = null;
        try {
            queues = StringUtils.isNotBlank((CharSequence)rSubCluster) ? this.invoke(remoteMethod, GetQueueInfoResponse.class, rSubCluster) : this.invokeConcurrent(remoteMethod, GetQueueInfoResponse.class);
        }
        catch (Exception ex) {
            this.routerMetrics.incrGetQueueInfoFailedRetrieved();
            String msg = "Unable to get queue [" + request.getQueueName() + "] to exception.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get QueueInfo", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, ex);
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededGetQueueInfoRetrieved(stopTime - startTime);
        RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Get QueueInfo", "RouterClientRMService");
        return RouterYarnClientUtils.mergeQueues(queues);
    }

    public GetQueueUserAclsInfoResponse getQueueUserAcls(GetQueueUserAclsInfoRequest request) throws YarnException, IOException {
        if (request == null) {
            this.routerMetrics.incrQueueUserAclsFailedRetrieved();
            String msg = "Missing getQueueUserAcls request.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get QueueUserAcls", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg);
        }
        long startTime = this.clock.getTime();
        ClientMethod remoteMethod = new ClientMethod("getQueueUserAcls", new Class[]{GetQueueUserAclsInfoRequest.class}, request);
        Collection<GetQueueUserAclsInfoResponse> queueUserAcls = null;
        try {
            queueUserAcls = this.invokeConcurrent(remoteMethod, GetQueueUserAclsInfoResponse.class);
        }
        catch (Exception ex) {
            this.routerMetrics.incrQueueUserAclsFailedRetrieved();
            String msg = "Unable to get queue user Acls due to exception.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get QueueUserAcls", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, ex);
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededGetQueueUserAclsRetrieved(stopTime - startTime);
        RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Get QueueUserAcls", "RouterClientRMService");
        return RouterYarnClientUtils.mergeQueueUserAcls(queueUserAcls);
    }

    public MoveApplicationAcrossQueuesResponse moveApplicationAcrossQueues(MoveApplicationAcrossQueuesRequest request) throws YarnException, IOException {
        if (request == null || request.getApplicationId() == null || request.getTargetQueue() == null) {
            this.routerMetrics.incrMoveApplicationAcrossQueuesFailedRetrieved();
            String msg = "Missing moveApplicationAcrossQueues request or applicationId or target queue.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Move ApplicationAcrossQueues", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg);
        }
        long startTime = this.clock.getTime();
        SubClusterId subClusterId = null;
        ApplicationId applicationId = request.getApplicationId();
        try {
            subClusterId = this.federationFacade.getApplicationHomeSubCluster(applicationId);
        }
        catch (YarnException e) {
            this.routerMetrics.incrMoveApplicationAcrossQueuesFailedRetrieved();
            String errMsgFormat = "Application %s does not exist in FederationStateStore.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Move ApplicationAcrossQueues", "UNKNOWN", "RouterClientRMService", String.format(errMsgFormat, applicationId));
            RouterServerUtil.logAndThrowException(e, errMsgFormat, applicationId);
        }
        ApplicationClientProtocol clientRMProxy = this.getClientRMProxyForSubCluster(subClusterId);
        MoveApplicationAcrossQueuesResponse response = null;
        try {
            response = clientRMProxy.moveApplicationAcrossQueues(request);
        }
        catch (Exception e) {
            this.routerMetrics.incrMoveApplicationAcrossQueuesFailedRetrieved();
            RouterServerUtil.logAndThrowException(e, "Unable to moveApplicationAcrossQueues for %s to SubCluster %s.", applicationId, subClusterId.getId());
        }
        if (response == null) {
            LOG.error("No response when moveApplicationAcrossQueues the applicationId {} to Queue {} In SubCluster {}.", new Object[]{request.getApplicationId(), request.getTargetQueue(), subClusterId.getId()});
        }
        long stopTime = this.clock.getTime();
        RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Move ApplicationAcrossQueues", "RouterClientRMService", applicationId, subClusterId);
        this.routerMetrics.succeededMoveApplicationAcrossQueuesRetrieved(stopTime - startTime);
        return response;
    }

    public GetNewReservationResponse getNewReservation(GetNewReservationRequest request) throws YarnException, IOException {
        if (request == null) {
            this.routerMetrics.incrGetNewReservationFailedRetrieved();
            String errMsg = "Missing getNewReservation request.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get NewReservation", "UNKNOWN", "RouterClientRMService", errMsg);
            RouterServerUtil.logAndThrowException(errMsg, null);
        }
        long startTime = this.clock.getTime();
        Map subClustersActive = this.federationFacade.getSubClusters(true);
        for (int i = 0; i < this.numSubmitRetries; ++i) {
            SubClusterId subClusterId = this.getRandomActiveSubCluster(subClustersActive);
            LOG.info("getNewReservation try #{} on SubCluster {}.", (Object)i, (Object)subClusterId);
            ApplicationClientProtocol clientRMProxy = this.getClientRMProxyForSubCluster(subClusterId);
            try {
                GetNewReservationResponse response = clientRMProxy.getNewReservation(request);
                if (response == null) continue;
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededGetNewReservationRetrieved(stopTime - startTime);
                RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Get NewReservation", "RouterClientRMService");
                return response;
            }
            catch (Exception e) {
                String logFormatted = "Unable to create a new Reservation in SubCluster {}.";
                LOG.warn(logFormatted, (Object)subClusterId.getId(), (Object)e);
                RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get NewReservation", "UNKNOWN", "RouterClientRMService", logFormatted, subClusterId.getId());
                subClustersActive.remove(subClusterId);
            }
        }
        this.routerMetrics.incrGetNewReservationFailedRetrieved();
        String errMsg = "Failed to create a new reservation.";
        RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get NewReservation", "UNKNOWN", "RouterClientRMService", errMsg);
        throw new YarnException(errMsg);
    }

    public ReservationSubmissionResponse submitReservation(ReservationSubmissionRequest request) throws YarnException, IOException {
        if (request == null || request.getReservationId() == null || request.getReservationDefinition() == null || request.getQueue() == null) {
            this.routerMetrics.incrSubmitReservationFailedRetrieved();
            String msg = "Missing submitReservation request or reservationId or reservation definition or queue.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Submit Reservation", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, null);
        }
        long startTime = this.clock.getTime();
        ReservationId reservationId = request.getReservationId();
        for (int i = 0; i < this.numSubmitRetries; ++i) {
            try {
                SubClusterId subClusterId = this.policyFacade.getReservationHomeSubCluster(request);
                LOG.info("submitReservation ReservationId {} try #{} on SubCluster {}.", new Object[]{reservationId, i, subClusterId});
                ReservationHomeSubCluster reservationHomeSubCluster = ReservationHomeSubCluster.newInstance((ReservationId)reservationId, (SubClusterId)subClusterId);
                Boolean exists = this.existsReservationHomeSubCluster(reservationId);
                if (!exists.booleanValue() || i == 0) {
                    this.addReservationHomeSubCluster(reservationId, reservationHomeSubCluster);
                } else {
                    this.updateReservationHomeSubCluster(subClusterId, reservationId, reservationHomeSubCluster);
                }
                ApplicationClientProtocol clientRMProxy = this.getClientRMProxyForSubCluster(subClusterId);
                ReservationSubmissionResponse response = clientRMProxy.submitReservation(request);
                if (response == null) continue;
                LOG.info("Reservation {} submitted on subCluster {}.", (Object)reservationId, (Object)subClusterId);
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededSubmitReservationRetrieved(stopTime - startTime);
                RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Submit Reservation", "RouterClientRMService");
                return response;
            }
            catch (Exception e) {
                LOG.warn("Unable to submit(try #{}) the Reservation {}.", new Object[]{i, reservationId, e});
            }
        }
        this.routerMetrics.incrSubmitReservationFailedRetrieved();
        String msg = String.format("Reservation %s failed to be submitted.", reservationId);
        RouterAuditLogger.logFailure(this.user.getShortUserName(), "Submit Reservation", "UNKNOWN", "RouterClientRMService", msg);
        throw new YarnException(msg);
    }

    public ReservationListResponse listReservations(ReservationListRequest request) throws YarnException, IOException {
        if (request == null || request.getReservationId() == null) {
            this.routerMetrics.incrListReservationsFailedRetrieved();
            String msg = "Missing listReservations request.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "List Reservations", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, null);
        }
        long startTime = this.clock.getTime();
        ClientMethod remoteMethod = new ClientMethod("listReservations", new Class[]{ReservationListRequest.class}, request);
        Collection<ReservationListResponse> listResponses = null;
        try {
            listResponses = this.invokeConcurrent(remoteMethod, ReservationListResponse.class);
        }
        catch (Exception ex) {
            String msg = "Unable to list reservations node due to exception.";
            this.routerMetrics.incrListReservationsFailedRetrieved();
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "List Reservations", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, ex);
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededListReservationsRetrieved(stopTime - startTime);
        RouterAuditLogger.logSuccess(this.user.getShortUserName(), "List Reservations", "RouterClientRMService");
        return RouterYarnClientUtils.mergeReservationsList(listResponses);
    }

    public ReservationUpdateResponse updateReservation(ReservationUpdateRequest request) throws YarnException, IOException {
        if (request == null || request.getReservationId() == null || request.getReservationDefinition() == null) {
            this.routerMetrics.incrUpdateReservationFailedRetrieved();
            String msg = "Missing updateReservation request or reservationId or reservation definition.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Update Reservation", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, null);
        }
        long startTime = this.clock.getTime();
        ReservationId reservationId = request.getReservationId();
        SubClusterId subClusterId = this.getReservationHomeSubCluster(reservationId);
        try {
            ApplicationClientProtocol client = this.getClientRMProxyForSubCluster(subClusterId);
            ReservationUpdateResponse response = client.updateReservation(request);
            if (response != null) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededUpdateReservationRetrieved(stopTime - startTime);
                RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Update Reservation", "RouterClientRMService");
                return response;
            }
        }
        catch (Exception ex) {
            this.routerMetrics.incrUpdateReservationFailedRetrieved();
            String msg = "Unable to reservation update due to exception.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Update Reservation", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, ex);
        }
        this.routerMetrics.incrUpdateReservationFailedRetrieved();
        String msg = String.format("Reservation %s failed to be update.", reservationId);
        RouterAuditLogger.logFailure(this.user.getShortUserName(), "Update Reservation", "UNKNOWN", "RouterClientRMService", msg);
        throw new YarnException(msg);
    }

    public ReservationDeleteResponse deleteReservation(ReservationDeleteRequest request) throws YarnException, IOException {
        if (request == null || request.getReservationId() == null) {
            this.routerMetrics.incrDeleteReservationFailedRetrieved();
            String msg = "Missing deleteReservation request or reservationId.";
            RouterServerUtil.logAndThrowException(msg, null);
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Delete Reservation", "UNKNOWN", "RouterClientRMService", msg);
        }
        long startTime = this.clock.getTime();
        ReservationId reservationId = request.getReservationId();
        SubClusterId subClusterId = this.getReservationHomeSubCluster(reservationId);
        try {
            ApplicationClientProtocol client = this.getClientRMProxyForSubCluster(subClusterId);
            ReservationDeleteResponse response = client.deleteReservation(request);
            if (response != null) {
                this.federationFacade.deleteReservationHomeSubCluster(reservationId);
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededDeleteReservationRetrieved(stopTime - startTime);
                RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Delete Reservation", "RouterClientRMService");
                return response;
            }
        }
        catch (Exception ex) {
            this.routerMetrics.incrUpdateReservationFailedRetrieved();
            String msg = "Unable to reservation delete due to exception.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Delete Reservation", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, ex);
        }
        this.routerMetrics.incrDeleteReservationFailedRetrieved();
        String msg = String.format("Reservation %s failed to be delete.", reservationId);
        RouterAuditLogger.logFailure(this.user.getShortUserName(), "Delete Reservation", "UNKNOWN", "RouterClientRMService", msg);
        throw new YarnException(msg);
    }

    public GetNodesToLabelsResponse getNodeToLabels(GetNodesToLabelsRequest request) throws YarnException, IOException {
        if (request == null) {
            this.routerMetrics.incrNodeToLabelsFailedRetrieved();
            String msg = "Missing getNodesToLabels request.";
            RouterServerUtil.logAndThrowException(msg, null);
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get NodeToLabels", "UNKNOWN", "RouterClientRMService", msg);
        }
        long startTime = this.clock.getTime();
        ClientMethod remoteMethod = new ClientMethod("getNodeToLabels", new Class[]{GetNodesToLabelsRequest.class}, request);
        Collection<GetNodesToLabelsResponse> clusterNodes = null;
        try {
            clusterNodes = this.invokeConcurrent(remoteMethod, GetNodesToLabelsResponse.class);
        }
        catch (Exception ex) {
            this.routerMetrics.incrNodeToLabelsFailedRetrieved();
            String msg = "Unable to get node label due to exception.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get NodeToLabels", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, ex);
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededGetNodeToLabelsRetrieved(stopTime - startTime);
        RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Get NodeToLabels", "RouterClientRMService");
        return RouterYarnClientUtils.mergeNodesToLabelsResponse(clusterNodes);
    }

    public GetLabelsToNodesResponse getLabelsToNodes(GetLabelsToNodesRequest request) throws YarnException, IOException {
        if (request == null) {
            this.routerMetrics.incrLabelsToNodesFailedRetrieved();
            String msg = "Missing getLabelsToNodes request.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get LabelsToNodes", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, null);
        }
        long startTime = this.clock.getTime();
        ClientMethod remoteMethod = new ClientMethod("getLabelsToNodes", new Class[]{GetLabelsToNodesRequest.class}, request);
        Collection<GetLabelsToNodesResponse> labelNodes = null;
        try {
            labelNodes = this.invokeConcurrent(remoteMethod, GetLabelsToNodesResponse.class);
        }
        catch (Exception ex) {
            this.routerMetrics.incrLabelsToNodesFailedRetrieved();
            String msg = "Unable to get label node due to exception.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get LabelsToNodes", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, ex);
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededGetLabelsToNodesRetrieved(stopTime - startTime);
        RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Get LabelsToNodes", "RouterClientRMService");
        return RouterYarnClientUtils.mergeLabelsToNodes(labelNodes);
    }

    public GetClusterNodeLabelsResponse getClusterNodeLabels(GetClusterNodeLabelsRequest request) throws YarnException, IOException {
        if (request == null) {
            this.routerMetrics.incrClusterNodeLabelsFailedRetrieved();
            String msg = "Missing getClusterNodeLabels request.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get ClusterNodeLabels", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, null);
        }
        long startTime = this.clock.getTime();
        ClientMethod remoteMethod = new ClientMethod("getClusterNodeLabels", new Class[]{GetClusterNodeLabelsRequest.class}, request);
        Collection<GetClusterNodeLabelsResponse> nodeLabels = null;
        try {
            nodeLabels = this.invokeConcurrent(remoteMethod, GetClusterNodeLabelsResponse.class);
        }
        catch (Exception ex) {
            this.routerMetrics.incrClusterNodeLabelsFailedRetrieved();
            String msg = "Unable to get cluster nodeLabels due to exception.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get ClusterNodeLabels", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, ex);
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededGetClusterNodeLabelsRetrieved(stopTime - startTime);
        RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Get ClusterNodeLabels", "RouterClientRMService");
        return RouterYarnClientUtils.mergeClusterNodeLabelsResponse(nodeLabels);
    }

    public GetApplicationAttemptReportResponse getApplicationAttemptReport(GetApplicationAttemptReportRequest request) throws YarnException, IOException {
        if (request == null || request.getApplicationAttemptId() == null || request.getApplicationAttemptId().getApplicationId() == null) {
            this.routerMetrics.incrAppAttemptReportFailedRetrieved();
            String msg = "Missing getApplicationAttemptReport request or applicationId or applicationAttemptId information.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get ApplicationAttemptReport", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, null);
        }
        long startTime = this.clock.getTime();
        SubClusterId subClusterId = null;
        ApplicationId applicationId = request.getApplicationAttemptId().getApplicationId();
        try {
            subClusterId = this.getApplicationHomeSubCluster(applicationId);
        }
        catch (YarnException e) {
            this.routerMetrics.incrAppAttemptReportFailedRetrieved();
            String msgFormat = "ApplicationAttempt %s belongs to Application %s does not exist in FederationStateStore.";
            ApplicationAttemptId applicationAttemptId = request.getApplicationAttemptId();
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get ApplicationAttemptReport", "UNKNOWN", "RouterClientRMService", msgFormat, applicationAttemptId, applicationId);
            RouterServerUtil.logAndThrowException(e, msgFormat, applicationAttemptId, applicationId);
        }
        ApplicationClientProtocol clientRMProxy = this.getClientRMProxyForSubCluster(subClusterId);
        GetApplicationAttemptReportResponse response = null;
        try {
            response = clientRMProxy.getApplicationAttemptReport(request);
        }
        catch (Exception e) {
            this.routerMetrics.incrAppAttemptReportFailedRetrieved();
            String msg = String.format("Unable to get the applicationAttempt report for %s to SubCluster %s.", request.getApplicationAttemptId(), subClusterId.getId());
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get ApplicationAttemptReport", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, e);
        }
        if (response == null) {
            LOG.error("No response when attempting to retrieve the report of the applicationAttempt {} to SubCluster {}.", (Object)request.getApplicationAttemptId(), (Object)subClusterId.getId());
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededAppAttemptReportRetrieved(stopTime - startTime);
        RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Get ApplicationAttemptReport", "RouterClientRMService");
        return response;
    }

    public GetApplicationAttemptsResponse getApplicationAttempts(GetApplicationAttemptsRequest request) throws YarnException, IOException {
        if (request == null || request.getApplicationId() == null) {
            this.routerMetrics.incrAppAttemptsFailedRetrieved();
            String msg = "Missing getApplicationAttempts request or application id.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get ApplicationAttempts", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg);
        }
        long startTime = this.clock.getTime();
        ApplicationId applicationId = request.getApplicationId();
        SubClusterId subClusterId = null;
        try {
            subClusterId = this.getApplicationHomeSubCluster(applicationId);
        }
        catch (YarnException ex) {
            this.routerMetrics.incrAppAttemptsFailedRetrieved();
            String msg = "Application " + applicationId + " does not exist in FederationStateStore.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get ApplicationAttempts", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, ex);
        }
        ApplicationClientProtocol clientRMProxy = this.getClientRMProxyForSubCluster(subClusterId);
        GetApplicationAttemptsResponse response = null;
        try {
            response = clientRMProxy.getApplicationAttempts(request);
        }
        catch (Exception ex) {
            this.routerMetrics.incrAppAttemptsFailedRetrieved();
            String msg = "Unable to get the application attempts for " + applicationId + " from SubCluster " + subClusterId.getId();
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get ApplicationAttempts", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, ex);
        }
        if (response == null) {
            LOG.error("No response when attempting to retrieve the attempts list of the application = {} to SubCluster = {}.", (Object)applicationId, (Object)subClusterId.getId());
        }
        long stopTime = this.clock.getTime();
        RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Get ApplicationAttempts", "RouterClientRMService", applicationId);
        this.routerMetrics.succeededAppAttemptsRetrieved(stopTime - startTime);
        return response;
    }

    public GetContainerReportResponse getContainerReport(GetContainerReportRequest request) throws YarnException, IOException {
        if (request == null || request.getContainerId() == null) {
            this.routerMetrics.incrGetContainerReportFailedRetrieved();
            String msg = "Missing getContainerReport request or containerId";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get ContainerReport", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, null);
        }
        long startTime = this.clock.getTime();
        ApplicationId applicationId = request.getContainerId().getApplicationAttemptId().getApplicationId();
        SubClusterId subClusterId = null;
        try {
            subClusterId = this.getApplicationHomeSubCluster(applicationId);
        }
        catch (YarnException ex) {
            this.routerMetrics.incrGetContainerReportFailedRetrieved();
            String msg = "Application " + applicationId + " does not exist in FederationStateStore.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get ContainerReport", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, ex);
        }
        ApplicationClientProtocol clientRMProxy = this.getClientRMProxyForSubCluster(subClusterId);
        GetContainerReportResponse response = null;
        try {
            response = clientRMProxy.getContainerReport(request);
        }
        catch (Exception ex) {
            this.routerMetrics.incrGetContainerReportFailedRetrieved();
            LOG.error("Unable to get the container report for {} from SubCluster {}.", new Object[]{applicationId, subClusterId.getId(), ex});
        }
        if (response == null) {
            LOG.error("No response when attempting to retrieve the container report of the ContainerId = {} From SubCluster = {}.", (Object)request.getContainerId(), (Object)subClusterId.getId());
        }
        long stopTime = this.clock.getTime();
        RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Get ContainerReport", "RouterClientRMService", applicationId, subClusterId);
        this.routerMetrics.succeededGetContainerReportRetrieved(stopTime - startTime);
        return response;
    }

    public GetContainersResponse getContainers(GetContainersRequest request) throws YarnException, IOException {
        if (request == null || request.getApplicationAttemptId() == null) {
            this.routerMetrics.incrGetContainersFailedRetrieved();
            String msg = "Missing getContainers request or ApplicationAttemptId.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get Containers", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, null);
        }
        long startTime = this.clock.getTime();
        ApplicationId applicationId = request.getApplicationAttemptId().getApplicationId();
        SubClusterId subClusterId = null;
        try {
            subClusterId = this.getApplicationHomeSubCluster(applicationId);
        }
        catch (YarnException ex) {
            this.routerMetrics.incrGetContainersFailedRetrieved();
            String msg = "Application " + applicationId + " does not exist in FederationStateStore.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get Containers", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, ex);
        }
        ApplicationClientProtocol clientRMProxy = this.getClientRMProxyForSubCluster(subClusterId);
        GetContainersResponse response = null;
        try {
            response = clientRMProxy.getContainers(request);
        }
        catch (Exception ex) {
            this.routerMetrics.incrGetContainersFailedRetrieved();
            String msg = "Unable to get the containers for " + applicationId + " from SubCluster " + subClusterId.getId();
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get Containers", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, ex);
        }
        if (response == null) {
            LOG.error("No response when attempting to retrieve the container report of the ApplicationId = {} From SubCluster = {}.", (Object)applicationId, (Object)subClusterId.getId());
        }
        long stopTime = this.clock.getTime();
        RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Get Containers", "RouterClientRMService", applicationId, subClusterId);
        this.routerMetrics.succeededGetContainersRetrieved(stopTime - startTime);
        return response;
    }

    public GetDelegationTokenResponse getDelegationToken(GetDelegationTokenRequest request) throws YarnException, IOException {
        String msg;
        if (request == null || request.getRenewer() == null) {
            this.routerMetrics.incrGetDelegationTokenFailedRetrieved();
            msg = "Missing getDelegationToken request or Renewer.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get DelegationToken", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, null);
        }
        try {
            if (!RouterServerUtil.isAllowedDelegationTokenOp()) {
                this.routerMetrics.incrGetDelegationTokenFailedRetrieved();
                msg = "Delegation Token can be issued only with kerberos authentication.";
                RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get DelegationToken", "UNKNOWN", "RouterClientRMService", msg);
                throw new IOException(msg);
            }
            long startTime = this.clock.getTime();
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            Text owner = new Text(ugi.getUserName());
            Text realUser = null;
            if (ugi.getRealUser() != null) {
                realUser = new Text(ugi.getRealUser().getUserName());
            }
            RMDelegationTokenIdentifier tokenIdentifier = new RMDelegationTokenIdentifier(owner, new Text(request.getRenewer()), realUser);
            Token realRMDToken = new Token((TokenIdentifier)tokenIdentifier, (SecretManager)this.getTokenSecretManager());
            org.apache.hadoop.yarn.api.records.Token routerRMDTToken = BuilderUtils.newDelegationToken((byte[])realRMDToken.getIdentifier(), (String)realRMDToken.getKind().toString(), (byte[])realRMDToken.getPassword(), (String)realRMDToken.getService().toString());
            long stopTime = this.clock.getTime();
            this.routerMetrics.succeededGetDelegationTokenRetrieved(stopTime - startTime);
            RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Get DelegationToken", "RouterClientRMService");
            return GetDelegationTokenResponse.newInstance((org.apache.hadoop.yarn.api.records.Token)routerRMDTToken);
        }
        catch (IOException e) {
            this.routerMetrics.incrGetDelegationTokenFailedRetrieved();
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get DelegationToken", "UNKNOWN", "RouterClientRMService", "getDelegationToken error, errMsg = " + e.getMessage());
            throw new YarnException((Throwable)e);
        }
    }

    public RenewDelegationTokenResponse renewDelegationToken(RenewDelegationTokenRequest request) throws YarnException, IOException {
        try {
            if (!RouterServerUtil.isAllowedDelegationTokenOp()) {
                this.routerMetrics.incrRenewDelegationTokenFailedRetrieved();
                String msg = "Delegation Token can be renewed only with kerberos authentication";
                RouterAuditLogger.logFailure(this.user.getShortUserName(), "Renew DelegationToken", "UNKNOWN", "RouterClientRMService", msg);
                throw new IOException(msg);
            }
            long startTime = this.clock.getTime();
            org.apache.hadoop.yarn.api.records.Token protoToken = request.getDelegationToken();
            Token token = new Token(protoToken.getIdentifier().array(), protoToken.getPassword().array(), new Text(protoToken.getKind()), new Text(protoToken.getService()));
            String renewer = RouterServerUtil.getRenewerForToken((Token<RMDelegationTokenIdentifier>)token);
            long nextExpTime = this.getTokenSecretManager().renewToken(token, renewer);
            RenewDelegationTokenResponse renewResponse = (RenewDelegationTokenResponse)Records.newRecord(RenewDelegationTokenResponse.class);
            renewResponse.setNextExpirationTime(nextExpTime);
            long stopTime = this.clock.getTime();
            this.routerMetrics.succeededRenewDelegationTokenRetrieved(stopTime - startTime);
            RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Renew DelegationToken", "RouterClientRMService");
            return renewResponse;
        }
        catch (IOException e) {
            this.routerMetrics.incrRenewDelegationTokenFailedRetrieved();
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Renew DelegationToken", "UNKNOWN", "RouterClientRMService", "renewDelegationToken error, errMsg = " + e.getMessage());
            throw new YarnException((Throwable)e);
        }
    }

    public CancelDelegationTokenResponse cancelDelegationToken(CancelDelegationTokenRequest request) throws YarnException, IOException {
        try {
            if (!RouterServerUtil.isAllowedDelegationTokenOp()) {
                this.routerMetrics.incrCancelDelegationTokenFailedRetrieved();
                String msg = "Delegation Token can be cancelled only with kerberos authentication";
                RouterAuditLogger.logFailure(this.user.getShortUserName(), "Cancel DelegationToken", "UNKNOWN", "RouterClientRMService", msg);
                throw new IOException(msg);
            }
            long startTime = this.clock.getTime();
            org.apache.hadoop.yarn.api.records.Token protoToken = request.getDelegationToken();
            Token token = new Token(protoToken.getIdentifier().array(), protoToken.getPassword().array(), new Text(protoToken.getKind()), new Text(protoToken.getService()));
            String currentUser = UserGroupInformation.getCurrentUser().getUserName();
            this.getTokenSecretManager().cancelToken(token, currentUser);
            long stopTime = this.clock.getTime();
            this.routerMetrics.succeededCancelDelegationTokenRetrieved(stopTime - startTime);
            RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Cancel DelegationToken", "RouterClientRMService");
            return (CancelDelegationTokenResponse)Records.newRecord(CancelDelegationTokenResponse.class);
        }
        catch (IOException e) {
            this.routerMetrics.incrCancelDelegationTokenFailedRetrieved();
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Cancel DelegationToken", "UNKNOWN", "RouterClientRMService", "cancelDelegationToken error, errMsg = " + e.getMessage());
            throw new YarnException((Throwable)e);
        }
    }

    public FailApplicationAttemptResponse failApplicationAttempt(FailApplicationAttemptRequest request) throws YarnException, IOException {
        if (request == null || request.getApplicationAttemptId() == null || request.getApplicationAttemptId().getApplicationId() == null) {
            this.routerMetrics.incrFailAppAttemptFailedRetrieved();
            String msg = "Missing failApplicationAttempt request or applicationId or applicationAttemptId information.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Fail ApplicationAttempt", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, null);
        }
        long startTime = this.clock.getTime();
        SubClusterId subClusterId = null;
        ApplicationAttemptId applicationAttemptId = request.getApplicationAttemptId();
        ApplicationId applicationId = applicationAttemptId.getApplicationId();
        try {
            subClusterId = this.getApplicationHomeSubCluster(applicationId);
        }
        catch (YarnException e) {
            this.routerMetrics.incrFailAppAttemptFailedRetrieved();
            String msg = "ApplicationAttempt " + applicationAttemptId + " belongs to Application " + applicationId + " does not exist in FederationStateStore.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Fail ApplicationAttempt", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, e);
        }
        ApplicationClientProtocol clientRMProxy = this.getClientRMProxyForSubCluster(subClusterId);
        FailApplicationAttemptResponse response = null;
        try {
            response = clientRMProxy.failApplicationAttempt(request);
        }
        catch (Exception e) {
            this.routerMetrics.incrFailAppAttemptFailedRetrieved();
            String msg = "Unable to get the applicationAttempt report for " + applicationAttemptId + " to SubCluster " + subClusterId;
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Fail ApplicationAttempt", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, e);
        }
        if (response == null) {
            LOG.error("No response when attempting to retrieve the report of the applicationAttempt {} to SubCluster {}.", (Object)request.getApplicationAttemptId(), (Object)subClusterId.getId());
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededFailAppAttemptRetrieved(stopTime - startTime);
        RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Fail ApplicationAttempt", "RouterClientRMService", applicationId, subClusterId);
        return response;
    }

    public UpdateApplicationPriorityResponse updateApplicationPriority(UpdateApplicationPriorityRequest request) throws YarnException, IOException {
        if (request == null || request.getApplicationId() == null || request.getApplicationPriority() == null) {
            this.routerMetrics.incrUpdateAppPriorityFailedRetrieved();
            String msg = "Missing updateApplicationPriority request or applicationId or applicationPriority information.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Update ApplicationPriority", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, null);
        }
        long startTime = this.clock.getTime();
        SubClusterId subClusterId = null;
        ApplicationId applicationId = request.getApplicationId();
        try {
            subClusterId = this.getApplicationHomeSubCluster(applicationId);
        }
        catch (YarnException e) {
            this.routerMetrics.incrUpdateAppPriorityFailedRetrieved();
            String msg = "Application " + applicationId + " does not exist in FederationStateStore.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Update ApplicationPriority", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, e);
        }
        ApplicationClientProtocol clientRMProxy = this.getClientRMProxyForSubCluster(subClusterId);
        UpdateApplicationPriorityResponse response = null;
        try {
            response = clientRMProxy.updateApplicationPriority(request);
        }
        catch (Exception e) {
            this.routerMetrics.incrFailAppAttemptFailedRetrieved();
            String msg = "Unable to update application priority for " + applicationId + " to SubCluster " + subClusterId;
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Update ApplicationPriority", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, e);
        }
        if (response == null) {
            LOG.error("No response when update application priority of the applicationId {} to SubCluster {}.", (Object)applicationId, (Object)subClusterId.getId());
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededUpdateAppPriorityRetrieved(stopTime - startTime);
        RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Update ApplicationPriority", "RouterClientRMService", applicationId, subClusterId);
        return response;
    }

    public SignalContainerResponse signalToContainer(SignalContainerRequest request) throws YarnException, IOException {
        if (request == null || request.getContainerId() == null || request.getCommand() == null) {
            this.routerMetrics.incrSignalToContainerFailedRetrieved();
            String msg = "Missing signalToContainer request or containerId or command information.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Signal ToContainer", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, null);
        }
        long startTime = this.clock.getTime();
        SubClusterId subClusterId = null;
        ApplicationId applicationId = request.getContainerId().getApplicationAttemptId().getApplicationId();
        try {
            subClusterId = this.getApplicationHomeSubCluster(applicationId);
        }
        catch (YarnException ex) {
            this.routerMetrics.incrSignalToContainerFailedRetrieved();
            String msg = "Application " + applicationId + " does not exist in FederationStateStore.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Signal ToContainer", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, ex);
        }
        ApplicationClientProtocol clientRMProxy = this.getClientRMProxyForSubCluster(subClusterId);
        SignalContainerResponse response = null;
        try {
            response = clientRMProxy.signalToContainer(request);
        }
        catch (Exception ex) {
            String msg = "Unable to signal to container for " + applicationId + " from SubCluster " + subClusterId;
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Signal ToContainer", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, ex);
        }
        if (response == null) {
            LOG.error("No response when signal to container of the applicationId {} to SubCluster {}.", (Object)applicationId, (Object)subClusterId);
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededSignalToContainerRetrieved(stopTime - startTime);
        RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Signal ToContainer", "RouterClientRMService", applicationId, subClusterId);
        return response;
    }

    public UpdateApplicationTimeoutsResponse updateApplicationTimeouts(UpdateApplicationTimeoutsRequest request) throws YarnException, IOException {
        if (request == null || request.getApplicationId() == null || request.getApplicationTimeouts() == null) {
            this.routerMetrics.incrUpdateApplicationTimeoutsRetrieved();
            String msg = "Missing updateApplicationTimeouts request or applicationId or applicationTimeouts information.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Update ApplicationTimeouts", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, null);
        }
        long startTime = this.clock.getTime();
        SubClusterId subClusterId = null;
        ApplicationId applicationId = request.getApplicationId();
        try {
            subClusterId = this.getApplicationHomeSubCluster(applicationId);
        }
        catch (YarnException e) {
            this.routerMetrics.incrFailAppAttemptFailedRetrieved();
            String msg = "Application " + applicationId + " does not exist in FederationStateStore.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Update ApplicationTimeouts", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, e);
        }
        ApplicationClientProtocol clientRMProxy = this.getClientRMProxyForSubCluster(subClusterId);
        UpdateApplicationTimeoutsResponse response = null;
        try {
            response = clientRMProxy.updateApplicationTimeouts(request);
        }
        catch (Exception e) {
            this.routerMetrics.incrFailAppAttemptFailedRetrieved();
            String msg = "Unable to update application timeout for " + applicationId + " to SubCluster " + subClusterId;
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Update ApplicationTimeouts", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, e);
        }
        if (response == null) {
            LOG.error("No response when update application timeout of the applicationId {} to SubCluster {}.", (Object)applicationId, (Object)subClusterId.getId());
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededUpdateAppTimeoutsRetrieved(stopTime - startTime);
        RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Update ApplicationTimeouts", "RouterClientRMService", applicationId, subClusterId);
        return response;
    }

    public GetAllResourceProfilesResponse getResourceProfiles(GetAllResourceProfilesRequest request) throws YarnException, IOException {
        if (request == null) {
            this.routerMetrics.incrGetResourceProfilesFailedRetrieved();
            String msg = "Missing getResourceProfiles request.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get ResourceProfiles", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, null);
        }
        long startTime = this.clock.getTime();
        ClientMethod remoteMethod = new ClientMethod("getResourceProfiles", new Class[]{GetAllResourceProfilesRequest.class}, request);
        Collection<GetAllResourceProfilesResponse> resourceProfiles = null;
        try {
            resourceProfiles = this.invokeConcurrent(remoteMethod, GetAllResourceProfilesResponse.class);
        }
        catch (Exception ex) {
            this.routerMetrics.incrGetResourceProfilesFailedRetrieved();
            String msg = "Unable to get resource profiles due to exception.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get ResourceProfiles", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException("Unable to get resource profiles due to exception.", ex);
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededGetResourceProfilesRetrieved(stopTime - startTime);
        RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Get ResourceProfiles", "RouterClientRMService");
        return RouterYarnClientUtils.mergeClusterResourceProfilesResponse(resourceProfiles);
    }

    public GetResourceProfileResponse getResourceProfile(GetResourceProfileRequest request) throws YarnException, IOException {
        if (request == null || request.getProfileName() == null) {
            this.routerMetrics.incrGetResourceProfileFailedRetrieved();
            String msg = "Missing getResourceProfile request or profileName.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get ResourceProfile", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, null);
        }
        long startTime = this.clock.getTime();
        ClientMethod remoteMethod = new ClientMethod("getResourceProfile", new Class[]{GetResourceProfileRequest.class}, request);
        Collection<GetResourceProfileResponse> resourceProfile = null;
        try {
            resourceProfile = this.invokeConcurrent(remoteMethod, GetResourceProfileResponse.class);
        }
        catch (Exception ex) {
            this.routerMetrics.incrGetResourceProfileFailedRetrieved();
            String msg = "Unable to get resource profile due to exception.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get ResourceProfile", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, ex);
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededGetResourceProfileRetrieved(stopTime - startTime);
        RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Get ResourceProfile", "RouterClientRMService");
        return RouterYarnClientUtils.mergeClusterResourceProfileResponse(resourceProfile);
    }

    public GetAllResourceTypeInfoResponse getResourceTypeInfo(GetAllResourceTypeInfoRequest request) throws YarnException, IOException {
        Collection<GetAllResourceTypeInfoResponse> listResourceTypeInfo;
        if (request == null) {
            this.routerMetrics.incrResourceTypeInfoFailedRetrieved();
            String msg = "Missing getResourceTypeInfo request.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get ResourceTypeInfo", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, null);
        }
        long startTime = this.clock.getTime();
        ClientMethod remoteMethod = new ClientMethod("getResourceTypeInfo", new Class[]{GetAllResourceTypeInfoRequest.class}, request);
        try {
            listResourceTypeInfo = this.invokeConcurrent(remoteMethod, GetAllResourceTypeInfoResponse.class);
        }
        catch (Exception ex) {
            this.routerMetrics.incrResourceTypeInfoFailedRetrieved();
            String msg = "Unable to get all resource type info node due to exception.";
            LOG.error(msg, (Throwable)ex);
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get ResourceTypeInfo", "UNKNOWN", "RouterClientRMService", msg);
            throw ex;
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededGetResourceTypeInfoRetrieved(stopTime - startTime);
        RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Get ResourceTypeInfo", "RouterClientRMService");
        return RouterYarnClientUtils.mergeResourceTypes(listResourceTypeInfo);
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
        super.shutdown();
    }

    public GetAttributesToNodesResponse getAttributesToNodes(GetAttributesToNodesRequest request) throws YarnException, IOException {
        if (request == null || request.getNodeAttributes() == null) {
            this.routerMetrics.incrGetAttributesToNodesFailedRetrieved();
            String msg = "Missing getAttributesToNodes request or nodeAttributes.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get AttributesToNodes", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, null);
        }
        long startTime = this.clock.getTime();
        ClientMethod remoteMethod = new ClientMethod("getAttributesToNodes", new Class[]{GetAttributesToNodesRequest.class}, request);
        Collection<GetAttributesToNodesResponse> attributesToNodesResponses = null;
        try {
            attributesToNodesResponses = this.invokeConcurrent(remoteMethod, GetAttributesToNodesResponse.class);
        }
        catch (Exception ex) {
            this.routerMetrics.incrGetAttributesToNodesFailedRetrieved();
            String msg = "Unable to get attributes to nodes due to exception.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get AttributesToNodes", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, ex);
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededGetAttributesToNodesRetrieved(stopTime - startTime);
        RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Get AttributesToNodes", "RouterClientRMService");
        return RouterYarnClientUtils.mergeAttributesToNodesResponse(attributesToNodesResponses);
    }

    public GetClusterNodeAttributesResponse getClusterNodeAttributes(GetClusterNodeAttributesRequest request) throws YarnException, IOException {
        if (request == null) {
            this.routerMetrics.incrGetClusterNodeAttributesFailedRetrieved();
            String msg = "Missing getClusterNodeAttributes request.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get ClusterNodeAttributes", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, null);
        }
        long startTime = this.clock.getTime();
        ClientMethod remoteMethod = new ClientMethod("getClusterNodeAttributes", new Class[]{GetClusterNodeAttributesRequest.class}, request);
        Collection<GetClusterNodeAttributesResponse> clusterNodeAttributesResponses = null;
        try {
            clusterNodeAttributesResponses = this.invokeConcurrent(remoteMethod, GetClusterNodeAttributesResponse.class);
        }
        catch (Exception ex) {
            this.routerMetrics.incrGetClusterNodeAttributesFailedRetrieved();
            String msg = "Unable to get cluster node attributes due to exception.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get ClusterNodeAttributes", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, ex);
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededGetClusterNodeAttributesRetrieved(stopTime - startTime);
        RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Get ClusterNodeAttributes", "RouterClientRMService");
        return RouterYarnClientUtils.mergeClusterNodeAttributesResponse(clusterNodeAttributesResponses);
    }

    public GetNodesToAttributesResponse getNodesToAttributes(GetNodesToAttributesRequest request) throws YarnException, IOException {
        if (request == null || request.getHostNames() == null) {
            this.routerMetrics.incrGetNodesToAttributesFailedRetrieved();
            String msg = "Missing getNodesToAttributes request or hostNames.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get NodesToAttributes", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, null);
        }
        long startTime = this.clock.getTime();
        ClientMethod remoteMethod = new ClientMethod("getNodesToAttributes", new Class[]{GetNodesToAttributesRequest.class}, request);
        Collection<GetNodesToAttributesResponse> nodesToAttributesResponses = null;
        try {
            nodesToAttributesResponses = this.invokeConcurrent(remoteMethod, GetNodesToAttributesResponse.class);
        }
        catch (Exception ex) {
            this.routerMetrics.incrGetNodesToAttributesFailedRetrieved();
            String msg = "Unable to get nodes to attributes due to exception.";
            RouterAuditLogger.logFailure(this.user.getShortUserName(), "Get NodesToAttributes", "UNKNOWN", "RouterClientRMService", msg);
            RouterServerUtil.logAndThrowException(msg, ex);
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededGetNodesToAttributesRetrieved(stopTime - startTime);
        RouterAuditLogger.logSuccess(this.user.getShortUserName(), "Get NodesToAttributes", "RouterClientRMService");
        return RouterYarnClientUtils.mergeNodesToAttributesResponse(nodesToAttributesResponses);
    }

    protected SubClusterId getApplicationHomeSubCluster(ApplicationId applicationId) throws YarnException {
        SubClusterId resultSubClusterId;
        block7: {
            if (applicationId == null) {
                LOG.error("ApplicationId is Null, Can't find in SubCluster.");
                return null;
            }
            resultSubClusterId = null;
            try {
                resultSubClusterId = this.federationFacade.getApplicationHomeSubCluster(applicationId);
            }
            catch (YarnException ex) {
                if (!LOG.isDebugEnabled()) break block7;
                LOG.debug("Can't find applicationId = {} in home sub cluster,  try foreach sub clusters.", (Object)applicationId);
            }
        }
        if (resultSubClusterId != null) {
            return resultSubClusterId;
        }
        Map subClusters = this.federationFacade.getSubClusters(true);
        for (SubClusterId subClusterId : subClusters.keySet()) {
            try {
                GetApplicationReportRequest appReportRequest;
                GetApplicationReportResponse appReportResponse;
                ApplicationClientProtocol clientRMProxy = this.getClientRMProxyForSubCluster(subClusterId);
                if (clientRMProxy == null || (appReportResponse = clientRMProxy.getApplicationReport(appReportRequest = GetApplicationReportRequest.newInstance((ApplicationId)applicationId))) == null || !applicationId.equals((Object)appReportResponse.getApplicationReport().getApplicationId())) continue;
                resultSubClusterId = this.federationFacade.addApplicationHomeSubCluster(ApplicationHomeSubCluster.newInstance((ApplicationId)applicationId, (SubClusterId)subClusterId));
                return resultSubClusterId;
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Can't find applicationId = {} in Sub Cluster!", (Object)applicationId);
            }
        }
        String errorMsg = String.format("Can't find applicationId = %s in any sub clusters", applicationId);
        throw new YarnException(errorMsg);
    }

    protected SubClusterId getReservationHomeSubCluster(ReservationId reservationId) throws YarnException {
        if (reservationId == null) {
            LOG.error("ReservationId is Null, Can't find in SubCluster.");
            return null;
        }
        try {
            SubClusterId resultSubClusterId = this.federationFacade.getReservationHomeSubCluster(reservationId);
            if (resultSubClusterId != null) {
                return resultSubClusterId;
            }
        }
        catch (YarnException e) {
            RouterServerUtil.logAndThrowException(e, "Can't find reservationId = %s in home sub cluster.", reservationId);
        }
        String errorMsg = String.format("Can't find reservationId = %s in home sub cluster.", reservationId);
        throw new YarnException(errorMsg);
    }

    @VisibleForTesting
    public FederationStateStoreFacade getFederationFacade() {
        return this.federationFacade;
    }

    @VisibleForTesting
    public Map<SubClusterId, ApplicationClientProtocol> getClientRMProxies() {
        return this.clientRMProxies;
    }

    private Boolean existsReservationHomeSubCluster(ReservationId reservationId) {
        try {
            SubClusterId subClusterId = this.federationFacade.getReservationHomeSubCluster(reservationId);
            if (subClusterId != null) {
                return true;
            }
        }
        catch (YarnException e) {
            LOG.warn("get homeSubCluster by reservationId = {} error.", (Object)reservationId, (Object)e);
        }
        return false;
    }

    private void addReservationHomeSubCluster(ReservationId reservationId, ReservationHomeSubCluster homeSubCluster) throws YarnException {
        try {
            this.federationFacade.addReservationHomeSubCluster(homeSubCluster);
        }
        catch (YarnException e) {
            RouterServerUtil.logAndThrowException(e, "Unable to insert the ReservationId %s into the FederationStateStore.", reservationId);
        }
    }

    private void updateReservationHomeSubCluster(SubClusterId subClusterId, ReservationId reservationId, ReservationHomeSubCluster homeSubCluster) throws YarnException {
        try {
            this.federationFacade.updateReservationHomeSubCluster(homeSubCluster);
        }
        catch (YarnException e) {
            SubClusterId subClusterIdInStateStore = this.federationFacade.getReservationHomeSubCluster(reservationId);
            if (subClusterId == subClusterIdInStateStore) {
                LOG.info("Reservation {} already submitted on SubCluster {}.", (Object)reservationId, (Object)subClusterId);
            }
            RouterServerUtil.logAndThrowException(e, "Unable to update the ReservationId %s into the FederationStateStore.", reservationId);
        }
    }

    protected int getNumMinThreads(Configuration conf) {
        String threadSize = conf.get("yarn.router.interceptor.user.threadpool-size");
        if (StringUtils.isNotBlank((CharSequence)threadSize)) {
            LOG.warn("{} is a deprecated property, please remove it, use {} to configure the minimum number of thread pool.", (Object)"yarn.router.interceptor.user.threadpool-size", (Object)"yarn.router.interceptor.user-thread-pool.minimum-pool-size");
            return Integer.parseInt(threadSize);
        }
        int numMinThreads = conf.getInt("yarn.router.interceptor.user-thread-pool.minimum-pool-size", 5);
        return numMinThreads;
    }

    protected int getNumMaxThreads(Configuration conf) {
        String threadSize = conf.get("yarn.router.interceptor.user.threadpool-size");
        if (StringUtils.isNotBlank((CharSequence)threadSize)) {
            LOG.warn("{} is a deprecated property, please remove it, use {} to configure the maximum number of thread pool.", (Object)"yarn.router.interceptor.user.threadpool-size", (Object)"yarn.router.interceptor.user-thread-pool.maximum-pool-size");
            return Integer.parseInt(threadSize);
        }
        int numMaxThreads = conf.getInt("yarn.router.interceptor.user-thread-pool.maximum-pool-size", 5);
        return numMaxThreads;
    }

    @VisibleForTesting
    public void setNumSubmitRetries(int numSubmitRetries) {
        this.numSubmitRetries = numSubmitRetries;
    }

    @VisibleForTesting
    public void setAllowPartialResult(boolean allowPartialResult) {
        this.allowPartialResult = allowPartialResult;
    }
}

