/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp;

import com.google.gson.Gson;
import com.google.inject.Inject;
import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.api.json.JSONJAXBContext;
import com.sun.jersey.api.json.JSONUnmarshaller;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.apache.hadoop.yarn.server.router.Router;
import org.apache.hadoop.yarn.server.router.webapp.RouterBlock;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

class FederationBlock
extends RouterBlock {
    private final Router router;

    @Inject
    FederationBlock(View.ViewContext ctx, Router router) {
        super(router, ctx);
        this.router = router;
    }

    public void render(HtmlBlock.Block html) {
        boolean isEnabled = this.isYarnFederationEnabled();
        this.initHtmlPageFederation(html, isEnabled);
    }

    @Override
    protected ClusterMetricsInfo getClusterMetricsInfo(String capability) {
        try {
            if (capability != null && !capability.isEmpty()) {
                JSONJAXBContext jc = new JSONJAXBContext(JSONConfiguration.mapped().rootUnwrapping(false).build(), new Class[]{ClusterMetricsInfo.class});
                JSONUnmarshaller unmarShaller = jc.createJSONUnmarshaller();
                StringReader stringReader = new StringReader(capability);
                ClusterMetricsInfo clusterMetrics = (ClusterMetricsInfo)unmarShaller.unmarshalFromJSON((Reader)stringReader, ClusterMetricsInfo.class);
                return clusterMetrics;
            }
        }
        catch (Exception e) {
            LOG.error("Cannot parse SubCluster info", (Throwable)e);
        }
        return null;
    }

    private void initFederationSubClusterDetailTableJs(HtmlBlock.Block html, List<Map<String, String>> subClusterDetailMap) {
        Gson gson = new Gson();
        html.script().$type("text/javascript").__(new Object[]{" var scTableData = " + gson.toJson(subClusterDetailMap) + "; "}).__();
        html.script(this.root_url(new String[]{"static/federation/federation.js"}));
    }

    private void initHtmlPageFederation(HtmlBlock.Block html, boolean isEnabled) {
        ArrayList<Map<String, String>> lists = new ArrayList<Map<String, String>>();
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#rms").$class("cell-border").$style("width:100%").thead().tr().th(".id", "SubCluster").th(".state", "State").th(".lastStartTime", "LastStartTime").th(".lastHeartBeat", "LastHeartBeat").th(".resources", "Resources").th(".nodes", "Nodes").__()).__()).tbody();
        try {
            if (isEnabled) {
                this.initSubClusterPage((Hamlet.TBODY<Hamlet.TABLE<Hamlet>>)tbody, lists);
            } else {
                this.initLocalClusterPage((Hamlet.TBODY<Hamlet.TABLE<Hamlet>>)tbody, lists);
            }
        }
        catch (Exception e) {
            LOG.error("Cannot render Router Federation.", (Throwable)e);
        }
        this.initFederationSubClusterDetailTableJs(html, lists);
        ((Hamlet.DIV)((Hamlet)((Hamlet.TABLE)tbody.__()).__()).div().p().$style("color:red").__(new Object[]{"*The application counts are local per subcluster"}).__()).__();
    }

    private void initLocalClusterPage(Hamlet.TBODY<Hamlet.TABLE<Hamlet>> tbody, List<Map<String, String>> lists) {
        Configuration config = this.router.getConfig();
        SubClusterInfo localCluster = this.getSubClusterInfoByLocalCluster(config);
        if (localCluster != null) {
            try {
                this.initSubClusterPageItem(tbody, localCluster, lists);
            }
            catch (Exception e) {
                LOG.error("init LocalCluster = {} page data error.", (Object)localCluster, (Object)e);
            }
        }
    }

    private void initSubClusterPage(Hamlet.TBODY<Hamlet.TABLE<Hamlet>> tbody, List<Map<String, String>> lists) {
        List<SubClusterInfo> subClusters = this.getSubClusterInfoList();
        for (SubClusterInfo subCluster : subClusters) {
            try {
                this.initSubClusterPageItem(tbody, subCluster, lists);
            }
            catch (Exception e) {
                LOG.error("init subCluster = {} page data error.", (Object)subCluster, (Object)e);
            }
        }
    }

    private void initSubClusterPageItem(Hamlet.TBODY<Hamlet.TABLE<Hamlet>> tbody, SubClusterInfo subClusterInfo, List<Map<String, String>> lists) {
        String capability;
        ClusterMetricsInfo subClusterMetricsInfo;
        HashMap<String, String> subClusterMap = new HashMap<String, String>();
        SubClusterId subClusterId = subClusterInfo.getSubClusterId();
        String subClusterIdText = subClusterId.getId();
        String webAppAddress = subClusterInfo.getRMWebServiceAddress();
        Object herfWebAppAddress = "";
        if (webAppAddress != null && !webAppAddress.isEmpty()) {
            herfWebAppAddress = WebAppUtils.getHttpSchemePrefix((Configuration)this.router.getConfig()) + webAppAddress;
        }
        if ((subClusterMetricsInfo = this.getClusterMetricsInfo(capability = subClusterInfo.getCapability())) == null) {
            return;
        }
        Date lastStartTime = new Date(subClusterInfo.getLastStartTime());
        Date lastHeartBeat = new Date(subClusterInfo.getLastHeartBeat());
        long totalMB = subClusterMetricsInfo.getTotalMB();
        String totalMBDesc = StringUtils.byteDesc((long)(totalMB * 0x100000L));
        long totalVirtualCores = subClusterMetricsInfo.getTotalVirtualCores();
        String resources = String.format("<memory:%s, vCores:%s>", totalMBDesc, totalVirtualCores);
        long totalNodes = subClusterMetricsInfo.getTotalNodes();
        long activeNodes = subClusterMetricsInfo.getActiveNodes();
        String nodes = String.format("<totalNodes:%s, activeNodes:%s>", totalNodes, activeNodes);
        String stateStyle = "color:#dc3545;font-weight:bolder";
        SubClusterState state = subClusterInfo.getState();
        if (SubClusterState.SC_RUNNING == state) {
            stateStyle = "color:#28a745;font-weight:bolder";
        }
        ((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)tbody.tr().$id(subClusterIdText).td().$class("details-control").a((String)herfWebAppAddress, subClusterIdText).__()).td().$style(stateStyle).__(new Object[]{state.name()}).__()).td().__(new Object[]{lastStartTime}).__()).td().__(new Object[]{lastHeartBeat}).__()).td(resources).td(nodes).__();
        long allocatedMB = subClusterMetricsInfo.getAllocatedMB();
        String allocatedMBDesc = StringUtils.byteDesc((long)(allocatedMB * 0x100000L));
        long availableMB = subClusterMetricsInfo.getAvailableMB();
        String availableMBDesc = StringUtils.byteDesc((long)(availableMB * 0x100000L));
        long pendingMB = subClusterMetricsInfo.getPendingMB();
        String pendingMBDesc = StringUtils.byteDesc((long)(pendingMB * 0x100000L));
        long reservedMB = subClusterMetricsInfo.getReservedMB();
        String reservedMBDesc = StringUtils.byteDesc((long)(reservedMB * 0x100000L));
        subClusterMap.put("totalmemory", totalMBDesc);
        subClusterMap.put("allocatedmemory", allocatedMBDesc);
        subClusterMap.put("availablememory", availableMBDesc);
        subClusterMap.put("pendingmemory", pendingMBDesc);
        subClusterMap.put("reservedmemory", reservedMBDesc);
        subClusterMap.put("subcluster", subClusterId.getId());
        subClusterMap.put("capability", capability);
        lists.add(subClusterMap);
    }
}

