/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Set;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;

public final class QueueStateHelper {
    private static final Set<QueueState> VALID_STATE_CONFIGURATIONS = ImmutableSet.of((Object)QueueState.RUNNING, (Object)QueueState.STOPPED);
    private static final QueueState DEFAULT_STATE = QueueState.RUNNING;

    private QueueStateHelper() {
    }

    public static void setQueueState(AbstractCSQueue queue) {
        QueueState parentState;
        QueueState previousState = queue.getState();
        QueueState configuredState = queue.getQueueContext().getConfiguration().getConfiguredState(queue.getQueuePathObject());
        QueueState queueState = parentState = queue.getParent() == null ? null : queue.getParent().getState();
        if (configuredState != null && !VALID_STATE_CONFIGURATIONS.contains(configuredState)) {
            throw new IllegalArgumentException("Invalid queue state configuration. We can only use RUNNING or STOPPED.");
        }
        if (previousState == null) {
            QueueStateHelper.initializeState(queue, configuredState, parentState);
        } else {
            QueueStateHelper.reinitializeState(queue, previousState, configuredState);
        }
    }

    private static void reinitializeState(AbstractCSQueue queue, QueueState previousState, QueueState configuredState) {
        if (previousState == QueueState.RUNNING) {
            if (configuredState == QueueState.STOPPED) {
                queue.stopQueue();
            }
        } else if (configuredState == QueueState.RUNNING) {
            try {
                queue.activateQueue();
            }
            catch (YarnException ex) {
                throw new IllegalArgumentException(ex.getMessage());
            }
        }
    }

    private static void initializeState(AbstractCSQueue queue, QueueState configuredState, QueueState parentState) {
        QueueState currentState;
        QueueState queueState = currentState = configuredState == null ? DEFAULT_STATE : configuredState;
        if (parentState != null) {
            if (configuredState == QueueState.RUNNING && parentState != QueueState.RUNNING) {
                throw new IllegalArgumentException("The parent queue:" + queue.getParent().getQueuePath() + " cannot be STOPPED as the child queue:" + queue.getQueuePath() + " is in RUNNING state.");
            }
            if (configuredState == null) {
                currentState = parentState == QueueState.DRAINING ? QueueState.STOPPED : parentState;
            }
        }
        queue.updateQueueState(currentState);
    }
}

