/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerHealth;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivitiesLogger;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityDiagnosticConstant;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AppPriorityACLGroup;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityHeadroomProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacityVector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption.KillableContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ContainerAllocationProposal;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ResourceCommitRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.SchedulerContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.CandidateNodeSet;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.CandidateNodeSetUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.FifoOrderingPolicyForPendingApps;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.IteratorSelector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.OrderingPolicy;
import org.apache.hadoop.yarn.server.utils.Lock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractLeafQueue
extends AbstractCSQueue {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLeafQueue.class);
    private float absoluteUsedCapacity = 0.0f;
    protected int maxApplications;
    protected volatile int maxApplicationsPerUser;
    private float maxAMResourcePerQueuePercent;
    private volatile int nodeLocalityDelay;
    private volatile int rackLocalityAdditionalDelay;
    private volatile boolean rackLocalityFullReset;
    Map<ApplicationAttemptId, FiCaSchedulerApp> applicationAttemptMap = new ConcurrentHashMap<ApplicationAttemptId, FiCaSchedulerApp>();
    private Priority defaultAppPriorityPerQueue;
    private final OrderingPolicy<FiCaSchedulerApp> pendingOrderingPolicy;
    private volatile float minimumAllocationFactor;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final UsersManager usersManager;
    private Resource lastClusterResource = Resources.none();
    private final QueueResourceLimitsInfo queueResourceLimitsInfo = new QueueResourceLimitsInfo();
    private volatile ResourceLimits cachedResourceLimitsForHeadroom = null;
    private volatile OrderingPolicy<FiCaSchedulerApp> orderingPolicy = null;
    @VisibleForTesting
    Map<String, Map<SchedulingMode, ConcurrentMap<String, CachedUserLimit>>> userLimitsCache = new HashMap<String, Map<SchedulingMode, ConcurrentMap<String, CachedUserLimit>>>();
    @VisibleForTesting
    long currentUserLimitCacheVersion = 0L;
    private Map<String, TreeSet<RMContainer>> ignorePartitionExclusivityRMContainers = new ConcurrentHashMap<String, TreeSet<RMContainer>>();
    List<AppPriorityACLGroup> priorityAcls = new ArrayList<AppPriorityACLGroup>();
    private final List<FiCaSchedulerApp> runnableApps = new ArrayList<FiCaSchedulerApp>();
    private final List<FiCaSchedulerApp> nonRunnableApps = new ArrayList<FiCaSchedulerApp>();

    public AbstractLeafQueue(CapacitySchedulerQueueContext queueContext, String queueName, CSQueue parent, CSQueue old) throws IOException {
        this(queueContext, queueName, parent, old, false);
    }

    public AbstractLeafQueue(CapacitySchedulerQueueContext queueContext, String queueName, CSQueue parent, CSQueue old, boolean isDynamic) throws IOException {
        super(queueContext, queueName, parent, old);
        this.setDynamicQueue(isDynamic);
        this.usersManager = new UsersManager(this.usageTracker.getMetrics(), this, this.labelManager, this.resourceCalculator);
        this.pendingOrderingPolicy = new FifoOrderingPolicyForPendingApps<FiCaSchedulerApp>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setupQueueConfigs(Resource clusterResource) throws IOException {
        this.writeLock.lock();
        try {
            int maxGlobalPerQueueApps;
            CapacitySchedulerConfiguration configuration = this.queueContext.getConfiguration();
            super.setupQueueConfigs(clusterResource);
            this.lastClusterResource = clusterResource;
            this.cachedResourceLimitsForHeadroom = new ResourceLimits(clusterResource);
            this.setQueueResourceLimitsInfo(clusterResource);
            this.setOrderingPolicy(configuration.getAppOrderingPolicy(this.getQueuePathObject()));
            this.usersManager.setUserLimit(configuration.getUserLimit(this.getQueuePathObject()));
            this.usersManager.setUserLimitFactor(configuration.getUserLimitFactor(this.getQueuePathObject()));
            this.maxAMResourcePerQueuePercent = configuration.getMaximumApplicationMasterResourcePerQueuePercent(this.getQueuePathObject());
            this.maxApplications = configuration.getMaximumApplicationsPerQueue(this.getQueuePathObject());
            if (this.maxApplications < 0 && (maxGlobalPerQueueApps = configuration.getGlobalMaximumApplicationsPerQueue()) > 0) {
                this.maxApplications = maxGlobalPerQueueApps;
            }
            this.priorityAcls = configuration.getPriorityAcls(this.getQueuePathObject(), configuration.getClusterLevelApplicationMaxPriority());
            Set<String> accessibleNodeLabels = this.queueNodeLabelsSettings.getAccessibleNodeLabels();
            if (!SchedulerUtils.checkQueueLabelExpression(accessibleNodeLabels, this.queueNodeLabelsSettings.getDefaultLabelExpression(), null)) {
                throw new IOException("Invalid default label expression of  queue=" + this.getQueuePath() + " doesn't have permission to access all labels in default label expression. labelExpression of resource request=" + this.getDefaultNodeLabelExpressionStr() + ". Queue labels=" + (this.getAccessibleNodeLabels() == null ? "" : StringUtils.join(this.getAccessibleNodeLabels().iterator(), (char)',')));
            }
            this.nodeLocalityDelay = configuration.getNodeLocalityDelay();
            this.rackLocalityAdditionalDelay = configuration.getRackLocalityAdditionalDelay();
            this.rackLocalityFullReset = configuration.getRackLocalityFullReset();
            this.minimumAllocationFactor = Resources.ratio((ResourceCalculator)this.resourceCalculator, (Resource)Resources.subtract((Resource)this.queueAllocationSettings.getMaximumAllocation(), (Resource)this.queueAllocationSettings.getMinimumAllocation()), (Resource)this.queueAllocationSettings.getMaximumAllocation());
            StringBuilder aclsString = new StringBuilder();
            for (Map.Entry entry : this.acls.entrySet()) {
                aclsString.append(entry.getKey() + ":" + ((AccessControlList)entry.getValue()).getAclString());
            }
            StringBuilder labelStrBuilder = new StringBuilder();
            if (accessibleNodeLabels != null) {
                for (String nodeLabel : accessibleNodeLabels) {
                    labelStrBuilder.append(nodeLabel).append(",");
                }
            }
            this.defaultAppPriorityPerQueue = Priority.newInstance((int)configuration.getDefaultApplicationPriorityConfPerQueue(this.getQueuePathObject()));
            float f = Math.min(100.0f, configuration.getUserLimit(this.getQueuePathObject()));
            this.getUserWeights().validateForLeafQueue(f, this.getQueuePath());
            this.usersManager.updateUserWeights();
            LOG.info("Initializing " + this.getQueuePath() + "\n" + this.getExtendedCapacityOrWeightString() + "\nabsoluteCapacity = " + this.queueCapacities.getAbsoluteCapacity() + " [= parentAbsoluteCapacity * capacity ]\nmaxCapacity = " + this.queueCapacities.getMaximumCapacity() + " [= configuredMaxCapacity ]\nabsoluteMaxCapacity = " + this.queueCapacities.getAbsoluteMaximumCapacity() + " [= 1.0 maximumCapacity undefined, (parentAbsoluteMaxCapacity * maximumCapacity) / 100 otherwise ] \ncapacityVector = " + this.configuredCapacityVectors + "\nmaxCapacityVector = " + this.configuredMaxCapacityVectors + "\neffectiveMinResource=" + this.getEffectiveCapacity("") + " effectiveMaxResource=" + this.getEffectiveMaxCapacity("") + "\nuserLimit = " + this.usersManager.getUserLimit() + " [= configuredUserLimit ]\nuserLimitFactor = " + this.usersManager.getUserLimitFactor() + " [= configuredUserLimitFactor ]\nmaxApplications = " + this.maxApplications + " [= configuredMaximumSystemApplicationsPerQueue or (int)(configuredMaximumSystemApplications * absoluteCapacity)]\nmaxApplicationsPerUser = " + this.maxApplicationsPerUser + " [= (int)(maxApplications * (userLimit / 100.0f) * userLimitFactor) ]\nmaxParallelApps = " + this.getMaxParallelApps() + "\nusedCapacity = " + this.queueCapacities.getUsedCapacity() + " [= usedResourcesMemory / (clusterResourceMemory * absoluteCapacity)]\nabsoluteUsedCapacity = " + this.absoluteUsedCapacity + " [= usedResourcesMemory / clusterResourceMemory]\nmaxAMResourcePerQueuePercent = " + this.maxAMResourcePerQueuePercent + " [= configuredMaximumAMResourcePercent ]\nminimumAllocationFactor = " + this.minimumAllocationFactor + " [= (float)(maximumAllocationMemory - minimumAllocationMemory) / maximumAllocationMemory ]\nmaximumAllocation = " + this.queueAllocationSettings.getMaximumAllocation() + " [= configuredMaxAllocation ]\nnumContainers = " + this.usageTracker.getNumContainers() + " [= currentNumContainers ]\nstate = " + this.getState() + " [= configuredState ]\nacls = " + aclsString + " [= configuredAcls ]\nnodeLocalityDelay = " + this.nodeLocalityDelay + "\nrackLocalityAdditionalDelay = " + this.rackLocalityAdditionalDelay + "\nlabels=" + labelStrBuilder.toString() + "\nreservationsContinueLooking = " + this.reservationsContinueLooking + "\npreemptionDisabled = " + this.getPreemptionDisabled() + "\ndefaultAppPriorityPerQueue = " + this.defaultAppPriorityPerQueue + "\npriority = " + this.priority + "\nmaxLifetime = " + this.getMaximumApplicationLifetime() + " seconds\ndefaultLifetime = " + this.getDefaultApplicationLifetime() + " seconds");
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private String getDefaultNodeLabelExpressionStr() {
        String defaultLabelExpression = this.queueNodeLabelsSettings.getDefaultLabelExpression();
        return defaultLabelExpression == null ? "" : defaultLabelExpression;
    }

    @InterfaceAudience.Private
    public float getMinimumAllocationFactor() {
        return this.minimumAllocationFactor;
    }

    @InterfaceAudience.Private
    public float getMaxAMResourcePerQueuePercent() {
        return this.maxAMResourcePerQueuePercent;
    }

    public int getMaxApplications() {
        return this.maxApplications;
    }

    public int getMaxApplicationsPerUser() {
        return this.maxApplicationsPerUser;
    }

    public UsersManager getUsersManager() {
        return this.usersManager;
    }

    @Override
    public AbstractUsersManager getAbstractUsersManager() {
        return this.usersManager;
    }

    @Override
    public List<CSQueue> getChildQueues() {
        return null;
    }

    @Override
    public List<CSQueue> getChildQueuesByTryLock() {
        return null;
    }

    @VisibleForTesting
    void setUserLimit(float userLimit) {
        this.usersManager.setUserLimit(userLimit);
        this.usersManager.userLimitNeedsRecompute();
    }

    @VisibleForTesting
    void setUserLimitFactor(float userLimitFactor) {
        this.usersManager.setUserLimitFactor(userLimitFactor);
        this.usersManager.userLimitNeedsRecompute();
    }

    @Override
    public int getNumApplications() {
        this.readLock.lock();
        try {
            int n = this.getNumPendingApplications() + this.getNumActiveApplications() + this.getNumNonRunnableApps();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getNumPendingApplications() {
        this.readLock.lock();
        try {
            int n = this.pendingOrderingPolicy.getNumSchedulableEntities();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getNumActiveApplications() {
        this.readLock.lock();
        try {
            int n = this.orderingPolicy.getNumSchedulableEntities();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public int getNumPendingApplications(String user) {
        this.readLock.lock();
        try {
            UsersManager.User u = this.getUser(user);
            if (null == u) {
                int n = 0;
                return n;
            }
            int n = u.getPendingApplications();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public int getNumActiveApplications(String user) {
        this.readLock.lock();
        try {
            UsersManager.User u = this.getUser(user);
            if (null == u) {
                int n = 0;
                return n;
            }
            int n = u.getActiveApplications();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @InterfaceAudience.Private
    public float getUserLimit() {
        return this.usersManager.getUserLimit();
    }

    @InterfaceAudience.Private
    public float getUserLimitFactor() {
        return this.usersManager.getUserLimitFactor();
    }

    @Override
    public QueueInfo getQueueInfo(boolean includeChildQueues, boolean recursive) {
        QueueInfo queueInfo = this.getQueueInfo();
        return queueInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation user) {
        this.readLock.lock();
        try {
            QueueUserACLInfo userAclInfo = (QueueUserACLInfo)this.recordFactory.newRecordInstance(QueueUserACLInfo.class);
            ArrayList<QueueACL> operations = new ArrayList<QueueACL>();
            for (QueueACL operation : QueueACL.values()) {
                if (!this.hasAccess(operation, user)) continue;
                operations.add(operation);
            }
            userAclInfo.setQueueName(this.getQueuePath());
            userAclInfo.setUserAcls(operations);
            List<QueueUserACLInfo> list = Collections.singletonList(userAclInfo);
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String toString() {
        this.readLock.lock();
        try {
            String string = this.getQueuePath() + ": " + this.getCapacityOrWeightString() + ", absoluteCapacity=" + this.queueCapacities.getAbsoluteCapacity() + ", usedResources=" + this.usageTracker.getQueueUsage().getUsed() + ", usedCapacity=" + this.getUsedCapacity() + ", absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + ", numApps=" + this.getNumApplications() + ", numContainers=" + this.getNumContainers() + ", effectiveMinResource=" + this.getEffectiveCapacity("") + " , effectiveMaxResource=" + this.getEffectiveMaxCapacity("");
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected String getExtendedCapacityOrWeightString() {
        if (this.queueCapacities.getWeight() != -1.0f) {
            return "weight = " + this.queueCapacities.getWeight() + " [= (float) configuredCapacity (with w suffix)] \nnormalizedWeight = " + this.queueCapacities.getNormalizedWeight() + " [= (float) configuredCapacity / sum(configuredCapacity of all queues under the parent)]";
        }
        return "capacity = " + this.queueCapacities.getCapacity() + " [= (float) configuredCapacity / 100 ]";
    }

    @VisibleForTesting
    public UsersManager.User getUser(String userName) {
        return this.usersManager.getUser(userName);
    }

    @VisibleForTesting
    public UsersManager.User getOrCreateUser(String userName) {
        return this.usersManager.getUserAndAddIfAbsent(userName);
    }

    @InterfaceAudience.Private
    public List<AppPriorityACLGroup> getPriorityACLs() {
        this.readLock.lock();
        try {
            ArrayList<AppPriorityACLGroup> arrayList = new ArrayList<AppPriorityACLGroup>(this.priorityAcls);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reinitialize(CSQueue newlyParsedQueue, Resource clusterResource) throws IOException {
        this.writeLock.lock();
        try {
            Resource newMax;
            if (newlyParsedQueue != this) {
                this.setDynamicQueue(false);
            }
            if (!(newlyParsedQueue instanceof AbstractLeafQueue) || !newlyParsedQueue.getQueuePath().equals(this.getQueuePath())) {
                throw new IOException("Trying to reinitialize " + this.getQueuePath() + " from " + newlyParsedQueue.getQueuePath());
            }
            AbstractLeafQueue newlyParsedLeafQueue = (AbstractLeafQueue)newlyParsedQueue;
            Resource oldMax = this.getMaximumAllocation();
            if (!Resources.fitsIn((Resource)oldMax, (Resource)(newMax = newlyParsedLeafQueue.getMaximumAllocation()))) {
                throw new IOException("Trying to reinitialize " + this.getQueuePath() + " the maximum allocation size can not be decreased! Current setting: " + oldMax + ", trying to set it to: " + newMax);
            }
            this.setupQueueConfigs(clusterResource);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void submitApplicationAttempt(FiCaSchedulerApp application, String userName) {
        this.submitApplicationAttempt(application, userName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitApplicationAttempt(FiCaSchedulerApp application, String userName, boolean isMoveApp) {
        boolean isAppAlreadySubmitted = this.applicationAttemptMap.containsKey(application.getApplicationAttemptId());
        this.writeLock.lock();
        try {
            UsersManager.User user = this.usersManager.getUserAndAddIfAbsent(userName);
            this.addApplicationAttempt(application, user);
        }
        finally {
            this.writeLock.unlock();
        }
        if (!isMoveApp && !isAppAlreadySubmitted) {
            boolean unmanagedAM = application.getAppSchedulingInfo() != null && application.getAppSchedulingInfo().isUnmanagedAM();
            this.usageTracker.getMetrics().submitAppAttempt(userName, unmanagedAM);
        }
        this.parent.submitApplicationAttempt(application, userName);
    }

    @Override
    public void submitApplication(ApplicationId applicationId, String userName, String queue) throws AccessControlException {
        this.validateSubmitApplication(applicationId, userName, queue);
        this.updateLastSubmittedTimeStamp();
        try {
            this.parent.submitApplication(applicationId, userName, queue);
        }
        catch (AccessControlException ace) {
            LOG.info("Failed to submit application to parent-queue: " + this.parent.getQueuePath(), (Throwable)ace);
            throw ace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateSubmitApplication(ApplicationId applicationId, String userName, String queue) throws AccessControlException {
        this.writeLock.lock();
        try {
            if (this.getState() != QueueState.RUNNING) {
                String msg = "Queue " + this.getQueuePath() + " is STOPPED. Cannot accept submission of application: " + applicationId;
                LOG.info(msg);
                throw new AccessControlException(msg);
            }
            if (this.getNumApplications() >= this.getMaxApplications() && !(this instanceof AutoCreatedLeafQueue)) {
                String msg = "Queue " + this.getQueuePath() + " already has " + this.getNumApplications() + " applications, cannot accept submission of application: " + applicationId;
                LOG.info(msg);
                throw new AccessControlException(msg);
            }
            UsersManager.User user = this.usersManager.getUserAndAddIfAbsent(userName);
            if (user.getTotalApplications() >= this.getMaxApplicationsPerUser() && !(this instanceof AutoCreatedLeafQueue)) {
                String msg = "Queue " + this.getQueuePath() + " already has " + user.getTotalApplications() + " applications from user " + userName + " cannot accept submission of application: " + applicationId;
                LOG.info(msg);
                throw new AccessControlException(msg);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        try {
            this.parent.validateSubmitApplication(applicationId, userName, queue);
        }
        catch (AccessControlException ace) {
            LOG.info("Failed to submit application to parent-queue: " + this.parent.getQueuePath(), (Throwable)ace);
            throw ace;
        }
    }

    public Resource getAMResourceLimit() {
        return this.usageTracker.getQueueUsage().getAMLimit();
    }

    public Resource getAMResourceLimitPerPartition(String nodePartition) {
        return this.usageTracker.getQueueUsage().getAMLimit(nodePartition);
    }

    @VisibleForTesting
    public Resource calculateAndGetAMResourceLimit() {
        return this.calculateAndGetAMResourceLimitPerPartition("");
    }

    @VisibleForTesting
    public Resource getUserAMResourceLimit() {
        return this.getUserAMResourceLimitPerPartition("", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getUserAMResourceLimitPerPartition(String nodePartition, String userName) {
        float userWeight = 1.0f;
        if (userName != null && this.getUser(userName) != null) {
            userWeight = this.getUser(userName).getWeight();
        }
        this.readLock.lock();
        try {
            float effectiveUserLimit;
            float preWeightedUserLimit = effectiveUserLimit = Math.max(this.usersManager.getUserLimit() / 100.0f, 1.0f / (float)Math.max(this.getAbstractUsersManager().getNumActiveUsers(), 1));
            effectiveUserLimit = Math.min(effectiveUserLimit * userWeight, 1.0f);
            Resource queuePartitionResource = this.getEffectiveCapacity(nodePartition);
            Resource minimumAllocation = this.queueAllocationSettings.getMinimumAllocation();
            Resource userAMLimit = Resources.multiplyAndNormalizeUp((ResourceCalculator)this.resourceCalculator, (Resource)queuePartitionResource, (double)(this.queueCapacities.getMaxAMResourcePercentage(nodePartition) * effectiveUserLimit * this.usersManager.getUserLimitFactor()), (Resource)minimumAllocation);
            if (this.getUserLimitFactor() == -1.0f) {
                userAMLimit = Resources.multiplyAndNormalizeUp((ResourceCalculator)this.resourceCalculator, (Resource)queuePartitionResource, (double)this.queueCapacities.getMaxAMResourcePercentage(nodePartition), (Resource)minimumAllocation);
            }
            userAMLimit = Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)this.lastClusterResource, (Resource)userAMLimit, (Resource)Resources.clone((Resource)this.getAMResourceLimitPerPartition(nodePartition)));
            Resource preWeighteduserAMLimit = Resources.multiplyAndNormalizeUp((ResourceCalculator)this.resourceCalculator, (Resource)queuePartitionResource, (double)(this.queueCapacities.getMaxAMResourcePercentage(nodePartition) * preWeightedUserLimit * this.usersManager.getUserLimitFactor()), (Resource)minimumAllocation);
            if (this.getUserLimitFactor() == -1.0f) {
                preWeighteduserAMLimit = Resources.multiplyAndNormalizeUp((ResourceCalculator)this.resourceCalculator, (Resource)queuePartitionResource, (double)this.queueCapacities.getMaxAMResourcePercentage(nodePartition), (Resource)minimumAllocation);
            }
            preWeighteduserAMLimit = Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)this.lastClusterResource, (Resource)preWeighteduserAMLimit, (Resource)Resources.clone((Resource)this.getAMResourceLimitPerPartition(nodePartition)));
            this.usageTracker.getQueueUsage().setUserAMLimit(nodePartition, preWeighteduserAMLimit);
            LOG.debug("Effective user AM limit for \"{}\":{}. Effective weighted user AM limit: {}. User weight: {}", new Object[]{userName, preWeighteduserAMLimit, userAMLimit, Float.valueOf(userWeight)});
            Resource resource = userAMLimit;
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource calculateAndGetAMResourceLimitPerPartition(String nodePartition) {
        this.writeLock.lock();
        try {
            Resource queuePartitionResource = this.getEffectiveCapacity(nodePartition);
            Resource queueCurrentLimit = Resources.none();
            if (nodePartition.equals("")) {
                QueueResourceLimitsInfo queueResourceLimitsInfo = this.queueResourceLimitsInfo;
                synchronized (queueResourceLimitsInfo) {
                    queueCurrentLimit = this.queueResourceLimitsInfo.getQueueCurrentLimit();
                }
            }
            float amResourcePercent = this.queueCapacities.getMaxAMResourcePercentage(nodePartition);
            Resource queuePartitionUsableResource = Resources.fitsIn((ResourceCalculator)this.resourceCalculator, (Resource)queuePartitionResource, (Resource)queueCurrentLimit) ? queueCurrentLimit : queuePartitionResource;
            Resource amResouceLimit = Resources.multiplyAndNormalizeUp((ResourceCalculator)this.resourceCalculator, (Resource)queuePartitionUsableResource, (double)amResourcePercent, (Resource)this.queueAllocationSettings.getMinimumAllocation());
            this.usageTracker.getMetrics().setAMResouceLimit(nodePartition, amResouceLimit);
            this.usageTracker.getQueueUsage().setAMLimit(nodePartition, amResouceLimit);
            LOG.debug("Queue: {}, node label : {}, queue partition resource : {}, queue current limit : {}, queue partition usable resource : {}, amResourceLimit : {}", new Object[]{this.getQueuePath(), nodePartition, queuePartitionResource, queueCurrentLimit, queuePartitionUsableResource, amResouceLimit});
            Resource resource = amResouceLimit;
            return resource;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activateApplications() {
        this.writeLock.lock();
        try {
            HashMap<String, Resource> userAmPartitionLimit = new HashMap<String, Resource>();
            for (String nodePartition : this.getNodeLabelsForQueue()) {
                this.calculateAndGetAMResourceLimitPerPartition(nodePartition);
            }
            Iterator<FiCaSchedulerApp> fsApp = this.getPendingAppsOrderingPolicy().getAssignmentIterator(IteratorSelector.EMPTY_ITERATOR_SELECTOR);
            while (fsApp.hasNext()) {
                Resource userAmIfStarted;
                FiCaSchedulerApp application = fsApp.next();
                ApplicationId applicationId = application.getApplicationId();
                String partitionName = application.getAppAMNodePartitionName();
                Resource amLimit = this.getAMResourceLimitPerPartition(partitionName);
                if (amLimit == null) {
                    amLimit = this.calculateAndGetAMResourceLimitPerPartition(partitionName);
                }
                Resource amIfStarted = Resources.add((Resource)application.getAMResource(partitionName), (Resource)this.usageTracker.getQueueUsage().getAMUsed(partitionName));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("application " + application.getId() + " AMResource " + application.getAMResource(partitionName) + " maxAMResourcePerQueuePercent " + this.maxAMResourcePerQueuePercent + " amLimit " + amLimit + " lastClusterResource " + this.lastClusterResource + " amIfStarted " + amIfStarted + " AM node-partition name " + partitionName);
                }
                if (!this.resourceCalculator.fitsIn(amIfStarted, amLimit)) {
                    if (this.getNumActiveApplications() < 1 || Resources.lessThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)this.lastClusterResource, (Resource)this.usageTracker.getQueueUsage().getAMUsed(partitionName), (Resource)Resources.none())) {
                        LOG.warn("maximum-am-resource-percent is insufficient to start a single application in queue, it is likely set too low. skipping enforcement to allow at least one application to start");
                    } else {
                        application.updateAMContainerDiagnostics(SchedulerApplicationAttempt.AMState.INACTIVATED, "Queue's AM resource limit exceeded. ");
                        LOG.debug("Not activating application {} as  amIfStarted: {} exceeds amLimit: {}", new Object[]{applicationId, amIfStarted, amLimit});
                        continue;
                    }
                }
                UsersManager.User user = this.usersManager.getUserAndAddIfAbsent(application.getUser());
                Resource userAMLimit = (Resource)userAmPartitionLimit.get(partitionName);
                if (userAMLimit == null) {
                    userAMLimit = this.getUserAMResourceLimitPerPartition(partitionName, application.getUser());
                    userAmPartitionLimit.put(partitionName, userAMLimit);
                }
                if (!this.resourceCalculator.fitsIn(userAmIfStarted = Resources.add((Resource)application.getAMResource(partitionName), (Resource)user.getConsumedAMResources(partitionName)), userAMLimit)) {
                    if (this.getNumActiveApplications() < 1 || Resources.lessThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)this.lastClusterResource, (Resource)this.usageTracker.getQueueUsage().getAMUsed(partitionName), (Resource)Resources.none())) {
                        LOG.warn("maximum-am-resource-percent is insufficient to start a single application in queue for user, it is likely set too low. skipping enforcement to allow at least one application to start");
                    } else {
                        application.updateAMContainerDiagnostics(SchedulerApplicationAttempt.AMState.INACTIVATED, "User's AM resource limit exceeded. ");
                        LOG.debug("Not activating application {} for user: {} as userAmIfStarted: {} exceeds userAmLimit: {}", new Object[]{applicationId, user, userAmIfStarted, userAMLimit});
                        continue;
                    }
                }
                user.activateApplication();
                this.orderingPolicy.addSchedulableEntity(application);
                application.updateAMContainerDiagnostics(SchedulerApplicationAttempt.AMState.ACTIVATED, null);
                this.usageTracker.getQueueUsage().incAMUsed(partitionName, application.getAMResource(partitionName));
                user.getResourceUsage().incAMUsed(partitionName, application.getAMResource(partitionName));
                user.getResourceUsage().setAMLimit(partitionName, userAMLimit);
                this.usageTracker.getMetrics().incAMUsed(partitionName, application.getUser(), application.getAMResource(partitionName));
                this.usageTracker.getMetrics().setAMResouceLimitForUser(partitionName, application.getUser(), userAMLimit);
                fsApp.remove();
                LOG.info("Application " + applicationId + " from user: " + application.getUser() + " activated in queue: " + this.getQueuePath());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void addApplicationAttempt(FiCaSchedulerApp application, UsersManager.User user) {
        this.writeLock.lock();
        try {
            this.applicationAttemptMap.put(application.getApplicationAttemptId(), application);
            if (!application.isRunnable()) {
                this.nonRunnableApps.add(application);
                LOG.info("Application attempt {} is not runnable, parallel limit reached", (Object)application.getApplicationAttemptId());
                return;
            }
            this.runnableApps.add(application);
            LOG.debug("Adding runnable application: {}", (Object)application.getApplicationAttemptId());
            user.submitApplication();
            this.getPendingAppsOrderingPolicy().addSchedulableEntity(application);
            if (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)this.lastClusterResource, (Resource)this.lastClusterResource, (Resource)Resources.none())) {
                this.activateApplications();
            } else {
                application.updateAMContainerDiagnostics(SchedulerApplicationAttempt.AMState.INACTIVATED, "Skipping AM assignment as cluster resource is empty. ");
                LOG.info("Skipping activateApplications for " + application.getApplicationAttemptId() + " since cluster resource is " + Resources.none());
            }
            LOG.info("Application added - appId: " + application.getApplicationId() + " user: " + application.getUser() + ", leaf-queue: " + this.getQueuePath() + " #user-pending-applications: " + user.getPendingApplications() + " #user-active-applications: " + user.getActiveApplications() + " #queue-pending-applications: " + this.getNumPendingApplications() + " #queue-active-applications: " + this.getNumActiveApplications() + " #queue-nonrunnable-applications: " + this.getNumNonRunnableApps());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void finishApplication(ApplicationId application, String user) {
        this.usersManager.deactivateApplication(user, application);
        this.appFinished();
        this.parent.finishApplication(application, user);
    }

    @Override
    public void finishApplicationAttempt(FiCaSchedulerApp application, String queue) {
        this.removeApplicationAttempt(application, application.getUser());
        this.parent.finishApplicationAttempt(application, queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeApplicationAttempt(FiCaSchedulerApp application, String userName) {
        this.writeLock.lock();
        try {
            UsersManager.User user = this.usersManager.getUserAndAddIfAbsent(userName);
            boolean runnable = this.runnableApps.remove(application);
            if (!runnable && !this.removeNonRunnableApp(application)) {
                LOG.error("Given app to remove " + application + " does not exist in queue " + this.getQueuePath());
            }
            String partitionName = application.getAppAMNodePartitionName();
            boolean wasActive = this.orderingPolicy.removeSchedulableEntity(application);
            if (!wasActive) {
                this.pendingOrderingPolicy.removeSchedulableEntity(application);
            } else {
                this.usageTracker.getQueueUsage().decAMUsed(partitionName, application.getAMResource(partitionName));
                user.getResourceUsage().decAMUsed(partitionName, application.getAMResource(partitionName));
                this.usageTracker.getMetrics().decAMUsed(partitionName, application.getUser(), application.getAMResource(partitionName));
            }
            this.applicationAttemptMap.remove(application.getApplicationAttemptId());
            user.finishApplication(wasActive);
            if (user.getTotalApplications() == 0) {
                this.usersManager.removeUser(application.getUser());
            }
            this.activateApplications();
            LOG.info("Application removed - appId: " + application.getApplicationId() + " user: " + application.getUser() + " queue: " + this.getQueuePath() + " #user-pending-applications: " + user.getPendingApplications() + " #user-active-applications: " + user.getActiveApplications() + " #queue-pending-applications: " + this.getNumPendingApplications() + " #queue-active-applications: " + this.getNumActiveApplications());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private FiCaSchedulerApp getApplication(ApplicationAttemptId applicationAttemptId) {
        return this.applicationAttemptMap.get(applicationAttemptId);
    }

    private void setPreemptionAllowed(ResourceLimits limits, String nodePartition) {
        float guaranteedCapacity;
        if (!this.usageTracker.getQueueResourceQuotas().getEffectiveMinResource(nodePartition).equals((Object)Resources.none())) {
            limits.setIsAllowPreemption(Resources.lessThan((ResourceCalculator)this.resourceCalculator, (Resource)this.queueContext.getClusterResource(), (Resource)this.usageTracker.getQueueUsage().getUsed(nodePartition), (Resource)this.usageTracker.getQueueResourceQuotas().getEffectiveMinResource(nodePartition)));
            return;
        }
        float usedCapacity = this.queueCapacities.getAbsoluteUsedCapacity(nodePartition);
        limits.setIsAllowPreemption(usedCapacity < (guaranteedCapacity = this.queueCapacities.getAbsoluteCapacity(nodePartition)));
    }

    private CSAssignment allocateFromReservedContainer(Resource clusterResource, CandidateNodeSet<FiCaSchedulerNode> candidates, ResourceLimits currentResourceLimits, SchedulingMode schedulingMode) {
        FiCaSchedulerApp application;
        RMContainer reservedContainer;
        FiCaSchedulerNode node = CandidateNodeSetUtils.getSingleNode(candidates);
        if (node != null && (reservedContainer = node.getReservedContainer()) != null && null != (application = this.getApplication(reservedContainer.getApplicationAttemptId()))) {
            ActivitiesLogger.APP.startAppAllocationRecording(this.activitiesManager, node, SystemClock.getInstance().getTime(), application);
            CSAssignment assignment = application.assignContainers(clusterResource, candidates, currentResourceLimits, schedulingMode, reservedContainer);
            return assignment;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentMap<String, CachedUserLimit> getUserLimitCache(String partition, SchedulingMode schedulingMode) {
        Map<String, Map<SchedulingMode, ConcurrentMap<String, CachedUserLimit>>> map = this.userLimitsCache;
        synchronized (map) {
            ConcurrentMap<String, CachedUserLimit> uLCBySchedulingMode;
            long latestVersion = this.usersManager.getLatestVersionOfUsersState();
            if (latestVersion != this.currentUserLimitCacheVersion) {
                this.currentUserLimitCacheVersion = latestVersion;
                this.userLimitsCache.clear();
                HashMap<SchedulingMode, ConcurrentHashMap<String, CachedUserLimit>> uLCByPartition = new HashMap<SchedulingMode, ConcurrentHashMap<String, CachedUserLimit>>();
                this.userLimitsCache.put(partition, uLCByPartition);
                ConcurrentHashMap<String, CachedUserLimit> uLCBySchedulingMode2 = new ConcurrentHashMap<String, CachedUserLimit>();
                uLCByPartition.put(schedulingMode, uLCBySchedulingMode2);
                return uLCBySchedulingMode2;
            }
            Map<SchedulingMode, ConcurrentMap<String, CachedUserLimit>> uLCByPartition = this.userLimitsCache.get(partition);
            if (uLCByPartition == null) {
                uLCByPartition = new HashMap<SchedulingMode, ConcurrentMap<String, CachedUserLimit>>();
                this.userLimitsCache.put(partition, uLCByPartition);
            }
            if ((uLCBySchedulingMode = uLCByPartition.get((Object)schedulingMode)) == null) {
                uLCBySchedulingMode = new ConcurrentHashMap<String, CachedUserLimit>();
                uLCByPartition.put(schedulingMode, uLCBySchedulingMode);
            }
            return uLCBySchedulingMode;
        }
    }

    @Override
    public CSAssignment assignContainers(Resource clusterResource, CandidateNodeSet<FiCaSchedulerNode> candidates, ResourceLimits currentResourceLimits, SchedulingMode schedulingMode) {
        this.updateCurrentResourceLimits(currentResourceLimits, clusterResource);
        FiCaSchedulerNode node = CandidateNodeSetUtils.getSingleNode(candidates);
        if (LOG.isDebugEnabled()) {
            LOG.debug("assignContainers: partition=" + candidates.getPartition() + " #applications=" + this.orderingPolicy.getNumSchedulableEntities());
        }
        this.setPreemptionAllowed(currentResourceLimits, candidates.getPartition());
        CSAssignment assignment = this.allocateFromReservedContainer(clusterResource, candidates, currentResourceLimits, schedulingMode);
        if (null != assignment) {
            return assignment;
        }
        if (schedulingMode == SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY && !this.queueNodeLabelsSettings.isAccessibleToPartition(candidates.getPartition())) {
            ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, (SchedulerNode)node, this.parent.getQueuePath(), this.getQueuePath(), ActivityState.REJECTED, "Queue is not able to access partition");
            return CSAssignment.NULL_ASSIGNMENT;
        }
        if (!this.hasPendingResourceRequest(candidates.getPartition(), clusterResource, schedulingMode)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skip this queue=" + this.getQueuePath() + ", because it doesn't need more resource, schedulingMode=" + schedulingMode.name() + " node-partition=" + candidates.getPartition());
            }
            ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, (SchedulerNode)node, this.parent.getQueuePath(), this.getQueuePath(), ActivityState.SKIPPED, "Queue does not need more resource");
            return CSAssignment.NULL_ASSIGNMENT;
        }
        ConcurrentMap<String, CachedUserLimit> userLimits = this.getUserLimitCache(candidates.getPartition(), schedulingMode);
        boolean needAssignToQueueCheck = true;
        IteratorSelector sel = new IteratorSelector();
        sel.setPartition(candidates.getPartition());
        Iterator<FiCaSchedulerApp> assignmentIterator = this.orderingPolicy.getAssignmentIterator(sel);
        while (assignmentIterator.hasNext()) {
            Resource assigned;
            FiCaSchedulerApp application = assignmentIterator.next();
            if (!this.applicationAttemptMap.containsKey(application.getApplicationAttemptId())) continue;
            ActivitiesLogger.APP.startAppAllocationRecording(this.activitiesManager, node, SystemClock.getInstance().getTime(), application);
            Resource appReserved = application.getCurrentReservation();
            if (needAssignToQueueCheck) {
                if (!super.canAssignToThisQueue(clusterResource, candidates.getPartition(), currentResourceLimits, appReserved, schedulingMode)) {
                    ActivitiesLogger.APP.recordRejectedAppActivityFromLeafQueue(this.activitiesManager, node, application, application.getPriority(), "Queue hits max-capacity limit");
                    ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, (SchedulerNode)node, this.parent.getQueuePath(), this.getQueuePath(), ActivityState.REJECTED, "Queue hits max-capacity limit");
                    return CSAssignment.NULL_ASSIGNMENT;
                }
                if (!this.reservationsContinueLooking || appReserved.equals((Object)Resources.none())) {
                    needAssignToQueueCheck = false;
                }
            }
            CachedUserLimit cul = (CachedUserLimit)userLimits.get(application.getUser());
            Resource cachedUserLimit = null;
            if (cul != null) {
                cachedUserLimit = cul.userLimit;
            }
            Resource userLimit = this.computeUserLimitAndSetHeadroom(application, clusterResource, candidates.getPartition(), schedulingMode, cachedUserLimit);
            if (cul == null) {
                cul = new CachedUserLimit(userLimit);
                CachedUserLimit retVal = userLimits.putIfAbsent(application.getUser(), cul);
                if (retVal != null) {
                    cul = retVal;
                    userLimit = cul.userLimit;
                }
            }
            boolean userAssignable = true;
            if (!cul.canAssign && Resources.fitsIn((Resource)appReserved, (Resource)cul.reservation)) {
                userAssignable = false;
            } else {
                userAssignable = this.canAssignToUser(clusterResource, application.getUser(), userLimit, application, candidates.getPartition(), currentResourceLimits);
                if (!userAssignable && Resources.fitsIn((Resource)cul.reservation, (Resource)appReserved) && this.applicationAttemptMap.containsKey(application.getApplicationAttemptId())) {
                    cul.canAssign = false;
                    cul.reservation = appReserved;
                }
            }
            if (!userAssignable) {
                String userName = application.getUser();
                UsersManager.User user = this.getUser(userName);
                Resource usedResourceByUser = user == null ? null : user.getUsed(candidates.getPartition());
                application.updateAMContainerDiagnostics(SchedulerApplicationAttempt.AMState.ACTIVATED, "User capacity has reached its maximum limit, user limit is " + userLimit + ", resource used by " + userName + " is " + usedResourceByUser + ".");
                ActivitiesLogger.APP.recordRejectedAppActivityFromLeafQueue(this.activitiesManager, node, application, application.getPriority(), "Queue hits user max-capacity limit");
                continue;
            }
            assignment = application.assignContainers(clusterResource, candidates, currentResourceLimits, schedulingMode, null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("post-assignContainers for application " + application.getApplicationId());
                application.showRequests();
            }
            if (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)(assigned = assignment.getResource()), (Resource)Resources.none())) {
                ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, (SchedulerNode)node, this.parent.getQueuePath(), this.getQueuePath(), ActivityState.ACCEPTED, ActivityDiagnosticConstant.EMPTY);
                return assignment;
            }
            if (assignment.getSkippedType() == CSAssignment.SkippedType.OTHER) {
                ActivitiesLogger.APP.finishSkippedAppAllocationRecording(this.activitiesManager, application.getApplicationId(), ActivityState.SKIPPED, ActivityDiagnosticConstant.EMPTY);
                application.updateNodeInfoForAMDiagnostics(node);
                continue;
            }
            if (assignment.getSkippedType() == CSAssignment.SkippedType.QUEUE_LIMIT) {
                ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, (SchedulerNode)node, this.parent.getQueuePath(), this.getQueuePath(), ActivityState.REJECTED, () -> "Queue does not have enough headroom for inner highest-priority request from " + application.getApplicationId());
                return assignment;
            }
            ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, (SchedulerNode)node, this.parent.getQueuePath(), this.getQueuePath(), ActivityState.SKIPPED, "Queue skipped to respect FIFO of applications");
            ActivitiesLogger.APP.finishSkippedAppAllocationRecording(this.activitiesManager, application.getApplicationId(), ActivityState.SKIPPED, ActivityDiagnosticConstant.EMPTY);
            return CSAssignment.NULL_ASSIGNMENT;
        }
        ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, (SchedulerNode)node, this.parent.getQueuePath(), this.getQueuePath(), ActivityState.SKIPPED, ActivityDiagnosticConstant.EMPTY);
        return CSAssignment.NULL_ASSIGNMENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accept(Resource cluster, ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> request) {
        ContainerAllocationProposal<FiCaSchedulerApp, FiCaSchedulerNode> allocation = request.getFirstAllocatedOrReservedContainer();
        SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer = allocation.getAllocatedOrReservedContainer();
        if (allocation.getAllocateFromReservedContainer() == null) {
            this.readLock.lock();
            try {
                FiCaSchedulerApp app = schedulerContainer.getSchedulerApplicationAttempt();
                String username = app.getUser();
                String p = schedulerContainer.getNodePartition();
                Resource userLimit = this.computeUserLimitAndSetHeadroom(app, cluster, p, allocation.getSchedulingMode(), null);
                UsersManager.User user = this.getUser(username);
                if (user == null) {
                    LOG.debug("User {} has been removed!", (Object)username);
                    boolean bl = false;
                    return bl;
                }
                Resource usedResource = Resources.clone((Resource)user.getUsed(p));
                Resources.subtractFrom((Resource)usedResource, (Resource)request.getTotalReleasedResource());
                if (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)cluster, (Resource)usedResource, (Resource)userLimit)) {
                    LOG.debug("Used resource={} exceeded user-limit={}", (Object)usedResource, (Object)userLimit);
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
        return super.accept(cluster, request);
    }

    private void internalReleaseContainer(Resource clusterResource, SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer) {
        RMContainer rmContainer = schedulerContainer.getRmContainer();
        AbstractLeafQueue targetLeafQueue = schedulerContainer.getSchedulerApplicationAttempt().getCSLeafQueue();
        if (targetLeafQueue == this) {
            if (rmContainer.getState() == RMContainerState.RESERVED) {
                this.completedContainer(clusterResource, schedulerContainer.getSchedulerApplicationAttempt(), schedulerContainer.getSchedulerNode(), rmContainer, SchedulerUtils.createAbnormalContainerStatus(rmContainer.getContainerId(), "Container reservation no longer required."), RMContainerEventType.RELEASED, null, false);
            }
        } else {
            targetLeafQueue.completedContainer(clusterResource, schedulerContainer.getSchedulerApplicationAttempt(), schedulerContainer.getSchedulerNode(), schedulerContainer.getRmContainer(), SchedulerUtils.createPreemptedContainerStatus(rmContainer.getContainerId(), "Container preempted by scheduler"), RMContainerEventType.KILL, null, false);
        }
    }

    private void releaseContainers(Resource clusterResource, ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> request) {
        for (SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer : request.getContainersToRelease()) {
            this.internalReleaseContainer(clusterResource, schedulerContainer);
        }
        if (null != request.getContainersToAllocate() && !request.getContainersToAllocate().isEmpty()) {
            for (ContainerAllocationProposal containerAllocationProposal : request.getContainersToAllocate()) {
                if (null == containerAllocationProposal.getToRelease()) continue;
                for (SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer : containerAllocationProposal.getToRelease()) {
                    this.internalReleaseContainer(clusterResource, schedulerContainer);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Resource cluster, ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> request) {
        boolean applyToParentQueue = false;
        this.releaseContainers(cluster, request);
        this.writeLock.lock();
        try {
            if (request.anythingAllocatedOrReserved()) {
                ContainerAllocationProposal<FiCaSchedulerApp, FiCaSchedulerNode> allocation = request.getFirstAllocatedOrReservedContainer();
                SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer = allocation.getAllocatedOrReservedContainer();
                if (allocation.getAllocateFromReservedContainer() == null) {
                    applyToParentQueue = true;
                    this.allocateResource(cluster, schedulerContainer.getSchedulerApplicationAttempt(), allocation.getAllocatedOrReservedResource(), schedulerContainer.getNodePartition(), schedulerContainer.getRmContainer());
                    this.orderingPolicy.containerAllocated(schedulerContainer.getSchedulerApplicationAttempt(), schedulerContainer.getRmContainer());
                }
                if (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)cluster, (Resource)request.getTotalReservedResource(), (Resource)Resources.none())) {
                    this.incReservedResource(schedulerContainer.getNodePartition(), request.getTotalReservedResource());
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (this.parent != null && applyToParentQueue) {
            this.parent.apply(cluster, request);
        }
    }

    protected Resource getHeadroom(UsersManager.User user, Resource queueCurrentLimit, Resource clusterResource, FiCaSchedulerApp application) {
        return this.getHeadroom(user, queueCurrentLimit, clusterResource, application, "");
    }

    protected Resource getHeadroom(UsersManager.User user, Resource queueCurrentLimit, Resource clusterResource, FiCaSchedulerApp application, String partition) {
        return this.getHeadroom(user, queueCurrentLimit, clusterResource, this.getResourceLimitForActiveUsers(application.getUser(), clusterResource, partition, SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), partition);
    }

    private Resource getHeadroom(UsersManager.User user, Resource currentPartitionResourceLimit, Resource clusterResource, Resource userLimitResource, String partition) {
        currentPartitionResourceLimit = partition.equals("") ? currentPartitionResourceLimit : this.getQueueMaxResource(partition);
        Resource headroom = Resources.componentwiseMin((Resource)Resources.subtractNonNegative((Resource)userLimitResource, (Resource)user.getUsed(partition)), (Resource)Resources.subtractNonNegative((Resource)currentPartitionResourceLimit, (Resource)this.usageTracker.getQueueUsage().getUsed(partition)));
        headroom = Resources.roundDown((ResourceCalculator)this.resourceCalculator, (Resource)headroom, (Resource)this.queueAllocationSettings.getMinimumAllocation());
        Resource clusterPartitionResource = this.labelManager.getResourceByLabel(partition, clusterResource);
        Resource clusterFreePartitionResource = Resources.subtract((Resource)clusterPartitionResource, (Resource)this.queueContext.getClusterResourceUsage().getUsed(partition));
        headroom = Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)clusterPartitionResource, (Resource)clusterFreePartitionResource, (Resource)headroom);
        return headroom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setQueueResourceLimitsInfo(Resource clusterResource) {
        QueueResourceLimitsInfo queueResourceLimitsInfo = this.queueResourceLimitsInfo;
        synchronized (queueResourceLimitsInfo) {
            this.queueResourceLimitsInfo.setQueueCurrentLimit(this.cachedResourceLimitsForHeadroom.getLimit());
            this.queueResourceLimitsInfo.setClusterResource(clusterResource);
        }
    }

    @Lock(value={AbstractLeafQueue.class})
    Resource computeUserLimitAndSetHeadroom(FiCaSchedulerApp application, Resource clusterResource, String nodePartition, SchedulingMode schedulingMode, Resource userLimit) {
        Resource headroom;
        String user = application.getUser();
        UsersManager.User queueUser = this.getUser(user);
        if (queueUser == null) {
            LOG.debug("User {} has been removed!", (Object)user);
            return Resources.none();
        }
        if (userLimit == null) {
            userLimit = this.getResourceLimitForActiveUsers(application.getUser(), clusterResource, nodePartition, schedulingMode);
        }
        this.setQueueResourceLimitsInfo(clusterResource);
        Resource resource = headroom = this.usageTracker.getMetrics().getUserMetrics(user) == null ? Resources.none() : this.getHeadroom(queueUser, this.cachedResourceLimitsForHeadroom.getLimit(), clusterResource, userLimit, nodePartition);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Headroom calculation for user " + user + ":  userLimit=" + userLimit + " queueMaxAvailRes=" + this.cachedResourceLimitsForHeadroom.getLimit() + " consumed=" + queueUser.getUsed() + " partition=" + nodePartition);
        }
        CapacityHeadroomProvider headroomProvider = new CapacityHeadroomProvider(queueUser, this, application, this.queueResourceLimitsInfo);
        application.setHeadroomProvider(headroomProvider);
        this.usageTracker.getMetrics().setAvailableResourcesToUser(nodePartition, user, headroom);
        return userLimit;
    }

    @Lock(value={Lock.NoLock.class})
    public int getNodeLocalityDelay() {
        return this.nodeLocalityDelay;
    }

    @Lock(value={Lock.NoLock.class})
    public int getRackLocalityAdditionalDelay() {
        return this.rackLocalityAdditionalDelay;
    }

    @Lock(value={Lock.NoLock.class})
    public boolean getRackLocalityFullReset() {
        return this.rackLocalityFullReset;
    }

    public Resource getResourceLimitForActiveUsers(String userName, Resource clusterResource, String nodePartition, SchedulingMode schedulingMode) {
        return this.usersManager.getComputedResourceLimitForActiveUsers(userName, clusterResource, nodePartition, schedulingMode);
    }

    public Resource getResourceLimitForAllUsers(String userName, Resource clusterResource, String nodePartition, SchedulingMode schedulingMode) {
        return this.usersManager.getComputedResourceLimitForAllUsers(userName, clusterResource, nodePartition, schedulingMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    protected boolean canAssignToUser(Resource clusterResource, String userName, Resource limit, FiCaSchedulerApp application, String nodePartition, ResourceLimits currentResourceLimits) {
        this.readLock.lock();
        try {
            UsersManager.User user = this.getUser(userName);
            if (user == null) {
                LOG.debug("User {} has been removed!", (Object)userName);
                boolean bl = false;
                return bl;
            }
            currentResourceLimits.setAmountNeededUnreserve(Resources.none());
            if (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)user.getUsed(nodePartition), (Resource)limit)) {
                if (this.reservationsContinueLooking && Resources.lessThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)Resources.subtract((Resource)user.getUsed(), (Resource)application.getCurrentReservation()), (Resource)limit)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("User " + userName + " in queue " + this.getQueuePath() + " will exceed limit based on reservations -  consumed: " + user.getUsed() + " reserved: " + application.getCurrentReservation() + " limit: " + limit);
                    }
                    Resource amountNeededToUnreserve = Resources.subtract((Resource)user.getUsed(nodePartition), (Resource)limit);
                    currentResourceLimits.setAmountNeededUnreserve(amountNeededToUnreserve);
                    boolean bl = true;
                    return bl;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("User " + userName + " in queue " + this.getQueuePath() + " will exceed limit -  consumed: " + user.getUsed(nodePartition) + " limit: " + limit);
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    protected void parseAndSetDynamicTemplates() {
        this.queueContext.getConfiguration().setUserLimitFactor(this.getQueuePathObject(), -1.0f);
        this.queueContext.getConfiguration().setMaximumApplicationMasterResourcePerQueuePercent(this.getQueuePathObject(), 1.0f);
        super.parseAndSetDynamicTemplates();
    }

    @Override
    protected void setDynamicQueueACLProperties() {
        super.setDynamicQueueACLProperties();
        if (this.parent instanceof AbstractManagedParentQueue) {
            this.acls.putAll(this.queueContext.getConfiguration().getACLsForLegacyAutoCreatedLeafQueue(this.parent.getQueuePathObject()));
        } else if (this.parent instanceof ParentQueue) {
            this.acls.putAll(CapacitySchedulerConfiguration.getACLsForFlexibleAutoCreatedLeafQueue(((ParentQueue)this.parent).getAutoCreatedQueueTemplate()));
        }
    }

    private void updateSchedulerHealthForCompletedContainer(RMContainer rmContainer, ContainerStatus containerStatus) {
        SchedulerHealth schedulerHealth = this.queueContext.getSchedulerHealth();
        if (null == schedulerHealth) {
            return;
        }
        if (containerStatus.getExitStatus() == -102) {
            schedulerHealth.updatePreemption(Time.now(), rmContainer.getAllocatedNode(), rmContainer.getContainerId(), this.getQueuePath());
            schedulerHealth.updateSchedulerPreemptionCounts(1L);
        } else {
            schedulerHealth.updateRelease(this.queueContext.getLastNodeUpdateTime(), rmContainer.getAllocatedNode(), rmContainer.getContainerId(), this.getQueuePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recalculateQueueUsageRatio(Resource clusterResource, String nodePartition) {
        this.writeLock.lock();
        try {
            ResourceUsage queueResourceUsage = this.getQueueResourceUsage();
            if (nodePartition == null) {
                for (String partition : Sets.union(this.getQueueCapacities().getExistingNodeLabels(), queueResourceUsage.getExistingNodeLabels())) {
                    this.usersManager.updateUsageRatio(partition, clusterResource);
                }
            } else {
                this.usersManager.updateUsageRatio(nodePartition, clusterResource);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completedContainer(Resource clusterResource, FiCaSchedulerApp application, FiCaSchedulerNode node, RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event, CSQueue childQueue, boolean sortQueues) {
        this.updateSchedulerHealthForCompletedContainer(rmContainer, containerStatus);
        if (application != null) {
            boolean removed = false;
            this.writeLock.lock();
            try {
                Container container = rmContainer.getContainer();
                if (rmContainer.getState() == RMContainerState.RESERVED) {
                    removed = application.unreserve(rmContainer.getReservedSchedulerKey(), node, rmContainer);
                } else {
                    removed = application.containerCompleted(rmContainer, containerStatus, event, node.getPartition());
                    node.releaseContainer(rmContainer.getContainerId(), false);
                }
                if (removed) {
                    this.orderingPolicy.containerReleased(application, rmContainer);
                    this.releaseResource(clusterResource, application, container.getResource(), node.getPartition(), rmContainer);
                }
            }
            finally {
                this.writeLock.unlock();
            }
            if (removed) {
                this.parent.completedContainer(clusterResource, application, node, rmContainer, null, event, this, sortQueues);
            }
        }
        this.queueContext.getPreemptionManager().removeKillableContainer(new KillableContainer(rmContainer, node.getPartition(), this.getQueuePath()));
        if (containerStatus != null && -102 == containerStatus.getExitStatus()) {
            this.updateQueuePreemptionMetrics(rmContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void allocateResource(Resource clusterResource, SchedulerApplicationAttempt application, Resource resource, String nodePartition, RMContainer rmContainer) {
        this.writeLock.lock();
        try {
            super.allocateResource(clusterResource, resource, nodePartition);
            if (null != rmContainer && rmContainer.getNodeLabelExpression().equals("") && !nodePartition.equals("")) {
                TreeSet rmContainers = this.ignorePartitionExclusivityRMContainers.computeIfAbsent(nodePartition, k -> new TreeSet());
                rmContainers.add(rmContainer);
            }
            String userName = application.getUser();
            UsersManager.User user = this.usersManager.updateUserResourceUsage(userName, resource, this.queueContext.getClusterResource(), nodePartition, true);
            Resource partitionHeadroom = Resources.createResource((int)0, (int)0);
            if (this.usageTracker.getMetrics().getUserMetrics(userName) != null) {
                partitionHeadroom = this.getHeadroom(user, this.cachedResourceLimitsForHeadroom.getLimit(), clusterResource, this.getResourceLimitForActiveUsers(userName, clusterResource, nodePartition, SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), nodePartition);
            }
            this.usageTracker.getMetrics().setAvailableResourcesToUser(nodePartition, userName, partitionHeadroom);
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getQueuePath() + " user=" + userName + " used=" + this.usageTracker.getQueueUsage().getUsed(nodePartition) + " numContainers=" + this.usageTracker.getNumContainers() + " headroom = " + application.getHeadroom() + " user-resources=" + user.getUsed());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseResource(Resource clusterResource, FiCaSchedulerApp application, Resource resource, String nodePartition, RMContainer rmContainer) {
        this.writeLock.lock();
        try {
            super.releaseResource(clusterResource, resource, nodePartition);
            if (null != rmContainer && rmContainer.getNodeLabelExpression().equals("") && !nodePartition.equals("") && this.ignorePartitionExclusivityRMContainers.containsKey(nodePartition)) {
                Set rmContainers = this.ignorePartitionExclusivityRMContainers.get(nodePartition);
                rmContainers.remove(rmContainer);
                if (rmContainers.isEmpty()) {
                    this.ignorePartitionExclusivityRMContainers.remove(nodePartition);
                }
            }
            String userName = application.getUser();
            UsersManager.User user = this.usersManager.updateUserResourceUsage(userName, resource, this.queueContext.getClusterResource(), nodePartition, false);
            Resource partitionHeadroom = Resources.createResource((int)0, (int)0);
            if (this.usageTracker.getMetrics().getUserMetrics(userName) != null) {
                partitionHeadroom = this.getHeadroom(user, this.cachedResourceLimitsForHeadroom.getLimit(), clusterResource, this.getResourceLimitForActiveUsers(userName, clusterResource, nodePartition, SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), nodePartition);
            }
            this.usageTracker.getMetrics().setAvailableResourcesToUser(nodePartition, userName, partitionHeadroom);
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getQueuePath() + " used=" + this.usageTracker.getQueueUsage().getUsed() + " numContainers=" + this.usageTracker.getNumContainers() + " user=" + userName + " user-resources=" + user.getUsed());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void updateCurrentResourceLimits(ResourceLimits currentResourceLimits, Resource clusterResource) {
        this.cachedResourceLimitsForHeadroom = new ResourceLimits(currentResourceLimits.getLimit());
        Resource queueMaxResource = this.getEffectiveMaxCapacityDown("", this.queueAllocationSettings.getMinimumAllocation());
        this.cachedResourceLimitsForHeadroom.setLimit(Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)queueMaxResource, (Resource)currentResourceLimits.getLimit()));
    }

    @Override
    public void refreshAfterResourceCalculation(Resource clusterResource, ResourceLimits resourceLimits) {
        this.lastClusterResource = clusterResource;
        boolean clusterResourceAvailable = Stream.of(clusterResource.getResources()).map(ResourceInformation::getValue).anyMatch(num -> num > 0L);
        this.updateMaximumApplications(clusterResourceAvailable);
        this.updateCurrentResourceLimits(resourceLimits, clusterResource);
        this.setQueueResourceLimitsInfo(clusterResource);
        this.recalculateQueueUsageRatio(clusterResource, null);
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, clusterResource, this, this.labelManager, null);
        CSQueueUtils.updateConfiguredCapacityMetrics(this.resourceCalculator, this.labelManager.getResourceByLabel(null, clusterResource), "", this);
        this.activateApplications();
        this.usersManager.userLimitNeedsRecompute();
        for (FiCaSchedulerApp application : this.orderingPolicy.getSchedulableEntities()) {
            this.computeUserLimitAndSetHeadroom(application, clusterResource, "", SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY, null);
        }
        LOG.info("Refresh after resource calculation (LEAF) {}\neffectiveMinResource = {}\neffectiveMaxResource = {}\ncapacity = {}\nmaxCapacity = {}\nabsoluteCapacity = {}\nabsoluteMaxCapacity = {}", new Object[]{this.queuePath, this.getEffectiveCapacity(""), this.getEffectiveMaxCapacity(""), Float.valueOf(this.getCapacity()), Float.valueOf(this.getMaximumCapacity()), Float.valueOf(this.getAbsoluteCapacity()), Float.valueOf(this.getAbsoluteMaximumCapacity())});
    }

    @Override
    public void updateClusterResource(Resource clusterResource, ResourceLimits currentResourceLimits) {
        if (this.queueContext.getConfiguration().isLegacyQueueMode()) {
            this.updateClusterResourceLegacyMode(clusterResource, currentResourceLimits);
            return;
        }
        this.queueContext.getQueueManager().getQueueCapacityHandler().updateChildren(clusterResource, this.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClusterResourceLegacyMode(Resource clusterResource, ResourceLimits currentResourceLimits) {
        this.writeLock.lock();
        try {
            this.lastClusterResource = clusterResource;
            this.updateAbsoluteCapacities();
            super.updateEffectiveResources(clusterResource);
            this.updateMaximumApplications(true);
            this.updateCurrentResourceLimits(currentResourceLimits, clusterResource);
            this.setQueueResourceLimitsInfo(clusterResource);
            this.recalculateQueueUsageRatio(clusterResource, null);
            CSQueueUtils.updateQueueStatistics(this.resourceCalculator, clusterResource, this, this.labelManager, null);
            CSQueueUtils.updateConfiguredCapacityMetrics(this.resourceCalculator, this.labelManager.getResourceByLabel(null, clusterResource), "", this);
            this.activateApplications();
            this.usersManager.userLimitNeedsRecompute();
            for (FiCaSchedulerApp application : this.orderingPolicy.getSchedulableEntities()) {
                this.computeUserLimitAndSetHeadroom(application, clusterResource, "", SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY, null);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void incUsedResource(String nodeLabel, Resource resourceToInc, SchedulerApplicationAttempt application) {
        this.usersManager.updateUserResourceUsage(application.getUser(), resourceToInc, this.queueContext.getClusterResource(), nodeLabel, true);
        super.incUsedResource(nodeLabel, resourceToInc, application);
    }

    @Override
    public void decUsedResource(String nodeLabel, Resource resourceToDec, SchedulerApplicationAttempt application) {
        this.usersManager.updateUserResourceUsage(application.getUser(), resourceToDec, this.queueContext.getClusterResource(), nodeLabel, false);
        super.decUsedResource(nodeLabel, resourceToDec, application);
    }

    public void incAMUsedResource(String nodeLabel, Resource resourceToInc, SchedulerApplicationAttempt application) {
        UsersManager.User user = this.getUser(application.getUser());
        if (user == null) {
            return;
        }
        user.getResourceUsage().incAMUsed(nodeLabel, resourceToInc);
        this.usageTracker.getQueueUsage().incAMUsed(nodeLabel, resourceToInc);
    }

    public void decAMUsedResource(String nodeLabel, Resource resourceToDec, SchedulerApplicationAttempt application) {
        UsersManager.User user = this.getUser(application.getUser());
        if (user == null) {
            return;
        }
        user.getResourceUsage().decAMUsed(nodeLabel, resourceToDec);
        this.usageTracker.getQueueUsage().decAMUsed(nodeLabel, resourceToDec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverContainer(Resource clusterResource, SchedulerApplicationAttempt attempt, RMContainer rmContainer) {
        if (rmContainer.getState().equals((Object)RMContainerState.COMPLETED)) {
            return;
        }
        if (rmContainer.getExecutionType() != ExecutionType.GUARANTEED) {
            return;
        }
        this.writeLock.lock();
        try {
            FiCaSchedulerNode node = this.queueContext.getNode(rmContainer.getContainer().getNodeId());
            this.allocateResource(clusterResource, attempt, rmContainer.getContainer().getResource(), node.getPartition(), rmContainer);
        }
        finally {
            this.writeLock.unlock();
        }
        this.parent.recoverContainer(clusterResource, attempt, rmContainer);
    }

    public Collection<FiCaSchedulerApp> getPendingApplications() {
        return Collections.unmodifiableCollection(this.pendingOrderingPolicy.getSchedulableEntities());
    }

    public Collection<FiCaSchedulerApp> getApplications() {
        return Collections.unmodifiableCollection(this.orderingPolicy.getSchedulableEntities());
    }

    public Collection<FiCaSchedulerApp> getAllApplications() {
        HashSet<FiCaSchedulerApp> apps = new HashSet<FiCaSchedulerApp>(this.pendingOrderingPolicy.getSchedulableEntities());
        apps.addAll(this.orderingPolicy.getSchedulableEntities());
        return Collections.unmodifiableCollection(apps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getTotalPendingResourcesConsideringUserLimit(Resource clusterResources, String partition, boolean deductReservedFromPending) {
        this.readLock.lock();
        try {
            HashMap<String, Resource> userNameToHeadroom = new HashMap<String, Resource>();
            Resource totalPendingConsideringUserLimit = Resource.newInstance((int)0, (int)0);
            for (FiCaSchedulerApp app : this.getApplications()) {
                String userName = app.getUser();
                if (!userNameToHeadroom.containsKey(userName)) {
                    UsersManager.User user = this.getUsersManager().getUserAndAddIfAbsent(userName);
                    Resource headroom = Resources.subtract((Resource)this.getResourceLimitForActiveUsers(app.getUser(), clusterResources, partition, SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Resource)user.getUsed(partition));
                    headroom = Resources.componentwiseMax((Resource)headroom, (Resource)Resources.none());
                    userNameToHeadroom.put(userName, headroom);
                }
                Resource pending = app.getAppAttemptResourceUsage().getPending(partition);
                if (deductReservedFromPending) {
                    pending = Resources.subtract((Resource)pending, (Resource)app.getAppAttemptResourceUsage().getReserved(partition));
                }
                pending = Resources.componentwiseMax((Resource)pending, (Resource)Resources.none());
                Resource minpendingConsideringUserLimit = Resources.componentwiseMin((Resource)((Resource)userNameToHeadroom.get(userName)), (Resource)pending);
                Resources.addTo((Resource)totalPendingConsideringUserLimit, (Resource)minpendingConsideringUserLimit);
                Resources.subtractFrom((Resource)((Resource)userNameToHeadroom.get(userName)), (Resource)minpendingConsideringUserLimit);
            }
            Resource resource = totalPendingConsideringUserLimit;
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectSchedulerApplications(Collection<ApplicationAttemptId> apps) {
        this.readLock.lock();
        try {
            for (FiCaSchedulerApp pendingApp : this.pendingOrderingPolicy.getSchedulableEntities()) {
                apps.add(pendingApp.getApplicationAttemptId());
            }
            for (FiCaSchedulerApp app : this.orderingPolicy.getSchedulableEntities()) {
                apps.add(app.getApplicationAttemptId());
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void attachContainer(Resource clusterResource, FiCaSchedulerApp application, RMContainer rmContainer) {
        if (application != null && rmContainer != null && rmContainer.getExecutionType() == ExecutionType.GUARANTEED) {
            FiCaSchedulerNode node = this.queueContext.getNode(rmContainer.getContainer().getNodeId());
            this.allocateResource(clusterResource, application, rmContainer.getContainer().getResource(), node.getPartition(), rmContainer);
            LOG.info("movedContainer container=" + rmContainer.getContainer() + " containerState=" + (Object)((Object)rmContainer.getState()) + " resource=" + rmContainer.getContainer().getResource() + " queueMoveIn=" + this + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.usageTracker.getQueueUsage().getUsed() + " cluster=" + clusterResource);
            this.parent.attachContainer(clusterResource, application, rmContainer);
        }
    }

    @Override
    public void detachContainer(Resource clusterResource, FiCaSchedulerApp application, RMContainer rmContainer) {
        if (application != null && rmContainer != null && rmContainer.getExecutionType() == ExecutionType.GUARANTEED) {
            FiCaSchedulerNode node = this.queueContext.getNode(rmContainer.getContainer().getNodeId());
            this.releaseResource(clusterResource, application, rmContainer.getContainer().getResource(), node.getPartition(), rmContainer);
            LOG.info("movedContainer container=" + rmContainer.getContainer() + " containerState=" + (Object)((Object)rmContainer.getState()) + " resource=" + rmContainer.getContainer().getResource() + " queueMoveOut=" + this + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.usageTracker.getQueueUsage().getUsed() + " cluster=" + clusterResource);
            this.parent.detachContainer(clusterResource, application, rmContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TreeSet<RMContainer>> getIgnoreExclusivityRMContainers() {
        HashMap clonedMap = new HashMap();
        this.readLock.lock();
        try {
            for (Map.Entry<String, TreeSet<RMContainer>> entry : this.ignorePartitionExclusivityRMContainers.entrySet()) {
                clonedMap.put(entry.getKey(), new TreeSet(entry.getValue()));
            }
            HashMap hashMap = clonedMap;
            return hashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setCapacity(float capacity) {
        this.configuredCapacityVectors.put("", QueueCapacityVector.of(capacity * 100.0f, QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE));
        this.queueCapacities.setCapacity(capacity);
    }

    public void setCapacity(String nodeLabel, float capacity) {
        this.configuredCapacityVectors.put(nodeLabel, QueueCapacityVector.of(capacity * 100.0f, QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE));
        this.queueCapacities.setCapacity(nodeLabel, capacity);
    }

    public void setAbsoluteCapacity(float absoluteCapacity) {
        this.queueCapacities.setAbsoluteCapacity(absoluteCapacity);
    }

    public void setAbsoluteCapacity(String nodeLabel, float absoluteCapacity) {
        this.queueCapacities.setAbsoluteCapacity(nodeLabel, absoluteCapacity);
    }

    public void setMaxApplicationsPerUser(int maxApplicationsPerUser) {
        this.maxApplicationsPerUser = maxApplicationsPerUser;
    }

    public void setMaxApplications(int maxApplications) {
        this.maxApplications = maxApplications;
    }

    public void setMaxAMResourcePerQueuePercent(float maxAMResourcePerQueuePercent) {
        this.maxAMResourcePerQueuePercent = maxAMResourcePerQueuePercent;
    }

    public OrderingPolicy<FiCaSchedulerApp> getOrderingPolicy() {
        return this.orderingPolicy;
    }

    void setOrderingPolicy(OrderingPolicy<FiCaSchedulerApp> orderingPolicy) {
        this.writeLock.lock();
        try {
            if (null != this.orderingPolicy) {
                orderingPolicy.addAllSchedulableEntities(this.orderingPolicy.getSchedulableEntities());
            }
            this.orderingPolicy = orderingPolicy;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Priority getDefaultApplicationPriority() {
        return this.defaultAppPriorityPerQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateApplicationPriority(SchedulerApplication<FiCaSchedulerApp> app, Priority newAppPriority) {
        this.writeLock.lock();
        try {
            FiCaSchedulerApp attempt = app.getCurrentAppAttempt();
            boolean isActive = this.orderingPolicy.removeSchedulableEntity(attempt);
            if (!isActive) {
                this.pendingOrderingPolicy.removeSchedulableEntity(attempt);
            }
            attempt.setPriority(newAppPriority);
            if (isActive) {
                this.orderingPolicy.addSchedulableEntity(attempt);
            } else {
                this.pendingOrderingPolicy.addSchedulableEntity(attempt);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public OrderingPolicy<FiCaSchedulerApp> getPendingAppsOrderingPolicy() {
        return this.pendingOrderingPolicy;
    }

    @Override
    public void stopQueue() {
        this.writeLock.lock();
        try {
            if (this.getNumApplications() > 0) {
                this.updateQueueState(QueueState.DRAINING);
            } else {
                this.updateQueueState(QueueState.STOPPED);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void updateMaximumApplications(boolean absoluteCapacityIsReadyForUse) {
        CapacitySchedulerConfiguration configuration = this.queueContext.getConfiguration();
        int maxAppsForQueue = configuration.getMaximumApplicationsPerQueue(this.getQueuePathObject());
        int maxDefaultPerQueueApps = configuration.getGlobalMaximumApplicationsPerQueue();
        int maxSystemApps = configuration.getMaximumSystemApplications();
        int baseMaxApplications = maxDefaultPerQueueApps > 0 ? Math.min(maxDefaultPerQueueApps, maxSystemApps) : maxSystemApps;
        String maxLabel = "";
        if (maxAppsForQueue < 0) {
            if (!absoluteCapacityIsReadyForUse) {
                maxAppsForQueue = baseMaxApplications;
            } else if (maxDefaultPerQueueApps > 0 && this.capacityConfigType != AbstractCSQueue.CapacityConfigType.ABSOLUTE_RESOURCE) {
                maxAppsForQueue = baseMaxApplications;
            } else {
                for (String label : this.queueNodeLabelsSettings.getConfiguredNodeLabels()) {
                    int maxApplicationsByLabel = (int)((float)baseMaxApplications * this.queueCapacities.getAbsoluteCapacity(label));
                    if (maxApplicationsByLabel <= maxAppsForQueue) continue;
                    maxAppsForQueue = maxApplicationsByLabel;
                    maxLabel = label;
                }
            }
        }
        this.setMaxApplications(maxAppsForQueue);
        this.updateMaxAppsPerUser();
        LOG.info("LeafQueue: " + this.getQueuePath() + " update max app related, maxApplications=" + maxAppsForQueue + ", maxApplicationsPerUser=" + this.maxApplicationsPerUser + ", Abs Cap:" + this.queueCapacities.getAbsoluteCapacity(maxLabel) + ", Cap: " + this.queueCapacities.getCapacity(maxLabel) + ", MaxCap : " + this.queueCapacities.getMaximumCapacity(maxLabel));
    }

    private void updateMaxAppsPerUser() {
        int maxAppsPerUser = this.maxApplications;
        if (this.getUsersManager().getUserLimitFactor() != -1.0f) {
            int maxApplicationsWithUserLimits = (int)((float)this.maxApplications * (this.getUsersManager().getUserLimit() / 100.0f) * this.getUsersManager().getUserLimitFactor());
            maxAppsPerUser = Math.min(this.maxApplications, maxApplicationsWithUserLimits);
        }
        this.setMaxApplicationsPerUser(maxAppsPerUser);
    }

    public Set<String> getAllUsers() {
        return this.getUsersManager().getUsers().keySet();
    }

    private void updateQueuePreemptionMetrics(RMContainer rmc) {
        long usedMillis = rmc.getFinishTime() - rmc.getCreationTime();
        long usedSeconds = usedMillis / 1000L;
        CSQueueMetrics metrics = this.usageTracker.getMetrics();
        Resource containerResource = rmc.getAllocatedResource();
        metrics.preemptContainer();
        long mbSeconds = containerResource.getMemorySize() * usedMillis / 1000L;
        long vcSeconds = (long)containerResource.getVirtualCores() * usedMillis / 1000L;
        metrics.updatePreemptedMemoryMBSeconds(mbSeconds);
        metrics.updatePreemptedVcoreSeconds(vcSeconds);
        metrics.updatePreemptedResources(containerResource);
        metrics.updatePreemptedSecondsForCustomResources(containerResource, usedSeconds);
        metrics.updatePreemptedForCustomResources(containerResource);
    }

    @Override
    int getNumRunnableApps() {
        this.readLock.lock();
        try {
            int n = this.runnableApps.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    int getNumNonRunnableApps() {
        this.readLock.lock();
        try {
            int n = this.nonRunnableApps.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    boolean removeNonRunnableApp(FiCaSchedulerApp app) {
        this.writeLock.lock();
        try {
            boolean bl = this.nonRunnableApps.remove(app);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    List<FiCaSchedulerApp> getCopyOfNonRunnableAppSchedulables() {
        ArrayList<FiCaSchedulerApp> appsToReturn = new ArrayList<FiCaSchedulerApp>();
        this.readLock.lock();
        try {
            appsToReturn.addAll(this.nonRunnableApps);
        }
        finally {
            this.readLock.unlock();
        }
        return appsToReturn;
    }

    @Override
    public boolean isEligibleForAutoDeletion() {
        return this.isDynamicQueue() && this.getNumApplications() == 0 && this.queueContext.getConfiguration().isAutoExpiredDeletionEnabled(this.getQueuePathObject());
    }

    static class CachedUserLimit {
        final Resource userLimit;
        volatile boolean canAssign = true;
        volatile Resource reservation = Resources.none();

        CachedUserLimit(Resource userLimit) {
            this.userLimit = userLimit;
        }
    }

    static class QueueResourceLimitsInfo {
        private Resource queueCurrentLimit;
        private Resource clusterResource;

        QueueResourceLimitsInfo() {
        }

        public void setQueueCurrentLimit(Resource currentLimit) {
            this.queueCurrentLimit = currentLimit;
        }

        public Resource getQueueCurrentLimit() {
            return this.queueCurrentLimit;
        }

        public void setClusterResource(Resource clusterResource) {
            this.clusterResource = clusterResource;
        }

        public Resource getClusterResource() {
            return this.clusterResource;
        }
    }
}

