/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.SettableFuture;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerUpdates;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.QueueEntitlement;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;

public interface YarnScheduler
extends EventHandler<SchedulerEvent> {
    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public QueueInfo getQueueInfo(String var1, boolean var2, boolean var3) throws IOException;

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public List<QueueUserACLInfo> getQueueUserAclInfo();

    @InterfaceAudience.LimitedPrivate(value={"yarn"})
    @InterfaceStability.Unstable
    public Resource getClusterResource();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public Resource getMinimumResourceCapability();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public Resource getMaximumResourceCapability();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public Resource getMaximumResourceCapability(String var1);

    @InterfaceAudience.LimitedPrivate(value={"yarn"})
    @InterfaceStability.Evolving
    public ResourceCalculator getResourceCalculator();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public int getNumClusterNodes();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public Allocation allocate(ApplicationAttemptId var1, List<ResourceRequest> var2, List<SchedulingRequest> var3, List<ContainerId> var4, List<String> var5, List<String> var6, ContainerUpdates var7);

    @InterfaceAudience.LimitedPrivate(value={"yarn"})
    @InterfaceStability.Stable
    public SchedulerNodeReport getNodeReport(NodeId var1);

    @InterfaceAudience.LimitedPrivate(value={"yarn"})
    @InterfaceStability.Stable
    public SchedulerAppReport getSchedulerAppInfo(ApplicationAttemptId var1);

    @InterfaceAudience.LimitedPrivate(value={"yarn"})
    @InterfaceStability.Evolving
    public ApplicationResourceUsageReport getAppResourceUsageReport(ApplicationAttemptId var1);

    @InterfaceAudience.LimitedPrivate(value={"yarn"})
    @InterfaceStability.Evolving
    public QueueMetrics getRootQueueMetrics();

    public boolean checkAccess(UserGroupInformation var1, QueueACL var2, String var3);

    @InterfaceAudience.LimitedPrivate(value={"yarn"})
    @InterfaceStability.Stable
    public List<ApplicationAttemptId> getAppsInQueue(String var1);

    @InterfaceAudience.LimitedPrivate(value={"yarn"})
    @InterfaceStability.Unstable
    public RMContainer getRMContainer(ContainerId var1);

    @InterfaceAudience.LimitedPrivate(value={"yarn"})
    @InterfaceStability.Evolving
    public String moveApplication(ApplicationId var1, String var2) throws YarnException;

    @InterfaceAudience.LimitedPrivate(value={"yarn"})
    @InterfaceStability.Evolving
    public void preValidateMoveApplication(ApplicationId var1, String var2) throws YarnException;

    public void moveAllApps(String var1, String var2) throws YarnException;

    public void killAllAppsInQueue(String var1) throws YarnException;

    public void removeQueue(String var1) throws YarnException;

    public void addQueue(Queue var1) throws YarnException, IOException;

    public void setEntitlement(String var1, QueueEntitlement var2) throws YarnException;

    public Set<String> getPlanQueues() throws YarnException;

    public EnumSet<YarnServiceProtos.SchedulerResourceTypes> getSchedulingResourceTypes();

    public Priority checkAndGetApplicationPriority(Priority var1, UserGroupInformation var2, String var3, ApplicationId var4) throws YarnException;

    public Priority updateApplicationPriority(Priority var1, ApplicationId var2, SettableFuture<Object> var3, UserGroupInformation var4) throws YarnException;

    public List<Container> getTransferredContainers(ApplicationAttemptId var1);

    public void setClusterMaxPriority(Configuration var1) throws YarnException;

    public List<ResourceRequest> getPendingResourceRequestsForAttempt(ApplicationAttemptId var1);

    public List<SchedulingRequest> getPendingSchedulingRequestsForAttempt(ApplicationAttemptId var1);

    public Priority getMaxClusterLevelAppPriority();

    public SchedulerNode getSchedulerNode(NodeId var1);

    public Resource getNormalizedResource(Resource var1, Resource var2);

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public long checkAndGetApplicationLifetime(String var1, long var2, RMAppImpl var4);

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public long getMaximumApplicationLifetime(String var1);
}

