/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp;

import java.io.StringReader;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.http.RestCsrfPreventionFilter;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.util.XMLUtils;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.util.YarnVersionInfo;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestRMWithCSRFFilter
extends JerseyTestBase {
    private static MockRM rm;

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register((Object)new JerseyBinder());
        config.register(RMWebServices.class);
        config.register(GenericExceptionHandler.class);
        config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        this.forceSet("jersey.config.test.container.port", "0");
        return config;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testNoCustomHeaderFromBrowser() throws Exception {
        WebTarget r = this.target();
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("info").request(new String[]{"application/xml"}).header("User-Agent", (Object)"Mozilla/5.0").get(Response.class);
    }

    @Test
    public void testIncludeCustomHeaderFromBrowser() throws Exception {
        WebTarget r = this.target();
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("info").request(new String[]{"application/xml"}).header("User-Agent", (Object)"Mozilla/5.0").header("X-XSRF-HEADER", (Object)"").get(Response.class);
        Assert.assertTrue((String)"Should have been accepted", (response.getStatus() == Response.Status.OK.getStatusCode() ? 1 : 0) != 0);
        Assert.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        String xml = (String)response.readEntity(String.class);
        this.verifyClusterInfoXML(xml);
    }

    @Test
    public void testAllowedMethod() throws Exception {
        WebTarget r = this.target();
        Response response = r.path("ws").path("v1").path("cluster").path("info").request(new String[]{"application/xml"}).header("User-Agent", (Object)"Mozilla/5.0").head();
        Assert.assertTrue((String)"Should have been allowed", (response.getStatus() == Response.Status.OK.getStatusCode() ? 1 : 0) != 0);
    }

    @Test
    public void testAllowNonBrowserInteractionWithoutHeader() throws Exception {
        WebTarget r = this.target();
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("info").request(new String[]{"application/xml"}).get(Response.class);
        Assert.assertTrue((String)"Should have been accepted", (response.getStatus() == Response.Status.OK.getStatusCode() ? 1 : 0) != 0);
        Assert.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        String xml = (String)response.readEntity(String.class);
        this.verifyClusterInfoXML(xml);
    }

    public void verifyClusterInfoXML(String xml) throws Exception {
        DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("clusterInfo");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            this.verifyClusterGeneric(WebServicesTestUtils.getXmlLong((Element)element, (String)"id"), WebServicesTestUtils.getXmlLong((Element)element, (String)"startedOn"), WebServicesTestUtils.getXmlString((Element)element, (String)"state"), WebServicesTestUtils.getXmlString((Element)element, (String)"haState"), WebServicesTestUtils.getXmlString((Element)element, (String)"haZooKeeperConnectionState"), WebServicesTestUtils.getXmlString((Element)element, (String)"hadoopVersionBuiltOn"), WebServicesTestUtils.getXmlString((Element)element, (String)"hadoopBuildVersion"), WebServicesTestUtils.getXmlString((Element)element, (String)"hadoopVersion"), WebServicesTestUtils.getXmlString((Element)element, (String)"resourceManagerVersionBuiltOn"), WebServicesTestUtils.getXmlString((Element)element, (String)"resourceManagerBuildVersion"), WebServicesTestUtils.getXmlString((Element)element, (String)"resourceManagerVersion"));
        }
    }

    public void verifyClusterGeneric(long clusterid, long startedon, String state, String haState, String haZooKeeperConnectionState, String hadoopVersionBuiltOn, String hadoopBuildVersion, String hadoopVersion, String resourceManagerVersionBuiltOn, String resourceManagerBuildVersion, String resourceManagerVersion) {
        Assert.assertEquals((String)"clusterId doesn't match: ", (long)ResourceManager.getClusterTimeStamp(), (long)clusterid);
        Assert.assertEquals((String)"startedOn doesn't match: ", (long)ResourceManager.getClusterTimeStamp(), (long)startedon);
        Assert.assertTrue((String)("stated doesn't match: " + state), (boolean)state.matches(Service.STATE.INITED.toString()));
        Assert.assertTrue((String)("HA state doesn't match: " + haState), (boolean)haState.matches("INITIALIZING"));
        WebServicesTestUtils.checkStringMatch((String)"hadoopVersionBuiltOn", (String)VersionInfo.getDate(), (String)hadoopVersionBuiltOn);
        WebServicesTestUtils.checkStringEqual((String)"hadoopBuildVersion", (String)VersionInfo.getBuildVersion(), (String)hadoopBuildVersion);
        WebServicesTestUtils.checkStringMatch((String)"hadoopVersion", (String)VersionInfo.getVersion(), (String)hadoopVersion);
        WebServicesTestUtils.checkStringMatch((String)"resourceManagerVersionBuiltOn", (String)YarnVersionInfo.getDate(), (String)resourceManagerVersionBuiltOn);
        WebServicesTestUtils.checkStringEqual((String)"resourceManagerBuildVersion", (String)YarnVersionInfo.getBuildVersion(), (String)resourceManagerBuildVersion);
        WebServicesTestUtils.checkStringMatch((String)"resourceManagerVersion", (String)YarnVersionInfo.getVersion(), (String)resourceManagerVersion);
    }

    private static class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            Configuration conf = new Configuration();
            conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
            rm = new MockRM(conf);
            rm.getRMContext().getContainerTokenSecretManager().rollMasterKey();
            rm.getRMContext().getNMTokenSecretManager().rollMasterKey();
            rm.disableDrainEventsImplicitly();
            RestCsrfPreventionFilter csrfFilter = new RestCsrfPreventionFilter();
            HashMap<String, String> initParams = new HashMap<String, String>();
            initParams.put("methods-to-ignore", "OPTIONS,HEAD,TRACE");
            this.bind(csrfFilter).to(RestCsrfPreventionFilter.class);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getScheme()).thenReturn((Object)"http");
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            ((InstanceBinding)this.bind((Object)rm).to(ResourceManager.class)).named("rm");
            ((InstanceBinding)this.bind(conf).to(Configuration.class)).named("conf");
            this.bind(request).to(HttpServletRequest.class);
            this.bind(response).to(HttpServletResponse.class);
        }
    }
}

