/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.helper;

import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;

public final class AppInfoJsonVerifications {
    private AppInfoJsonVerifications() {
    }

    public static void verify(JSONObject info, RMApp app) throws JSONException {
        WebServicesTestUtils.checkStringMatch((String)"id", (String)app.getApplicationId().toString(), (String)info.getString("id"));
        WebServicesTestUtils.checkStringMatch((String)"user", (String)app.getUser(), (String)info.getString("user"));
        WebServicesTestUtils.checkStringMatch((String)"name", (String)app.getName(), (String)info.getString("name"));
        WebServicesTestUtils.checkStringMatch((String)"applicationType", (String)app.getApplicationType(), (String)info.getString("applicationType"));
        WebServicesTestUtils.checkStringMatch((String)"queue", (String)app.getQueue(), (String)info.getString("queue"));
        Assert.assertEquals((String)"priority doesn't match", (long)0L, (long)info.getInt("priority"));
        WebServicesTestUtils.checkStringMatch((String)"state", (String)app.getState().toString(), (String)info.getString("state"));
        WebServicesTestUtils.checkStringMatch((String)"finalStatus", (String)app.getFinalApplicationStatus().toString(), (String)info.getString("finalStatus"));
        Assert.assertEquals((String)"progress doesn't match", (double)0.0, (double)((float)info.getDouble("progress")), (double)0.0);
        if ("UNASSIGNED".equals(info.getString("trackingUI"))) {
            WebServicesTestUtils.checkStringMatch((String)"trackingUI", (String)"UNASSIGNED", (String)info.getString("trackingUI"));
        }
        WebServicesTestUtils.checkStringEqual((String)"diagnostics", (String)app.getDiagnostics().toString(), (String)info.getString("diagnostics"));
        Assert.assertEquals((String)"clusterId doesn't match", (long)ResourceManager.getClusterTimeStamp(), (long)info.getLong("clusterId"));
        Assert.assertEquals((String)"startedTime doesn't match", (long)app.getStartTime(), (long)info.getLong("startedTime"));
        Assert.assertEquals((String)"finishedTime doesn't match", (long)app.getFinishTime(), (long)info.getLong("finishedTime"));
        Assert.assertTrue((String)"elapsed time not greater than 0", (info.getLong("elapsedTime") > 0L ? 1 : 0) != 0);
        WebServicesTestUtils.checkStringMatch((String)"amHostHttpAddress", (String)app.getCurrentAppAttempt().getMasterContainer().getNodeHttpAddress(), (String)info.getString("amHostHttpAddress"));
        Assert.assertTrue((String)"amContainerLogs doesn't match", (boolean)info.getString("amContainerLogs").startsWith("http://"));
        Assert.assertTrue((String)"amContainerLogs doesn't contain user info", (boolean)info.getString("amContainerLogs").endsWith("/" + app.getUser()));
        Assert.assertEquals((String)"allocatedMB doesn't match", (long)1024L, (long)info.getInt("allocatedMB"));
        Assert.assertEquals((String)"allocatedVCores doesn't match", (long)1L, (long)info.getInt("allocatedVCores"));
        Assert.assertEquals((String)"queueUsagePerc doesn't match", (float)50.0f, (float)((float)info.getDouble("queueUsagePercentage")), (float)0.01f);
        Assert.assertEquals((String)"clusterUsagePerc doesn't match", (float)50.0f, (float)((float)info.getDouble("clusterUsagePercentage")), (float)0.01f);
        Assert.assertEquals((String)"numContainers doesn't match", (long)1L, (long)info.getInt("runningContainers"));
        Assert.assertNotNull((String)"preemptedResourceSecondsMap should not be null", (Object)info.get("preemptedResourceSecondsMap"));
        Assert.assertEquals((String)"preemptedResourceMB doesn't match", (long)app.getRMAppMetrics().getResourcePreempted().getMemorySize(), (long)info.getInt("preemptedResourceMB"));
        Assert.assertEquals((String)"preemptedResourceVCores doesn't match", (long)app.getRMAppMetrics().getResourcePreempted().getVirtualCores(), (long)info.getInt("preemptedResourceVCores"));
        Assert.assertEquals((String)"numNonAMContainerPreempted doesn't match", (long)app.getRMAppMetrics().getNumNonAMContainersPreempted(), (long)info.getInt("numNonAMContainerPreempted"));
        Assert.assertEquals((String)"numAMContainerPreempted doesn't match", (long)app.getRMAppMetrics().getNumAMContainersPreempted(), (long)info.getInt("numAMContainerPreempted"));
        Assert.assertEquals((String)"Log aggregation Status doesn't match", (Object)app.getLogAggregationStatusForAppReport().toString(), (Object)info.getString("logAggregationStatus"));
        Assert.assertEquals((String)"unmanagedApplication doesn't match", (Object)app.getApplicationSubmissionContext().getUnmanagedAM(), (Object)info.getBoolean("unmanagedApplication"));
        if (app.getApplicationSubmissionContext().getNodeLabelExpression() != null) {
            Assert.assertEquals((String)"appNodeLabelExpression doesn't match", (Object)app.getApplicationSubmissionContext().getNodeLabelExpression(), (Object)info.getString("appNodeLabelExpression"));
        }
        Assert.assertEquals((String)"amNodeLabelExpression doesn't match", (Object)((ResourceRequest)app.getAMResourceRequests().get(0)).getNodeLabelExpression(), (Object)info.getString("amNodeLabelExpression"));
        Assert.assertEquals((String)"amRPCAddress", (Object)AppInfo.getAmRPCAddressFromRMAppAttempt((RMAppAttempt)app.getCurrentAppAttempt()), (Object)info.getString("amRPCAddress"));
    }
}

