/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.fairscheduler;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.fairscheduler.FairSchedulerJsonVerifications;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.fairscheduler.FairSchedulerXmlVerifications;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.helper.BufferedClientResponse;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.helper.JsonCustomResourceTypeTestcase;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.helper.XmlCustomResourceTypeTestCase;
import org.apache.hadoop.yarn.util.resource.CustomResourceTypesConfigurationProvider;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.w3c.dom.Element;

public class TestRMWebServicesFairSchedulerCustomResourceTypes
extends JerseyTestBase {
    private static MockRM rm;
    private static YarnConfiguration conf;

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register((Object)new JerseyBinder());
        config.register(RMWebServices.class);
        config.register(GenericExceptionHandler.class);
        config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        this.forceSet("jersey.config.test.container.port", "0");
        return config;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @After
    public void tearDown() {
        ResourceUtils.resetResourceTypes((Configuration)new Configuration());
    }

    @After
    public void teardown() {
        CustomResourceTypesConfigurationProvider.reset();
    }

    @Test
    public void testClusterSchedulerWithCustomResourceTypesJson() throws JSONException {
        FairScheduler scheduler = (FairScheduler)rm.getResourceScheduler();
        QueueManager queueManager = scheduler.getQueueManager();
        queueManager.getLeafQueue("root.q.subqueue1", true);
        queueManager.getLeafQueue("root.q.subqueue2", true);
        FSLeafQueue subqueue1 = queueManager.getLeafQueue("root.q.subqueue1", false);
        this.incrementUsedResourcesOnQueue(subqueue1, 33L);
        WebTarget path = this.target().path("ws").path("v1").path("cluster").path("scheduler");
        Response response = (Response)path.request(new String[]{"application/json"}).get(Response.class);
        this.verifyJsonResponse(path, response, CustomResourceTypesConfigurationProvider.getCustomResourceTypes());
    }

    @Test
    public void testClusterSchedulerWithCustomResourceTypesXml() {
        FairScheduler scheduler = (FairScheduler)rm.getResourceScheduler();
        QueueManager queueManager = scheduler.getQueueManager();
        queueManager.getLeafQueue("root.q.subqueue1", true);
        queueManager.getLeafQueue("root.q.subqueue2", true);
        FSLeafQueue subqueue1 = queueManager.getLeafQueue("root.q.subqueue1", false);
        this.incrementUsedResourcesOnQueue(subqueue1, 33L);
        WebTarget path = this.target().path("ws").path("v1").path("cluster").path("scheduler");
        Response response = (Response)path.request(new String[]{"application/xml"}).get(Response.class);
        this.verifyXmlResponse(path, response, CustomResourceTypesConfigurationProvider.getCustomResourceTypes());
    }

    @Test
    public void testClusterSchedulerWithElevenCustomResourceTypesXml() {
        CustomResourceTypesConfigurationProvider.setResourceTypes((int)2, (String)"k");
        FairScheduler scheduler = (FairScheduler)rm.getResourceScheduler();
        QueueManager queueManager = scheduler.getQueueManager();
        queueManager.getLeafQueue("root.q.subqueue1", true);
        queueManager.getLeafQueue("root.q.subqueue2", true);
        FSLeafQueue subqueue1 = queueManager.getLeafQueue("root.q.subqueue1", false);
        this.incrementUsedResourcesOnQueue(subqueue1, 33L);
        WebTarget path = this.target().path("ws").path("v1").path("cluster").path("scheduler");
        Response response = (Response)path.request(new String[]{"application/xml"}).get(Response.class);
        this.verifyXmlResponse(path, response, CustomResourceTypesConfigurationProvider.getCustomResourceTypes());
    }

    @Test
    public void testClusterSchedulerElevenWithCustomResourceTypesJson() throws JSONException {
        CustomResourceTypesConfigurationProvider.setResourceTypes((int)2, (String)"k");
        FairScheduler scheduler = (FairScheduler)rm.getResourceScheduler();
        QueueManager queueManager = scheduler.getQueueManager();
        queueManager.getLeafQueue("root.q.subqueue1", true);
        queueManager.getLeafQueue("root.q.subqueue2", true);
        FSLeafQueue subqueue1 = queueManager.getLeafQueue("root.q.subqueue1", false);
        this.incrementUsedResourcesOnQueue(subqueue1, 33L);
        WebTarget path = this.target().path("ws").path("v1").path("cluster").path("scheduler");
        Response response = (Response)path.request(new String[]{"application/json"}).get(Response.class);
        this.verifyJsonResponse(path, response, CustomResourceTypesConfigurationProvider.getCustomResourceTypes());
    }

    private void verifyJsonResponse(WebTarget path, Response response, List<String> customResourceTypes) throws JSONException {
        JsonCustomResourceTypeTestcase testCase = new JsonCustomResourceTypeTestcase(path, new BufferedClientResponse(response));
        testCase.verify(json -> {
            try {
                JSONObject queue = json.getJSONObject("scheduler").getJSONObject("schedulerInfo").getJSONObject("rootQueue").getJSONObject("childQueues").getJSONObject("queue");
                JSONArray queues = new JSONArray();
                queues.put((Object)queue);
                Assert.assertEquals((long)1L, (long)queues.length());
                JSONObject firstChildQueue = queues.getJSONObject(0);
                new FairSchedulerJsonVerifications(customResourceTypes).verify(firstChildQueue);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void verifyXmlResponse(WebTarget path, Response response, List<String> customResourceTypes) {
        XmlCustomResourceTypeTestCase testCase = new XmlCustomResourceTypeTestCase(path, new BufferedClientResponse(response));
        testCase.verify(xml -> {
            Element scheduler = (Element)xml.getElementsByTagName("scheduler").item(0);
            Element schedulerInfo = (Element)scheduler.getElementsByTagName("schedulerInfo").item(0);
            Element rootQueue = (Element)schedulerInfo.getElementsByTagName("rootQueue").item(0);
            Element childQueues = (Element)rootQueue.getElementsByTagName("childQueues").item(0);
            Element queue = (Element)childQueues.getElementsByTagName("queue").item(0);
            new FairSchedulerXmlVerifications(customResourceTypes).verify(queue);
        });
    }

    private void incrementUsedResourcesOnQueue(FSLeafQueue queue, long value) {
        try {
            Map customResources = CustomResourceTypesConfigurationProvider.getCustomResourceTypes().stream().collect(Collectors.toMap(Function.identity(), v -> value));
            queue.incUsedResource(Resource.newInstance((long)20L, (int)30, customResources));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            conf = new YarnConfiguration();
            conf.setClass("yarn.resourcemanager.scheduler.class", FairScheduler.class, ResourceScheduler.class);
            this.initResourceTypes(conf);
            rm = new MockRM((Configuration)conf);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            ((InstanceBinding)this.bind((Object)rm).to(ResourceManager.class)).named("rm");
            ((InstanceBinding)this.bind(conf).to(Configuration.class)).named("conf");
            this.bind(request).to(HttpServletRequest.class);
            this.bind(response).to(HttpServletResponse.class);
        }

        private void initResourceTypes(YarnConfiguration conf) {
            conf.set("yarn.resourcemanager.configuration.provider-class", CustomResourceTypesConfigurationProvider.class.getName());
            ResourceUtils.resetResourceTypes((Configuration)conf);
        }
    }
}

