/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.fairscheduler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServices;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRMWebServicesFairScheduler
extends JerseyTestBase {
    private static MockRM rm;
    private static YarnConfiguration conf;

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register((Object)new JerseyBinder());
        config.register(RMWebServices.class);
        config.register(GenericExceptionHandler.class);
        config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        this.forceSet("jersey.config.test.container.port", "0");
        return config;
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testClusterScheduler() throws JSONException {
        WebTarget r = this.targetWithJsonObject();
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler").request(new String[]{"application/json"}).get(Response.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        this.verifyClusterScheduler(json);
    }

    @Test
    public void testClusterSchedulerSlash() throws JSONException {
        WebTarget r = this.targetWithJsonObject();
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/").request(new String[]{"application/json"}).get(Response.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        this.verifyClusterScheduler(json);
    }

    @Test
    public void testClusterSchedulerWithSubQueues() throws JSONException {
        FairScheduler scheduler = (FairScheduler)rm.getResourceScheduler();
        QueueManager queueManager = scheduler.getQueueManager();
        queueManager.getLeafQueue("root.q.subqueue1", true);
        queueManager.getLeafQueue("root.q.subqueue2", true);
        WebTarget r = this.targetWithJsonObject();
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/").request(new String[]{"application/json"}).get(Response.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        JSONArray subQueueInfo = json.getJSONObject("scheduler").getJSONObject("schedulerInfo").getJSONObject("rootQueue").getJSONObject("childQueues").getJSONObject("queue").getJSONObject("childQueues").getJSONArray("queue");
        Assert.assertEquals((long)2L, (long)subQueueInfo.length());
        try {
            subQueueInfo.getJSONObject(1).getJSONObject("childQueues");
            Assert.fail((String)"FairSchedulerQueueInfo should omit field 'childQueues'if child queue is empty.");
        }
        catch (JSONException je) {
            Assert.assertEquals((Object)"JSONObject[\"childQueues\"] not found.", (Object)je.getMessage());
        }
    }

    private void verifyClusterScheduler(JSONObject json) throws JSONException {
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject info = json.getJSONObject("scheduler");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)info.length());
        info = info.getJSONObject("schedulerInfo");
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)info.length());
        JSONObject rootQueue = info.getJSONObject("rootQueue");
        Assert.assertEquals((Object)"root", (Object)rootQueue.getString("queueName"));
    }

    @Test
    public void testClusterSchedulerOverviewFair() throws Exception {
        WebTarget r = this.targetWithJsonObject();
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler-overview").request(new String[]{"application/json"}).get(Response.class);
        Assert.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        JSONObject scheduler = json.getJSONObject("scheduler");
        TestRMWebServices.verifyClusterSchedulerOverView(scheduler, "Fair Scheduler");
    }

    private static class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            conf = new YarnConfiguration();
            conf.setClass("yarn.resourcemanager.scheduler.class", FairScheduler.class, ResourceScheduler.class);
            rm = new MockRM((Configuration)conf);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            ((InstanceBinding)this.bind((Object)rm).to(ResourceManager.class)).named("rm");
            ((InstanceBinding)this.bind(conf).to(Configuration.class)).named("conf");
            this.bind(request).to(HttpServletRequest.class);
            this.bind(response).to(HttpServletResponse.class);
        }
    }
}

