/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.XMLUtils;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.glassfish.jersey.jettison.JettisonJaxbContext;
import org.glassfish.jersey.jettison.JettisonMarshaller;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public final class TestWebServiceUtil {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
    private static final ObjectWriter OBJECT_WRITER = MAPPER.writerWithDefaultPrettyPrinter();

    private TestWebServiceUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runTest(String template, String name, MockRM rm, WebTarget resource) throws Exception {
        try {
            boolean legacyQueueMode = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration().isLegacyQueueMode();
            TestWebServiceUtil.assertJsonResponse(TestWebServiceUtil.sendRequest(resource), TestWebServiceUtil.getExpectedResourceFile(template, name, "0", legacyQueueMode));
            MockNM nm1 = rm.registerNode("h1:1234", 8192, 8);
            rm.registerNode("h2:1234", 8192, 8);
            TestWebServiceUtil.assertJsonResponse(TestWebServiceUtil.sendRequest(resource), TestWebServiceUtil.getExpectedResourceFile(template, name, "16", legacyQueueMode));
            rm.registerNode("h3:1234", 8192, 8);
            MockNM nm4 = rm.registerNode("h4:1234", 8192, 8);
            TestWebServiceUtil.assertJsonResponse(TestWebServiceUtil.sendRequest(resource), TestWebServiceUtil.getExpectedResourceFile(template, name, "32", legacyQueueMode));
            rm.unRegisterNode(nm1);
            rm.unRegisterNode(nm4);
            TestWebServiceUtil.assertJsonResponse(TestWebServiceUtil.sendRequest(resource), TestWebServiceUtil.getExpectedResourceFile(template, name, "16", legacyQueueMode));
        }
        finally {
            rm.close();
        }
    }

    public static String getExpectedResourceFile(String template, String name, String suffix, boolean legacyQueueMode) throws IOException {
        String legacyResource = String.format(template, TestWebServiceUtil.legacySuffix(legacyQueueMode, name), suffix);
        try (InputStream stream = TestWebServiceUtil.getResourceAsStream(legacyResource);){
            if (stream != null) {
                String string = legacyResource;
                return string;
            }
        }
        return String.format(template, name, suffix);
    }

    public static String legacySuffix(boolean legacyQueueMode, String text) {
        if (legacyQueueMode) {
            return text + "-legacy";
        }
        return text;
    }

    public static Response sendRequest(WebTarget resource) {
        return (Response)resource.path("ws").path("v1").path("cluster").path("scheduler").request(new String[]{"application/json"}).get(Response.class);
    }

    public static void assertXmlType(Response response) {
        Assert.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
    }

    public static void assertXmlResponse(Response response, String expectedResourceFilename) throws Exception {
        TestWebServiceUtil.assertXmlType(response);
        Document document = TestWebServiceUtil.loadDocument((String)response.readEntity(String.class));
        String actual = TestWebServiceUtil.serializeDocument(document).trim();
        TestWebServiceUtil.updateTestDataAutomatically(expectedResourceFilename, actual);
        Assert.assertEquals((Object)TestWebServiceUtil.getResourceAsString(expectedResourceFilename), (Object)actual);
    }

    public static String serializeDocument(Document document) throws TransformerException {
        DOMSource domSource = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = XMLUtils.newSecureTransformerFactory();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.transform(domSource, result);
        return writer.toString();
    }

    public static Document loadDocument(String xml) throws Exception {
        DocumentBuilderFactory factory = XMLUtils.newSecureDocumentBuilderFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(xml));
        return builder.parse(is);
    }

    public static void assertJsonResponse(Response response, String expectedResourceFilename) throws IOException {
        TestWebServiceUtil.assertJsonType(response);
        JsonNode jsonNode = MAPPER.readTree((String)response.readEntity(String.class));
        TestWebServiceUtil.sortQueuesLexically((ObjectNode)jsonNode);
        String actual = OBJECT_WRITER.writeValueAsString((Object)jsonNode);
        TestWebServiceUtil.updateTestDataAutomatically(expectedResourceFilename, actual);
        Assert.assertEquals((Object)OBJECT_WRITER.writeValueAsString((Object)MAPPER.readTree(Objects.requireNonNull(TestWebServiceUtil.getResourceAsString(expectedResourceFilename)))), (Object)actual);
    }

    private static void sortQueuesLexically(ObjectNode object) {
        Iterator keys = object.fieldNames();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            JsonNode o = object.get(key);
            if (key.equals("queue") && o.isArray()) {
                ArrayNode original = (ArrayNode)o;
                ArrayList<ObjectNode> queues = new ArrayList<ObjectNode>(original.size());
                for (int i = 0; i < original.size(); ++i) {
                    if (!original.get(i).isObject()) continue;
                    queues.add((ObjectNode)original.get(i));
                }
                queues.sort(new Comparator<ObjectNode>(){
                    private static final String SORT_BY_KEY = "queuePath";

                    @Override
                    public int compare(ObjectNode a, ObjectNode b) {
                        return a.get(SORT_BY_KEY).asText().compareTo(b.get(SORT_BY_KEY).asText());
                    }
                });
                object.set("queue", (JsonNode)MAPPER.createObjectNode().arrayNode().addAll(queues));
                continue;
            }
            if (!o.isObject()) continue;
            TestWebServiceUtil.sortQueuesLexically((ObjectNode)o);
        }
    }

    public static void assertJsonType(Response response) {
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
    }

    public static InputStream getResourceAsStream(String configFilename) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.getResourceAsStream(configFilename);
    }

    /*
     * Exception decompiling
     */
    public static String getResourceAsString(String configFilename) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void updateTestDataAutomatically(String configFilename, String actualContent) {
        if (System.getenv("UPDATE_TESTDATA") == null) {
            return;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            String resource = Objects.requireNonNull(Objects.requireNonNull(classLoader.getResource(configFilename)).toURI().getPath()).replaceAll("/target/test-classes/", "/src/test/resources/");
            try (FileWriter writer = new FileWriter(resource, false);){
                writer.write(actualContent);
            }
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
            Assert.fail((String)("overwrite should not fail " + e.getMessage()));
        }
    }

    public static MockRM createRM(Configuration config) {
        return TestWebServiceUtil.createRM(config, false);
    }

    public static MockRM createRM(Configuration config, boolean setCustomAuthFilter) {
        config.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        config.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
        MockRM rm = new MockRM(config);
        rm.start();
        return rm;
    }

    public static MockRM createMutableRM(Configuration conf, boolean setCustomAuthFilter) {
        conf.set("yarn.scheduler.configuration.store.class", "memory");
        return TestWebServiceUtil.createRM((Configuration)new CapacitySchedulerConfiguration(conf), setCustomAuthFilter);
    }

    public static void reinitialize(MockRM rm, Configuration conf) throws IOException {
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        cs.reinitialize(conf, rm.getRMContext(), true);
    }

    public static File getCapacitySchedulerConfigFileInTarget() {
        return new File("target/test-classes", "capacity-scheduler.xml");
    }

    public static File getBackupCapacitySchedulerConfigFileInTarget() {
        return new File("target/test-classes", "capacity-scheduler.xml.tmp");
    }

    public static void backupSchedulerConfigFileInTarget() {
        File file = TestWebServiceUtil.getCapacitySchedulerConfigFileInTarget();
        if (file.exists() && !file.renameTo(TestWebServiceUtil.getBackupCapacitySchedulerConfigFileInTarget())) {
            throw new RuntimeException("Failed to backup configuration file");
        }
    }

    public static void restoreSchedulerConfigFileInTarget() {
        File file = TestWebServiceUtil.getBackupCapacitySchedulerConfigFileInTarget();
        if (file.exists()) {
            TestWebServiceUtil.getCapacitySchedulerConfigFileInTarget().delete();
            if (!file.renameTo(TestWebServiceUtil.getCapacitySchedulerConfigFileInTarget())) {
                throw new RuntimeException("Failed to restore configuration file");
            }
        }
    }

    public static String toEntity(Object obj, Class<?> klass, String mediaType) throws Exception {
        if (mediaType == "application/json") {
            return TestWebServiceUtil.toJson(obj, klass);
        }
        if (mediaType == "application/xml") {
            return TestWebServiceUtil.toXml(obj, klass);
        }
        return null;
    }

    public static String toJson(Object obj, Class<?> klass) throws Exception {
        StringWriter stringWriter = new StringWriter();
        JettisonJaxbContext jettisonJaxbContext = new JettisonJaxbContext(new Class[]{klass});
        JettisonMarshaller jettisonMarshaller = jettisonJaxbContext.createJsonMarshaller();
        jettisonMarshaller.marshallToJSON(obj, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public static String toXml(Object obj, Class<?> klass) throws JAXBException {
        StringWriter stringWriter = new StringWriter();
        JettisonJaxbContext jettisonJaxbContext = new JettisonJaxbContext(new Class[]{klass});
        Marshaller marshaller = jettisonJaxbContext.createMarshaller();
        marshaller.marshal(obj, (Writer)stringWriter);
        return stringWriter.toString();
    }
}

