/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.AllocationState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.ResourceUsageMultiNodeLookupPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.ActivitiesTestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWSConsts;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRMWebServicesSchedulerActivitiesWithMultiNodesEnabled
extends JerseyTestBase {
    private static MockRM rm;
    private static CapacitySchedulerConfiguration csConf;
    private static YarnConfiguration conf;

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register(RMWebServices.class);
        config.register((Object)new JerseyBinder());
        config.register(GenericExceptionHandler.class);
        config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        this.forceSet("jersey.config.test.container.port", "0");
        return config;
    }

    private static void setupQueueConfiguration(CapacitySchedulerConfiguration config) {
        QueuePath root = new QueuePath("root");
        QueuePath a = new QueuePath("root", "a");
        QueuePath b = new QueuePath("root", "b");
        config.setQueues(root, new String[]{"a", "b"});
        config.setCapacity(a, 10.5f);
        config.setMaximumCapacity(a, 50.0f);
        config.setCapacity(b, 89.5f);
        config.setMaximumApplicationMasterResourcePerQueuePercent(b, 100.0f);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testAssignContainer() throws Exception {
        rm.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 2048, rm.getResourceTrackerService());
        nm.registerNode();
        try {
            RMApp app1 = MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b").build());
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm);
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"127.0.0.1", (Resource)Resources.createResource((int)1024), (int)1), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"/default-rack", (Resource)Resources.createResource((int)1024), (int)1), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)1024), (int)1)), null);
            WebTarget r = this.targetWithJsonObject();
            Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
            RMNode rmNode = (RMNode)rm.getRMContext().getRMNodes().get(nm.getNodeId());
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode));
            response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocations = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "activities", "allocations");
            ActivitiesTestUtils.verifyStateOfAllocations(allocations, "finalAllocationState", "ALLOCATED");
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testSchedulingWithoutPendingRequests() throws Exception {
        rm.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 8192, rm.getResourceTrackerService());
        nm.registerNode();
        try {
            WebTarget r = this.targetWithJsonObject();
            Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
            RMNode rmNode = (RMNode)rm.getRMContext().getRMNodes().get(nm.getNodeId());
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode));
            response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocation = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "activities", "allocations");
            ActivitiesTestUtils.verifyStateOfAllocations(allocation, "finalAllocationState", "SKIPPED");
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testAppAssignContainer() throws Exception {
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 4096);
        MockNM nm2 = rm.registerNode("127.0.0.2:1234", 2048);
        try {
            RMApp app1 = MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b").build());
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)3072), (int)1)), null);
            WebTarget r = this.target().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            MultivaluedHashMap params = new MultivaluedHashMap();
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"waiting for display", (Object)json.getJSONObject("appActivities").getString("diagnostic"));
            CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
            RMNode rmNode = (RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId());
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode));
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocationObj = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "appActivities", "allocations");
            ActivitiesTestUtils.verifyStateOfAllocations(allocationObj, "allocationState", "ALLOCATED");
            JSONObject requestAllocationObj = ActivitiesTestUtils.getFirstSubNodeFromJson(allocationObj, "children");
            ActivitiesTestUtils.verifyNumberOfAllocationAttempts(requestAllocationObj, 2);
            ActivitiesTestUtils.verifyStateOfAllocations(requestAllocationObj, "allocationState", "ALLOCATED");
            JSONArray allocationAttemptArray = requestAllocationObj.getJSONArray("children");
            JSONObject allocationAttempt1 = allocationAttemptArray.getJSONObject(0);
            ActivitiesTestUtils.verifyStateOfAllocations(allocationAttempt1, "allocationState", "SKIPPED");
            Assert.assertTrue((boolean)allocationAttempt1.optString("diagnostic").contains("Node's total resource is insufficient for request, insufficient resources="));
            JSONObject allocationAttempt2 = allocationAttemptArray.getJSONObject(1);
            ActivitiesTestUtils.verifyStateOfAllocations(allocationAttempt2, "allocationState", "ALLOCATED");
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testInsufficientResourceDiagnostic() throws Exception {
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 4096);
        MockNM nm2 = rm.registerNode("127.0.0.2:1234", 2048);
        MockNM nm3 = rm.registerNode("127.0.0.3:1234", 2048);
        MockNM nm4 = rm.registerNode("127.0.0.4:1234", 2048);
        try {
            RMApp app1 = MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(3072L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b").build());
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
            RMApp app2 = MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app2").withUser("user1").withAcls(null).withQueue("b").build());
            MockAM am2 = MockRM.launchAndRegisterAM(app2, rm, nm1);
            WebTarget r = this.targetWithJsonObject();
            Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Assert.assertEquals((Object)"waiting for next allocation", (Object)json.getJSONObject("activities").getString("diagnostic"));
            am2.allocate("*", 4096, 1, new ArrayList<ContainerId>());
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            json = (JSONObject)response.readEntity(JSONObject.class);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocationObj = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "activities", "allocations");
            Predicate<JSONObject> findApp1Pred = obj -> obj.optString("name").equals(app1.getApplicationId().toString());
            JSONObject app1Obj = ActivitiesTestUtils.findInAllocations(allocationObj, findApp1Pred).get(0);
            Assert.assertEquals((Object)"SKIPPED", (Object)app1Obj.optString("allocationState"));
            Assert.assertEquals((Object)"Application does not need more resource", (Object)app1Obj.optString("diagnostic"));
            Predicate<JSONObject> findApp2ReqPred = obj -> obj.optString("name").equals("request_1_-1");
            List<JSONObject> app2ReqObjs = ActivitiesTestUtils.findInAllocations(allocationObj, findApp2ReqPred);
            Assert.assertEquals((long)1L, (long)app2ReqObjs.size());
            JSONArray app2ReqChildren = app2ReqObjs.get(0).getJSONArray("children");
            Assert.assertEquals((long)4L, (long)app2ReqChildren.length());
            for (int i = 0; i < app2ReqChildren.length(); ++i) {
                JSONObject reqChild = app2ReqChildren.getJSONObject(i);
                if (!reqChild.getString("allocationState").equals("SKIPPED")) continue;
                String diagnostic = reqChild.getString("diagnostic");
                Assert.assertTrue((boolean)diagnostic.contains("Node's total resource is insufficient for request, insufficient resources="));
            }
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testAppInsufficientResourceDiagnostic() throws Exception {
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 4096);
        MockNM nm2 = rm.registerNode("127.0.0.2:1234", 2048);
        MockNM nm3 = rm.registerNode("127.0.0.3:1234", 2048);
        MockNM nm4 = rm.registerNode("127.0.0.4:1234", 2048);
        try {
            RMApp app1 = MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(3072L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b").build());
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
            WebTarget r = this.target().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            MultivaluedHashMap params = new MultivaluedHashMap();
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"waiting for display", (Object)json.getJSONObject("appActivities").getString("diagnostic"));
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)0), (String)"*", (Resource)Resources.createResource((int)1024), (int)1), ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)4096), (int)1)), null);
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 2);
            JSONArray allocationArray = json.getJSONObject("appActivities").getJSONArray("allocations");
            JSONObject allocationObj = allocationArray.getJSONObject(0);
            ActivitiesTestUtils.verifyStateOfAllocations(allocationObj, "allocationState", "RESERVED");
            JSONObject requestAllocationObj = ActivitiesTestUtils.getFirstSubNodeFromJson(allocationObj, "children");
            ActivitiesTestUtils.verifyNumberOfAllocationAttempts(requestAllocationObj, 4);
            JSONArray allocationAttemptArray = requestAllocationObj.getJSONArray("children");
            for (int i = 0; i < allocationAttemptArray.length(); ++i) {
                JSONObject allocationAttemptObj = allocationAttemptArray.getJSONObject(i);
                if (i == allocationAttemptArray.length() - 1) continue;
                Assert.assertTrue((boolean)allocationAttemptObj.optString("diagnostic").contains("Node's total resource is insufficient for request, insufficient resources="));
            }
            allocationObj = allocationArray.getJSONObject(1);
            ActivitiesTestUtils.verifyStateOfAllocations(allocationObj, "allocationState", "ALLOCATED");
            requestAllocationObj = ActivitiesTestUtils.getFirstSubNodeFromJson(allocationObj, "children");
            ActivitiesTestUtils.verifyNumberOfAllocationAttempts(requestAllocationObj, 1);
            ActivitiesTestUtils.verifyStateOfAllocations(requestAllocationObj, "allocationState", "ALLOCATED");
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testGroupByDiagnostics() throws Exception {
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 4096);
        MockNM nm2 = rm.registerNode("127.0.0.2:1234", 2048);
        MockNM nm3 = rm.registerNode("127.0.0.3:1234", 2048);
        MockNM nm4 = rm.registerNode("127.0.0.4:1234", 2048);
        try {
            RMApp app1 = MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(3072L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b").build());
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
            WebTarget r = this.target().path("/ws/v1/cluster").path("/scheduler/activities");
            MultivaluedHashMap params = new MultivaluedHashMap();
            params.add((Object)"groupBy", (Object)"NON-EXIST-GROUP-BY");
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertTrue((boolean)json.getJSONObject("activities").getString("diagnostic").startsWith("Got invalid groupBy:"));
            params.remove((Object)"groupBy");
            params.add((Object)"groupBy", (Object)RMWSConsts.ActivitiesGroupBy.DIAGNOSTIC.name().toLowerCase());
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"waiting for next allocation", (Object)json.getJSONObject("activities").getString("diagnostic"));
            am1.allocate("*", 4096, 1, new ArrayList<ContainerId>());
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocationObj = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "activities", "allocations");
            Predicate<JSONObject> findReqPred = obj -> obj.optString("name").equals("request_1_-1");
            List<JSONObject> reqObjs = ActivitiesTestUtils.findInAllocations(allocationObj, findReqPred);
            Assert.assertEquals((long)1L, (long)reqObjs.size());
            JSONArray reqChildren = reqObjs.get(0).getJSONArray("children");
            Assert.assertEquals((long)2L, (long)reqChildren.length());
            for (int i = 0; i < reqChildren.length(); ++i) {
                JSONObject reqChild = reqChildren.getJSONObject(i);
                if (reqChild.getString("allocationState").equals(AllocationState.SKIPPED.name())) {
                    Assert.assertEquals((Object)"3", (Object)reqChild.getString("count"));
                    Assert.assertEquals((long)3L, (long)reqChild.getJSONArray("nodeIds").length());
                    Assert.assertTrue((boolean)reqChild.optString("diagnostic").contains("Node's total resource is insufficient for request, insufficient resources="));
                    continue;
                }
                if (reqChild.getString("allocationState").equals(AllocationState.RESERVED.name())) {
                    Assert.assertEquals((Object)"1", (Object)reqChild.getString("count"));
                    Assert.assertNotNull((Object)reqChild.getString("nodeIds"));
                    continue;
                }
                Assert.fail((String)("Allocation state should be " + AllocationState.SKIPPED.name() + " or " + AllocationState.RESERVED.name() + "!"));
            }
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testAppGroupByDiagnostics() throws Exception {
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 4096);
        MockNM nm2 = rm.registerNode("127.0.0.2:1234", 2048);
        MockNM nm3 = rm.registerNode("127.0.0.3:1234", 2048);
        MockNM nm4 = rm.registerNode("127.0.0.4:1234", 2048);
        try {
            RMApp app1 = MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(3072L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b").build());
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
            WebTarget r = this.target().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            MultivaluedHashMap params = new MultivaluedHashMap();
            params.add((Object)"groupBy", (Object)"NON-EXIST-GROUP-BY");
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertTrue((boolean)json.getJSONObject("appActivities").getString("diagnostic").startsWith("Got invalid groupBy:"));
            params.remove((Object)"groupBy");
            params.add((Object)"groupBy", (Object)RMWSConsts.ActivitiesGroupBy.DIAGNOSTIC.name().toLowerCase());
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"waiting for display", (Object)json.getJSONObject("appActivities").getString("diagnostic"));
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)0), (String)"*", (Resource)Resources.createResource((int)1024), (int)1), ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)4096), (int)1)), null);
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 2);
            List<JSONObject> allocations = ActivitiesTestUtils.getSubNodesFromJson(json, "appActivities", "allocations");
            JSONObject allocationObj = allocations.get(0);
            ActivitiesTestUtils.verifyStateOfAllocations(allocationObj, "allocationState", "RESERVED");
            JSONObject requestAllocationObj = ActivitiesTestUtils.getFirstSubNodeFromJson(allocationObj, "children");
            ActivitiesTestUtils.verifyNumberOfAllocationAttempts(requestAllocationObj, 2);
            JSONArray allocationAttemptArray = requestAllocationObj.getJSONArray("children");
            for (int i = 0; i < allocationAttemptArray.length(); ++i) {
                JSONObject allocationAttemptObj = allocationAttemptArray.getJSONObject(i);
                if (allocationAttemptObj.getString("allocationState").equals(AllocationState.SKIPPED.name())) {
                    Assert.assertEquals((Object)"3", (Object)allocationAttemptObj.getString("count"));
                    Assert.assertEquals((long)3L, (long)allocationAttemptObj.getJSONArray("nodeIds").length());
                    Assert.assertTrue((boolean)allocationAttemptObj.optString("diagnostic").contains("Node's total resource is insufficient for request, insufficient resources="));
                    continue;
                }
                if (allocationAttemptObj.getString("allocationState").equals(AllocationState.RESERVED.name())) {
                    Assert.assertEquals((Object)"1", (Object)allocationAttemptObj.getString("count"));
                    Assert.assertNotNull((Object)allocationAttemptObj.getString("nodeIds"));
                    continue;
                }
                Assert.fail((String)("Allocation state should be " + AllocationState.SKIPPED.name() + " or " + AllocationState.RESERVED.name() + "!"));
            }
            allocationObj = allocations.get(1);
            ActivitiesTestUtils.verifyStateOfAllocations(allocationObj, "allocationState", "ALLOCATED");
            requestAllocationObj = ActivitiesTestUtils.getFirstSubNodeFromJson(allocationObj, "children");
            ActivitiesTestUtils.verifyNumberOfAllocationAttempts(requestAllocationObj, 1);
            ActivitiesTestUtils.verifyStateOfAllocations(requestAllocationObj, "allocationState", "ALLOCATED");
            JSONObject allocationAttemptObj = ActivitiesTestUtils.getFirstSubNodeFromJson(requestAllocationObj, "children");
            Assert.assertEquals((Object)"1", (Object)allocationAttemptObj.getString("count"));
            Assert.assertNotNull((Object)allocationAttemptObj.getString("nodeIds"));
        }
        finally {
            rm.stop();
        }
    }

    private class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            csConf = new CapacitySchedulerConfiguration();
            TestRMWebServicesSchedulerActivitiesWithMultiNodesEnabled.setupQueueConfiguration(csConf);
            conf = new YarnConfiguration((Configuration)csConf);
            conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
            conf.setBoolean("yarn.scheduler.capacity.multi-node-placement-enabled", true);
            String policyName = "resource-based";
            conf.set("yarn.scheduler.capacity.multi-node-sorting.policy.names", policyName);
            conf.set("yarn.scheduler.capacity.multi-node-sorting.policy", policyName);
            String policyConfPrefix = "yarn.scheduler.capacity.multi-node-sorting.policy." + policyName;
            conf.set(policyConfPrefix + ".class", ResourceUsageMultiNodeLookupPolicy.class.getName());
            conf.set(policyConfPrefix + ".sorting-interval.ms", "0");
            conf.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
            conf.setLong("yarn.resourcemanager.nodemanagers.heartbeat-interval-ms", 30000L);
            rm = new MockRM((Configuration)conf);
            ((InstanceBinding)this.bind((Object)rm).to(ResourceManager.class)).named("rm");
            ((InstanceBinding)this.bind(conf).to(Configuration.class)).named("conf");
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            this.bind(request).to(HttpServletRequest.class);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            this.bind(response).to(HttpServletResponse.class);
        }
    }
}

