/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.api.resource.PlacementConstraints;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.ActivitiesTestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWSConsts;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.reader.NodeLabelsInfoReader;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRMWebServicesSchedulerActivities
extends JerseyTestBase {
    private MockRM rm;

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register(RMWebServices.class);
        config.register((Object)new JerseyBinder());
        config.register(GenericExceptionHandler.class);
        config.register(NodeLabelsInfoReader.class);
        config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        this.forceSet("jersey.config.test.container.port", "0");
        return config;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    public static MockRM createMockRM(CapacitySchedulerConfiguration csConf) {
        TestRMWebServicesSchedulerActivities.setupQueueConfiguration(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
        return new MockRM((Configuration)conf);
    }

    public static void setupQueueConfiguration(CapacitySchedulerConfiguration config) {
        config.set("yarn.scheduler.capacity.root.queues", "a, b, c");
        config.set("yarn.scheduler.capacity.root.a.queues", "a1, a2");
        config.set("yarn.scheduler.capacity.root.b.queues", "b1, b2, b3");
        config.set("yarn.scheduler.capacity.root.a.a1.queues", "a1a, a1b, a1c");
        config.set("yarn.scheduler.capacity.root.a.capacity", "10.5");
        config.set("yarn.scheduler.capacity.root.a.maximum-capacity", "50");
        config.set("yarn.scheduler.capacity.root.a.max-parallel-app", "42");
        config.set("yarn.scheduler.capacity.root.b.capacity", "79.5");
        config.set("yarn.scheduler.capacity.root.c.capacity", "10");
        config.set("yarn.scheduler.capacity.root.a.a1.capacity", "30");
        config.set("yarn.scheduler.capacity.root.a.a1.maximum-capacity", "50");
        config.set("yarn.scheduler.capacity.root.a.a1.user-limit-factor", "100");
        config.set("yarn.scheduler.capacity.root.a.a2.capacity", "70");
        config.set("yarn.scheduler.capacity.root.a.a2.maximum-application-lifetime", "100");
        config.set("yarn.scheduler.capacity.root.a.a2.default-application-lifetime", "50");
        config.set("yarn.scheduler.capacity.root.a.a2.user-limit-factor", "100");
        config.set("yarn.scheduler.capacity.root.b.b1.capacity", "60");
        config.set("yarn.scheduler.capacity.root.b.b2.capacity", "39.5");
        config.set("yarn.scheduler.capacity.root.b.b3.capacity", "0.5");
        config.set("yarn.scheduler.capacity.root.b.b1.user-limit-factor", "100");
        config.set("yarn.scheduler.capacity.root.b.b2.user-limit-factor", "100");
        config.set("yarn.scheduler.capacity.root.b.b3.user-limit-factor", "100");
        config.set("yarn.scheduler.capacity.root.a.a1.a1a.capacity", "65");
        config.set("yarn.scheduler.capacity.root.a.a1.a1b.capacity", "15");
        config.set("yarn.scheduler.capacity.root.a.a1.a1c.capacity", "20");
        config.set("yarn.scheduler.capacity.root.a.a1.a1c.auto-create-child-queue.enabled", "true");
        config.set("yarn.scheduler.capacity.root.a.a1.a1c.leaf-queue-template.capacity", "50");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAssignMultipleContainersPerNodeHeartbeat() throws Exception {
        this.rm.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 24576, this.rm.getResourceTrackerService());
        nm.registerNode();
        try {
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(10L, this.rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
            RMApp app1 = MockRMAppSubmitter.submit(this.rm, data);
            MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm);
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"127.0.0.1", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"/default-rack", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)1024), (int)10)), null);
            WebTarget r = this.targetWithJsonObject();
            MultivaluedHashMap params = new MultivaluedHashMap();
            params.add((Object)"nodeId", (Object)"127.0.0.1:1234");
            Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParam("nodeId", new Object[]{"127.0.0.1:1234"}).request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            nm.nodeHeartbeat(true);
            Thread.sleep(1000L);
            response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParam("nodeId", new Object[]{"127.0.0.1:1234"}).request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            json = (JSONObject)response.readEntity(JSONObject.class);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocation = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "activities", "allocations");
            ActivitiesTestUtils.verifyStateOfAllocations(allocation, "finalAllocationState", "ALLOCATED");
            ActivitiesTestUtils.verifyQueueOrder(allocation, "root-root.a-root.c-root.b-root.b.b2-root.b.b3-root.b.b1");
        }
        finally {
            this.rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAssignWithoutAvailableResource() throws Exception {
        this.rm.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 1024, this.rm.getResourceTrackerService());
        nm.registerNode();
        try {
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
            RMApp app1 = MockRMAppSubmitter.submit(this.rm, data);
            MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm);
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"127.0.0.1", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"/default-rack", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)1024), (int)10)), null);
            WebTarget r = this.targetWithJsonObject();
            MultivaluedHashMap params = new MultivaluedHashMap();
            params.add((Object)"nodeId", (Object)"127.0.0.1");
            Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParam("nodeId", new Object[]{"127.0.0.1"}).request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            nm.nodeHeartbeat(true);
            Thread.sleep(1000L);
            response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParam("nodeId", new Object[]{"127.0.0.1"}).request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            json = (JSONObject)response.readEntity(JSONObject.class);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject rootObj = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "activities", "allocations").getJSONObject("root");
            Assert.assertTrue((boolean)rootObj.optString("diagnostic").startsWith("Initial check: node resource is insufficient for minimum allocation"));
        }
        finally {
            this.rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoNM() throws Exception {
        this.rm.start();
        try {
            WebTarget r = this.targetWithJsonObject();
            Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParam("nodeId", new Object[]{"127.0.0.1:1234"}).request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Thread.sleep(1000L);
            response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParam("nodeId", new Object[]{"127.0.0.1:1234"}).request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            json = (JSONObject)response.readEntity(JSONObject.class);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 0);
        }
        finally {
            this.rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWrongNodeId() throws Exception {
        this.rm.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 24576, this.rm.getResourceTrackerService());
        nm.registerNode();
        try {
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
            RMApp app1 = MockRMAppSubmitter.submit(this.rm, data);
            MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm);
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"127.0.0.1", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"/default-rack", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)1024), (int)10)), null);
            WebTarget r = this.targetWithJsonObject();
            Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParam("nodeId", new Object[]{"127.0.0.0"}).request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            nm.nodeHeartbeat(true);
            Thread.sleep(1000L);
            response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParam("nodeId", new Object[]{"127.0.0.0"}).request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            json = (JSONObject)response.readEntity(JSONObject.class);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 0);
        }
        finally {
            this.rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReserveNewContainer() throws Exception {
        this.rm.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 4096, this.rm.getResourceTrackerService());
        MockNM nm2 = new MockNM("127.0.0.2:1234", 4096, this.rm.getResourceTrackerService());
        nm1.registerNode();
        nm2.registerNode();
        try {
            MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(10L, this.rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
            RMApp app1 = MockRMAppSubmitter.submit(this.rm, data1);
            MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm1);
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(10L, this.rm).withAppName("app2").withUser("user1").withAcls(null).withQueue("b2").withUnmanagedAM(false).build();
            RMApp app2 = MockRMAppSubmitter.submit(this.rm, data);
            MockAM am2 = MockRM.launchAndRegisterAM(app2, this.rm, nm2);
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)4096), (int)10)), null);
            WebTarget r = this.targetWithJsonObject();
            Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParam("nodeId", new Object[]{"127.0.0.2"}).request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            nm2.nodeHeartbeat(true);
            Thread.sleep(1000L);
            response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParam("nodeId", new Object[]{"127.0.0.2"}).request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            json = (JSONObject)response.readEntity(JSONObject.class);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocations = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "activities", "allocations");
            ActivitiesTestUtils.verifyQueueOrder(allocations, "root-root.a-root.c-root.b-root.b.b3-root.b.b1");
            ActivitiesTestUtils.verifyStateOfAllocations(allocations, "finalAllocationState", "RESERVED");
            r = this.targetWithJsonObject();
            response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParam("nodeId", new Object[]{"127.0.0.2"}).request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            json = (JSONObject)response.readEntity(JSONObject.class);
            nm2.nodeHeartbeat(true);
            Thread.sleep(1000L);
            response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParam("nodeId", new Object[]{"127.0.0.2"}).request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            json = (JSONObject)response.readEntity(JSONObject.class);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocation = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "activities", "allocations");
            ActivitiesTestUtils.verifyQueueOrder(allocation, "root.b.b1");
            ActivitiesTestUtils.verifyStateOfAllocations(allocation, "finalAllocationState", "RESERVED");
            CapacityScheduler cs = (CapacityScheduler)this.rm.getResourceScheduler();
            ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)1L);
            cs.completedContainer(cs.getRMContainer(containerId), ContainerStatus.newInstance((ContainerId)containerId, (ContainerState)ContainerState.COMPLETE, (String)"", (int)0), RMContainerEventType.FINISHED);
            r = this.targetWithJsonObject();
            response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParam("nodeId", new Object[]{"127.0.0.2"}).request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            json = (JSONObject)response.readEntity(JSONObject.class);
            nm2.nodeHeartbeat(true);
            Thread.sleep(1000L);
            response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParam("nodeId", new Object[]{"127.0.0.2"}).request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            json = (JSONObject)response.readEntity(JSONObject.class);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            allocations = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "activities", "allocations");
            ActivitiesTestUtils.verifyQueueOrder(allocations, "root.b.b1");
            ActivitiesTestUtils.verifyStateOfAllocations(allocations, "finalAllocationState", "ALLOCATED_FROM_RESERVED");
        }
        finally {
            this.rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testActivityJSON() throws Exception {
        this.rm.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 24576, this.rm.getResourceTrackerService());
        nm.registerNode();
        try {
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(10L, this.rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
            RMApp app1 = MockRMAppSubmitter.submit(this.rm, data);
            WebTarget r = this.targetWithJsonObject();
            Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParam("nodeId", new Object[]{"127.0.0.1"}).request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            nm.nodeHeartbeat(true);
            Thread.sleep(1000L);
            response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").queryParam("nodeId", new Object[]{"127.0.0.1"}).request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            json = (JSONObject)response.readEntity(JSONObject.class);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocation = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "activities", "allocations");
            ActivitiesTestUtils.verifyStateOfAllocations(allocation, "finalAllocationState", "ALLOCATED");
            ActivitiesTestUtils.verifyNumberOfNodes(allocation, 6);
            ActivitiesTestUtils.verifyQueueOrder(allocation, "root-root.b-root.b.b1");
        }
        finally {
            this.rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppActivityJSON() throws Exception {
        this.rm.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 24576, this.rm.getResourceTrackerService());
        nm.registerNode();
        try {
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(10L, this.rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
            RMApp app1 = MockRMAppSubmitter.submit(this.rm, data);
            WebTarget r = this.target().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            MultivaluedHashMap params = new MultivaluedHashMap();
            ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            nm.nodeHeartbeat(true);
            Thread.sleep(5000L);
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocation = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "appActivities", "allocations");
            ActivitiesTestUtils.verifyStateOfAllocations(allocation, "allocationState", "ALLOCATED");
            JSONObject requestAllocationObj = ActivitiesTestUtils.getFirstSubNodeFromJson(allocation, "children");
            ActivitiesTestUtils.verifyStateOfAllocations(requestAllocationObj, "allocationState", "ALLOCATED");
            Assert.assertEquals((long)0L, (long)requestAllocationObj.optInt("requestPriority"));
            Assert.assertEquals((long)-1L, (long)requestAllocationObj.optLong("allocationRequestId"));
            ActivitiesTestUtils.verifyNumberOfAllocationAttempts(requestAllocationObj, 1);
            List<JSONObject> allocationAttempts = ActivitiesTestUtils.getSubNodesFromJson(requestAllocationObj, "children");
            Assert.assertEquals((long)1L, (long)allocationAttempts.size());
            ActivitiesTestUtils.verifyStateOfAllocations(allocationAttempts.get(0), "allocationState", "ALLOCATED");
            Assert.assertNotNull((Object)allocationAttempts.get(0).get("nodeId"));
        }
        finally {
            this.rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppAssignMultipleContainersPerNodeHeartbeat() throws Exception {
        this.rm.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 24576, this.rm.getResourceTrackerService());
        nm.registerNode();
        try {
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
            RMApp app1 = MockRMAppSubmitter.submit(this.rm, data);
            MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm);
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"127.0.0.1", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"/default-rack", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)1024), (int)10)), null);
            WebTarget r = this.target().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            MultivaluedHashMap params = new MultivaluedHashMap();
            ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            nm.nodeHeartbeat(true);
            Thread.sleep(5000L);
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 10);
            List<JSONObject> allocations = ActivitiesTestUtils.getSubNodesFromJson(json, "appActivities", "allocations");
            for (int i = 0; i < allocations.size(); ++i) {
                ActivitiesTestUtils.verifyStateOfAllocations(allocations.get(i), "allocationState", "ALLOCATED");
            }
        }
        finally {
            this.rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppAssignWithoutAvailableResource() throws Exception {
        this.rm.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 1024, this.rm.getResourceTrackerService());
        nm.registerNode();
        try {
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
            RMApp app1 = MockRMAppSubmitter.submit(this.rm, data);
            MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm);
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"127.0.0.1", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"/default-rack", (Resource)Resources.createResource((int)1024), (int)10), ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)1024), (int)10)), null);
            WebTarget r = this.target().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            MultivaluedHashMap params = new MultivaluedHashMap();
            ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            nm.nodeHeartbeat(true);
            Thread.sleep(5000L);
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 0);
        }
        finally {
            this.rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppNoNM() throws Exception {
        this.rm.start();
        try {
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
            RMApp app1 = MockRMAppSubmitter.submit(this.rm, data);
            WebTarget r = this.target().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            MultivaluedHashMap params = new MultivaluedHashMap();
            ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 0);
        }
        finally {
            this.rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppReserveNewContainer() throws Exception {
        this.rm.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 4096, this.rm.getResourceTrackerService());
        MockNM nm2 = new MockNM("127.0.0.2:1234", 4096, this.rm.getResourceTrackerService());
        nm1.registerNode();
        nm2.registerNode();
        try {
            MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(10L, this.rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
            RMApp app1 = MockRMAppSubmitter.submit(this.rm, data1);
            MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm1);
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(10L, this.rm).withAppName("app2").withUser("user1").withAcls(null).withQueue("b2").withUnmanagedAM(false).build();
            RMApp app2 = MockRMAppSubmitter.submit(this.rm, data);
            MockAM am2 = MockRM.launchAndRegisterAM(app2, this.rm, nm2);
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)4096), (int)10)), null);
            WebTarget r = this.target().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            MultivaluedHashMap params = new MultivaluedHashMap();
            ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            nm2.nodeHeartbeat(true);
            Thread.sleep(1000L);
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            nm2.nodeHeartbeat(true);
            Thread.sleep(1000L);
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 2);
            CapacityScheduler cs = (CapacityScheduler)this.rm.getResourceScheduler();
            ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)1L);
            cs.completedContainer(cs.getRMContainer(containerId), ContainerStatus.newInstance((ContainerId)containerId, (ContainerState)ContainerState.COMPLETE, (String)"", (int)0), RMContainerEventType.FINISHED);
            nm2.nodeHeartbeat(true);
            Thread.sleep(1000L);
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 3);
        }
        finally {
            this.rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testInsufficientResourceDiagnostic() throws Exception {
        this.rm.start();
        CapacityScheduler cs = (CapacityScheduler)this.rm.getResourceScheduler();
        MockNM nm1 = this.rm.registerNode("127.0.0.1:1234", 4096);
        MockNM nm2 = this.rm.registerNode("127.0.0.2:1234", 8192);
        try {
            RMApp app1 = MockRMAppSubmitter.submit(this.rm, MockRMAppSubmissionData.Builder.createWithMemory(512L, this.rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").build());
            MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm1);
            WebTarget r = this.targetWithJsonObject();
            Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Assert.assertEquals((Object)"waiting for next allocation", (Object)ActivitiesTestUtils.getFirstSubNodeFromJson(json, "activities").optString("diagnostic"));
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)5120), (int)1)), null);
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            json = (JSONObject)response.readEntity(JSONObject.class);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocationObj = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "activities", "allocations");
            Predicate<JSONObject> findReqPred = obj -> obj.optString("name").equals("request_-1_-1");
            List<JSONObject> app2ReqObjs = ActivitiesTestUtils.findInAllocations(allocationObj, findReqPred);
            Assert.assertEquals((long)1L, (long)app2ReqObjs.size());
            List<JSONObject> reqAllocations = ActivitiesTestUtils.getSubNodesFromJson(app2ReqObjs.get(0), "children");
            Assert.assertEquals((long)1L, (long)reqAllocations.size());
            Assert.assertTrue((boolean)reqAllocations.get(0).getString("diagnostic").contains("Node's total resource is insufficient for request, insufficient resources="));
        }
        finally {
            this.rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testPlacementConstraintDiagnostic() throws Exception {
        this.rm.start();
        CapacityScheduler cs = (CapacityScheduler)this.rm.getResourceScheduler();
        MockNM nm1 = this.rm.registerNode("127.0.0.1:1234", 4096);
        try {
            RMApp app1 = MockRMAppSubmitter.submit(this.rm, MockRMAppSubmissionData.Builder.createWithMemory(512L, this.rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").build());
            MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm1);
            PlacementConstraint pcExpression = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})}));
            ArrayList<SchedulingRequest> schedulingRequests = new ArrayList<SchedulingRequest>();
            schedulingRequests.add(ActivitiesTestUtils.schedulingRequest(5, 1, 1L, 1, 512, pcExpression, "foo"));
            AllocateRequest allocateReq = AllocateRequest.newBuilder().schedulingRequests(schedulingRequests).build();
            am1.allocate(allocateReq);
            WebTarget r = this.targetWithJsonObject();
            Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
            Assert.assertEquals((Object)"waiting for next allocation", (Object)ActivitiesTestUtils.getFirstSubNodeFromJson(json, "activities").optString("diagnostic"));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/activities").request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            json = (JSONObject)response.readEntity(JSONObject.class);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocationObj = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "activities", "allocations");
            Predicate<JSONObject> findReqPred = obj -> obj.optString("name").equals("request_1_1");
            List<JSONObject> reqObjs = ActivitiesTestUtils.findInAllocations(allocationObj, findReqPred);
            Assert.assertEquals((long)1L, (long)reqObjs.size());
            JSONObject reqChild = ActivitiesTestUtils.getFirstSubNodeFromJson(reqObjs.get(0), "children");
            Assert.assertTrue((boolean)reqChild.getString("diagnostic").contains("Node does not match partition or placement constraints, unsatisfied PC expression="));
        }
        finally {
            this.rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testAppInsufficientResourceDiagnostic() throws Exception {
        this.rm.start();
        CapacityScheduler cs = (CapacityScheduler)this.rm.getResourceScheduler();
        MockNM nm1 = this.rm.registerNode("127.0.0.1:1234", 4096);
        MockNM nm2 = this.rm.registerNode("127.0.0.2:1234", 8192);
        try {
            RMApp app1 = MockRMAppSubmitter.submit(this.rm, MockRMAppSubmissionData.Builder.createWithMemory(512L, this.rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").build());
            MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm1);
            WebTarget r = this.target().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            MultivaluedHashMap params = new MultivaluedHashMap();
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"waiting for display", (Object)json.getJSONObject("appActivities").getString("diagnostic"));
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)Resources.createResource((int)5120), (int)1)), null);
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocationObj = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "appActivities", "allocations");
            JSONObject requestAllocationObj = ActivitiesTestUtils.getFirstSubNodeFromJson(allocationObj, "children");
            ActivitiesTestUtils.verifyNumberOfAllocationAttempts(requestAllocationObj, 1);
            JSONObject allocationAttemptObj = ActivitiesTestUtils.getFirstSubNodeFromJson(requestAllocationObj, "children");
            ActivitiesTestUtils.verifyStateOfAllocations(allocationAttemptObj, "allocationState", "SKIPPED");
            Assert.assertTrue((boolean)allocationAttemptObj.optString("diagnostic").contains("Node's total resource is insufficient for request, insufficient resources="));
        }
        finally {
            this.rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testAppPlacementConstraintDiagnostic() throws Exception {
        this.rm.start();
        CapacityScheduler cs = (CapacityScheduler)this.rm.getResourceScheduler();
        MockNM nm1 = this.rm.registerNode("127.0.0.1:1234", 4096);
        MockNM nm2 = this.rm.registerNode("127.0.0.2:1234", 8192);
        try {
            RMApp app1 = MockRMAppSubmitter.submit(this.rm, MockRMAppSubmissionData.Builder.createWithMemory(512L, this.rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").build());
            MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm1);
            WebTarget r = this.target().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            MultivaluedHashMap params = new MultivaluedHashMap();
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"waiting for display", (Object)json.getJSONObject("appActivities").getString("diagnostic"));
            PlacementConstraint pcExpression = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})}));
            ArrayList<SchedulingRequest> schedulingRequests = new ArrayList<SchedulingRequest>();
            schedulingRequests.add(ActivitiesTestUtils.schedulingRequest(5, 1, 1L, 1, 512, pcExpression, "foo"));
            AllocateRequest allocateReq = AllocateRequest.newBuilder().schedulingRequests(schedulingRequests).build();
            am1.allocate(allocateReq);
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocationObj = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "appActivities", "allocations");
            JSONObject requestAllocationObj = ActivitiesTestUtils.getFirstSubNodeFromJson(allocationObj, "children");
            ActivitiesTestUtils.verifyNumberOfAllocationAttempts(requestAllocationObj, 1);
            JSONObject allocationAttemptObj = ActivitiesTestUtils.getFirstSubNodeFromJson(requestAllocationObj, "children");
            ActivitiesTestUtils.verifyStateOfAllocations(allocationAttemptObj, "allocationState", "SKIPPED");
            Assert.assertTrue((boolean)allocationAttemptObj.optString("diagnostic").contains("Node does not match partition or placement constraints, unsatisfied PC expression="));
        }
        finally {
            this.rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testAppFilterByRequestPrioritiesAndAllocationRequestIds() throws Exception {
        this.rm.start();
        CapacityScheduler cs = (CapacityScheduler)this.rm.getResourceScheduler();
        MockNM nm1 = this.rm.registerNode("127.0.0.1:1234", 8192);
        try {
            RMApp app1 = MockRMAppSubmitter.submit(this.rm, MockRMAppSubmissionData.Builder.createWithMemory(512L, this.rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").build());
            MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm1);
            WebTarget r = this.target().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            MultivaluedHashMap params = new MultivaluedHashMap();
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"waiting for display", (Object)json.getJSONObject("appActivities").getString("diagnostic"));
            am1.allocate(Arrays.asList(ResourceRequest.newBuilder().priority(Priority.UNDEFINED).allocationRequestId(1L).resourceName("*").capability(Resources.createResource((int)1024)).numContainers(1).build()), null);
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            am1.allocate(Arrays.asList(ResourceRequest.newBuilder().priority(Priority.UNDEFINED).allocationRequestId(2L).resourceName("*").capability(Resources.createResource((int)1024)).numContainers(1).build()), null);
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            am1.allocate(Arrays.asList(ResourceRequest.newBuilder().priority(Priority.newInstance((int)0)).allocationRequestId(1L).resourceName("*").capability(Resources.createResource((int)1024)).numContainers(1).build()), null);
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            am1.allocate(Arrays.asList(ResourceRequest.newBuilder().priority(Priority.newInstance((int)0)).allocationRequestId(3L).resourceName("*").capability(Resources.createResource((int)1024)).numContainers(1).build()), null);
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            MultivaluedHashMap filterParams1 = new MultivaluedHashMap((MultivaluedMap)params);
            filterParams1.add((Object)"requestPriorities", (Object)"0,-1");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)filterParams1);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 4);
            MultivaluedHashMap filterParams2 = new MultivaluedHashMap((MultivaluedMap)params);
            filterParams2.add((Object)"requestPriorities", (Object)"-1");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)filterParams2);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 2);
            JSONArray allocations = json.getJSONObject("appActivities").getJSONArray("allocations");
            for (int i = 0; i < allocations.length(); ++i) {
                Assert.assertEquals((Object)"-1", (Object)ActivitiesTestUtils.getFirstSubNodeFromJson(allocations.getJSONObject(i), "children").optString("requestPriority"));
            }
            MultivaluedHashMap filterParams3 = new MultivaluedHashMap((MultivaluedMap)params);
            filterParams3.add((Object)"allocationRequestIds", (Object)"1");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)filterParams3);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 2);
            allocations = json.getJSONObject("appActivities").getJSONArray("allocations");
            for (int i = 0; i < allocations.length(); ++i) {
                Assert.assertEquals((Object)"1", (Object)ActivitiesTestUtils.getFirstSubNodeFromJson(allocations.getJSONObject(i), "children").optString("allocationRequestId"));
            }
            MultivaluedHashMap filterParams4 = new MultivaluedHashMap((MultivaluedMap)params);
            filterParams4.add((Object)"requestPriorities", (Object)"0");
            filterParams4.add((Object)"allocationRequestIds", (Object)"1");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)filterParams4);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocation = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "appActivities", "allocations");
            JSONObject request = ActivitiesTestUtils.getFirstSubNodeFromJson(allocation, "children");
            Assert.assertEquals((Object)"0", (Object)request.optString("requestPriority"));
            Assert.assertEquals((Object)"1", (Object)request.optString("allocationRequestId"));
            MultivaluedHashMap filterParams5 = new MultivaluedHashMap((MultivaluedMap)params);
            filterParams5.add((Object)"requestPriorities", (Object)"-1");
            filterParams5.add((Object)"allocationRequestIds", (Object)"1,2");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)filterParams5);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 2);
            allocations = json.getJSONObject("appActivities").getJSONArray("allocations");
            for (int i = 0; i < allocations.length(); ++i) {
                Assert.assertEquals((Object)"-1", (Object)ActivitiesTestUtils.getFirstSubNodeFromJson(allocations.getJSONObject(i), "children").optString("requestPriority"));
            }
            MultivaluedHashMap filterParams6 = new MultivaluedHashMap((MultivaluedMap)params);
            filterParams6.add((Object)"requestPriorities", (Object)"-1");
            filterParams6.add((Object)"allocationRequestIds", (Object)"-1,1");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)filterParams6);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
        }
        finally {
            this.rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testAppLimit() throws Exception {
        this.rm.start();
        CapacityScheduler cs = (CapacityScheduler)this.rm.getResourceScheduler();
        MockNM nm1 = this.rm.registerNode("127.0.0.1:1234", 4096);
        MockNM nm2 = this.rm.registerNode("127.0.0.2:1234", 8192);
        try {
            RMApp app1 = MockRMAppSubmitter.submit(this.rm, MockRMAppSubmissionData.Builder.createWithMemory(512L, this.rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").build());
            MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm1);
            WebTarget r = this.target().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            MultivaluedHashMap params = new MultivaluedHashMap();
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"waiting for display", (Object)json.getJSONObject("appActivities").getString("diagnostic"));
            am1.allocate("*", 5120, 1, new ArrayList<ContainerId>());
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 3);
            params.putSingle((Object)"limit", (Object)"10");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 3);
            params.putSingle((Object)"limit", (Object)"2");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 2);
            params.putSingle((Object)"limit", (Object)"1");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            params.putSingle((Object)"limit", (Object)"STRING");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"limit must be integer!", (Object)json.getJSONObject("appActivities").getString("diagnostic"));
            params.putSingle((Object)"limit", (Object)"0");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"limit must be greater than 0!", (Object)json.getJSONObject("appActivities").getString("diagnostic"));
            params.putSingle((Object)"limit", (Object)"-3");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"limit must be greater than 0!", (Object)json.getJSONObject("appActivities").getString("diagnostic"));
        }
        finally {
            this.rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testAppActions() throws Exception {
        this.rm.start();
        CapacityScheduler cs = (CapacityScheduler)this.rm.getResourceScheduler();
        MockNM nm1 = this.rm.registerNode("127.0.0.1:1234", 8192);
        try {
            RMApp app1 = MockRMAppSubmitter.submit(this.rm, MockRMAppSubmissionData.Builder.createWithMemory(512L, this.rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").build());
            MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm1);
            am1.allocate("*", 512, 10, new ArrayList<ContainerId>());
            WebTarget r = this.target().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            MultivaluedHashMap params = new MultivaluedHashMap();
            params.add((Object)"maxTime", (Object)1);
            params.add((Object)"actions", (Object)"get,invalid-action");
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertTrue((boolean)json.getJSONObject("appActivities").getString("diagnostic").startsWith("Got invalid action"));
            params.putSingle((Object)"actions", (Object)"get");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"waiting for display", (Object)json.getJSONObject("appActivities").getString("diagnostic"));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            params.putSingle((Object)"actions", (Object)"get");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"waiting for display", (Object)json.getJSONObject("appActivities").getString("diagnostic"));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            params.putSingle((Object)"actions", (Object)"refresh");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"Successfully received action: refresh", (Object)json.getJSONObject("appActivities").getString("diagnostic"));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            Thread.sleep(1000L);
            params.putSingle((Object)"actions", (Object)"get");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            Thread.sleep(1000L);
            params.remove((Object)"actions");
            params.add((Object)"actions", (Object)"refresh,get");
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            Thread.sleep(1000L);
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 2);
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            Thread.sleep(1000L);
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 3);
        }
        finally {
            this.rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testAppSummary() throws Exception {
        this.rm.start();
        CapacityScheduler cs = (CapacityScheduler)this.rm.getResourceScheduler();
        MockNM nm1 = this.rm.registerNode("127.0.0.1:1234", 8192);
        MockNM nm2 = this.rm.registerNode("127.0.0.2:1234", 4096);
        MockNM nm3 = this.rm.registerNode("127.0.0.3:1234", 4096);
        try {
            RMApp app1 = MockRMAppSubmitter.submit(this.rm, MockRMAppSubmissionData.Builder.createWithMemory(5120L, this.rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").build());
            WebTarget r = this.target().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            MultivaluedHashMap params = new MultivaluedHashMap();
            JSONObject json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            Assert.assertEquals((Object)"waiting for display", (Object)json.getJSONObject("appActivities").getString("diagnostic"));
            MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm1);
            am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)0), (String)"*", (Resource)Resources.createResource((int)5120), (int)1)), null);
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)this.rm.getRMContext().getRMNodes().get(nm2.getNodeId())));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)this.rm.getRMContext().getRMNodes().get(nm3.getNodeId())));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId())));
            params.add((Object)"summarize", (Object)"true");
            params.add((Object)"groupBy", (Object)RMWSConsts.ActivitiesGroupBy.DIAGNOSTIC);
            json = ActivitiesTestUtils.requestWebResource(r, (MultivaluedMap<String, String>)params);
            ActivitiesTestUtils.verifyNumberOfAllocations(json, 1);
            JSONObject allocation = ActivitiesTestUtils.getFirstSubNodeFromJson(json, "appActivities", "allocations");
            JSONObject reqestAllocation = ActivitiesTestUtils.getFirstSubNodeFromJson(allocation, "children");
            JSONArray attempts = reqestAllocation.getJSONArray("children");
            Assert.assertEquals((long)2L, (long)attempts.length());
            for (int i = 0; i < attempts.length(); ++i) {
                JSONObject attempt = attempts.getJSONObject(i);
                if (attempt.getString("allocationState").equals(ActivityState.SKIPPED.name())) {
                    Assert.assertEquals((long)2L, (long)attempt.getJSONArray("nodeIds").length());
                    continue;
                }
                if (!attempt.getString("allocationState").equals(ActivityState.RESERVED.name())) continue;
                Object obj = attempt.get("nodeIds");
                JSONArray jsonArray = new JSONArray();
                if (obj instanceof JSONArray) {
                    jsonArray = attempt.getJSONArray("nodeIds");
                } else {
                    jsonArray.put(obj);
                }
                Assert.assertEquals((long)1L, (long)jsonArray.length());
                Assert.assertEquals((Object)nm1.getNodeId().toString(), (Object)jsonArray.getString(0));
            }
        }
        finally {
            this.rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNodeSkippedBecauseOfRelaxLocality() throws Exception {
        this.rm.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 4096, this.rm.getResourceTrackerService());
        MockNM nm2 = new MockNM("127.0.0.2:1234", 4096, this.rm.getResourceTrackerService());
        nm1.registerNode();
        nm2.registerNode();
        try {
            RMApp app1 = MockRMAppSubmitter.submit(this.rm, MockRMAppSubmissionData.Builder.createWithMemory(10L, this.rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").build());
            MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm1);
            am1.allocate(Arrays.asList(ResourceRequest.newBuilder().priority(Priority.UNDEFINED).resourceName("127.0.0.2").capability(Resources.createResource((int)1024)).numContainers(1).build(), ResourceRequest.newBuilder().priority(Priority.UNDEFINED).resourceName("/default-rack").capability(Resources.createResource((int)1024)).numContainers(1).relaxLocality(false).build(), ResourceRequest.newBuilder().priority(Priority.UNDEFINED).resourceName("*").capability(Resources.createResource((int)1024)).numContainers(1).relaxLocality(false).build()), null);
            WebTarget r = this.target().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            ActivitiesTestUtils.requestWebResource(r, null);
            WebTarget sr = this.target().path("/ws/v1/cluster").path("/scheduler/activities");
            ActivitiesTestUtils.requestWebResource(sr, null);
            nm1.nodeHeartbeat(true);
            Thread.sleep(1000L);
            JSONObject appActivitiesJson = ActivitiesTestUtils.requestWebResource(r, null);
            JSONObject schedulerActivitiesJson = ActivitiesTestUtils.requestWebResource(sr, null);
            ActivitiesTestUtils.verifyNumberOfAllocations(appActivitiesJson, 1);
            List<JSONObject> allocationAttempts = ActivitiesTestUtils.getSubNodesFromJson(appActivitiesJson, "appActivities", "allocations", "children", "children");
            Assert.assertEquals((long)1L, (long)allocationAttempts.size());
            Assert.assertEquals((Object)"Node skipped because relax locality is not allowed", (Object)allocationAttempts.get(0).optString("diagnostic"));
            ActivitiesTestUtils.verifyNumberOfAllocations(schedulerActivitiesJson, 1);
            Predicate<JSONObject> findA1AQueuePred = obj -> obj.optString("name").equals("request_-1_-1");
            List<JSONObject> reqObjs = ActivitiesTestUtils.findInAllocations(ActivitiesTestUtils.getFirstSubNodeFromJson(schedulerActivitiesJson, "activities", "allocations"), findA1AQueuePred);
            Assert.assertEquals((long)1L, (long)reqObjs.size());
            Assert.assertEquals((Object)ActivityState.SKIPPED.name(), (Object)reqObjs.get(0).optString("allocationState"));
            JSONObject nodeObj = ActivitiesTestUtils.getFirstSubNodeFromJson(reqObjs.get(0), "children");
            Assert.assertEquals((Object)nm1.getNodeId().toString(), (Object)nodeObj.optString("nodeId"));
            Assert.assertEquals((Object)"Node skipped because relax locality is not allowed", (Object)nodeObj.optString("diagnostic"));
        }
        finally {
            this.rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueueSkippedBecauseOfHeadroom() throws Exception {
        this.rm.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 4096, this.rm.getResourceTrackerService());
        MockNM nm2 = new MockNM("127.0.0.2:1234", 4096, this.rm.getResourceTrackerService());
        nm1.registerNode();
        nm2.registerNode();
        try {
            RMApp app1 = MockRMAppSubmitter.submit(this.rm, MockRMAppSubmissionData.Builder.createWithMemory(10L, this.rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("a1a").build());
            MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm1);
            am1.allocate(Arrays.asList(ResourceRequest.newBuilder().priority(Priority.UNDEFINED).resourceName("*").capability(Resources.createResource((int)3072)).numContainers(1).relaxLocality(false).build()), null);
            WebTarget r = this.target().path("/ws/v1/cluster").path(ActivitiesTestUtils.format("/scheduler/app-activities/{appid}", app1.getApplicationId().toString()));
            ActivitiesTestUtils.requestWebResource(r, null);
            WebTarget sr = this.target().path("/ws/v1/cluster").path("/scheduler/activities");
            ActivitiesTestUtils.requestWebResource(sr, null);
            nm1.nodeHeartbeat(true);
            Thread.sleep(1000L);
            JSONObject appActivitiesJson = ActivitiesTestUtils.requestWebResource(r, null);
            JSONObject schedulerActivitiesJson = ActivitiesTestUtils.requestWebResource(sr, null);
            ActivitiesTestUtils.verifyNumberOfAllocations(appActivitiesJson, 1);
            List<JSONObject> requestAllocations = ActivitiesTestUtils.getSubNodesFromJson(appActivitiesJson, "appActivities", "allocations", "children");
            Assert.assertEquals((long)1L, (long)requestAllocations.size());
            Assert.assertEquals((Object)"Queue does not have enough headroom for inner highest-priority request", (Object)requestAllocations.get(0).optString("diagnostic"));
            Assert.assertFalse((boolean)requestAllocations.get(0).has("children"));
            ActivitiesTestUtils.verifyNumberOfAllocations(schedulerActivitiesJson, 1);
            Predicate<JSONObject> findA1AQueuePred = obj -> obj.optString("name").equals("root.a.a1.a1a");
            List<JSONObject> a1aQueueObj = ActivitiesTestUtils.findInAllocations(ActivitiesTestUtils.getFirstSubNodeFromJson(schedulerActivitiesJson, "activities", "allocations"), findA1AQueuePred);
            Assert.assertEquals((long)1L, (long)a1aQueueObj.size());
            Assert.assertEquals((Object)ActivityState.REJECTED.name(), (Object)a1aQueueObj.get(0).optString("allocationState"));
            Assert.assertTrue((boolean)a1aQueueObj.get(0).optString("diagnostic").startsWith("Queue does not have enough headroom for inner highest-priority request"));
            Predicate<JSONObject> findReqPred = obj -> obj.optString("name").equals("request_-1_-1");
            List<JSONObject> reqObj = ActivitiesTestUtils.findInAllocations(ActivitiesTestUtils.getFirstSubNodeFromJson(schedulerActivitiesJson, "activities", "allocations"), findReqPred);
            Assert.assertEquals((long)1L, (long)reqObj.size());
            Assert.assertEquals((Object)ActivityState.REJECTED.name(), (Object)reqObj.get(0).optString("allocationState"));
            Assert.assertTrue((boolean)reqObj.get(0).optString("diagnostic").startsWith("Queue does not have enough headroom for inner highest-priority request"));
        }
        finally {
            this.rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testSchedulerBulkActivities() throws Exception {
        this.rm.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 4096, this.rm.getResourceTrackerService());
        MockNM nm2 = new MockNM("127.0.0.2:1234", 4096, this.rm.getResourceTrackerService());
        nm1.registerNode();
        nm2.registerNode();
        MockNM[] nms = new MockNM[]{nm1, nm2};
        try {
            int expectedCount = 5;
            RESTClient restClient = new RESTClient(5);
            restClient.start();
            this.sendHeartbeat(restClient, nms);
            JSONObject activitiesJson = restClient.getOutput().getJSONObject("bulkActivities");
            Object activities = activitiesJson.get("activities");
            Assert.assertEquals((String)"Number of activities is wrong", (long)expectedCount, (long)((JSONArray)activities).length());
            expectedCount = 1000;
            restClient = new RESTClient(expectedCount);
            restClient.start();
            this.sendHeartbeat(restClient, nms);
            activitiesJson = restClient.getOutput().getJSONObject("bulkActivities");
            activities = activitiesJson.get("activities");
            Assert.assertEquals((String)"Max Activities Limit does not work", (long)500L, (long)((JSONArray)activities).length());
        }
        finally {
            this.rm.stop();
        }
    }

    private void sendHeartbeat(RESTClient restClient, MockNM[] nms) throws Exception {
        GenericTestUtils.waitFor(() -> {
            try {
                for (MockNM nm : nms) {
                    nm.nodeHeartbeat(true);
                }
            }
            catch (Exception e) {
                return false;
            }
            return restClient.isDone();
        }, (long)10L, (long)20000L);
    }

    private CapacitySchedulerConfiguration createConfig(CapacitySchedulerConfiguration config) {
        config.set("yarn.scheduler.capacity.root.queues", "a, b, c");
        config.set("yarn.scheduler.capacity.root.a.queues", "a1, a2");
        config.set("yarn.scheduler.capacity.root.b.queues", "b1, b2, b3");
        config.set("yarn.scheduler.capacity.root.a.a1.queues", "a1a, a1b, a1c");
        config.set("yarn.scheduler.capacity.root.a.capacity", "10.5");
        config.set("yarn.scheduler.capacity.root.a.maximum-capacity", "50");
        config.set("yarn.scheduler.capacity.root.a.max-parallel-app", "42");
        config.set("yarn.scheduler.capacity.root.b.capacity", "79.5");
        config.set("yarn.scheduler.capacity.root.c.capacity", "10");
        config.set("yarn.scheduler.capacity.root.a.a1.capacity", "30");
        config.set("yarn.scheduler.capacity.root.a.a1.maximum-capacity", "50");
        config.set("yarn.scheduler.capacity.root.a.a1.user-limit-factor", "100");
        config.set("yarn.scheduler.capacity.root.a.a2.capacity", "70");
        config.set("yarn.scheduler.capacity.root.a.a2.maximum-application-lifetime", "100");
        config.set("yarn.scheduler.capacity.root.a.a2.default-application-lifetime", "50");
        config.set("yarn.scheduler.capacity.root.a.a2.user-limit-factor", "100");
        config.set("yarn.scheduler.capacity.root.b.b1.capacity", "60");
        config.set("yarn.scheduler.capacity.root.b.b2.capacity", "39.5");
        config.set("yarn.scheduler.capacity.root.b.b3.capacity", "0.5");
        config.set("yarn.scheduler.capacity.root.b.b1.user-limit-factor", "100");
        config.set("yarn.scheduler.capacity.root.b.b2.user-limit-factor", "100");
        config.set("yarn.scheduler.capacity.root.b.b3.user-limit-factor", "100");
        config.set("yarn.scheduler.capacity.root.a.a1.a1a.capacity", "65");
        config.set("yarn.scheduler.capacity.root.a.a1.a1b.capacity", "15");
        config.set("yarn.scheduler.capacity.root.a.a1.a1c.capacity", "20");
        config.set("yarn.scheduler.capacity.root.a.a1.a1c.auto-create-child-queue.enabled", "true");
        config.set("yarn.scheduler.capacity.root.a.a1.a1c.leaf-queue-template.capacity", "50");
        return config;
    }

    private class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            CapacitySchedulerConfiguration config = TestRMWebServicesSchedulerActivities.this.createConfig(new CapacitySchedulerConfiguration(new Configuration(false)));
            TestRMWebServicesSchedulerActivities.this.rm = TestRMWebServicesSchedulerActivities.createMockRM(config);
            ((InstanceBinding)this.bind((Object)TestRMWebServicesSchedulerActivities.this.rm).to(ResourceManager.class)).named("rm");
            ((InstanceBinding)this.bind(config).to(Configuration.class)).named("conf");
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            this.bind(request).to(HttpServletRequest.class);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            this.bind(response).to(HttpServletResponse.class);
        }
    }

    private class RESTClient
    extends Thread {
        private int expectedCount;
        private boolean done = false;
        private JSONObject json;

        RESTClient(int expectedCount) {
            this.expectedCount = expectedCount;
        }

        boolean isDone() {
            return this.done;
        }

        JSONObject getOutput() {
            return this.json;
        }

        @Override
        public void run() {
            WebTarget r = TestRMWebServicesSchedulerActivities.this.targetWithJsonObject();
            Response response = (Response)r.path("ws").path("v1").path("cluster").path("/scheduler/bulk-activities").queryParam("activitiesCount", new Object[]{this.expectedCount}).request(new String[]{"application/json"}).get(Response.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
            this.json = (JSONObject)response.readEntity(JSONObject.class);
            this.done = true;
        }
    }
}

