/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileWriter;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestWebServiceUtil;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationDeleteRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationSubmissionRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationUpdateRequestInfo;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.UTCClock;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.assertj.core.api.Assertions;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.jettison.JettisonJaxbContext;
import org.glassfish.jersey.jettison.JettisonUnmarshaller;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class TestRMWebServicesReservation
extends JerseyTestBase {
    private String webserviceUserName = "testuser";
    private static boolean setAuthFilter = false;
    private static boolean enableRecurrence = false;
    private static MockRM rm;
    private static final int MINIMUM_RESOURCE_DURATION = 100000;
    private static final Clock clock;
    private static final int MAXIMUM_PERIOD = 86400000;
    private static final int DEFAULT_RECURRENCE = 8640000;
    private static final String TEST_DIR;
    private static final String FS_ALLOC_FILE;
    private static final String DEFAULT_QUEUE = "dedicated";
    private static final String LIST_RESERVATION_PATH = "reservation/list";
    private static final String GET_NEW_RESERVATION_PATH = "reservation/new-reservation";
    private static JettisonUnmarshaller reservationSubmissionRequestInfoReader;
    private ResourceConfig config;
    private HttpServletRequest hsRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
    private HttpServletResponse hsResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);

    protected Application configure() {
        this.config = new ResourceConfig();
        this.config.register(RMWebServices.class);
        this.config.register(GenericExceptionHandler.class);
        if (setAuthFilter) {
            this.config.register(TestRMCustomAuthFilter.class);
        }
        this.config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        this.forceSet("jersey.config.test.container.port", "0");
        return this.config;
    }

    private CapTestServletModule getNoAuthInjectorCap() {
        setAuthFilter = false;
        return new CapTestServletModule(false);
    }

    private CapTestServletModule getSimpleAuthInjectorCap() {
        setAuthFilter = true;
        return new CapTestServletModule(true);
    }

    private FairTestServletModule getNoAuthInjectorFair() {
        setAuthFilter = false;
        return new FairTestServletModule(false);
    }

    private FairTestServletModule getSimpleAuthInjectorFair() {
        setAuthFilter = true;
        return new FairTestServletModule(true);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> guiceConfigs() {
        return Arrays.asList({0, true}, {1, true}, {2, true}, {3, true}, {0, false}, {1, false}, {2, false}, {3, false});
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    public TestRMWebServicesReservation(int run, boolean recurrence) {
        enableRecurrence = recurrence;
        switch (run) {
            default: {
                this.config.register((Object)this.getNoAuthInjectorCap());
                break;
            }
            case 1: {
                this.config.register((Object)this.getSimpleAuthInjectorCap());
                break;
            }
            case 2: {
                this.config.register((Object)this.getNoAuthInjectorFair());
                break;
            }
            case 3: {
                this.config.register((Object)this.getSimpleAuthInjectorFair());
            }
        }
    }

    private boolean isAuthenticationEnabled() {
        return setAuthFilter;
    }

    private WebTarget constructWebResource(WebTarget target, String ... paths) {
        for (String path : paths) {
            target = target.path(path);
        }
        if (this.isAuthenticationEnabled()) {
            target = target.queryParam("user.name", new Object[]{this.webserviceUserName});
        }
        return target;
    }

    private WebTarget constructWebResource(String ... paths) {
        WebTarget target = this.targetWithJsonObject().path("ws").path("v1").path("cluster");
        return this.constructWebResource(target, paths);
    }

    @After
    public void tearDown() throws Exception {
        if (rm != null) {
            rm.stop();
        }
        super.tearDown();
    }

    @Test
    public void testSubmitReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        ReservationId rid = this.getReservationIdTestHelper(1);
        Response response = this.reservationSubmissionTestHelper("reservation/submit", "application/json", rid);
        if (this.isAuthenticationEnabled()) {
            Assert.assertTrue((boolean)this.isHttpSuccessResponse(response));
            this.verifyReservationCount(1);
        }
        rm.stop();
    }

    @Test
    public void testSubmitDuplicateReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        ReservationId rid = this.getReservationIdTestHelper(1);
        long currentTimestamp = clock.getTime() + 100000L;
        Response response = this.reservationSubmissionTestHelper("reservation/submit", "application/json", currentTimestamp, "", rid);
        if (this.isAuthenticationEnabled()) {
            Assert.assertTrue((boolean)this.isHttpSuccessResponse(response));
        }
        response = this.reservationSubmissionTestHelper("reservation/submit", "application/json", currentTimestamp, "", rid);
        if (this.isAuthenticationEnabled()) {
            Assert.assertTrue((boolean)this.isHttpSuccessResponse(response));
            this.verifyReservationCount(1);
        }
        rm.stop();
    }

    @Test
    public void testSubmitDifferentReservationWithSameId() throws Exception {
        rm.start();
        this.setupCluster(100);
        ReservationId rid = this.getReservationIdTestHelper(1);
        long currentTimestamp = clock.getTime() + 100000L;
        Response response = this.reservationSubmissionTestHelper("reservation/submit", "application/json", currentTimestamp, "res1", rid);
        if (this.isAuthenticationEnabled()) {
            Assert.assertTrue((boolean)this.isHttpSuccessResponse(response));
        }
        response = this.reservationSubmissionTestHelper("reservation/submit", "application/json", currentTimestamp + 100000L, "res1", rid);
        if (this.isAuthenticationEnabled()) {
            Assert.assertTrue((!this.isHttpSuccessResponse(response) ? 1 : 0) != 0);
            this.verifyReservationCount(1);
        }
        rm.stop();
    }

    @Test
    public void testFailedSubmitReservation() throws Exception {
        rm.start();
        this.setupCluster(1);
        ReservationId rid = this.getReservationIdTestHelper(1);
        Response response = this.reservationSubmissionTestHelper("reservation/submit", "application/json", rid);
        Assert.assertTrue((!this.isHttpSuccessResponse(response) ? 1 : 0) != 0);
        rm.stop();
    }

    @Test
    public void testUpdateReservation() throws JSONException, Exception {
        rm.start();
        this.setupCluster(100);
        ReservationId rid = this.getReservationIdTestHelper(1);
        Response response = this.reservationSubmissionTestHelper("reservation/submit", "application/json", rid);
        if (this.isAuthenticationEnabled()) {
            Assert.assertTrue((boolean)this.isHttpSuccessResponse(response));
        }
        this.updateReservationTestHelper("reservation/update", rid, "application/json");
        rm.stop();
    }

    @Test
    public void testTimeIntervalRequestListReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        long time = clock.getTime() + 100000L;
        ReservationId id1 = this.getReservationIdTestHelper(1);
        ReservationId id2 = this.getReservationIdTestHelper(2);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time, "res_1", id1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time + 100000L, "res_2", id2);
        WebTarget target = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("start-time", new Object[]{Long.toString((long)((double)time * 0.9))}).queryParam("end-time", new Object[]{Long.toString(time + 90000L)}).queryParam("include-resource-allocations", new Object[]{"true"}).queryParam("queue", new Object[]{DEFAULT_QUEUE});
        JSONObject json = this.testListReservationHelper(target);
        if (!this.isAuthenticationEnabled() && json == null) {
            return;
        }
        JSONObject reservations = json.getJSONObject("reservationListInfo").getJSONObject("reservations");
        this.testRDLHelper(reservations);
        String reservationName = reservations.getJSONObject("reservation-definition").getString("reservation-name");
        Assert.assertEquals((Object)reservationName, (Object)"res_1");
        rm.stop();
    }

    @Test
    public void testSameTimeIntervalRequestListReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        long time = clock.getTime() + 100000L;
        ReservationId id1 = this.getReservationIdTestHelper(1);
        ReservationId id2 = this.getReservationIdTestHelper(2);
        if (!this.isAuthenticationEnabled() && id1 == null && id2 == null) {
            return;
        }
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time, "res_1", id1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time + 100000L, "res_2", id2);
        String timeParam = Long.toString(time + 50000L);
        WebTarget target = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("start-time", new Object[]{timeParam}).queryParam("end-time", new Object[]{timeParam}).queryParam("include-resource-allocations", new Object[]{"true"}).queryParam("queue", new Object[]{DEFAULT_QUEUE});
        JSONObject json = this.testListReservationHelper(target);
        if (!this.isAuthenticationEnabled() && json == null) {
            return;
        }
        JSONObject reservations = json.getJSONObject("reservationListInfo").getJSONObject("reservations");
        this.testRDLHelper(reservations);
        String reservationName = reservations.getJSONObject("reservation-definition").getString("reservation-name");
        Assert.assertEquals((Object)reservationName, (Object)"res_1");
        rm.stop();
    }

    @Test
    public void testInvalidTimeIntervalRequestListReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        long time = clock.getTime() + 100000L;
        ReservationId id1 = this.getReservationIdTestHelper(1);
        ReservationId id2 = this.getReservationIdTestHelper(2);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time, "res_1", id1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time + 100000L, "res_2", id2);
        WebTarget target = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("start-time", new Object[]{"-100"}).queryParam("end-time", new Object[]{"-100"}).queryParam("include-resource-allocations", new Object[]{"true"}).queryParam("queue", new Object[]{DEFAULT_QUEUE});
        JSONObject json = this.testListReservationHelper(target);
        if (!this.isAuthenticationEnabled() && json == null) {
            return;
        }
        JSONArray reservations = json.getJSONObject("reservationListInfo").getJSONArray("reservations");
        Assert.assertEquals((long)2L, (long)reservations.length());
        this.testRDLHelper(reservations.getJSONObject(0));
        this.testRDLHelper(reservations.getJSONObject(1));
        rm.stop();
    }

    @Test
    public void testInvalidEndTimeRequestListReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        long time = clock.getTime() + 100000L;
        ReservationId id1 = this.getReservationIdTestHelper(1);
        ReservationId id2 = this.getReservationIdTestHelper(2);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time, "res_1", id1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time + 100000L, "res_2", id2);
        WebTarget target = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("start-time", new Object[]{Long.toString((long)((double)time + 130000.0))}).queryParam("end-time", new Object[]{"-1"}).queryParam("include-resource-allocations", new Object[]{"true"}).queryParam("queue", new Object[]{DEFAULT_QUEUE});
        JSONObject json = this.testListReservationHelper(target);
        if (!this.isAuthenticationEnabled() && json == null) {
            return;
        }
        if (!enableRecurrence) {
            JSONObject reservations = json.getJSONObject("reservationListInfo").getJSONObject("reservations");
            this.testRDLHelper(reservations);
            String reservationName = reservations.getJSONObject("reservation-definition").getString("reservation-name");
            Assert.assertEquals((Object)"res_2", (Object)reservationName);
        } else {
            JSONArray reservations = json.getJSONObject("reservationListInfo").getJSONArray("reservations");
            Assert.assertEquals((long)2L, (long)reservations.length());
        }
        rm.stop();
    }

    @Test
    public void testEmptyEndTimeRequestListReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        long time = clock.getTime() + 100000L;
        ReservationId id1 = this.getReservationIdTestHelper(1);
        ReservationId id2 = this.getReservationIdTestHelper(2);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time, "res_1", id1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time + 100000L, "res_2", id2);
        WebTarget target = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("start-time", new Object[]{new Long((long)((double)time + 130000.0)).toString()}).queryParam("include-resource-allocations", new Object[]{"true"}).queryParam("queue", new Object[]{DEFAULT_QUEUE});
        JSONObject json = this.testListReservationHelper(target);
        if (!this.isAuthenticationEnabled() && json == null) {
            return;
        }
        if (!enableRecurrence) {
            JSONObject reservations = json.getJSONObject("reservationListInfo").getJSONObject("reservations");
            this.testRDLHelper(reservations);
            String reservationName = reservations.getJSONObject("reservation-definition").getString("reservation-name");
            Assert.assertEquals((Object)"res_2", (Object)reservationName);
        } else {
            JSONArray reservations = json.getJSONObject("reservationListInfo").getJSONArray("reservations");
            Assert.assertEquals((long)2L, (long)reservations.length());
        }
        rm.stop();
    }

    @Test
    public void testInvalidStartTimeRequestListReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        long time = clock.getTime() + 100000L;
        ReservationId id1 = this.getReservationIdTestHelper(1);
        ReservationId id2 = this.getReservationIdTestHelper(2);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time, "res_1", id1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time + 100000L, "res_2", id2);
        WebTarget target = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("start-time", new Object[]{"-1"}).queryParam("end-time", new Object[]{new Long((long)((double)time + 90000.0)).toString()}).queryParam("include-resource-allocations", new Object[]{"true"}).queryParam("queue", new Object[]{DEFAULT_QUEUE});
        JSONObject json = this.testListReservationHelper(target);
        if (!this.isAuthenticationEnabled() && json == null) {
            return;
        }
        JSONObject reservations = json.getJSONObject("reservationListInfo").getJSONObject("reservations");
        this.testRDLHelper(reservations);
        String reservationName = reservations.getJSONObject("reservation-definition").getString("reservation-name");
        Assert.assertEquals((Object)reservationName, (Object)"res_1");
        rm.stop();
    }

    @Test
    public void testEmptyStartTimeRequestListReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        ReservationId id1 = this.getReservationIdTestHelper(1);
        ReservationId id2 = this.getReservationIdTestHelper(2);
        long time = clock.getTime() + 100000L;
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time, "res_1", id1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", time + 100000L, "res_2", id2);
        WebTarget target = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("end-time", new Object[]{new Long((long)((double)time + 90000.0)).toString()}).queryParam("include-resource-allocations", new Object[]{"true"}).queryParam("queue", new Object[]{DEFAULT_QUEUE});
        JSONObject json = this.testListReservationHelper(target);
        if (!this.isAuthenticationEnabled() && json == null) {
            return;
        }
        JSONObject reservations = json.getJSONObject("reservationListInfo").getJSONObject("reservations");
        this.testRDLHelper(reservations);
        String reservationName = reservations.getJSONObject("reservation-definition").getString("reservation-name");
        Assert.assertEquals((Object)reservationName, (Object)"res_1");
        rm.stop();
    }

    @Test
    public void testQueueOnlyRequestListReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        ReservationId id1 = this.getReservationIdTestHelper(1);
        ReservationId id2 = this.getReservationIdTestHelper(2);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", clock.getTime(), "res_1", id1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", clock.getTime(), "res_2", id2);
        WebTarget target = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("queue", new Object[]{DEFAULT_QUEUE});
        JSONObject json = this.testListReservationHelper(target);
        if (!this.isAuthenticationEnabled() && json == null) {
            return;
        }
        Assertions.assertThat((int)json.getJSONObject("reservationListInfo").getJSONArray("reservations").length()).isEqualTo(2);
        this.testRDLHelper(json.getJSONObject("reservationListInfo").getJSONArray("reservations").getJSONObject(0));
        this.testRDLHelper(json.getJSONObject("reservationListInfo").getJSONArray("reservations").getJSONObject(1));
        rm.stop();
    }

    @Test
    public void testEmptyQueueRequestListReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        ReservationId id1 = this.getReservationIdTestHelper(1);
        ReservationId id2 = this.getReservationIdTestHelper(2);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", clock.getTime(), "res_1", id1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", clock.getTime(), "res_2", id2);
        WebTarget target = this.constructWebResource(LIST_RESERVATION_PATH);
        this.testListReservationHelper(target, Response.Status.BAD_REQUEST);
        rm.stop();
    }

    @Test
    public void testNonExistentQueueRequestListReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        ReservationId id1 = this.getReservationIdTestHelper(1);
        ReservationId id2 = this.getReservationIdTestHelper(2);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", clock.getTime(), "res_1", id1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", clock.getTime(), "res_2", id2);
        WebTarget target = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("queue", new Object[]{"dedicated_invalid"});
        this.testListReservationHelper(target, Response.Status.BAD_REQUEST);
        rm.stop();
    }

    @Test
    public void testReservationIdRequestListReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        ReservationId id1 = this.getReservationIdTestHelper(1);
        ReservationId id2 = this.getReservationIdTestHelper(2);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", clock.getTime(), "res_1", id1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", clock.getTime(), "res_1", id1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", clock.getTime(), "res_2", id2);
        WebTarget target = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("include-resource-allocations", new Object[]{"true"}).queryParam("queue", new Object[]{DEFAULT_QUEUE});
        if (id1 != null) {
            target = target.queryParam("reservation-id", new Object[]{id1.toString()});
        }
        JSONObject json = this.testListReservationHelper(target);
        if (!this.isAuthenticationEnabled() && json == null) {
            return;
        }
        JSONObject reservations = json.getJSONObject("reservationListInfo").getJSONObject("reservations");
        this.testRDLHelper(reservations);
        String reservationId = reservations.getString("reservation-id");
        Assert.assertEquals((Object)id1.toString(), (Object)reservationId);
        rm.stop();
    }

    @Test
    public void testInvalidReservationIdRequestListReservation() throws Exception {
        rm.start();
        this.setupCluster(100);
        ReservationId id1 = this.getReservationIdTestHelper(1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", clock.getTime(), "res_1", id1);
        WebTarget target = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("queue", new Object[]{DEFAULT_QUEUE});
        if (id1 != null) {
            target = target.queryParam("reservation-id", new Object[]{"invalid" + id1.toString()});
        }
        JSONObject response = this.testListReservationHelper(target, Response.Status.NOT_FOUND);
        rm.stop();
    }

    @Test
    public void testIncludeResourceAllocations() throws Exception {
        rm.start();
        this.setupCluster(100);
        ReservationId id1 = this.getReservationIdTestHelper(1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", clock.getTime(), "res_1", id1);
        WebTarget target = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("include-resource-allocations", new Object[]{"true"}).queryParam("queue", new Object[]{DEFAULT_QUEUE});
        if (id1 != null) {
            target = target.queryParam("reservation-id", new Object[]{id1.toString()});
        }
        JSONObject json = this.testListReservationHelper(target);
        if (!this.isAuthenticationEnabled() && json == null) {
            return;
        }
        JSONObject reservations = json.getJSONObject("reservationListInfo").getJSONObject("reservations");
        this.testRDLHelper(reservations);
        String reservationId = reservations.getString("reservation-id");
        Assert.assertEquals((Object)id1.toString(), (Object)reservationId);
        Assert.assertTrue((boolean)reservations.has("resource-allocations"));
        rm.stop();
    }

    @Test
    public void testExcludeResourceAllocations() throws Exception {
        rm.start();
        this.setupCluster(100);
        ReservationId id1 = this.getReservationIdTestHelper(1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", clock.getTime(), "res_1", id1);
        WebTarget target = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("include-resource-allocations", new Object[]{"false"}).queryParam("queue", new Object[]{DEFAULT_QUEUE});
        if (id1 != null) {
            target = target.queryParam("reservation-id", new Object[]{id1.toString()});
        }
        JSONObject json = this.testListReservationHelper(target);
        if (!this.isAuthenticationEnabled() && json == null) {
            return;
        }
        JSONObject reservations = json.getJSONObject("reservationListInfo").getJSONObject("reservations");
        this.testRDLHelper(reservations);
        String reservationId = reservations.getString("reservation-id");
        Assert.assertEquals((Object)id1.toString(), (Object)reservationId);
        Assert.assertTrue((!reservations.has("resource-allocations") ? 1 : 0) != 0);
        rm.stop();
    }

    @Test
    public void testDeleteReservation() throws JSONException, Exception {
        rm.start();
        for (int i = 0; i < 100; ++i) {
            MockNM amNodeManager = rm.registerNode("127.0.0." + i + ":1234", 102400);
            amNodeManager.nodeHeartbeat(true);
        }
        ReservationId rid = this.getReservationIdTestHelper(1);
        this.reservationSubmissionTestHelper("reservation/submit", "application/json", rid);
        this.testDeleteReservationHelper("reservation/delete", rid, "application/json");
        rm.stop();
    }

    private ReservationId getReservationIdTestHelper(int fallbackReservationId) throws Exception {
        Thread.sleep(1000L);
        if (this.isAuthenticationEnabled()) {
            Principal principal1 = () -> this.webserviceUserName;
            Mockito.when((Object)this.hsRequest.getUserPrincipal()).thenReturn((Object)principal1);
        }
        Response response = (Response)this.constructWebResource(GET_NEW_RESERVATION_PATH).request(new String[]{"application/json"}).accept(new String[]{"application/json"}).post(null, Response.class);
        if (!this.isAuthenticationEnabled()) {
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.UNAUTHORIZED, (Response.StatusType)response.getStatusInfo());
            return ReservationId.newInstance((long)clock.getTime(), (long)fallbackReservationId);
        }
        System.out.println("RESPONSE:" + response);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        JSONObject json = ((JSONObject)response.readEntity(JSONObject.class)).getJSONObject("new-reservation");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        ReservationId rid = null;
        try {
            rid = ReservationId.parseReservationId((String)json.getString("reservation-id"));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return rid;
    }

    private Response reservationSubmissionTestHelper(String path, String media, ReservationId reservationId) throws Exception {
        long arrival = clock.getTime() + 100000L;
        return this.reservationSubmissionTestHelper(path, media, arrival, "res_1", reservationId);
    }

    private Response reservationSubmissionTestHelper(String path, String media, Long arrival, String reservationName, ReservationId reservationId) throws Exception {
        String reservationJson = this.loadJsonFile("submit-reservation.json");
        String recurrenceExpression = "";
        if (enableRecurrence) {
            recurrenceExpression = String.format("\"recurrence-expression\" : \"%s\",", 8640000);
        }
        String reservationJsonRequest = String.format(reservationJson, reservationId.toString(), arrival, arrival + 100000L, reservationName, recurrenceExpression);
        return this.submitAndVerifyReservation(path, media, reservationJsonRequest);
    }

    private Response submitAndVerifyReservation(String path, String media, String reservationJson) throws Exception {
        ReservationSubmissionRequestInfo rsci = (ReservationSubmissionRequestInfo)reservationSubmissionRequestInfoReader.unmarshalFromJSON((Reader)new StringReader(reservationJson), ReservationSubmissionRequestInfo.class);
        Thread.sleep(1000L);
        Response response = (Response)this.constructWebResource(path).request(new String[]{"application/json"}).accept(new String[]{media}).post(Entity.entity((Object)TestWebServiceUtil.toJson(rsci, ReservationSubmissionRequestInfo.class), (MediaType)MediaType.APPLICATION_JSON_TYPE), Response.class);
        if (!this.isAuthenticationEnabled()) {
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.UNAUTHORIZED, (Response.StatusType)response.getStatusInfo());
        }
        return response;
    }

    private void updateReservationTestHelper(String path, ReservationId reservationId, String media) throws Exception {
        JettisonUnmarshaller reservationUpdateRequestInfoReader;
        String reservationJson = this.loadJsonFile("update-reservation.json");
        try {
            JettisonJaxbContext jettisonJaxbContext = new JettisonJaxbContext(new Class[]{ReservationUpdateRequestInfo.class});
            reservationUpdateRequestInfoReader = jettisonJaxbContext.createJsonUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        ReservationUpdateRequestInfo rsci = (ReservationUpdateRequestInfo)reservationUpdateRequestInfoReader.unmarshalFromJSON((Reader)new StringReader(reservationJson), ReservationUpdateRequestInfo.class);
        if (this.isAuthenticationEnabled()) {
            if (rsci.getReservationId() == null) {
                throw new IOException("Incorrectly parsed the reservationId");
            }
            rsci.setReservationId(reservationId.toString());
        }
        Thread.sleep(1000L);
        Response response = (Response)this.constructWebResource(path).request(new String[]{"application/json"}).accept(new String[]{media}).post(Entity.entity((Object)TestWebServiceUtil.toJson(rsci, ReservationUpdateRequestInfo.class), (MediaType)MediaType.APPLICATION_JSON_TYPE), Response.class);
        if (!this.isAuthenticationEnabled()) {
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.UNAUTHORIZED, (Response.StatusType)response.getStatusInfo());
            return;
        }
        System.out.println("RESPONSE:" + response);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
    }

    private String loadJsonFile(String filename) throws IOException {
        ClassLoader cL = Thread.currentThread().getContextClassLoader();
        if (cL == null) {
            cL = Configuration.class.getClassLoader();
        }
        URL submitURI = cL.getResource(filename);
        String reservationJson = FileUtils.readFileToString((File)new File(submitURI.getFile()));
        return reservationJson;
    }

    private void testDeleteReservationHelper(String path, ReservationId reservationId, String media) throws JSONException, Exception {
        JettisonUnmarshaller reader;
        String reservationJson = this.loadJsonFile("delete-reservation.json");
        try {
            JettisonJaxbContext jettisonJaxbContext = new JettisonJaxbContext(new Class[]{ReservationDeleteRequestInfo.class});
            reader = jettisonJaxbContext.createJsonUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        ReservationDeleteRequestInfo rsci = (ReservationDeleteRequestInfo)reader.unmarshalFromJSON((Reader)new StringReader(reservationJson), ReservationDeleteRequestInfo.class);
        if (this.isAuthenticationEnabled()) {
            if (rsci.getReservationId() == null) {
                throw new IOException("Incorrectly parsed the reservationId");
            }
            rsci.setReservationId(reservationId.toString());
        }
        Thread.sleep(1000L);
        Response response = (Response)this.constructWebResource(path).request(new String[]{"application/json"}).accept(new String[]{media}).post(Entity.entity((Object)TestWebServiceUtil.toJson(rsci, ReservationDeleteRequestInfo.class), (MediaType)MediaType.APPLICATION_JSON_TYPE), Response.class);
        if (!this.isAuthenticationEnabled()) {
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.UNAUTHORIZED, (Response.StatusType)response.getStatusInfo());
            return;
        }
        System.out.println("RESPONSE:" + response);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
    }

    private void testRDLHelper(JSONObject json) throws JSONException {
        JSONObject requests = json.getJSONObject("reservation-definition").getJSONObject("reservation-requests");
        String type = requests.getString("reservation-request-interpreter");
        Assert.assertEquals((Object)"0", (Object)type);
        Assert.assertEquals((long)60L, (long)requests.getJSONArray("reservation-request").getJSONObject(0).getInt("duration"));
    }

    private JSONObject testListReservationHelper(WebTarget target) throws Exception {
        return this.testListReservationHelper(target, Response.Status.OK);
    }

    private JSONObject testListReservationHelper(WebTarget target, Response.Status status) throws Exception {
        Thread.sleep(1000L);
        Response response = (Response)target.request().get(Response.class);
        if (!this.isAuthenticationEnabled()) {
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.UNAUTHORIZED, (Response.StatusType)response.getStatusInfo());
            return null;
        }
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)status, (Response.StatusType)response.getStatusInfo());
        return (JSONObject)response.readEntity(JSONObject.class);
    }

    private void verifyReservationCount(int count) throws Exception {
        WebTarget target = this.constructWebResource(LIST_RESERVATION_PATH).queryParam("queue", new Object[]{DEFAULT_QUEUE});
        JSONObject json = this.testListReservationHelper(target);
        if (count == 1) {
            json.getJSONObject("reservationListInfo").getJSONObject("reservations");
        } else {
            JSONArray reservations = json.getJSONArray("reservations");
            Assert.assertTrue((reservations.length() == count ? 1 : 0) != 0);
        }
    }

    private boolean isHttpSuccessResponse(Response response) {
        return response.getStatusInfo().getStatusCode() / 100 == 2;
    }

    private void setupCluster(int nodes) throws Exception {
        for (int i = 0; i < nodes; ++i) {
            MockNM amNodeManager = rm.registerNode("127.0.0." + i + ":1234", 102400);
            amNodeManager.nodeHeartbeat(true);
        }
    }

    static {
        clock = new UTCClock();
        TEST_DIR = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
        FS_ALLOC_FILE = new File(TEST_DIR, "test-fs-queues.xml").getAbsolutePath();
        try {
            JettisonJaxbContext jettisonJaxbContext = new JettisonJaxbContext(new Class[]{ReservationSubmissionRequestInfo.class});
            reservationSubmissionRequestInfoReader = jettisonJaxbContext.createJsonUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static class TestRMCustomAuthFilter
    extends AuthenticationFilter {
        protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
            Properties props = new Properties();
            Enumeration names = filterConfig.getInitParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!name.startsWith(configPrefix)) continue;
                String value = filterConfig.getInitParameter(name);
                props.put(name.substring(configPrefix.length()), value);
            }
            props.put("type", "simple");
            props.put("simple.anonymous.allowed", "false");
            return props;
        }
    }

    private class CapTestServletModule
    extends JerseyBinder {
        CapTestServletModule(boolean flag) {
            if (flag) {
                this.getConf().setBoolean("yarn.acl.enable", true);
                this.getConf().setStrings("yarn.admin.acl", new String[]{"testuser1"});
            }
        }

        @Override
        public void configureScheduler() {
            this.getConf().set("yarn.resourcemanager.scheduler.class", CapacityScheduler.class.getName());
            this.getConf().setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
            CapacitySchedulerConfiguration csconf = new CapacitySchedulerConfiguration(this.getConf());
            String[] queues = new String[]{"default", TestRMWebServicesReservation.DEFAULT_QUEUE};
            QueuePath dedicatedQueuePath = new QueuePath("root.dedicated");
            csconf.setQueues(new QueuePath("root"), queues);
            csconf.setCapacity(new QueuePath("root.default"), 50.0f);
            csconf.setCapacity(dedicatedQueuePath, 50.0f);
            csconf.setReservable(dedicatedQueuePath, true);
            this.setConf((Configuration)csconf);
        }
    }

    private class FairTestServletModule
    extends JerseyBinder {
        FairTestServletModule(boolean flag) {
            if (flag) {
                this.getConf().setBoolean("yarn.acl.enable", true);
                this.getConf().setStrings("yarn.admin.acl", new String[]{"testuser1"});
            }
        }

        @Override
        public void configureScheduler() {
            AllocationFileWriter.create().drfDefaultQueueSchedulingPolicy().addQueue(new AllocationFileQueue.Builder("root").aclAdministerApps("someuser ").subQueue(new AllocationFileQueue.Builder("default").aclAdministerApps("someuser ").build()).subQueue(new AllocationFileQueue.Builder(TestRMWebServicesReservation.DEFAULT_QUEUE).reservation().aclAdministerApps("someuser ").build()).build()).writeToFile(FS_ALLOC_FILE);
            this.getConf().set("yarn.scheduler.fair.allocation.file", FS_ALLOC_FILE);
            this.getConf().set("yarn.resourcemanager.scheduler.class", FairScheduler.class.getName());
        }
    }

    private class JerseyBinder
    extends AbstractBinder {
        private Configuration conf = new YarnConfiguration();

        private JerseyBinder() {
        }

        protected void configure() {
            this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
            this.conf.setBoolean("yarn.resourcemanager.reservation-system.enable", true);
            this.configureScheduler();
            rm = new MockRM(this.conf);
            ((InstanceBinding)this.bind((Object)rm).to(ResourceManager.class)).named("rm");
            ((InstanceBinding)this.bind(this.conf).to(Configuration.class)).named("conf");
            this.bind(TestRMWebServicesReservation.this.hsRequest).to(HttpServletRequest.class);
            this.bind(TestRMWebServicesReservation.this.hsResponse).to(HttpServletResponse.class);
        }

        public void configureScheduler() {
        }

        public Configuration getConf() {
            return this.conf;
        }

        public void setConf(Configuration conf) {
            this.conf = conf;
        }
    }
}

