/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.util.XMLUtils;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.ActivitiesTestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestWebServiceUtil;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@RunWith(value=Parameterized.class)
public class TestRMWebServicesForCSWithPartitions
extends JerseyTestBase {
    private static final String DEFAULT_PARTITION = "";
    private static final String CAPACITIES = "capacities";
    private static final String RESOURCE_USAGES_BY_PARTITION = "resourceUsagesByPartition";
    private static final String QUEUE_CAPACITIES_BY_PARTITION = "queueCapacitiesByPartition";
    private static final String QUEUE_C = "Qc";
    private static final String LEAF_QUEUE_C1 = "Qc1";
    private static final String LEAF_QUEUE_C2 = "Qc2";
    private static final String QUEUE_B = "Qb";
    private static final String QUEUE_A = "Qa";
    private static final String LABEL_LY = "Ly";
    private static final String LABEL_LX = "Lx";
    private static final QueuePath ROOT_QUEUE_PATH = new QueuePath("root");
    private static final ImmutableSet<String> CLUSTER_LABELS = ImmutableSet.of((Object)"Lx", (Object)"Ly", (Object)"");
    private static final String DOT = ".";
    private static final double EPSILON = (double)0.1f;
    private MockRM rm;
    private CapacitySchedulerConfiguration csConf;
    private YarnConfiguration conf;
    private final boolean legacyQueueMode;
    private MockNM nm1;

    @Parameterized.Parameters(name="{index}: legacy-queue-mode={0}")
    public static Collection<Boolean> getParameters() {
        return Arrays.asList(true, false);
    }

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register(RMWebServices.class);
        config.register((Object)new JerseyBinder());
        config.register(GenericExceptionHandler.class);
        config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        this.forceSet("jersey.config.test.container.port", "0");
        return config;
    }

    private void setupQueueConfiguration(CapacitySchedulerConfiguration config) {
        config.setLegacyQueueModeEnabled(this.legacyQueueMode);
        config.setQueues(ROOT_QUEUE_PATH, new String[]{QUEUE_A, QUEUE_B, QUEUE_C});
        String interMediateQueueC = "root.Qc";
        QueuePath interMediateQueueCPath = new QueuePath(interMediateQueueC);
        config.setQueues(interMediateQueueCPath, new String[]{LEAF_QUEUE_C1, LEAF_QUEUE_C2});
        config.setCapacityByLabel(ROOT_QUEUE_PATH, LABEL_LX, 100.0f);
        config.setCapacityByLabel(ROOT_QUEUE_PATH, LABEL_LY, 100.0f);
        String leafQueueA = "root.Qa";
        QueuePath leafQueueAPath = new QueuePath(leafQueueA);
        config.setCapacity(leafQueueAPath, 30.0f);
        config.setMaximumCapacity(leafQueueAPath, 50.0f);
        String leafQueueB = "root.Qb";
        QueuePath leafQueueBPath = new QueuePath(leafQueueB);
        config.setCapacity(leafQueueBPath, 30.0f);
        config.setMaximumCapacity(leafQueueBPath, 50.0f);
        config.setCapacity(interMediateQueueCPath, 40.0f);
        config.setMaximumCapacity(interMediateQueueCPath, 50.0f);
        String leafQueueC1 = interMediateQueueC + ".Qc1";
        QueuePath leafQueueC1Path = new QueuePath(leafQueueC1);
        config.setCapacity(leafQueueC1Path, 50.0f);
        config.setMaximumCapacity(leafQueueC1Path, 60.0f);
        String leafQueueC2 = interMediateQueueC + ".Qc2";
        QueuePath leafQueueC2Path = new QueuePath(leafQueueC2);
        config.setCapacity(leafQueueC2Path, 50.0f);
        config.setMaximumCapacity(leafQueueC2Path, 70.0f);
        config.setAccessibleNodeLabels(leafQueueAPath, (Set)ImmutableSet.of((Object)DEFAULT_PARTITION));
        config.setAccessibleNodeLabels(leafQueueBPath, (Set)ImmutableSet.of((Object)LABEL_LX));
        config.setAccessibleNodeLabels(interMediateQueueCPath, (Set)ImmutableSet.of((Object)LABEL_LX, (Object)LABEL_LY));
        config.setAccessibleNodeLabels(leafQueueC1Path, (Set)ImmutableSet.of((Object)LABEL_LX, (Object)LABEL_LY));
        config.setAccessibleNodeLabels(leafQueueC2Path, (Set)ImmutableSet.of((Object)LABEL_LX, (Object)LABEL_LY));
        config.setDefaultNodeLabelExpression(leafQueueBPath, LABEL_LX);
        config.setDefaultNodeLabelExpression(leafQueueC1Path, LABEL_LX);
        config.setDefaultNodeLabelExpression(leafQueueC2Path, LABEL_LY);
        config.setCapacityByLabel(leafQueueBPath, LABEL_LX, 30.0f);
        config.setCapacityByLabel(interMediateQueueCPath, LABEL_LX, 70.0f);
        config.setCapacityByLabel(leafQueueC1Path, LABEL_LX, 40.0f);
        config.setCapacityByLabel(leafQueueC2Path, LABEL_LX, 60.0f);
        config.setCapacityByLabel(interMediateQueueCPath, LABEL_LY, 100.0f);
        config.setCapacityByLabel(leafQueueC1Path, LABEL_LY, 50.0f);
        config.setCapacityByLabel(leafQueueC2Path, LABEL_LY, 50.0f);
        config.setMaximumCapacityByLabel(leafQueueC1Path, LABEL_LY, 75.0f);
        config.setMaximumCapacityByLabel(leafQueueC2Path, LABEL_LY, 75.0f);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @After
    public void tearDown() {
        if (this.rm != null) {
            this.rm.stop();
        }
    }

    public TestRMWebServicesForCSWithPartitions(boolean legacyQueueMode) {
        this.legacyQueueMode = legacyQueueMode;
    }

    @Test
    public void testSchedulerPartitions() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler").request(new String[]{"application/json"}).get(Response.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        this.verifySchedulerInfoJson(json);
    }

    @Test
    public void testSchedulerPartitionsSlash() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler/").request(new String[]{"application/json"}).get(Response.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        this.verifySchedulerInfoJson(json);
    }

    @Test
    public void testSchedulerPartitionsDefault() throws JSONException, Exception {
        WebTarget r = this.targetWithJsonObject();
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler").request().get(Response.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        this.verifySchedulerInfoJson(json);
    }

    @Test
    public void testSchedulerPartitionsXML() throws JSONException, Exception {
        WebTarget r = this.target();
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler").request(new String[]{"application/xml"}).get(Response.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        String xml = (String)response.readEntity(String.class);
        DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        this.verifySchedulerInfoXML(dom);
    }

    @Test
    public void testPartitionInSchedulerActivities() throws Exception {
        RMApp app1 = MockRMAppSubmitter.submit(this.rm, MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.rm).withAppName("app1").withUser("user1").withAcls(null).withQueue(QUEUE_B).withAmLabel(LABEL_LX).build());
        MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, this.nm1);
        am1.allocate(Arrays.asList(ResourceRequest.newBuilder().priority(Priority.UNDEFINED).resourceName("*").nodeLabelExpression(LABEL_LX).capability(Resources.createResource((int)2048)).numContainers(1).build()), null);
        WebTarget sr = this.target().path("/ws/v1/cluster").path("/scheduler/activities");
        ActivitiesTestUtils.requestWebResource(sr, null);
        this.nm1.nodeHeartbeat(true);
        Thread.sleep(1000L);
        JSONObject schedulerActivitiesJson = ActivitiesTestUtils.requestWebResource(sr, null);
        ActivitiesTestUtils.verifyNumberOfAllocations(schedulerActivitiesJson, 1);
        Predicate<JSONObject> findQueueBPred = obj -> obj.optString("name").equals("root.Qb");
        List<JSONObject> queueBObj = ActivitiesTestUtils.findInAllocations(ActivitiesTestUtils.getFirstSubNodeFromJson(schedulerActivitiesJson, "activities", "allocations"), findQueueBPred);
        Assert.assertEquals((long)1L, (long)queueBObj.size());
        Assert.assertEquals((Object)ActivityState.REJECTED.name(), (Object)queueBObj.get(0).optString("allocationState"));
        Assert.assertEquals((Object)("Queue does not have enough headroom for inner highest-priority request from " + am1.getApplicationAttemptId().getApplicationId()), (Object)queueBObj.get(0).optString("diagnostic"));
        Predicate<JSONObject> findQueueAPred = obj -> obj.optString("name").equals("root.Qa");
        List<JSONObject> queueAObj = ActivitiesTestUtils.findInAllocations(ActivitiesTestUtils.getFirstSubNodeFromJson(schedulerActivitiesJson, "activities", "allocations"), findQueueAPred);
        Assert.assertEquals((long)1L, (long)queueAObj.size());
        Assert.assertEquals((Object)ActivityState.REJECTED.name(), (Object)queueAObj.get(0).optString("allocationState"));
        Assert.assertEquals((Object)"Queue is not able to access partition", (Object)queueAObj.get(0).optString("diagnostic"));
        Predicate<JSONObject> findQueueCPred = obj -> obj.optString("name").equals("root.Qc");
        List<JSONObject> queueCObj = ActivitiesTestUtils.findInAllocations(ActivitiesTestUtils.getFirstSubNodeFromJson(schedulerActivitiesJson, "activities", "allocations"), findQueueCPred);
        Assert.assertEquals((long)1L, (long)queueCObj.size());
        Assert.assertEquals((Object)ActivityState.SKIPPED.name(), (Object)queueCObj.get(0).optString("allocationState"));
        Assert.assertEquals((Object)"Queue does not need more resource", (Object)queueCObj.get(0).optString("diagnostic"));
    }

    private void verifySchedulerInfoXML(Document dom) throws Exception {
        NodeList scheduler = dom.getElementsByTagName("scheduler");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)scheduler.getLength());
        NodeList schedulerInfo = dom.getElementsByTagName("schedulerInfo");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)schedulerInfo.getLength());
        for (int i = 0; i < schedulerInfo.getLength(); ++i) {
            Element element = (Element)schedulerInfo.item(i);
            NodeList children = element.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                int k;
                Element schedulerInfoElem = (Element)children.item(j);
                if (schedulerInfoElem.getTagName().equals("queues")) {
                    NodeList qListInfos = schedulerInfoElem.getChildNodes();
                    block12: for (k = 0; k < qListInfos.getLength(); ++k) {
                        String queue;
                        Element qElem2 = (Element)qListInfos.item(k);
                        switch (queue = WebServicesTestUtils.getXmlString((Element)qElem2, (String)"queueName")) {
                            case "Qa": {
                                this.verifyQueueAInfoXML(qElem2);
                                continue block12;
                            }
                            case "Qb": {
                                this.verifyQueueBInfoXML(qElem2);
                                continue block12;
                            }
                            case "Qc": {
                                this.verifyQueueCInfoXML(qElem2);
                                continue block12;
                            }
                            default: {
                                Assert.fail((String)("Unexpected queue" + queue));
                            }
                        }
                    }
                    continue;
                }
                if (!schedulerInfoElem.getTagName().equals(CAPACITIES)) continue;
                NodeList capacitiesListInfos = schedulerInfoElem.getChildNodes();
                Assert.assertEquals((String)"incorrect number of partitions", (long)3L, (long)capacitiesListInfos.getLength());
                for (k = 0; k < capacitiesListInfos.getLength(); ++k) {
                    Element partitionCapacitiesInfo = (Element)capacitiesListInfos.item(k);
                    String partitionName = WebServicesTestUtils.getXmlString((Element)partitionCapacitiesInfo, (String)"partitionName");
                    Assert.assertTrue((String)"invalid PartitionCapacityInfo", (boolean)CLUSTER_LABELS.contains((Object)partitionName));
                    this.verifyPartitionCapacityInfoXML(partitionCapacitiesInfo, 100.0f, 0.0f, 100.0f, 100.0f, 0.0f, 100.0f);
                }
            }
        }
    }

    private void verifyQueueAInfoXML(Element queueElem) {
        NodeList children = queueElem.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Element queueChildElem = (Element)children.item(j);
            if (queueChildElem.getTagName().equals(CAPACITIES)) {
                NodeList capacitiesListInfos = queueChildElem.getChildNodes();
                Assert.assertEquals((String)"incorrect number of partitions", (long)1L, (long)capacitiesListInfos.getLength());
                Element partitionCapacitiesInfo = (Element)capacitiesListInfos.item(0);
                String partitionName = WebServicesTestUtils.getXmlString((Element)partitionCapacitiesInfo, (String)"partitionName");
                Assert.assertTrue((String)"invalid PartitionCapacityInfo", (boolean)partitionName.isEmpty());
                this.verifyPartitionCapacityInfoXML(partitionCapacitiesInfo, 30.0f, 0.0f, 50.0f, 30.0f, 0.0f, 50.0f);
                continue;
            }
            if (!queueChildElem.getTagName().equals("resources")) continue;
            this.verifyResourceUsageInfoXML(queueChildElem);
        }
    }

    private void verifyQueueBInfoXML(Element queueElem) {
        Assert.assertEquals((String)"Invalid default Label expression", (Object)LABEL_LX, (Object)WebServicesTestUtils.getXmlString((Element)queueElem, (String)"defaultNodeLabelExpression"));
        NodeList children = queueElem.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Element queueChildElem = (Element)children.item(j);
            if (!queueChildElem.getTagName().equals(CAPACITIES)) continue;
            NodeList capacitiesListInfos = queueChildElem.getChildNodes();
            Assert.assertEquals((String)"incorrect number of partitions", (long)2L, (long)capacitiesListInfos.getLength());
            block9: for (int k = 0; k < capacitiesListInfos.getLength(); ++k) {
                String partitionName;
                Element partitionCapacitiesInfo = (Element)capacitiesListInfos.item(k);
                switch (partitionName = WebServicesTestUtils.getXmlString((Element)partitionCapacitiesInfo, (String)"partitionName")) {
                    case "Lx": {
                        this.verifyPartitionCapacityInfoXML(partitionCapacitiesInfo, 30.0f, 0.0f, 100.0f, 30.0f, 0.0f, 100.0f);
                        continue block9;
                    }
                    case "": {
                        this.verifyPartitionCapacityInfoXML(partitionCapacitiesInfo, 30.0f, 0.0f, 50.0f, 30.0f, 0.0f, 50.0f);
                        continue block9;
                    }
                    default: {
                        Assert.fail((String)("Unexpected partition" + partitionName));
                    }
                }
            }
        }
        Assert.assertEquals((String)"Node Labels are not matching", (Object)LABEL_LX, (Object)WebServicesTestUtils.getXmlString((Element)queueElem, (String)"nodeLabels"));
    }

    private void verifyQueueCInfoXML(Element queueElem) {
        NodeList children = queueElem.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Element queueChildElem = (Element)children.item(j);
            if (queueChildElem.getTagName().equals(CAPACITIES)) {
                this.verifyQcCapacitiesInfoXML(queueChildElem, 70.0f, 100.0f, 70.0f, 100.0f, 100.0f, 100.0f, 100.0f, 100.0f, 40.0f, 50.0f, 40.0f, 50.0f);
                continue;
            }
            if (queueChildElem.getTagName().equals("resources")) {
                this.verifyResourceUsageInfoXML(queueChildElem);
                continue;
            }
            if (!queueChildElem.getTagName().equals("queues")) continue;
            NodeList qListInfos = queueChildElem.getChildNodes();
            block9: for (int k = 0; k < qListInfos.getLength(); ++k) {
                String queue;
                Element qElem2 = (Element)qListInfos.item(k);
                switch (queue = WebServicesTestUtils.getXmlString((Element)qElem2, (String)"queueName")) {
                    case "Qc1": {
                        Assert.assertEquals((String)"Invalid default Label expression", (Object)LABEL_LX, (Object)WebServicesTestUtils.getXmlString((Element)qElem2, (String)"defaultNodeLabelExpression"));
                        NodeList queuec1Children = qElem2.getChildNodes();
                        for (int l = 0; l < queuec1Children.getLength(); ++l) {
                            Element queueC1ChildElem = (Element)queuec1Children.item(l);
                            if (!queueC1ChildElem.getTagName().equals(CAPACITIES)) continue;
                            this.verifyQcCapacitiesInfoXML(queueC1ChildElem, 40.0f, 100.0f, 28.0f, 100.0f, 50.0f, 75.0f, 50.0f, 75.0f, 50.0f, 60.0f, 20.0f, 30.0f);
                        }
                        continue block9;
                    }
                    case "Qc2": {
                        Assert.assertEquals((String)"Invalid default Label expression", (Object)LABEL_LY, (Object)WebServicesTestUtils.getXmlString((Element)qElem2, (String)"defaultNodeLabelExpression"));
                        NodeList queuec2Children = qElem2.getChildNodes();
                        for (int l = 0; l < queuec2Children.getLength(); ++l) {
                            Element queueC2ChildElem = (Element)queuec2Children.item(l);
                            if (!queueC2ChildElem.getTagName().equals(CAPACITIES)) continue;
                            this.verifyQcCapacitiesInfoXML(queueC2ChildElem, 60.0f, 100.0f, 42.0f, 100.0f, 50.0f, 75.0f, 50.0f, 75.0f, 50.0f, 70.0f, 20.0f, 35.0f);
                        }
                        continue block9;
                    }
                    default: {
                        Assert.fail((String)("Unexpected queue" + queue));
                    }
                }
            }
        }
    }

    private void verifyQcCapacitiesInfoXML(Element partitionCapacitiesElem, float lxCaps, float lxMaxCaps, float lxAbsCaps, float lxAbsMaxCaps, float lyCaps, float lyMaxCaps, float lyAbsCaps, float lyAbsMaxCaps, float defCaps, float defMaxCaps, float defAbsCaps, float defAbsMaxCaps) {
        NodeList capacitiesListInfos = partitionCapacitiesElem.getChildNodes();
        Assert.assertEquals((String)"incorrect number of partitions", (long)3L, (long)capacitiesListInfos.getLength());
        block10: for (int k = 0; k < capacitiesListInfos.getLength(); ++k) {
            String partitionName;
            Element partitionCapacitiesInfo = (Element)capacitiesListInfos.item(k);
            switch (partitionName = WebServicesTestUtils.getXmlString((Element)partitionCapacitiesInfo, (String)"partitionName")) {
                case "Lx": {
                    this.verifyPartitionCapacityInfoXML(partitionCapacitiesInfo, lxCaps, 0.0f, lxMaxCaps, lxAbsCaps, 0.0f, lxAbsMaxCaps);
                    continue block10;
                }
                case "Ly": {
                    this.verifyPartitionCapacityInfoXML(partitionCapacitiesInfo, lyCaps, 0.0f, lyMaxCaps, lyAbsCaps, 0.0f, lyAbsMaxCaps);
                    continue block10;
                }
                case "": {
                    this.verifyPartitionCapacityInfoXML(partitionCapacitiesInfo, defCaps, 0.0f, defMaxCaps, defAbsCaps, 0.0f, defAbsMaxCaps);
                    continue block10;
                }
                default: {
                    Assert.fail((String)("Unexpected partition" + partitionName));
                }
            }
        }
    }

    private void verifyResourceUsageInfoXML(Element queueChildElem) {
        NodeList resourceUsageInfo = queueChildElem.getChildNodes();
        Assert.assertEquals((String)"incorrect number of partitions", (long)1L, (long)resourceUsageInfo.getLength());
        Element partitionResourceUsageInfo = (Element)resourceUsageInfo.item(0);
        String partitionName = WebServicesTestUtils.getXmlString((Element)partitionResourceUsageInfo, (String)"partitionName");
        Assert.assertTrue((String)"invalid PartitionCapacityInfo", (boolean)DEFAULT_PARTITION.equals(partitionName));
    }

    private void verifyPartitionCapacityInfoXML(Element partitionInfo, float capacity, float usedCapacity, float maxCapacity, float absoluteCapacity, float absoluteUsedCapacity, float absoluteMaxCapacity) {
        Assert.assertEquals((String)"capacity doesn't match", (double)capacity, (double)WebServicesTestUtils.getXmlFloat((Element)partitionInfo, (String)"capacity"), (double)0.1f);
        Assert.assertEquals((String)"capacity doesn't match", (double)usedCapacity, (double)WebServicesTestUtils.getXmlFloat((Element)partitionInfo, (String)"usedCapacity"), (double)0.1f);
        Assert.assertEquals((String)"capacity doesn't match", (double)maxCapacity, (double)WebServicesTestUtils.getXmlFloat((Element)partitionInfo, (String)"maxCapacity"), (double)0.1f);
        Assert.assertEquals((String)"capacity doesn't match", (double)absoluteCapacity, (double)WebServicesTestUtils.getXmlFloat((Element)partitionInfo, (String)"absoluteCapacity"), (double)0.1f);
        Assert.assertEquals((String)"capacity doesn't match", (double)absoluteUsedCapacity, (double)WebServicesTestUtils.getXmlFloat((Element)partitionInfo, (String)"absoluteUsedCapacity"), (double)0.1f);
        Assert.assertEquals((String)"capacity doesn't match", (double)absoluteMaxCapacity, (double)WebServicesTestUtils.getXmlFloat((Element)partitionInfo, (String)"absoluteMaxCapacity"), (double)0.1f);
    }

    private void verifySchedulerInfoJson(JSONObject json) throws JSONException, Exception {
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject info = json.getJSONObject("scheduler");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)info.length());
        info = info.getJSONObject("schedulerInfo");
        Assert.assertEquals((String)"incorrect number of elements", (long)25L, (long)info.length());
        JSONObject capacitiesJsonObject = info.getJSONObject(CAPACITIES);
        JSONArray partitionsCapsArray = capacitiesJsonObject.getJSONArray(QUEUE_CAPACITIES_BY_PARTITION);
        Assert.assertEquals((String)"incorrect number of elements", (long)CLUSTER_LABELS.size(), (long)partitionsCapsArray.length());
        for (int i = 0; i < partitionsCapsArray.length(); ++i) {
            JSONObject partitionInfo = partitionsCapsArray.getJSONObject(i);
            String partitionName = partitionInfo.getString("partitionName");
            Assert.assertTrue((String)"Unknown partition received", (boolean)CLUSTER_LABELS.contains((Object)partitionName));
            this.verifyPartitionCapacityInfoJson(partitionInfo, 100.0f, 0.0f, 100.0f, 100.0f, 0.0f, 100.0f);
        }
        JSONObject jsonQueuesObject = info.getJSONObject("queues");
        JSONArray queuesArray = jsonQueuesObject.getJSONArray("queue");
        block19: for (int i = 0; i < queuesArray.length(); ++i) {
            JSONObject queueJson = queuesArray.getJSONObject(i);
            String queue = queueJson.getString("queueName");
            Object resourceUsagesByPartition = queueJson.getJSONObject("resources").get(RESOURCE_USAGES_BY_PARTITION);
            JSONArray resourceUsageByPartition = new JSONArray();
            if (resourceUsagesByPartition instanceof JSONArray) {
                resourceUsageByPartition = (JSONArray)JSONArray.class.cast(resourceUsagesByPartition);
            } else {
                resourceUsageByPartition.put(JSONObject.class.cast(resourceUsagesByPartition));
            }
            JSONObject resourcesJsonObject = queueJson.getJSONObject("resources");
            Object resourceUsagesByPartition2 = resourcesJsonObject.get(RESOURCE_USAGES_BY_PARTITION);
            JSONArray partitionsResourcesArray = new JSONArray();
            if (resourceUsagesByPartition2 instanceof JSONArray) {
                partitionsResourcesArray = (JSONArray)JSONArray.class.cast(resourceUsagesByPartition2);
            } else {
                partitionsResourcesArray.put(resourceUsagesByPartition2);
            }
            capacitiesJsonObject = queueJson.getJSONObject(CAPACITIES);
            Object queueCapacitiesByPartition = capacitiesJsonObject.get(QUEUE_CAPACITIES_BY_PARTITION);
            partitionsCapsArray = new JSONArray();
            if (queueCapacitiesByPartition instanceof JSONArray) {
                partitionsCapsArray = (JSONArray)JSONArray.class.cast(queueCapacitiesByPartition);
            } else {
                partitionsCapsArray.put(queueCapacitiesByPartition);
            }
            JSONObject partitionInfo = null;
            String partitionName = null;
            switch (queue) {
                case "Qa": {
                    Assert.assertEquals((String)"incorrect number of partitions", (long)1L, (long)partitionsCapsArray.length());
                    partitionInfo = partitionsCapsArray.getJSONObject(0);
                    partitionName = partitionInfo.getString("partitionName");
                    this.verifyPartitionCapacityInfoJson(partitionInfo, 30.0f, 0.0f, 50.0f, 30.0f, 0.0f, 50.0f);
                    Assert.assertEquals((String)"incorrect number of elements", (long)7L, (long)partitionsResourcesArray.getJSONObject(0).length());
                    Assert.assertEquals((String)"incorrect number of objects", (long)1L, (long)resourceUsageByPartition.length());
                    continue block19;
                }
                case "Qb": {
                    Assert.assertEquals((String)"Invalid default Label expression", (Object)LABEL_LX, (Object)queueJson.getString("defaultNodeLabelExpression"));
                    Assert.assertEquals((String)"incorrect number of elements", (long)7L, (long)partitionsResourcesArray.getJSONObject(0).length());
                    this.verifyAccesibleNodeLabels(queueJson, (Set<String>)ImmutableSet.of((Object)LABEL_LX));
                    Assert.assertEquals((String)"incorrect number of partitions", (long)2L, (long)partitionsCapsArray.length());
                    Assert.assertEquals((String)"incorrect number of objects", (long)2L, (long)resourceUsageByPartition.length());
                    block20: for (int j = 0; j < partitionsCapsArray.length(); ++j) {
                        partitionInfo = partitionsCapsArray.getJSONObject(j);
                        switch (partitionName = partitionInfo.getString("partitionName")) {
                            case "Lx": {
                                this.verifyPartitionCapacityInfoJson(partitionInfo, 30.0f, 0.0f, 100.0f, 30.0f, 0.0f, 100.0f);
                                continue block20;
                            }
                            case "": {
                                this.verifyPartitionCapacityInfoJson(partitionInfo, 30.0f, 0.0f, 50.0f, 30.0f, 0.0f, 50.0f);
                                continue block20;
                            }
                            default: {
                                Assert.fail((String)("Unexpected partition" + partitionName));
                            }
                        }
                    }
                    continue block19;
                }
                case "Qc": {
                    this.verifyAccesibleNodeLabels(queueJson, (Set<String>)ImmutableSet.of((Object)LABEL_LX, (Object)LABEL_LY));
                    Assert.assertEquals((String)"incorrect number of elements", (long)4L, (long)partitionsResourcesArray.getJSONObject(0).length());
                    this.verifyQcPartitionsCapacityInfoJson(partitionsCapsArray, 70.0f, 100.0f, 70.0f, 100.0f, 100.0f, 100.0f, 100.0f, 100.0f, 40.0f, 50.0f, 40.0f, 50.0f);
                    this.verifySubQueuesOfQc(queueJson);
                    continue block19;
                }
                default: {
                    Assert.fail((String)("Unexpected queue" + queue));
                }
            }
        }
    }

    private void verifyAccesibleNodeLabels(JSONObject queueJson, Set<String> accesibleNodeLabels) throws JSONException {
        Object nodeLabelsObj = queueJson.get("nodeLabels");
        JSONArray nodeLabels = new JSONArray();
        if (nodeLabelsObj instanceof JSONArray) {
            nodeLabels = queueJson.getJSONArray("nodeLabels");
        } else {
            nodeLabels.put(nodeLabelsObj);
        }
        Assert.assertEquals((String)"number of accessible Node Labels not matching", (long)accesibleNodeLabels.size(), (long)nodeLabels.length());
        for (int i = 0; i < nodeLabels.length(); ++i) {
            Assert.assertTrue((String)("Invalid accessible node label : " + nodeLabels.getString(i)), (boolean)accesibleNodeLabels.contains(nodeLabels.getString(i)));
        }
    }

    private void verifySubQueuesOfQc(JSONObject queueCJson) throws JSONException {
        JSONObject jsonQueuesObject = queueCJson.getJSONObject("queues");
        JSONArray queuesArray = jsonQueuesObject.getJSONArray("queue");
        block8: for (int i = 0; i < queuesArray.length(); ++i) {
            JSONObject queueJson = queuesArray.getJSONObject(i);
            String queue = queueJson.getString("queueName");
            JSONObject capacitiesJsonObject = queueJson.getJSONObject(CAPACITIES);
            JSONArray partitionsCapsArray = capacitiesJsonObject.getJSONArray(QUEUE_CAPACITIES_BY_PARTITION);
            switch (queue) {
                case "Qc1": {
                    this.verifyAccesibleNodeLabels(queueJson, (Set<String>)ImmutableSet.of((Object)LABEL_LX, (Object)LABEL_LY));
                    Assert.assertEquals((String)"Invalid default Label expression", (Object)LABEL_LX, (Object)queueJson.getString("defaultNodeLabelExpression"));
                    this.verifyQcPartitionsCapacityInfoJson(partitionsCapsArray, 40.0f, 100.0f, 28.0f, 100.0f, 50.0f, 75.0f, 50.0f, 75.0f, 50.0f, 60.0f, 20.0f, 30.0f);
                    continue block8;
                }
                case "Qc2": {
                    this.verifyAccesibleNodeLabels(queueJson, (Set<String>)ImmutableSet.of((Object)LABEL_LX, (Object)LABEL_LY));
                    Assert.assertEquals((String)"Invalid default Label expression", (Object)LABEL_LY, (Object)queueJson.getString("defaultNodeLabelExpression"));
                    this.verifyQcPartitionsCapacityInfoJson(partitionsCapsArray, 60.0f, 100.0f, 42.0f, 100.0f, 50.0f, 75.0f, 50.0f, 75.0f, 50.0f, 70.0f, 20.0f, 35.0f);
                    continue block8;
                }
                default: {
                    Assert.fail((String)("Unexpected queue" + queue));
                }
            }
        }
    }

    private void verifyQcPartitionsCapacityInfoJson(JSONArray partitionsCapsArray, float lxCaps, float lxMaxCaps, float lxAbsCaps, float lxAbsMaxCaps, float lyCaps, float lyMaxCaps, float lyAbsCaps, float lyAbsMaxCaps, float defCaps, float defMaxCaps, float defAbsCaps, float defAbsMaxCaps) throws JSONException {
        Assert.assertEquals((String)"incorrect number of partitions", (long)CLUSTER_LABELS.size(), (long)partitionsCapsArray.length());
        block10: for (int j = 0; j < partitionsCapsArray.length(); ++j) {
            String partitionName;
            JSONObject partitionInfo = partitionsCapsArray.getJSONObject(j);
            switch (partitionName = partitionInfo.getString("partitionName")) {
                case "Lx": {
                    this.verifyPartitionCapacityInfoJson(partitionInfo, lxCaps, 0.0f, lxMaxCaps, lxAbsCaps, 0.0f, lxAbsMaxCaps);
                    continue block10;
                }
                case "Ly": {
                    this.verifyPartitionCapacityInfoJson(partitionInfo, lyCaps, 0.0f, lyMaxCaps, lyAbsCaps, 0.0f, lyAbsMaxCaps);
                    continue block10;
                }
                case "": {
                    this.verifyPartitionCapacityInfoJson(partitionInfo, defCaps, 0.0f, defMaxCaps, defAbsCaps, 0.0f, defAbsMaxCaps);
                    continue block10;
                }
                default: {
                    Assert.fail((String)("Unexpected partition" + partitionName));
                }
            }
        }
    }

    private void verifyPartitionCapacityInfoJson(JSONObject partitionCapacityInfoJson, float capacity, float usedCapacity, float maxCapacity, float absoluteCapacity, float absoluteUsedCapacity, float absoluteMaxCapacity) throws JSONException {
        Assert.assertEquals((String)"capacity doesn't match", (double)capacity, (double)((float)partitionCapacityInfoJson.getDouble("capacity")), (double)0.1f);
        Assert.assertEquals((String)"capacity doesn't match", (double)usedCapacity, (double)((float)partitionCapacityInfoJson.getDouble("usedCapacity")), (double)0.1f);
        Assert.assertEquals((String)"capacity doesn't match", (double)maxCapacity, (double)((float)partitionCapacityInfoJson.getDouble("maxCapacity")), (double)0.1f);
        Assert.assertEquals((String)"capacity doesn't match", (double)absoluteCapacity, (double)((float)partitionCapacityInfoJson.getDouble("absoluteCapacity")), (double)0.1f);
        Assert.assertEquals((String)"capacity doesn't match", (float)absoluteUsedCapacity, (float)((float)partitionCapacityInfoJson.getDouble("absoluteUsedCapacity")), (float)0.001f);
        Assert.assertEquals((String)"capacity doesn't match", (float)absoluteMaxCapacity, (float)((float)partitionCapacityInfoJson.getDouble("absoluteMaxCapacity")), (float)0.001f);
    }

    private class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            try {
                TestRMWebServicesForCSWithPartitions.this.csConf = new CapacitySchedulerConfiguration();
                TestRMWebServicesForCSWithPartitions.this.setupQueueConfiguration(TestRMWebServicesForCSWithPartitions.this.csConf);
                TestRMWebServicesForCSWithPartitions.this.conf = new YarnConfiguration((Configuration)TestRMWebServicesForCSWithPartitions.this.csConf);
                TestRMWebServicesForCSWithPartitions.this.rm = TestWebServiceUtil.createRM((Configuration)TestRMWebServicesForCSWithPartitions.this.conf);
                HashSet<NodeLabel> labels = new HashSet<NodeLabel>();
                labels.add(NodeLabel.newInstance((String)TestRMWebServicesForCSWithPartitions.LABEL_LX));
                labels.add(NodeLabel.newInstance((String)TestRMWebServicesForCSWithPartitions.LABEL_LY));
                try {
                    RMNodeLabelsManager nodeLabelManager = TestRMWebServicesForCSWithPartitions.this.rm.getRMContext().getNodeLabelManager();
                    nodeLabelManager.addToCluserNodeLabels(labels);
                }
                catch (Exception e) {
                    Assert.fail();
                }
                TestRMWebServicesForCSWithPartitions.this.rm.start();
                TestRMWebServicesForCSWithPartitions.this.rm.getRMContext().getNodeLabelManager().addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"127.0.0.1", (int)0), (Object)Sets.newHashSet((Object[])new String[]{TestRMWebServicesForCSWithPartitions.LABEL_LX})));
                TestRMWebServicesForCSWithPartitions.this.nm1 = new MockNM("127.0.0.1:1234", 2048, TestRMWebServicesForCSWithPartitions.this.rm.getResourceTrackerService());
                MockNM nm2 = new MockNM("127.0.0.2:1234", 2048, TestRMWebServicesForCSWithPartitions.this.rm.getResourceTrackerService());
                TestRMWebServicesForCSWithPartitions.this.nm1.registerNode();
                nm2.registerNode();
                TestRMWebServicesForCSWithPartitions.this.rm.getRMContext().getNodeLabelManager().addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"127.0.0.2", (int)0), (Object)Sets.newHashSet((Object[])new String[]{TestRMWebServicesForCSWithPartitions.LABEL_LY})));
                MockNM nm3 = new MockNM("127.0.0.2:1234", 131072, TestRMWebServicesForCSWithPartitions.this.rm.getResourceTrackerService());
                nm3.registerNode();
                MockNM nm4 = new MockNM("127.0.0.3:1234", 131072, TestRMWebServicesForCSWithPartitions.this.rm.getResourceTrackerService());
                nm4.registerNode();
                HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
                Mockito.when((Object)request.getScheme()).thenReturn((Object)"http");
                HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
                ((InstanceBinding)this.bind((Object)TestRMWebServicesForCSWithPartitions.this.rm).to(ResourceManager.class)).named("rm");
                ((InstanceBinding)this.bind(TestRMWebServicesForCSWithPartitions.this.conf).to(Configuration.class)).named("conf");
                this.bind(request).to(HttpServletRequest.class);
                this.bind(response).to(HttpServletResponse.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

