/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.KerberosTestUtils;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.XMLUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServicesAppsModification;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestWebServiceUtil;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.DelegationToken;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@RunWith(value=Parameterized.class)
public class TestRMWebServicesDelegationTokens
extends JerseyTestBase {
    private static File testRootDir;
    private static File httpSpnegoKeytabFile;
    private static String httpSpnegoPrincipal;
    private static MiniKdc testMiniKDC;
    private static MockRM rm;
    private boolean isKerberosAuth = false;
    private ResourceConfig config;
    private HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
    final String yarnTokenHeader = "Hadoop-YARN-RM-Delegation-Token";

    protected Application configure() {
        this.config = new ResourceConfig();
        this.config.register(RMWebServices.class);
        this.config.register(GenericExceptionHandler.class);
        this.config.register(TestRMWebServicesAppsModification.TestRMCustomAuthFilter.class);
        this.config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        return this.config;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> guiceConfigs() {
        return Arrays.asList({0}, {1});
    }

    public TestRMWebServicesDelegationTokens(int run) throws Exception {
        switch (run) {
            default: {
                this.config.register((Object)new KerberosAuth());
                break;
            }
            case 1: {
                this.config.register((Object)new SimpleAuth());
            }
        }
    }

    @BeforeClass
    public static void setupKDC() throws Exception {
        testRootDir = new File("target", TestRMWebServicesDelegationTokens.class.getName() + "-root");
        testMiniKDC = new MiniKdc(MiniKdc.createConf(), testRootDir);
        testMiniKDC.start();
        testMiniKDC.createPrincipal(httpSpnegoKeytabFile, new String[]{"HTTP/localhost", "client", "client2", "client3"});
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        httpSpnegoKeytabFile.deleteOnExit();
        testRootDir.deleteOnExit();
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    @AfterClass
    public static void shutdownKdc() {
        if (testMiniKDC != null) {
            testMiniKDC.stop();
        }
    }

    @After
    public void tearDown() throws Exception {
        if (rm != null) {
            rm.stop();
        }
        super.tearDown();
        UserGroupInformation.setConfiguration((Configuration)new Configuration());
    }

    @Test
    public void testCreateDelegationToken() throws Exception {
        rm.start();
        String renewer = "test-renewer";
        DelegationToken token = new DelegationToken();
        token.setRenewer("test-renewer");
        String jsonBody = TestWebServiceUtil.toJson(token, DelegationToken.class);
        String xmlBody = "<delegation-token><renewer>test-renewer</renewer></delegation-token>";
        String[] mediaTypes = new String[]{"application/json", "application/xml"};
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("application/json", jsonBody);
        bodyMap.put("application/xml", xmlBody);
        for (String mediaType : mediaTypes) {
            String body = (String)bodyMap.get(mediaType);
            for (String contentType : mediaTypes) {
                if (this.isKerberosAuth) {
                    Mockito.when((Object)this.request.getAuthType()).thenReturn((Object)"Kerberos");
                    this.verifyKerberosAuthCreate(mediaType, contentType, body, "test-renewer");
                    continue;
                }
                this.verifySimpleAuthCreate(mediaType, contentType, body);
            }
        }
        rm.stop();
    }

    private void verifySimpleAuthCreate(String mediaType, String contentType, String body) {
        Response response = (Response)this.target().path("ws").path("v1").path("cluster").path("delegation-token").queryParam("user.name", new Object[]{"testuser"}).request(new String[]{contentType}).post(Entity.entity((Object)body, (MediaType)MediaType.valueOf((String)mediaType)), Response.class);
        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
    }

    private void verifyKerberosAuthCreate(String mType, String cType, String reqBody, String renUser) throws Exception {
        final String mediaType = mType;
        final String contentType = cType;
        final String body = reqBody;
        final String renewer = renUser;
        KerberosTestUtils.doAsClient((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Principal principal1 = () -> "client@EXAMPLE.COM";
                Mockito.when((Object)TestRMWebServicesDelegationTokens.this.request.getUserPrincipal()).thenReturn((Object)principal1);
                Response response = (Response)TestRMWebServicesDelegationTokens.this.targetWithJsonObject().path("ws").path("v1").path("cluster").path("delegation-token").request(new String[]{contentType}).post(Entity.entity((Object)body, (MediaType)MediaType.valueOf((String)mediaType)), Response.class);
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
                DelegationToken tok = TestRMWebServicesDelegationTokens.this.getDelegationTokenFromResponse(response);
                Assert.assertFalse((boolean)tok.getToken().isEmpty());
                Token token = new Token();
                token.decodeFromUrlString(tok.getToken());
                Assert.assertEquals((Object)renewer, (Object)((RMDelegationTokenIdentifier)token.decodeIdentifier()).getRenewer().toString());
                TestRMWebServicesDelegationTokens.this.assertValidRMToken(tok.getToken());
                DelegationToken dtoken = new DelegationToken();
                response = (Response)TestRMWebServicesDelegationTokens.this.targetWithJsonObject().path("ws").path("v1").path("cluster").path("delegation-token").request(new String[]{contentType}).post(Entity.entity((Object)TestWebServiceUtil.toEntity(dtoken, DelegationToken.class, mediaType), (String)mediaType), Response.class);
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
                tok = TestRMWebServicesDelegationTokens.this.getDelegationTokenFromResponse(response);
                Assert.assertFalse((boolean)tok.getToken().isEmpty());
                token = new Token();
                token.decodeFromUrlString(tok.getToken());
                Assert.assertEquals((Object)"", (Object)((RMDelegationTokenIdentifier)token.decodeIdentifier()).getRenewer().toString());
                TestRMWebServicesDelegationTokens.this.assertValidRMToken(tok.getToken());
                return null;
            }
        });
    }

    @Test
    public void testRenewDelegationToken() throws Exception {
        String[] mediaTypes;
        this.client().register((Object)new LoggingFeature());
        rm.start();
        String renewer = "client2";
        final DelegationToken dummyToken = new DelegationToken();
        dummyToken.setRenewer("client2");
        for (final String mediaType : mediaTypes = new String[]{"application/json", "application/xml"}) {
            for (final String contentType : mediaTypes) {
                if (!this.isKerberosAuth) {
                    this.verifySimpleAuthRenew(mediaType, contentType);
                    continue;
                }
                if (this.isKerberosAuth) {
                    Mockito.when((Object)this.request.getAuthType()).thenReturn((Object)"Kerberos");
                }
                final DelegationToken responseToken = (DelegationToken)KerberosTestUtils.doAsClient((Callable)new Callable<DelegationToken>(){

                    @Override
                    public DelegationToken call() throws Exception {
                        Principal principal1 = () -> "client@EXAMPLE.COM";
                        Mockito.when((Object)TestRMWebServicesDelegationTokens.this.request.getUserPrincipal()).thenReturn((Object)principal1);
                        Response response = (Response)TestRMWebServicesDelegationTokens.this.targetWithJsonObject().path("ws").path("v1").path("cluster").path("delegation-token").request(new String[]{contentType}).post(Entity.entity((Object)TestWebServiceUtil.toEntity(dummyToken, DelegationToken.class, mediaType), (String)mediaType), Response.class);
                        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
                        DelegationToken tok = TestRMWebServicesDelegationTokens.this.getDelegationTokenFromResponse(response);
                        Assert.assertFalse((boolean)tok.getToken().isEmpty());
                        String body = TestRMWebServicesDelegationTokens.generateRenewTokenBody(mediaType, tok.getToken());
                        Mockito.when((Object)TestRMWebServicesDelegationTokens.this.request.getHeader("Hadoop-YARN-RM-Delegation-Token")).thenReturn((Object)tok.getToken());
                        response = (Response)TestRMWebServicesDelegationTokens.this.target().path("ws").path("v1").path("cluster").path("delegation-token").path("expiration").request(new String[]{contentType}).header("Hadoop-YARN-RM-Delegation-Token", (Object)tok.getToken()).post(Entity.entity((Object)body, (String)mediaType), Response.class);
                        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
                        return tok;
                    }
                });
                KerberosTestUtils.doAs((String)"client2", (Callable)new Callable<DelegationToken>(){

                    @Override
                    public DelegationToken call() throws Exception {
                        Principal principal1 = () -> "client2@EXAMPLE.COM";
                        Mockito.when((Object)TestRMWebServicesDelegationTokens.this.request.getUserPrincipal()).thenReturn((Object)principal1);
                        Mockito.when((Object)TestRMWebServicesDelegationTokens.this.request.getHeader("Hadoop-YARN-RM-Delegation-Token")).thenReturn((Object)responseToken.getToken());
                        long oldExpirationTime = Time.now();
                        TestRMWebServicesDelegationTokens.this.assertValidRMToken(responseToken.getToken());
                        String body = TestRMWebServicesDelegationTokens.generateRenewTokenBody(mediaType, responseToken.getToken());
                        Response response = (Response)TestRMWebServicesDelegationTokens.this.targetWithJsonObject().path("ws").path("v1").path("cluster").path("delegation-token").path("expiration").request(new String[]{contentType}).header("Hadoop-YARN-RM-Delegation-Token", (Object)responseToken.getToken()).post(Entity.entity((Object)body, (String)mediaType), Response.class);
                        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
                        DelegationToken tok = TestRMWebServicesDelegationTokens.this.getDelegationTokenFromResponse(response);
                        String message = "Expiration time not as expected: old = " + oldExpirationTime + "; new = " + tok.getNextExpirationTime();
                        Assert.assertTrue((String)message, (tok.getNextExpirationTime() > oldExpirationTime ? 1 : 0) != 0);
                        oldExpirationTime = tok.getNextExpirationTime();
                        Thread.sleep(1000L);
                        response = (Response)TestRMWebServicesDelegationTokens.this.targetWithJsonObject().path("ws").path("v1").path("cluster").path("delegation-token").path("expiration").request(new String[]{contentType}).header("Hadoop-YARN-RM-Delegation-Token", (Object)responseToken.getToken()).post(Entity.entity((Object)body, (String)mediaType), Response.class);
                        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
                        tok = TestRMWebServicesDelegationTokens.this.getDelegationTokenFromResponse(response);
                        message = "Expiration time not as expected: old = " + oldExpirationTime + "; new = " + tok.getNextExpirationTime();
                        Assert.assertTrue((String)message, (tok.getNextExpirationTime() > oldExpirationTime ? 1 : 0) != 0);
                        return tok;
                    }
                });
                KerberosTestUtils.doAs((String)"client3", (Callable)new Callable<DelegationToken>(){

                    @Override
                    public DelegationToken call() throws Exception {
                        Principal principal1 = () -> "client3@EXAMPLE.COM";
                        Mockito.when((Object)TestRMWebServicesDelegationTokens.this.request.getUserPrincipal()).thenReturn((Object)principal1);
                        String body = TestRMWebServicesDelegationTokens.generateRenewTokenBody(mediaType, responseToken.getToken());
                        Response response = (Response)TestRMWebServicesDelegationTokens.this.target().path("ws").path("v1").path("cluster").path("delegation-token").path("expiration").request(new String[]{contentType}).header("Hadoop-YARN-RM-Delegation-Token", (Object)responseToken.getToken()).post(Entity.entity((Object)body, (String)mediaType), Response.class);
                        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
                        return null;
                    }
                });
                KerberosTestUtils.doAsClient((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        String token = "TEST_TOKEN_STRING";
                        Object body = "";
                        if (mediaType.equals("application/json")) {
                            DelegationToken dToken = new DelegationToken();
                            dToken.setToken(token);
                            body = TestWebServiceUtil.toJson(dToken, DelegationToken.class);
                        } else {
                            body = "<delegation-token><token>" + token + "</token></delegation-token>";
                        }
                        Mockito.when((Object)TestRMWebServicesDelegationTokens.this.request.getHeader("Hadoop-YARN-RM-Delegation-Token")).thenReturn(null);
                        Response response = (Response)TestRMWebServicesDelegationTokens.this.target().path("ws").path("v1").path("cluster").path("delegation-token").path("expiration").request().post(Entity.entity((Object)body, (MediaType)MediaType.valueOf((String)mediaType)), Response.class);
                        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
                        return null;
                    }
                });
            }
        }
        rm.stop();
    }

    private void verifySimpleAuthRenew(String mediaType, String contentType) throws Exception {
        String token = "TEST_TOKEN_STRING";
        Object body = "";
        if (mediaType.equals("application/json")) {
            DelegationToken delegationToken = new DelegationToken();
            body = "{\"token\": \"" + token + "\" }";
            delegationToken.setToken("test-123");
            body = TestWebServiceUtil.toJson(delegationToken, DelegationToken.class);
        } else {
            body = "<delegation-token><token>" + token + "</token></delegation-token>";
            body = "<delegation-token><xml>abcd</xml></delegation-token>";
        }
        Response response = (Response)this.target().path("ws").path("v1").path("cluster").path("delegation-token").queryParam("user.name", new Object[]{"testuser"}).request(new String[]{contentType}).post(Entity.entity((Object)body, (String)mediaType), Response.class);
        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
    }

    @Test
    public void testCancelDelegationToken() throws Exception {
        rm.start();
        if (!this.isKerberosAuth) {
            this.verifySimpleAuthCancel();
            return;
        }
        final DelegationToken dtoken = new DelegationToken();
        String renewer = "client2";
        dtoken.setRenewer(renewer);
        String[] mediaTypes = new String[]{"application/json", "application/xml"};
        Mockito.when((Object)this.request.getAuthType()).thenReturn((Object)"Kerberos");
        for (final String mediaType : mediaTypes) {
            for (final String contentType : mediaTypes) {
                KerberosTestUtils.doAsClient((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        Principal principal1 = () -> "client@EXAMPLE.COM";
                        Mockito.when((Object)TestRMWebServicesDelegationTokens.this.request.getUserPrincipal()).thenReturn((Object)principal1);
                        Response response = (Response)TestRMWebServicesDelegationTokens.this.targetWithJsonObject().path("ws").path("v1").path("cluster").path("delegation-token").request(new String[]{contentType}).post(Entity.entity((Object)TestWebServiceUtil.toEntity(dtoken, DelegationToken.class, mediaType), (String)mediaType), Response.class);
                        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
                        DelegationToken tok = TestRMWebServicesDelegationTokens.this.getDelegationTokenFromResponse(response);
                        Mockito.when((Object)TestRMWebServicesDelegationTokens.this.request.getHeader("Hadoop-YARN-RM-Delegation-Token")).thenReturn((Object)tok.getToken());
                        response = (Response)TestRMWebServicesDelegationTokens.this.targetWithJsonObject().path("ws").path("v1").path("cluster").path("delegation-token").request(new String[]{contentType}).header("Hadoop-YARN-RM-Delegation-Token", (Object)tok.getToken()).delete(Response.class);
                        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
                        TestRMWebServicesDelegationTokens.this.assertTokenCancelled(tok.getToken());
                        return null;
                    }
                });
                final DelegationToken tmpToken = (DelegationToken)KerberosTestUtils.doAsClient((Callable)new Callable<DelegationToken>(){

                    @Override
                    public DelegationToken call() throws Exception {
                        Principal principal1 = () -> "client@EXAMPLE.COM";
                        Mockito.when((Object)TestRMWebServicesDelegationTokens.this.request.getUserPrincipal()).thenReturn((Object)principal1);
                        Response response = (Response)TestRMWebServicesDelegationTokens.this.targetWithJsonObject().path("ws").path("v1").path("cluster").path("delegation-token").request(new String[]{contentType}).post(Entity.entity((Object)TestWebServiceUtil.toEntity(dtoken, DelegationToken.class, mediaType), (String)mediaType), Response.class);
                        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
                        DelegationToken tok = TestRMWebServicesDelegationTokens.this.getDelegationTokenFromResponse(response);
                        return tok;
                    }
                });
                KerberosTestUtils.doAs((String)renewer, (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        Principal principal1 = () -> "client2@EXAMPLE.COM";
                        Mockito.when((Object)TestRMWebServicesDelegationTokens.this.request.getUserPrincipal()).thenReturn((Object)principal1);
                        Mockito.when((Object)TestRMWebServicesDelegationTokens.this.request.getHeader("Hadoop-YARN-RM-Delegation-Token")).thenReturn((Object)tmpToken.getToken());
                        Response response = (Response)TestRMWebServicesDelegationTokens.this.targetWithJsonObject().path("ws").path("v1").path("cluster").path("delegation-token").request().header("Hadoop-YARN-RM-Delegation-Token", (Object)tmpToken.getToken()).accept(new String[]{contentType}).delete(Response.class);
                        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
                        TestRMWebServicesDelegationTokens.this.assertTokenCancelled(tmpToken.getToken());
                        return null;
                    }
                });
                final DelegationToken tmpToken2 = (DelegationToken)KerberosTestUtils.doAsClient((Callable)new Callable<DelegationToken>(){

                    @Override
                    public DelegationToken call() throws Exception {
                        Principal principal1 = () -> "client@EXAMPLE.COM";
                        Mockito.when((Object)TestRMWebServicesDelegationTokens.this.request.getUserPrincipal()).thenReturn((Object)principal1);
                        Response response = (Response)TestRMWebServicesDelegationTokens.this.targetWithJsonObject().path("ws").path("v1").path("cluster").path("delegation-token").request(new String[]{contentType}).post(Entity.entity((Object)TestWebServiceUtil.toEntity(dtoken, DelegationToken.class, mediaType), (String)mediaType), Response.class);
                        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
                        DelegationToken tok = TestRMWebServicesDelegationTokens.this.getDelegationTokenFromResponse(response);
                        return tok;
                    }
                });
                KerberosTestUtils.doAs((String)"client3", (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        Principal principal1 = () -> "client3@EXAMPLE.COM";
                        Mockito.when((Object)TestRMWebServicesDelegationTokens.this.request.getUserPrincipal()).thenReturn((Object)principal1);
                        Mockito.when((Object)TestRMWebServicesDelegationTokens.this.request.getHeader("Hadoop-YARN-RM-Delegation-Token")).thenReturn((Object)tmpToken2.getToken());
                        Response response = (Response)TestRMWebServicesDelegationTokens.this.targetWithJsonObject().path("ws").path("v1").path("cluster").path("delegation-token").request().header("Hadoop-YARN-RM-Delegation-Token", (Object)tmpToken2.getToken()).accept(new String[]{contentType}).delete(Response.class);
                        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
                        TestRMWebServicesDelegationTokens.this.assertValidRMToken(tmpToken2.getToken());
                        return null;
                    }
                });
                this.testCancelTokenBadRequests(mediaType, contentType);
            }
        }
        rm.stop();
    }

    private void testCancelTokenBadRequests(String mType, String cType) throws Exception {
        final String mediaType = mType;
        final String contentType = cType;
        final DelegationToken dtoken = new DelegationToken();
        String renewer = "client2";
        dtoken.setRenewer(renewer);
        KerberosTestUtils.doAsClient((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Principal principal1 = () -> "client@EXAMPLE.COM";
                Mockito.when((Object)TestRMWebServicesDelegationTokens.this.request.getUserPrincipal()).thenReturn((Object)principal1);
                Mockito.when((Object)TestRMWebServicesDelegationTokens.this.request.getHeader("Hadoop-YARN-RM-Delegation-Token")).thenReturn((Object)"random-string");
                Response response = (Response)TestRMWebServicesDelegationTokens.this.targetWithJsonObject().path("ws").path("v1").path("cluster").path("delegation-token").request(new String[]{contentType}).header("Hadoop-YARN-RM-Delegation-Token", (Object)"random-string").delete(Response.class);
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
                return null;
            }
        });
        KerberosTestUtils.doAsClient((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Principal principal1 = () -> "client@EXAMPLE.COM";
                Mockito.when((Object)TestRMWebServicesDelegationTokens.this.request.getUserPrincipal()).thenReturn((Object)principal1);
                Response response = (Response)TestRMWebServicesDelegationTokens.this.targetWithJsonObject().path("ws").path("v1").path("cluster").path("delegation-token").request(new String[]{contentType}).delete(Response.class);
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
                return null;
            }
        });
        final DelegationToken tmpToken = (DelegationToken)KerberosTestUtils.doAsClient((Callable)new Callable<DelegationToken>(){

            @Override
            public DelegationToken call() throws Exception {
                Principal principal1 = () -> "client@EXAMPLE.COM";
                Mockito.when((Object)TestRMWebServicesDelegationTokens.this.request.getUserPrincipal()).thenReturn((Object)principal1);
                Response response = (Response)TestRMWebServicesDelegationTokens.this.targetWithJsonObject().path("ws").path("v1").path("cluster").path("delegation-token").request(new String[]{contentType}).post(Entity.entity((Object)TestWebServiceUtil.toEntity(dtoken, DelegationToken.class, mediaType), (String)mediaType), Response.class);
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
                DelegationToken tok = TestRMWebServicesDelegationTokens.this.getDelegationTokenFromResponse(response);
                return tok;
            }
        });
        KerberosTestUtils.doAs((String)renewer, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Principal principal1 = () -> "client2@EXAMPLE.COM";
                Mockito.when((Object)TestRMWebServicesDelegationTokens.this.request.getHeader("Hadoop-YARN-RM-Delegation-Token")).thenReturn((Object)tmpToken.getToken());
                Mockito.when((Object)TestRMWebServicesDelegationTokens.this.request.getUserPrincipal()).thenReturn((Object)principal1);
                Response response = (Response)TestRMWebServicesDelegationTokens.this.targetWithJsonObject().path("ws").path("v1").path("cluster").path("delegation-token").request(new String[]{contentType}).header("Hadoop-YARN-RM-Delegation-Token", (Object)tmpToken.getToken()).delete(Response.class);
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
                response = (Response)TestRMWebServicesDelegationTokens.this.targetWithJsonObject().path("ws").path("v1").path("cluster").path("delegation-token").request(new String[]{contentType}).header("Hadoop-YARN-RM-Delegation-Token", (Object)tmpToken.getToken()).delete(Response.class);
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
                return null;
            }
        });
    }

    private void verifySimpleAuthCancel() {
        Response response = (Response)this.target().path("ws").path("v1").path("cluster").path("delegation-token").queryParam("user.name", new Object[]{"testuser"}).request().header("Hadoop-YARN-RM-Delegation-Token", (Object)"random").delete(Response.class);
        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
    }

    private DelegationToken getDelegationTokenFromResponse(Response response) throws IOException, ParserConfigurationException, SAXException, JSONException {
        if (response.getMediaType().toString().contains("application/json")) {
            return TestRMWebServicesDelegationTokens.getDelegationTokenFromJson(((JSONObject)response.readEntity(JSONObject.class)).getJSONObject("delegation-token"));
        }
        return TestRMWebServicesDelegationTokens.getDelegationTokenFromXML((String)response.readEntity(String.class));
    }

    public static DelegationToken getDelegationTokenFromXML(String tokenXML) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(tokenXML));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("delegation-token");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        Element element = (Element)nodes.item(0);
        DelegationToken ret = new DelegationToken();
        String token = WebServicesTestUtils.getXmlString((Element)element, (String)"token");
        if (token != null) {
            ret.setToken(token);
        } else {
            long expiration = WebServicesTestUtils.getXmlLong((Element)element, (String)"expiration-time");
            ret.setNextExpirationTime(expiration);
        }
        return ret;
    }

    public static DelegationToken getDelegationTokenFromJson(JSONObject json) throws JSONException {
        DelegationToken ret = new DelegationToken();
        if (json.has("token")) {
            ret.setToken(json.getString("token"));
        } else if (json.has("expiration-time")) {
            ret.setNextExpirationTime(json.getLong("expiration-time"));
        }
        return ret;
    }

    private void assertValidRMToken(String encodedToken) throws IOException {
        Token realToken = new Token();
        realToken.decodeFromUrlString(encodedToken);
        RMDelegationTokenIdentifier ident = (RMDelegationTokenIdentifier)rm.getRMContext().getRMDelegationTokenSecretManager().decodeTokenIdentifier(realToken);
        rm.getRMContext().getRMDelegationTokenSecretManager().verifyToken((AbstractDelegationTokenIdentifier)ident, realToken.getPassword());
        Assert.assertTrue((boolean)rm.getRMContext().getRMDelegationTokenSecretManager().getAllTokens().containsKey(ident));
    }

    private void assertTokenCancelled(String encodedToken) throws Exception {
        Token realToken = new Token();
        realToken.decodeFromUrlString(encodedToken);
        RMDelegationTokenIdentifier ident = (RMDelegationTokenIdentifier)rm.getRMContext().getRMDelegationTokenSecretManager().decodeTokenIdentifier(realToken);
        boolean exceptionCaught = false;
        try {
            rm.getRMContext().getRMDelegationTokenSecretManager().verifyToken((AbstractDelegationTokenIdentifier)ident, realToken.getPassword());
        }
        catch (SecretManager.InvalidToken it) {
            exceptionCaught = true;
        }
        Assert.assertTrue((String)"InvalidToken exception not thrown", (boolean)exceptionCaught);
        Assert.assertFalse((boolean)rm.getRMContext().getRMDelegationTokenSecretManager().getAllTokens().containsKey(ident));
    }

    private static String generateRenewTokenBody(String mediaType, String token) throws Exception {
        Object body = "";
        if (mediaType.contains("application/json")) {
            DelegationToken dToken = new DelegationToken();
            dToken.setToken(token);
            body = TestWebServiceUtil.toJson(dToken, DelegationToken.class);
        } else {
            body = "<delegation-token><token>" + token + "</token></delegation-token>";
        }
        return body;
    }

    static {
        httpSpnegoKeytabFile = new File(KerberosTestUtils.getKeytabFile());
        httpSpnegoPrincipal = KerberosTestUtils.getServerPrincipal();
    }

    private class KerberosAuth
    extends JerseyBinder {
        private KerberosAuth() {
        }

        @Override
        public void configureScheduler() {
            TestRMWebServicesDelegationTokens.this.isKerberosAuth = true;
            this.getConf().set("hadoop.security.authentication", "kerberos");
            this.getConf().set("yarn.resourcemanager.webapp.spnego-principal", httpSpnegoPrincipal);
            this.getConf().set("yarn.resourcemanager.webapp.spnego-keytab-file", httpSpnegoKeytabFile.getAbsolutePath());
            this.getConf().set("yarn.nodemanager.webapp.spnego-principal", httpSpnegoPrincipal);
            this.getConf().set("yarn.nodemanager.webapp.spnego-keytab-file", httpSpnegoKeytabFile.getAbsolutePath());
        }
    }

    private class SimpleAuth
    extends JerseyBinder {
        private SimpleAuth() {
        }

        @Override
        public void configureScheduler() {
            TestRMWebServicesDelegationTokens.this.isKerberosAuth = false;
            this.getConf().set("hadoop.security.authentication", "simple");
        }
    }

    public static class TestSimpleAuthFilter
    extends AuthenticationFilter {
        protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
            Properties properties = super.getConfiguration(configPrefix, filterConfig);
            properties.put("kerberos.principal", httpSpnegoPrincipal);
            properties.put("kerberos.keytab", httpSpnegoKeytabFile.getAbsolutePath());
            properties.put("type", "simple");
            properties.put("simple.anonymous.allowed", "false");
            return properties;
        }
    }

    public static class TestKerberosAuthFilter
    extends AuthenticationFilter {
        protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
            Properties properties = super.getConfiguration(configPrefix, filterConfig);
            properties.put("kerberos.principal", httpSpnegoPrincipal);
            properties.put("kerberos.keytab", httpSpnegoKeytabFile.getAbsolutePath());
            properties.put("type", "kerberos");
            return properties;
        }
    }

    private class JerseyBinder
    extends AbstractBinder {
        private Configuration conf = new YarnConfiguration();

        private JerseyBinder() {
        }

        protected void configure() {
            this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
            this.conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
            this.conf.setBoolean("yarn.acl.enable", true);
            rm = TestWebServiceUtil.createRM(this.conf);
            this.configureScheduler();
            Mockito.when((Object)TestRMWebServicesDelegationTokens.this.request.getScheme()).thenReturn((Object)"http");
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            ((InstanceBinding)this.bind((Object)rm).to(ResourceManager.class)).named("rm");
            ((InstanceBinding)this.bind(this.conf).to(Configuration.class)).named("conf");
            this.bind(TestRMWebServicesDelegationTokens.this.request).to(HttpServletRequest.class);
            this.bind(response).to(HttpServletResponse.class);
            Principal principal1 = () -> "testuser";
            Mockito.when((Object)TestRMWebServicesDelegationTokens.this.request.getUserPrincipal()).thenReturn((Object)principal1);
            if (TestRMWebServicesDelegationTokens.this.isKerberosAuth) {
                this.bind(TestKerberosAuthFilter.class);
            } else {
                this.bind(TestSimpleAuthFilter.class);
            }
        }

        public void configureScheduler() {
        }

        public Configuration getConf() {
            return this.conf;
        }
    }
}

