/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.helper.AppInfoJsonVerifications;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.helper.AppInfoXmlVerifications;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.helper.ResourceRequestsJsonVerifications;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.helper.ResourceRequestsXmlVerifications;
import org.apache.hadoop.yarn.util.resource.CustomResourceTypesConfigurationProvider;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestRMWebServicesCustomResourceTypesCommons {
    static void verifyAppsXML(NodeList appArray, RMApp app, ResourceManager rm) {
        for (int i = 0; i < appArray.getLength(); ++i) {
            Element element = (Element)appArray.item(i);
            AppInfoXmlVerifications.verify(element, app);
            NodeList resourceRequests = element.getElementsByTagName("resourceRequests");
            Assert.assertEquals((long)1L, (long)resourceRequests.getLength());
            Node resourceRequest = resourceRequests.item(0);
            ResourceRequest rr = (ResourceRequest)((AbstractYarnScheduler)rm.getRMContext().getScheduler()).getApplicationAttempt(app.getCurrentAppAttempt().getAppAttemptId()).getAppSchedulingInfo().getAllResourceRequests().get(0);
            ResourceRequestsXmlVerifications.verifyWithCustomResourceTypes((Element)resourceRequest, rr, CustomResourceTypesConfigurationProvider.getCustomResourceTypes());
        }
    }

    static void verifyAppInfoJson(JSONObject info, RMApp app, ResourceManager rm) throws JSONException {
        int expectedNumberOfElements = TestRMWebServicesCustomResourceTypesCommons.getExpectedNumberOfElements(app);
        Assert.assertEquals((String)"incorrect number of elements", (long)expectedNumberOfElements, (long)info.length());
        AppInfoJsonVerifications.verify(info, app);
        JSONArray resourceRequests = TestRMWebServicesCustomResourceTypesCommons.parseResourceRequests(info);
        JSONObject requestInfo = resourceRequests.getJSONObject(0);
        ResourceRequest rr = (ResourceRequest)((AbstractYarnScheduler)rm.getRMContext().getScheduler()).getApplicationAttempt(app.getCurrentAppAttempt().getAppAttemptId()).getAppSchedulingInfo().getAllResourceRequests().get(0);
        ResourceRequestsJsonVerifications.verifyWithCustomResourceTypes(requestInfo, rr, CustomResourceTypesConfigurationProvider.getCustomResourceTypes());
    }

    public static JSONArray parseResourceRequests(JSONObject info) throws JSONException {
        Object resourceRequests = info.get("resourceRequests");
        if (resourceRequests instanceof JSONArray) {
            return info.getJSONArray("resourceRequests");
        }
        if (resourceRequests instanceof JSONObject) {
            JSONObject resourceRequest = info.getJSONObject("resourceRequests");
            JSONArray jsonArray = new JSONArray();
            jsonArray.put((Object)resourceRequest);
            return jsonArray;
        }
        return null;
    }

    static int getExpectedNumberOfElements(RMApp app) {
        int expectedNumberOfElements = 42;
        if (app.getApplicationSubmissionContext().getNodeLabelExpression() != null) {
            ++expectedNumberOfElements;
        }
        if (((ResourceRequest)app.getAMResourceRequests().get(0)).getNodeLabelExpression() != null) {
            ++expectedNumberOfElements;
        }
        if (AppInfo.getAmRPCAddressFromRMAppAttempt((RMAppAttempt)app.getCurrentAppAttempt()) != null) {
            ++expectedNumberOfElements;
        }
        return expectedNumberOfElements;
    }
}

