/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.SignalContainerCommand;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServicesAppsModification;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.reader.ApplicationSubmissionContextInfoReader;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.writer.ApplicationSubmissionContextInfoWriter;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRMWebServicesContainers
extends JerseyTestBase {
    private static MockRM rm;
    private static String userName;

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register(RMWebServices.class);
        config.register((Object)new JerseyBinder());
        config.register(GenericExceptionHandler.class);
        config.register(ApplicationSubmissionContextInfoWriter.class);
        config.register(ApplicationSubmissionContextInfoReader.class);
        config.register(TestRMWebServicesAppsModification.TestRMCustomAuthFilter.class);
        config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        this.forceSet("jersey.config.test.container.port", "0");
        return config;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testSignalContainer() throws Exception {
        rm.start();
        MockNM nm = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app = MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).build());
        nm.nodeHeartbeat(true);
        MockRM.waitForState(app.getCurrentAppAttempt(), RMAppAttemptState.ALLOCATED);
        rm.sendAMLaunched(app.getCurrentAppAttempt().getAppAttemptId());
        WebTarget r = this.target();
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("containers").path(app.getCurrentAppAttempt().getMasterContainer().getId().toString()).path("signal").path("not-exist-signal").queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).post(null, Response.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Assert.assertTrue((boolean)((String)response.readEntity(String.class)).contains("Invalid command: NOT-EXIST-SIGNAL"));
        response = (Response)r.path("ws").path("v1").path("cluster").path("containers").path("XXX").path("signal").path(SignalContainerCommand.OUTPUT_THREAD_DUMP.name()).queryParam("user.name", new Object[]{userName}).request().accept(new String[]{"application/json"}).post(null, Response.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
        Assert.assertTrue((boolean)((String)response.readEntity(String.class)).contains("Invalid ContainerId"));
        response = (Response)r.path("ws").path("v1").path("cluster").path("containers").path(app.getCurrentAppAttempt().getMasterContainer().getId().toString()).path("signal").path(SignalContainerCommand.OUTPUT_THREAD_DUMP.name()).queryParam("user.name", new Object[]{userName}).request().accept(new String[]{"application/json"}).post(null, Response.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        response = (Response)r.path("ws").path("v1").path("cluster").path("containers").path(app.getCurrentAppAttempt().getMasterContainer().getId().toString()).path("signal").path(SignalContainerCommand.OUTPUT_THREAD_DUMP.name()).queryParam("user.name", new Object[]{"admin"}).request(new String[]{"application/json"}).post(null, Response.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        rm.stop();
    }

    private class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            try {
                userName = UserGroupInformation.getCurrentUser().getShortUserName();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to get current user name " + ioe.getMessage(), ioe);
            }
            Configuration conf = new Configuration();
            conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
            conf.set("yarn.admin.acl", "admin");
            rm = new MockRM(conf);
            ((InstanceBinding)this.bind((Object)rm).to(ResourceManager.class)).named("rm");
            ((InstanceBinding)this.bind(conf).to(Configuration.class)).named("conf");
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Principal principal = () -> userName;
            Mockito.when((Object)request.getUserPrincipal()).thenReturn((Object)principal);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            this.bind(request).to(HttpServletRequest.class);
            this.bind(response).to(HttpServletResponse.class);
        }
    }
}

