/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePrefixes;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServicesAppsModification;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestWebServiceUtil;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeLabelInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeLabelsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.reader.NodeLabelsInfoReader;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.writer.SchedConfUpdateInfoWriter;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.dao.QueueConfigInfo;
import org.apache.hadoop.yarn.webapp.dao.SchedConfUpdateInfo;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRMWebServicesConfigurationMutation
extends JerseyTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestRMWebServicesConfigurationMutation.class);
    private static final String LABEL_1 = "label1";
    public static final QueuePath ROOT = new QueuePath("root");
    public static final QueuePath ROOT_A = new QueuePath("root", "a");
    public static final QueuePath ROOT_A_A1 = QueuePath.createFromQueues((String[])new String[]{"root", "a", "a1"});
    public static final QueuePath ROOT_A_A2 = QueuePath.createFromQueues((String[])new String[]{"root", "a", "a2"});
    public static final QueuePath ROOT_B = new QueuePath("root", "b");
    public static final QueuePath ROOT_C = new QueuePath("root", "c");
    public static final QueuePath ROOT_C_C1 = QueuePath.createFromQueues((String[])new String[]{"root", "c", "c1"});
    public static final QueuePath ROOT_D = new QueuePath("root", "d");
    private static MockRM rm;
    private static String userName;
    private static CapacitySchedulerConfiguration csConf;
    private static YarnConfiguration conf;
    private HttpServletRequest request;

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register(RMWebServices.class);
        config.register((Object)new JerseyBinder());
        config.register(GenericExceptionHandler.class);
        config.register(NodeLabelsInfoReader.class);
        config.register(TestRMWebServicesAppsModification.TestRMCustomAuthFilter.class);
        config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        return config;
    }

    @BeforeClass
    public static void beforeClass() {
        TestWebServiceUtil.backupSchedulerConfigFileInTarget();
    }

    @AfterClass
    public static void afterClass() {
        TestWebServiceUtil.restoreSchedulerConfigFileInTarget();
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    private static void setupQueueConfiguration(CapacitySchedulerConfiguration config) {
        config.setQueues(ROOT, new String[]{"a", "b", "c", "mappedqueue"});
        config.setCapacity(ROOT_A, 25.0f);
        config.setMaximumCapacity(ROOT_A, 50.0f);
        config.setQueues(ROOT_A, new String[]{"a1", "a2"});
        config.setCapacity(ROOT_A_A1, 100.0f);
        config.setCapacity(ROOT_A_A2, 0.0f);
        config.setCapacity(ROOT_B, 75.0f);
        config.setCapacity(ROOT_C, 0.0f);
        config.setQueues(ROOT_C, new String[]{"c1"});
        config.setCapacity(ROOT_C_C1, 0.0f);
        config.setCapacity(ROOT_D, 0.0f);
        config.set("yarn.scheduler.capacity.queue-mappings", "g:hadoop:mappedqueue");
    }

    private CapacitySchedulerConfiguration getSchedulerConf() throws JSONException {
        WebTarget r = this.targetWithJsonObject();
        Response response = (Response)r.path("ws").path("v1").path("cluster").queryParam("user.name", new Object[]{userName}).path("scheduler-conf").request(new String[]{"application/json"}).get(Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        JSONObject json = ((JSONObject)response.readEntity(JSONObject.class)).getJSONObject("configuration");
        JSONArray items = (JSONArray)json.get("property");
        CapacitySchedulerConfiguration parsedConf = new CapacitySchedulerConfiguration();
        for (int i = 0; i < items.length(); ++i) {
            JSONObject obj = (JSONObject)items.get(i);
            parsedConf.set(obj.get("name").toString(), obj.get("value").toString());
        }
        return parsedConf;
    }

    @Test
    public void testGetSchedulerConf() throws Exception {
        CapacitySchedulerConfiguration orgConf = this.getSchedulerConf();
        Assert.assertNotNull((Object)orgConf);
        Assert.assertEquals((long)4L, (long)orgConf.getQueues(ROOT).size());
    }

    @Test
    public void testFormatSchedulerConf() throws Exception {
        CapacitySchedulerConfiguration newConf = this.getSchedulerConf();
        Assert.assertNotNull((Object)newConf);
        Assert.assertEquals((long)4L, (long)newConf.getQueues(ROOT).size());
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> nearEmptyCapacity = new HashMap<String, String>();
        nearEmptyCapacity.put("capacity", "1E-4");
        QueueConfigInfo d = new QueueConfigInfo("root.formattest", nearEmptyCapacity);
        updateInfo.getAddQueueInfo().add(d);
        HashMap<String, String> stoppedParam = new HashMap<String, String>();
        stoppedParam.put("state", QueueState.STOPPED.toString());
        QueueConfigInfo stoppedInfo = new QueueConfigInfo("root.formattest", stoppedParam);
        updateInfo.getUpdateQueueInfo().add(stoppedInfo);
        WebTarget r = (WebTarget)this.target().register(SchedConfUpdateInfoWriter.class);
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).put(Entity.entity((Object)updateInfo, (String)"application/json"), Response.class);
        newConf = this.getSchedulerConf();
        Assert.assertNotNull((Object)newConf);
        Assert.assertEquals((long)5L, (long)newConf.getQueues(ROOT).size());
        response = (Response)r.path("ws").path("v1").path("cluster").queryParam("user.name", new Object[]{userName}).path("/scheduler-conf/format").request(new String[]{"application/json"}).get(Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        newConf = this.getSchedulerConf();
        Assert.assertEquals((long)4L, (long)newConf.getQueues(ROOT).size());
    }

    private long getConfigVersion() throws Exception {
        WebTarget r = this.targetWithJsonObject();
        Response response = (Response)r.path("ws").path("v1").path("cluster").queryParam("user.name", new Object[]{userName}).path("/scheduler-conf/version").request(new String[]{"application/json"}).get(Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        JSONObject json = ((JSONObject)response.readEntity(JSONObject.class)).getJSONObject("configversion");
        return Long.parseLong(json.get("versionID").toString());
    }

    @Test
    public void testSchedulerConfigVersion() throws Exception {
        Assert.assertEquals((long)1L, (long)this.getConfigVersion());
        this.testAddNestedQueue();
        Assert.assertEquals((long)2L, (long)this.getConfigVersion());
    }

    @Test
    public void testAddNestedQueue() throws Exception {
        CapacitySchedulerConfiguration orgConf = this.getSchedulerConf();
        Assert.assertNotNull((Object)orgConf);
        Assert.assertEquals((long)4L, (long)orgConf.getQueues(ROOT).size());
        WebTarget r = (WebTarget)this.target().register(SchedConfUpdateInfoWriter.class);
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> d1Capacity = new HashMap<String, String>();
        d1Capacity.put("capacity", "25");
        d1Capacity.put("maximum-capacity", "25");
        HashMap<String, String> nearEmptyCapacity = new HashMap<String, String>();
        nearEmptyCapacity.put("capacity", "1E-4");
        nearEmptyCapacity.put("maximum-capacity", "1E-4");
        HashMap<String, String> d2Capacity = new HashMap<String, String>();
        d2Capacity.put("capacity", "75");
        d2Capacity.put("maximum-capacity", "75");
        QueueConfigInfo d1 = new QueueConfigInfo("root.d.d1", d1Capacity);
        QueueConfigInfo d2 = new QueueConfigInfo("root.d.d2", d2Capacity);
        QueueConfigInfo d = new QueueConfigInfo("root.d", nearEmptyCapacity);
        updateInfo.getAddQueueInfo().add(d1);
        updateInfo.getAddQueueInfo().add(d2);
        updateInfo.getAddQueueInfo().add(d);
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).put(Entity.entity((Object)updateInfo, (String)"application/json"), Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        Assert.assertEquals((long)5L, (long)newCSConf.getQueues(ROOT).size());
        Assert.assertEquals((long)2L, (long)newCSConf.getQueues(ROOT_D).size());
        Assert.assertEquals((float)25.0f, (float)newCSConf.getNonLabeledQueueCapacity(new QueuePath("root.d.d1")), (float)0.01f);
        Assert.assertEquals((float)75.0f, (float)newCSConf.getNonLabeledQueueCapacity(new QueuePath("root.d.d2")), (float)0.01f);
        CapacitySchedulerConfiguration newConf = this.getSchedulerConf();
        Assert.assertNotNull((Object)newConf);
        Assert.assertEquals((long)5L, (long)newConf.getQueues(ROOT).size());
    }

    @Test
    public void testAddWithUpdate() throws Exception {
        WebTarget r = (WebTarget)this.target().register(SchedConfUpdateInfoWriter.class);
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> dCapacity = new HashMap<String, String>();
        dCapacity.put("capacity", "25");
        HashMap<String, String> bCapacity = new HashMap<String, String>();
        bCapacity.put("capacity", "50");
        QueueConfigInfo d = new QueueConfigInfo("root.d", dCapacity);
        QueueConfigInfo b = new QueueConfigInfo("root.b", bCapacity);
        updateInfo.getAddQueueInfo().add(d);
        updateInfo.getUpdateQueueInfo().add(b);
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).put(Entity.entity((Object)updateInfo, (String)"application/json"), Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        Assert.assertEquals((long)5L, (long)newCSConf.getQueues(ROOT).size());
        Assert.assertEquals((float)25.0f, (float)newCSConf.getNonLabeledQueueCapacity(new QueuePath("root.d")), (float)0.01f);
        Assert.assertEquals((float)50.0f, (float)newCSConf.getNonLabeledQueueCapacity(new QueuePath("root.b")), (float)0.01f);
    }

    @Test
    public void testUnsetParentQueueOrderingPolicy() throws Exception {
        WebTarget r = (WebTarget)this.target().register(SchedConfUpdateInfoWriter.class);
        SchedConfUpdateInfo updateInfo1 = new SchedConfUpdateInfo();
        HashMap<String, String> updateParam = new HashMap<String, String>();
        updateParam.put("ordering-policy", "fair");
        QueueConfigInfo aUpdateInfo = new QueueConfigInfo("root.b", updateParam);
        updateInfo1.getUpdateQueueInfo().add(aUpdateInfo);
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).put(Entity.entity((Object)updateInfo1, (String)"application/json"), Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        String bOrderingPolicy = "yarn.scheduler.capacity.root.b.ordering-policy";
        Assert.assertEquals((Object)"fair", (Object)newCSConf.get(bOrderingPolicy));
        this.stopQueue(ROOT_B);
        SchedConfUpdateInfo updateInfo2 = new SchedConfUpdateInfo();
        HashMap<String, String> capacity = new HashMap<String, String>();
        capacity.put("capacity", "100");
        QueueConfigInfo b1 = new QueueConfigInfo("root.b.b1", capacity);
        updateInfo2.getAddQueueInfo().add(b1);
        response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).put(Entity.entity((Object)updateInfo2, (String)"application/json"), Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        bOrderingPolicy = "yarn.scheduler.capacity.root.b.ordering-policy";
        Assert.assertNull((String)"Failed to unset Parent Queue OrderingPolicy", (Object)newCSConf.get(bOrderingPolicy));
    }

    @Test
    public void testUnsetLeafQueueOrderingPolicy() throws Exception {
        WebTarget r = (WebTarget)this.target().register(SchedConfUpdateInfoWriter.class);
        SchedConfUpdateInfo updateInfo1 = new SchedConfUpdateInfo();
        HashMap<String, String> updateParam = new HashMap<String, String>();
        updateParam.put("ordering-policy", "priority-utilization");
        QueueConfigInfo aUpdateInfo = new QueueConfigInfo("root.c", updateParam);
        updateInfo1.getUpdateQueueInfo().add(aUpdateInfo);
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).put(Entity.entity((Object)updateInfo1, (String)"application/json"), Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        String cOrderingPolicy = "yarn.scheduler.capacity.root.c.ordering-policy";
        Assert.assertEquals((Object)"priority-utilization", (Object)newCSConf.get(cOrderingPolicy));
        this.stopQueue(ROOT_C_C1);
        SchedConfUpdateInfo updateInfo2 = new SchedConfUpdateInfo();
        updateInfo2.getRemoveQueueInfo().add("root.c.c1");
        response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).put(Entity.entity((Object)updateInfo2, (String)"application/json"), Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        cOrderingPolicy = "yarn.scheduler.capacity.root.c.ordering-policy";
        Assert.assertNull((String)"Failed to unset Leaf Queue OrderingPolicy", (Object)newCSConf.get(cOrderingPolicy));
    }

    @Test
    public void testRemoveQueue() throws Exception {
        WebTarget r = (WebTarget)this.target().register(SchedConfUpdateInfoWriter.class);
        this.stopQueue(ROOT_A_A2);
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        updateInfo.getRemoveQueueInfo().add("root.a.a2");
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).put(Entity.entity((Object)updateInfo, (String)"application/json"), Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        Assert.assertEquals((String)"Failed to remove the queue", (long)1L, (long)newCSConf.getQueues(ROOT_A).size());
        Assert.assertEquals((String)"Failed to remove the right queue", (Object)"a1", newCSConf.getQueues(ROOT_A).get(0));
    }

    @Test
    public void testStopWithRemoveQueue() throws Exception {
        WebTarget r = (WebTarget)this.target().register(SchedConfUpdateInfoWriter.class);
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> stoppedParam = new HashMap<String, String>();
        stoppedParam.put("state", QueueState.STOPPED.toString());
        QueueConfigInfo stoppedInfo = new QueueConfigInfo("root.a.a2", stoppedParam);
        updateInfo.getUpdateQueueInfo().add(stoppedInfo);
        updateInfo.getRemoveQueueInfo().add("root.a.a2");
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).put(Entity.entity((Object)updateInfo, (String)"application/json"), Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        Assert.assertEquals((long)1L, (long)newCSConf.getQueues(ROOT_A).size());
        Assert.assertEquals((Object)"a1", newCSConf.getQueues(ROOT_A).get(0));
    }

    @Test
    public void testRemoveQueueWhichHasQueueMapping() throws Exception {
        WebTarget r = (WebTarget)this.target().register(SchedConfUpdateInfoWriter.class);
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        Assert.assertNotNull((String)"Failed to setup CapacityScheduler Configuration", (Object)cs.getQueue("mappedqueue"));
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> stoppedParam = new HashMap<String, String>();
        stoppedParam.put("state", QueueState.STOPPED.toString());
        QueueConfigInfo stoppedInfo = new QueueConfigInfo("root.mappedqueue", stoppedParam);
        updateInfo.getUpdateQueueInfo().add(stoppedInfo);
        updateInfo.getRemoveQueueInfo().add("root.mappedqueue");
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).put(Entity.entity((Object)updateInfo, (String)"application/json"), Response.class);
        String responseText = (String)response.readEntity(String.class);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Assert.assertTrue((boolean)responseText.contains("Failed to re-init queues : org.apache.hadoop.yarn.exceptions.YarnException: Path root 'mappedqueue' does not exist. Path 'mappedqueue' is invalid"));
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        Assert.assertEquals((long)4L, (long)newCSConf.getQueues(ROOT).size());
        Assert.assertNotNull((String)"CapacityScheduler Configuration is corrupt", (Object)cs.getQueue("mappedqueue"));
    }

    @Test
    public void testStopWithConvertLeafToParentQueue() throws Exception {
        WebTarget r = (WebTarget)this.target().register(SchedConfUpdateInfoWriter.class);
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> stoppedParam = new HashMap<String, String>();
        stoppedParam.put("state", QueueState.STOPPED.toString());
        QueueConfigInfo stoppedInfo = new QueueConfigInfo("root.b", stoppedParam);
        updateInfo.getUpdateQueueInfo().add(stoppedInfo);
        HashMap<String, String> b1Capacity = new HashMap<String, String>();
        b1Capacity.put("capacity", "100");
        QueueConfigInfo b1 = new QueueConfigInfo("root.b.b1", b1Capacity);
        updateInfo.getAddQueueInfo().add(b1);
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).put(Entity.entity((Object)updateInfo, (String)"application/json"), Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        Assert.assertEquals((long)1L, (long)newCSConf.getQueues(ROOT_B).size());
        Assert.assertEquals((Object)"b1", newCSConf.getQueues(ROOT_B).get(0));
    }

    @Test
    public void testRemoveParentQueue() throws Exception {
        WebTarget r = (WebTarget)this.target().register(SchedConfUpdateInfoWriter.class);
        this.stopQueue(ROOT_C, ROOT_C_C1);
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        updateInfo.getRemoveQueueInfo().add("root.c");
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).put(Entity.entity((Object)updateInfo, (String)"application/json"), Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        Assert.assertEquals((long)3L, (long)newCSConf.getQueues(ROOT).size());
        Assert.assertEquals((long)0L, (long)newCSConf.getQueues(ROOT_C).size());
    }

    @Test
    public void testRemoveParentQueueWithCapacity() throws Exception {
        WebTarget r = (WebTarget)this.target().register(SchedConfUpdateInfoWriter.class);
        this.stopQueue(ROOT_A, ROOT_A_A1, ROOT_A_A2);
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        updateInfo.getRemoveQueueInfo().add("root.a");
        HashMap<String, String> bCapacity = new HashMap<String, String>();
        bCapacity.put("capacity", "100");
        QueueConfigInfo b = new QueueConfigInfo("root.b", bCapacity);
        updateInfo.getUpdateQueueInfo().add(b);
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).put(Entity.entity((Object)updateInfo, (String)"application/json"), Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        Assert.assertEquals((long)3L, (long)newCSConf.getQueues(ROOT).size());
        Assert.assertEquals((float)100.0f, (float)newCSConf.getNonLabeledQueueCapacity(new QueuePath("root.b")), (float)0.01f);
    }

    @Test
    public void testRemoveMultipleQueues() throws Exception {
        WebTarget r = (WebTarget)this.target().register(SchedConfUpdateInfoWriter.class);
        this.stopQueue(ROOT_B, ROOT_C, ROOT_C_C1);
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        updateInfo.getRemoveQueueInfo().add("root.b");
        updateInfo.getRemoveQueueInfo().add("root.c");
        HashMap<String, String> aCapacity = new HashMap<String, String>();
        aCapacity.put("capacity", "100");
        aCapacity.put("maximum-capacity", "100");
        QueueConfigInfo configInfo = new QueueConfigInfo("root.a", aCapacity);
        updateInfo.getUpdateQueueInfo().add(configInfo);
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).put(Entity.entity((Object)updateInfo, (String)"application/json"), Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        Assert.assertEquals((long)2L, (long)newCSConf.getQueues(ROOT).size());
    }

    private void stopQueue(QueuePath ... queuePaths) throws Exception {
        WebTarget r = (WebTarget)this.target().register(SchedConfUpdateInfoWriter.class);
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> stoppedParam = new HashMap<String, String>();
        stoppedParam.put("state", QueueState.STOPPED.toString());
        for (QueuePath queue : queuePaths) {
            QueueConfigInfo stoppedInfo = new QueueConfigInfo(queue.getFullPath(), stoppedParam);
            updateInfo.getUpdateQueueInfo().add(stoppedInfo);
        }
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).put(Entity.entity((Object)updateInfo, (String)"application/json"), Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        for (QueuePath queue : queuePaths) {
            Assert.assertEquals((Object)QueueState.STOPPED, (Object)newCSConf.getState(queue));
        }
    }

    @Test
    public void testUpdateQueue() throws Exception {
        WebTarget r = (WebTarget)this.target().register(SchedConfUpdateInfoWriter.class);
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> updateParam = new HashMap<String, String>();
        updateParam.put("maximum-am-resource-percent", "0.2");
        QueueConfigInfo aUpdateInfo = new QueueConfigInfo("root.a", updateParam);
        updateInfo.getUpdateQueueInfo().add(aUpdateInfo);
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        Assert.assertEquals((float)0.1f, (float)cs.getConfiguration().getMaximumApplicationMasterResourcePerQueuePercent(ROOT_A), (float)0.001f);
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).put(Entity.entity((Object)updateInfo, (String)"application/json"), Response.class);
        LOG.debug("Response headers: {}.", (Object)response.getHeaders());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = cs.getConfiguration();
        Assert.assertEquals((float)0.2f, (float)newCSConf.getMaximumApplicationMasterResourcePerQueuePercent(ROOT_A), (float)0.001f);
        updateParam.put("maximum-am-resource-percent", null);
        aUpdateInfo = new QueueConfigInfo("root.a", updateParam);
        updateInfo.getUpdateQueueInfo().clear();
        updateInfo.getUpdateQueueInfo().add(aUpdateInfo);
        response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).put(Entity.entity((Object)updateInfo, (String)"application/json"), Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        newCSConf = cs.getConfiguration();
        Assert.assertEquals((float)0.1f, (float)newCSConf.getMaximumApplicationMasterResourcePerQueuePercent(ROOT_A), (float)0.001f);
    }

    @Test
    public void testUpdateQueueCapacity() throws Exception {
        WebTarget r = (WebTarget)this.target().register(SchedConfUpdateInfoWriter.class);
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> updateParam = new HashMap<String, String>();
        updateParam.put("capacity", "50");
        QueueConfigInfo aUpdateInfo = new QueueConfigInfo("root.a", updateParam);
        QueueConfigInfo bUpdateInfo = new QueueConfigInfo("root.b", updateParam);
        updateInfo.getUpdateQueueInfo().add(aUpdateInfo);
        updateInfo.getUpdateQueueInfo().add(bUpdateInfo);
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).put(Entity.entity((Object)updateInfo, (String)"application/json"), Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        Assert.assertEquals((float)50.0f, (float)newCSConf.getNonLabeledQueueCapacity(new QueuePath("root.a")), (float)0.01f);
        Assert.assertEquals((float)50.0f, (float)newCSConf.getNonLabeledQueueCapacity(new QueuePath("root.b")), (float)0.01f);
    }

    @Test
    public void testGlobalConfChange() throws Exception {
        WebTarget r = (WebTarget)this.target().register(SchedConfUpdateInfoWriter.class);
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        updateInfo.getGlobalParams().put("yarn.scheduler.capacity.maximum-applications", "30000");
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).put(Entity.entity((Object)updateInfo, (String)"application/json"), Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacitySchedulerConfiguration newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        Assert.assertEquals((long)30000L, (long)newCSConf.getMaximumSystemApplications());
        updateInfo.getGlobalParams().put("yarn.scheduler.capacity.maximum-applications", null);
        response = (Response)r.path("ws").path("v1").path("cluster").path("scheduler-conf").queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).put(Entity.entity((Object)updateInfo, (String)"application/json"), Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        newCSConf = ((CapacityScheduler)rm.getResourceScheduler()).getConfiguration();
        Assert.assertEquals((long)10000L, (long)newCSConf.getMaximumSystemApplications());
    }

    @Test
    public void testNodeLabelRemovalResidualConfigsAreCleared() throws Exception {
        WebTarget r = (WebTarget)this.target().register(NodeLabelsInfoReader.class);
        NodeLabelsInfo nodeLabelsInfo = new NodeLabelsInfo();
        nodeLabelsInfo.getNodeLabelsInfo().add(new NodeLabelInfo(LABEL_1));
        WebTarget addNodeLabelsResource = r.path("ws").path("v1").path("cluster").path("add-node-labels");
        WebTarget getNodeLabelsResource = r.path("ws").path("v1").path("cluster").path("get-node-labels");
        WebTarget removeNodeLabelsResource = r.path("ws").path("v1").path("cluster").path("remove-node-labels");
        WebTarget schedulerConfResource = r.path("ws").path("v1").path("cluster").path("/scheduler-conf");
        Response response = (Response)addNodeLabelsResource.queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).post(Entity.entity((Object)this.logAndReturnJson(addNodeLabelsResource, TestWebServiceUtil.toJson(nodeLabelsInfo, NodeLabelsInfo.class)), (String)"application/json"), Response.class);
        response = (Response)getNodeLabelsResource.queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).get(Response.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        nodeLabelsInfo = (NodeLabelsInfo)response.readEntity(NodeLabelsInfo.class);
        Assert.assertEquals((long)1L, (long)nodeLabelsInfo.getNodeLabels().size());
        for (NodeLabelInfo nl : nodeLabelsInfo.getNodeLabelsInfo()) {
            Assert.assertEquals((Object)LABEL_1, (Object)nl.getName());
            Assert.assertTrue((boolean)nl.getExclusivity());
        }
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> updateForRoot = new HashMap<String, String>();
        updateForRoot.put("accessible-node-labels", "*");
        QueueConfigInfo rootUpdateInfo = new QueueConfigInfo(ROOT.getFullPath(), updateForRoot);
        HashMap<String, String> updateForRootA = new HashMap<String, String>();
        updateForRootA.put("accessible-node-labels", LABEL_1);
        QueueConfigInfo rootAUpdateInfo = new QueueConfigInfo(ROOT_A.getFullPath(), updateForRootA);
        updateInfo.getUpdateQueueInfo().add(rootUpdateInfo);
        updateInfo.getUpdateQueueInfo().add(rootAUpdateInfo);
        response = (Response)schedulerConfResource.queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).put(Entity.entity((Object)this.logAndReturnJson(schedulerConfResource, TestWebServiceUtil.toJson(updateInfo, SchedConfUpdateInfo.class)), (String)"application/json"), Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"*"}), (Object)cs.getConfiguration().getAccessibleNodeLabels(ROOT));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{LABEL_1}), (Object)cs.getConfiguration().getAccessibleNodeLabels(ROOT_A));
        updateInfo = new SchedConfUpdateInfo();
        updateForRoot = new HashMap();
        updateForRoot.put(this.getAccessibleNodeLabelsCapacityPropertyName(LABEL_1), "100");
        updateForRoot.put(this.getAccessibleNodeLabelsMaxCapacityPropertyName(LABEL_1), "100");
        rootUpdateInfo = new QueueConfigInfo(ROOT.getFullPath(), updateForRoot);
        updateForRootA = new HashMap();
        updateForRootA.put(this.getAccessibleNodeLabelsCapacityPropertyName(LABEL_1), "100");
        updateForRootA.put(this.getAccessibleNodeLabelsMaxCapacityPropertyName(LABEL_1), "100");
        rootAUpdateInfo = new QueueConfigInfo(ROOT_A.getFullPath(), updateForRootA);
        HashMap<String, String> updateForRootA_A1 = new HashMap<String, String>();
        updateForRootA_A1.put(this.getAccessibleNodeLabelsCapacityPropertyName(LABEL_1), "20");
        updateForRootA_A1.put(this.getAccessibleNodeLabelsMaxCapacityPropertyName(LABEL_1), "20");
        QueueConfigInfo rootA_A1UpdateInfo = new QueueConfigInfo(ROOT_A_A1.getFullPath(), updateForRootA_A1);
        HashMap<String, String> updateForRootA_A2 = new HashMap<String, String>();
        updateForRootA_A2.put(this.getAccessibleNodeLabelsCapacityPropertyName(LABEL_1), "80");
        updateForRootA_A2.put(this.getAccessibleNodeLabelsMaxCapacityPropertyName(LABEL_1), "80");
        QueueConfigInfo rootA_A2UpdateInfo = new QueueConfigInfo(ROOT_A_A2.getFullPath(), updateForRootA_A2);
        updateInfo.getUpdateQueueInfo().add(rootUpdateInfo);
        updateInfo.getUpdateQueueInfo().add(rootAUpdateInfo);
        updateInfo.getUpdateQueueInfo().add(rootA_A1UpdateInfo);
        updateInfo.getUpdateQueueInfo().add(rootA_A2UpdateInfo);
        response = (Response)schedulerConfResource.queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).put(Entity.entity((Object)this.logAndReturnJson(schedulerConfResource, TestWebServiceUtil.toJson(updateInfo, SchedConfUpdateInfo.class)), (String)"application/json"), Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((double)100.0, (double)cs.getConfiguration().getLabeledQueueCapacity(ROOT, LABEL_1), (double)0.001f);
        Assert.assertEquals((double)100.0, (double)cs.getConfiguration().getLabeledQueueMaximumCapacity(ROOT, LABEL_1), (double)0.001f);
        Assert.assertEquals((double)100.0, (double)cs.getConfiguration().getLabeledQueueCapacity(ROOT_A, LABEL_1), (double)0.001f);
        Assert.assertEquals((double)100.0, (double)cs.getConfiguration().getLabeledQueueMaximumCapacity(ROOT_A, LABEL_1), (double)0.001f);
        Assert.assertEquals((double)20.0, (double)cs.getConfiguration().getLabeledQueueCapacity(ROOT_A_A1, LABEL_1), (double)0.001f);
        Assert.assertEquals((double)20.0, (double)cs.getConfiguration().getLabeledQueueMaximumCapacity(ROOT_A_A1, LABEL_1), (double)0.001f);
        Assert.assertEquals((double)80.0, (double)cs.getConfiguration().getLabeledQueueCapacity(ROOT_A_A2, LABEL_1), (double)0.001f);
        Assert.assertEquals((double)80.0, (double)cs.getConfiguration().getLabeledQueueMaximumCapacity(ROOT_A_A2, LABEL_1), (double)0.001f);
        updateInfo = new SchedConfUpdateInfo();
        updateForRoot = new HashMap();
        updateForRoot.put("accessible-node-labels", "*");
        updateForRoot.put(this.getAccessibleNodeLabelsCapacityPropertyName(LABEL_1), "");
        updateForRoot.put(this.getAccessibleNodeLabelsMaxCapacityPropertyName(LABEL_1), "");
        rootUpdateInfo = new QueueConfigInfo(ROOT.getFullPath(), updateForRoot);
        updateForRootA = new HashMap();
        updateForRootA.put("accessible-node-labels", "");
        updateForRootA.put(this.getAccessibleNodeLabelsCapacityPropertyName(LABEL_1), "");
        updateForRootA.put(this.getAccessibleNodeLabelsMaxCapacityPropertyName(LABEL_1), "");
        rootAUpdateInfo = new QueueConfigInfo(ROOT_A.getFullPath(), updateForRootA);
        updateForRootA_A1 = new HashMap();
        updateForRootA_A1.put("accessible-node-labels", "");
        updateForRootA_A1.put(this.getAccessibleNodeLabelsCapacityPropertyName(LABEL_1), "");
        updateForRootA_A1.put(this.getAccessibleNodeLabelsMaxCapacityPropertyName(LABEL_1), "");
        rootA_A1UpdateInfo = new QueueConfigInfo(ROOT_A_A1.getFullPath(), updateForRootA_A1);
        updateForRootA_A2 = new HashMap();
        updateForRootA_A2.put("accessible-node-labels", "");
        updateForRootA_A2.put(this.getAccessibleNodeLabelsCapacityPropertyName(LABEL_1), "");
        updateForRootA_A2.put(this.getAccessibleNodeLabelsMaxCapacityPropertyName(LABEL_1), "");
        rootA_A2UpdateInfo = new QueueConfigInfo(ROOT_A_A2.getFullPath(), updateForRootA_A2);
        updateInfo.getUpdateQueueInfo().add(rootUpdateInfo);
        updateInfo.getUpdateQueueInfo().add(rootAUpdateInfo);
        updateInfo.getUpdateQueueInfo().add(rootA_A1UpdateInfo);
        updateInfo.getUpdateQueueInfo().add(rootA_A2UpdateInfo);
        response = (Response)schedulerConfResource.queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).put(Entity.entity((Object)this.logAndReturnJson(schedulerConfResource, TestWebServiceUtil.toJson(updateInfo, SchedConfUpdateInfo.class)), (String)"application/json"), Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"*"}), (Object)cs.getConfiguration().getAccessibleNodeLabels(ROOT));
        Assert.assertNull((Object)cs.getConfiguration().getAccessibleNodeLabels(ROOT_A));
        response = (Response)removeNodeLabelsResource.queryParam("user.name", new Object[]{userName}).queryParam("labels", new Object[]{LABEL_1}).request(new String[]{"application/json"}).post(null, Response.class);
        response = (Response)getNodeLabelsResource.queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).get(Response.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        nodeLabelsInfo = (NodeLabelsInfo)response.readEntity(NodeLabelsInfo.class);
        Assert.assertEquals((long)0L, (long)nodeLabelsInfo.getNodeLabels().size());
        Assert.assertNull((Object)this.getConfValueForQueueAndLabelAndType(cs, ROOT, LABEL_1, "capacity"));
        Assert.assertNull((Object)this.getConfValueForQueueAndLabelAndType(cs, ROOT, LABEL_1, "maximum-capacity"));
        Assert.assertNull((Object)this.getConfValueForQueueAndLabelAndType(cs, ROOT_A, LABEL_1, "capacity"));
        Assert.assertNull((Object)this.getConfValueForQueueAndLabelAndType(cs, ROOT_A, LABEL_1, "maximum-capacity"));
        Assert.assertNull((Object)this.getConfValueForQueueAndLabelAndType(cs, ROOT_A_A1, LABEL_1, "capacity"));
        Assert.assertNull((Object)this.getConfValueForQueueAndLabelAndType(cs, ROOT_A_A1, LABEL_1, "maximum-capacity"));
        Assert.assertNull((Object)this.getConfValueForQueueAndLabelAndType(cs, ROOT_A_A2, LABEL_1, "capacity"));
        Assert.assertNull((Object)this.getConfValueForQueueAndLabelAndType(cs, ROOT_A_A2, LABEL_1, "maximum-capacity"));
    }

    private String getConfValueForQueueAndLabelAndType(CapacityScheduler cs, QueuePath queuePath, String label, String type) {
        return cs.getConfiguration().get(QueuePrefixes.getNodeLabelPrefix((QueuePath)queuePath, (String)label) + type);
    }

    private Object logAndReturnJson(WebTarget ws, String json) {
        LOG.info("Sending to web resource: {}, json: {}", (Object)ws, (Object)json);
        return json;
    }

    private String getAccessibleNodeLabelsCapacityPropertyName(String label) {
        return String.format("%s.%s.%s", "accessible-node-labels", label, "capacity");
    }

    private String getAccessibleNodeLabelsMaxCapacityPropertyName(String label) {
        return String.format("%s.%s.%s", "accessible-node-labels", label, "maximum-capacity");
    }

    @Test
    public void testValidateWithClusterMaxAllocation() throws Exception {
        WebTarget r = (WebTarget)this.target().register(SchedConfUpdateInfoWriter.class);
        int clusterMax = 16384;
        conf.setInt("yarn.scheduler.maximum-allocation-mb", clusterMax);
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> updateParam = new HashMap<String, String>();
        updateParam.put("maximum-applications", "100");
        QueueConfigInfo aUpdateInfo = new QueueConfigInfo("root.a", updateParam);
        updateInfo.getUpdateQueueInfo().add(aUpdateInfo);
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("/scheduler-conf/validate").queryParam("user.name", new Object[]{userName}).request(new String[]{"application/json"}).post(Entity.entity((Object)updateInfo, (String)"application/json"), Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @After
    public void tearDown() throws Exception {
        if (rm != null) {
            rm.stop();
        }
        super.tearDown();
    }

    private class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            try {
                userName = UserGroupInformation.getCurrentUser().getShortUserName();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to get current user name " + ioe.getMessage(), ioe);
            }
            csConf = new CapacitySchedulerConfiguration(new Configuration(false), false);
            TestRMWebServicesConfigurationMutation.setupQueueConfiguration(csConf);
            conf = new YarnConfiguration();
            conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
            conf.set("yarn.scheduler.configuration.store.class", "memory");
            conf.set("yarn.admin.acl", userName);
            try {
                FileOutputStream out = new FileOutputStream(TestWebServiceUtil.getCapacitySchedulerConfigFileInTarget());
                csConf.writeXml((OutputStream)out);
                out.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write XML file", e);
            }
            rm = new MockRM((Configuration)conf);
            TestRMWebServicesConfigurationMutation.this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)TestRMWebServicesConfigurationMutation.this.request.getScheme()).thenReturn((Object)"http");
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            ((InstanceBinding)this.bind((Object)rm).to(ResourceManager.class)).named("rm");
            ((InstanceBinding)this.bind(csConf).to(Configuration.class)).named("conf");
            Principal principal = () -> userName;
            this.bind(TestRMWebServicesConfigurationMutation.this.request).to(HttpServletRequest.class);
            Mockito.when((Object)TestRMWebServicesConfigurationMutation.this.request.getUserPrincipal()).thenReturn((Object)principal);
            this.bind(response).to(HttpServletResponse.class);
        }
    }
}

