/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfigGeneratorForTest;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServicesAppsModification;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestWebServiceUtil;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.AfterClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRMWebServicesCapacitySchedulerMixedModeAbsoluteAndPercentage
extends JerseyTestBase {
    private static final String EXPECTED_FILE_TMPL = "webapp/mixed-%s-%s.json";
    private MockRM rm;
    private Configuration conf;
    private RMWebServices rmWebServices;

    public TestRMWebServicesCapacitySchedulerMixedModeAbsoluteAndPercentage() {
        TestWebServiceUtil.backupSchedulerConfigFileInTarget();
    }

    @AfterClass
    public static void afterClass() {
        TestWebServiceUtil.restoreSchedulerConfigFileInTarget();
    }

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register(RMWebServices.class);
        config.register((Object)new JerseyBinder());
        config.register(GenericExceptionHandler.class);
        config.register(TestRMWebServicesAppsModification.TestRMCustomAuthFilter.class);
        config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        return config;
    }

    @Test
    public void testSchedulerAbsoluteAndPercentage() throws Exception {
        TestWebServiceUtil.runTest(EXPECTED_FILE_TMPL, "testSchedulerAbsoluteAndPercentage", this.rm, this.target());
    }

    private class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            HashMap<String, String> configMap = new HashMap<String, String>();
            configMap.put("yarn.scheduler.capacity.legacy-queue-mode.enabled", "false");
            configMap.put("yarn.scheduler.capacity.root.queues", "default, test_1, test_2");
            configMap.put("yarn.scheduler.capacity.root.test_1.queues", "test_1_1, test_1_2, test_1_3");
            configMap.put("yarn.scheduler.capacity.root.default.capacity", "25");
            configMap.put("yarn.scheduler.capacity.root.test_1.capacity", "[memory=16384, vcores=16]");
            configMap.put("yarn.scheduler.capacity.root.test_2.capacity", "75");
            configMap.put("yarn.scheduler.capacity.root.test_1.test_1_1.capacity", "[memory=2048, vcores=2]");
            configMap.put("yarn.scheduler.capacity.root.test_1.test_1_2.capacity", "[memory=2048, vcores=2]");
            configMap.put("yarn.scheduler.capacity.root.test_1.test_1_3.capacity", "100");
            TestRMWebServicesCapacitySchedulerMixedModeAbsoluteAndPercentage.this.conf = CapacitySchedulerConfigGeneratorForTest.createConfiguration(configMap);
            TestRMWebServicesCapacitySchedulerMixedModeAbsoluteAndPercentage.this.rm = TestWebServiceUtil.createRM(CapacitySchedulerConfigGeneratorForTest.createConfiguration(configMap));
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getScheme()).thenReturn((Object)"http");
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            TestRMWebServicesCapacitySchedulerMixedModeAbsoluteAndPercentage.this.rmWebServices = new RMWebServices((ResourceManager)TestRMWebServicesCapacitySchedulerMixedModeAbsoluteAndPercentage.this.rm, TestRMWebServicesCapacitySchedulerMixedModeAbsoluteAndPercentage.this.conf);
            ((InstanceBinding)this.bind((Object)TestRMWebServicesCapacitySchedulerMixedModeAbsoluteAndPercentage.this.rm).to(ResourceManager.class)).named("rm");
            ((InstanceBinding)this.bind(TestRMWebServicesCapacitySchedulerMixedModeAbsoluteAndPercentage.this.conf).to(Configuration.class)).named("conf");
            this.bind(TestRMWebServicesCapacitySchedulerMixedModeAbsoluteAndPercentage.this.rmWebServices).to(RMWebServices.class);
            this.bind(request).to(HttpServletRequest.class);
            TestRMWebServicesCapacitySchedulerMixedModeAbsoluteAndPercentage.this.rmWebServices.setResponse(response);
            this.bind(response).to(HttpServletResponse.class);
        }
    }
}

