/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServicesAppsModification;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestWebServiceUtil;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.reader.ApplicationSubmissionContextInfoReader;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.writer.ApplicationSubmissionContextInfoWriter;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.writer.SchedConfUpdateInfoWriter;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.dao.QueueConfigInfo;
import org.apache.hadoop.yarn.webapp.dao.SchedConfUpdateInfo;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class TestRMWebServicesCapacitySchedulerConfigMutation
extends JerseyTestBase {
    private static final String EXPECTED_FILE_TMPL = "webapp/configmutation-%s-%s.json";
    private final boolean legacyQueueMode;
    private String userName;
    private Configuration absoluteConfig;
    private MockRM rm;
    private HttpServletRequest request;

    @Parameterized.Parameters(name="{index}: legacy-queue-mode={0}")
    public static Collection<Boolean> getParameters() {
        return Arrays.asList(true, false);
    }

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register(RMWebServices.class);
        config.register((Object)new JerseyBinder());
        config.register(GenericExceptionHandler.class);
        config.register(ApplicationSubmissionContextInfoWriter.class);
        config.register(SchedConfUpdateInfoWriter.class);
        config.register(ApplicationSubmissionContextInfoReader.class);
        config.register(TestRMWebServicesAppsModification.TestRMCustomAuthFilter.class);
        config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        return config;
    }

    @BeforeClass
    public static void beforeClass() {
        TestWebServiceUtil.backupSchedulerConfigFileInTarget();
    }

    @AfterClass
    public static void afterClass() {
        TestWebServiceUtil.restoreSchedulerConfigFileInTarget();
    }

    public TestRMWebServicesCapacitySchedulerConfigMutation(boolean legacyQueueMode) throws IOException {
        this.legacyQueueMode = legacyQueueMode;
        this.userName = UserGroupInformation.getCurrentUser().getShortUserName();
    }

    @Test
    public void testUpdateAbsoluteHierarchyWithZeroCapacities() throws Exception {
        Principal principal = () -> this.userName;
        Mockito.when((Object)this.request.getUserPrincipal()).thenReturn((Object)principal);
        this.rm.registerNode("h1:1234", 32768, 32);
        TestWebServiceUtil.assertJsonResponse((Response)this.target().path("ws/v1/cluster/scheduler").queryParam("user.name", new Object[]{this.userName}).request(new String[]{"application/json"}).get(Response.class), TestWebServiceUtil.getExpectedResourceFile(EXPECTED_FILE_TMPL, "absolute-hierarchy", "before-update", this.legacyQueueMode));
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> capacityChange = new HashMap<String, String>();
        capacityChange.put("capacity", "[memory=4096, vcores=4]");
        capacityChange.put("maximum-capacity", "[memory=32768, vcores=32]");
        QueueConfigInfo b = new QueueConfigInfo("root.a", capacityChange);
        updateInfo.getUpdateQueueInfo().add(b);
        Response response = (Response)((WebTarget)this.target().register(SchedConfUpdateInfoWriter.class)).path("ws/v1/cluster/scheduler-conf").queryParam("user.name", new Object[]{this.userName}).request(new String[]{"application/json"}).put(Entity.entity((Object)updateInfo, (String)"application/json"), Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        TestWebServiceUtil.assertJsonResponse((Response)this.target().path("ws/v1/cluster/scheduler").queryParam("user.name", new Object[]{this.userName}).request(new String[]{"application/json"}).get(Response.class), TestWebServiceUtil.getExpectedResourceFile(EXPECTED_FILE_TMPL, "absolute-hierarchy", "after-update", this.legacyQueueMode));
    }

    private Configuration createAbsoluteConfig() {
        Configuration conf = new Configuration(false);
        conf.set("yarn.admin.acl", this.userName);
        conf.set("yarn.scheduler.capacity.legacy-queue-mode.enabled", String.valueOf(this.legacyQueueMode));
        conf.set("yarn.scheduler.capacity.root.capacity", "[memory=32768, vcores=32]");
        conf.set("yarn.scheduler.capacity.root.queues", "default, a");
        conf.set("yarn.scheduler.capacity.root.default.capacity", "[memory=1024, vcores=1]");
        conf.set("yarn.scheduler.capacity.root.a.capacity", "[memory=0, vcores=0]");
        conf.set("yarn.scheduler.capacity.root.a.max-capacity", "[memory=32768, vcores=32]");
        conf.set("yarn.scheduler.capacity.root.a.queues", "b, c");
        conf.set("yarn.scheduler.capacity.root.a.b.capacity", "[memory=0, vcores=0]");
        conf.set("yarn.scheduler.capacity.root.a.b.max-capacity", "[memory=32768, vcores=32]");
        conf.set("yarn.scheduler.capacity.root.a.c.capacity", "[memory=0, vcores=0]");
        conf.set("yarn.scheduler.capacity.root.a.c.max-capacity", "[memory=32768, vcores=32]");
        return conf;
    }

    private class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            try {
                TestRMWebServicesCapacitySchedulerConfigMutation.this.absoluteConfig = TestRMWebServicesCapacitySchedulerConfigMutation.this.createAbsoluteConfig();
                FileOutputStream out = new FileOutputStream(TestWebServiceUtil.getCapacitySchedulerConfigFileInTarget());
                TestRMWebServicesCapacitySchedulerConfigMutation.this.absoluteConfig.writeXml((OutputStream)out);
                out.close();
            }
            catch (Exception e) {
                System.out.println(e);
            }
            TestRMWebServicesCapacitySchedulerConfigMutation.this.rm = TestWebServiceUtil.createMutableRM(TestRMWebServicesCapacitySchedulerConfigMutation.this.absoluteConfig, true);
            TestRMWebServicesCapacitySchedulerConfigMutation.this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)TestRMWebServicesCapacitySchedulerConfigMutation.this.request.getScheme()).thenReturn((Object)"http");
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            ((InstanceBinding)this.bind((Object)TestRMWebServicesCapacitySchedulerConfigMutation.this.rm).to(ResourceManager.class)).named("rm");
            ((InstanceBinding)this.bind(TestRMWebServicesCapacitySchedulerConfigMutation.this.absoluteConfig).to(Configuration.class)).named("conf");
            this.bind(TestRMWebServicesCapacitySchedulerConfigMutation.this.request).to(HttpServletRequest.class);
            this.bind(response).to(HttpServletResponse.class);
        }
    }
}

