/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfigGeneratorForTest;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServicesAppsModification;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestWebServiceUtil;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.reader.ApplicationSubmissionContextInfoReader;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.writer.ApplicationSubmissionContextInfoWriter;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class TestRMWebServicesCapacitySchedLegacyQueueCreation
extends JerseyTestBase {
    private final boolean legacyQueueMode;
    private MockRM rm;

    @Parameterized.Parameters(name="{index}: legacy-queue-mode={0}")
    public static Collection<Boolean> getParameters() {
        return Arrays.asList(true, false);
    }

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register(RMWebServices.class);
        config.register((Object)new JerseyBinder());
        config.register(GenericExceptionHandler.class);
        config.register(ApplicationSubmissionContextInfoWriter.class);
        config.register(ApplicationSubmissionContextInfoReader.class);
        config.register(TestRMWebServicesAppsModification.TestRMCustomAuthFilter.class);
        config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        return config;
    }

    public TestRMWebServicesCapacitySchedLegacyQueueCreation(boolean legacyQueueMode) {
        this.legacyQueueMode = legacyQueueMode;
        TestWebServiceUtil.backupSchedulerConfigFileInTarget();
    }

    @AfterClass
    public static void afterClass() {
        TestWebServiceUtil.restoreSchedulerConfigFileInTarget();
    }

    @Test
    public void testSchedulerResponsePercentageModeLegacyAutoCreation() throws Exception {
        this.rm.registerNode("h1:1234", 32768, 32);
        TestWebServiceUtil.assertJsonResponse(this.sendRequest(), "webapp/scheduler-response-PercentageModeLegacyAutoCreation.json");
    }

    private Response sendRequest() {
        return (Response)this.target().path("ws").path("v1").path("cluster").path("scheduler").request(new String[]{"application/json"}).get(Response.class);
    }

    private class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("yarn.scheduler.capacity.legacy-queue-mode.enabled", String.valueOf(TestRMWebServicesCapacitySchedLegacyQueueCreation.this.legacyQueueMode));
            config.put("yarn.scheduler.capacity.root.queues", "default, managed");
            config.put("yarn.scheduler.capacity.root.default.capacity", "25");
            config.put("yarn.scheduler.capacity.root.managed.capacity", "75");
            config.put("yarn.scheduler.capacity.root.managed.auto-create-child-queue.enabled", "true");
            Configuration conf = CapacitySchedulerConfigGeneratorForTest.createConfiguration(config);
            conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
            TestRMWebServicesCapacitySchedLegacyQueueCreation.this.rm = TestWebServiceUtil.createMutableRM(conf, false);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getScheme()).thenReturn((Object)"http");
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            ((InstanceBinding)this.bind((Object)TestRMWebServicesCapacitySchedLegacyQueueCreation.this.rm).to(ResourceManager.class)).named("rm");
            ((InstanceBinding)this.bind(conf).to(Configuration.class)).named("conf");
            this.bind(request).to(HttpServletRequest.class);
            this.bind(response).to(HttpServletResponse.class);
        }
    }
}

