/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfigGeneratorForTest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServicesAppsModification;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestWebServiceUtil;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.reader.ApplicationSubmissionContextInfoReader;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.writer.ApplicationSubmissionContextInfoWriter;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.assertj.core.api.Assertions;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class TestRMWebServicesCapacitySchedDynamicConfigWeightModeDQC
extends JerseyTestBase {
    private final boolean legacyQueueMode;
    private MockRM rm;
    private static final String EXPECTED_FILE_TMPL = "webapp/dynamic-%s-%s.json";
    private Configuration conf;

    @Parameterized.Parameters(name="{index}: legacy-queue-mode={0}")
    public static Collection<Boolean> getParameters() {
        return Arrays.asList(true, false);
    }

    public TestRMWebServicesCapacitySchedDynamicConfigWeightModeDQC(boolean legacyQueueMode) {
        this.legacyQueueMode = legacyQueueMode;
        TestWebServiceUtil.backupSchedulerConfigFileInTarget();
    }

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register(RMWebServices.class);
        config.register((Object)new JerseyBinder());
        config.register(GenericExceptionHandler.class);
        config.register(ApplicationSubmissionContextInfoWriter.class);
        config.register(ApplicationSubmissionContextInfoReader.class);
        config.register(TestRMWebServicesAppsModification.TestRMCustomAuthFilter.class);
        config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        return config;
    }

    @AfterClass
    public static void afterClass() {
        TestWebServiceUtil.restoreSchedulerConfigFileInTarget();
    }

    @Test
    public void testWeightModeFlexibleAQC() throws Exception {
        this.rm.registerNode("h1:1234", 32768, 32);
        TestWebServiceUtil.assertJsonResponse(TestWebServiceUtil.sendRequest(this.target()), TestWebServiceUtil.getExpectedResourceFile(EXPECTED_FILE_TMPL, "testWeightMode", "before-aqc", this.legacyQueueMode));
        this.createDynamicQueues(this.rm, "test2");
        TestWebServiceUtil.reinitialize(this.rm, this.conf);
        TestWebServiceUtil.assertJsonResponse(TestWebServiceUtil.sendRequest(this.target()), TestWebServiceUtil.getExpectedResourceFile(EXPECTED_FILE_TMPL, "testWeightMode", "after-aqc", this.legacyQueueMode));
    }

    private void setupAQC(Configuration config, String queueWithConfigPrefix) {
        config.set(queueWithConfigPrefix + "auto-queue-creation-v2.enabled", "true");
        config.set(queueWithConfigPrefix + "auto-queue-creation-v2.maximum-queue-depth", "10");
        config.set(queueWithConfigPrefix + "auto-queue-creation-v2.leaf-template.capacity", "10w");
        config.set(queueWithConfigPrefix + "auto-queue-creation-v2.parent-template.acl_submit_applications", "parentUser");
        config.set(queueWithConfigPrefix + "auto-queue-creation-v2.parent-template.acl_administer_queue", "parentAdmin");
        config.set(queueWithConfigPrefix + "autoParent1.auto-queue-creation-v2.leaf-template.acl_submit_applications", "ap1User");
        config.set(queueWithConfigPrefix + "autoParent1.auto-queue-creation-v2.leaf-template.acl_administer_queue", "ap1Admin");
        config.set(queueWithConfigPrefix + "*.auto-queue-creation-v2.leaf-template.acl_submit_applications", "leafUser");
        config.set(queueWithConfigPrefix + "*.auto-queue-creation-v2.leaf-template.acl_administer_queue", "leafAdmin");
        config.set(queueWithConfigPrefix + "parent.*.auto-queue-creation-v2.leaf-template.acl_submit_applications", "pLeafUser");
        config.set(queueWithConfigPrefix + "parent.*.auto-queue-creation-v2.leaf-template.acl_administer_queue", "pLeafAdmin");
        config.set(queueWithConfigPrefix + "autoParent1.auto-queue-creation-v2.template.maximum-applications", "300");
    }

    private void createDynamicQueues(MockRM mockRM, String queueName) {
        try {
            CapacityScheduler cs = (CapacityScheduler)mockRM.getResourceScheduler();
            CapacitySchedulerQueueManager autoQueueHandler = cs.getCapacitySchedulerQueueManager();
            autoQueueHandler.createQueue(new QueuePath("root." + queueName + ".auto1"));
            autoQueueHandler.createQueue(new QueuePath("root." + queueName + ".auto2"));
            autoQueueHandler.createQueue(new QueuePath("root." + queueName + ".autoParent1.auto3"));
            autoQueueHandler.createQueue(new QueuePath("root." + queueName + ".autoParent1.auto4"));
            autoQueueHandler.createQueue(new QueuePath("root." + queueName + ".autoParent2.auto5"));
            autoQueueHandler.createQueue(new QueuePath("root." + queueName + ".parent.autoParent2.auto6"));
            autoQueueHandler.createQueue(new QueuePath("root." + queueName + ".parent2.auto7"));
        }
        catch (IOException | YarnException e) {
            Assertions.fail((String)("Can not auto create queues under " + queueName), (Throwable)e);
        }
    }

    private class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            HashMap<String, String> configMap = new HashMap<String, String>();
            configMap.put("yarn.scheduler.capacity.legacy-queue-mode.enabled", String.valueOf(TestRMWebServicesCapacitySchedDynamicConfigWeightModeDQC.this.legacyQueueMode));
            configMap.put("yarn.scheduler.capacity.root.queues", "default, test1, test2");
            configMap.put("yarn.scheduler.capacity.root.test1.queues", "test1_1, test1_2, test1_3");
            configMap.put("yarn.scheduler.capacity.root.default.capacity", "4w");
            configMap.put("yarn.scheduler.capacity.root.test1.capacity", "16w");
            configMap.put("yarn.scheduler.capacity.root.test2.capacity", "12w");
            configMap.put("yarn.scheduler.capacity.root.test1.test1_1.capacity", "2w");
            configMap.put("yarn.scheduler.capacity.root.test1.test1_2.capacity", "2w");
            configMap.put("yarn.scheduler.capacity.root.test1.test1_3.capacity", "12w");
            TestRMWebServicesCapacitySchedDynamicConfigWeightModeDQC.this.conf = CapacitySchedulerConfigGeneratorForTest.createConfiguration(configMap);
            TestRMWebServicesCapacitySchedDynamicConfigWeightModeDQC.this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
            TestRMWebServicesCapacitySchedDynamicConfigWeightModeDQC.this.setupAQC(TestRMWebServicesCapacitySchedDynamicConfigWeightModeDQC.this.conf, "yarn.scheduler.capacity.root.test2.");
            TestRMWebServicesCapacitySchedDynamicConfigWeightModeDQC.this.rm = TestWebServiceUtil.createMutableRM(TestRMWebServicesCapacitySchedDynamicConfigWeightModeDQC.this.conf, false);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getScheme()).thenReturn((Object)"http");
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            ((InstanceBinding)this.bind((Object)TestRMWebServicesCapacitySchedDynamicConfigWeightModeDQC.this.rm).to(ResourceManager.class)).named("rm");
            ((InstanceBinding)this.bind(TestRMWebServicesCapacitySchedDynamicConfigWeightModeDQC.this.conf).to(Configuration.class)).named("conf");
            this.bind(request).to(HttpServletRequest.class);
            this.bind(response).to(HttpServletResponse.class);
        }
    }
}

