/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfigGeneratorForTest;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServicesAppsModification;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestWebServiceUtil;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.reader.ApplicationSubmissionContextInfoReader;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.writer.ApplicationSubmissionContextInfoWriter;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class TestRMWebServicesCapacitySchedDynamicConfig
extends JerseyTestBase {
    private final boolean legacyQueueMode;
    private MockRM rm;
    private static final String EXPECTED_FILE_TMPL = "webapp/dynamic-%s-%s.json";

    @Parameterized.Parameters(name="{index}: legacy-queue-mode={0}")
    public static Collection<Boolean> getParameters() {
        return Arrays.asList(true, false);
    }

    public TestRMWebServicesCapacitySchedDynamicConfig(boolean legacyQueueMode) {
        this.legacyQueueMode = legacyQueueMode;
        TestWebServiceUtil.backupSchedulerConfigFileInTarget();
    }

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register(RMWebServices.class);
        config.register((Object)new JerseyBinder());
        config.register(GenericExceptionHandler.class);
        config.register(ApplicationSubmissionContextInfoWriter.class);
        config.register(ApplicationSubmissionContextInfoReader.class);
        config.register(TestRMWebServicesAppsModification.TestRMCustomAuthFilter.class);
        config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        return config;
    }

    @AfterClass
    public static void afterClass() {
        TestWebServiceUtil.restoreSchedulerConfigFileInTarget();
    }

    @Test
    public void testPercentageMode() throws Exception {
        TestWebServiceUtil.runTest(EXPECTED_FILE_TMPL, "testPercentageMode", this.rm, this.target());
    }

    private class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            HashMap<String, String> configMap = new HashMap<String, String>();
            configMap.put("yarn.scheduler.capacity.legacy-queue-mode.enabled", String.valueOf(TestRMWebServicesCapacitySchedDynamicConfig.this.legacyQueueMode));
            configMap.put("yarn.scheduler.capacity.root.queues", "default, test1, test2");
            configMap.put("yarn.scheduler.capacity.root.test1.queues", "test1_1, test1_2, test1_3");
            configMap.put("yarn.scheduler.capacity.root.default.capacity", "12.5");
            configMap.put("yarn.scheduler.capacity.root.test1.capacity", "50");
            configMap.put("yarn.scheduler.capacity.root.test2.capacity", "37.5");
            configMap.put("yarn.scheduler.capacity.root.test1.test1_1.capacity", "12.5");
            configMap.put("yarn.scheduler.capacity.root.test1.test1_2.capacity", "12.5");
            configMap.put("yarn.scheduler.capacity.root.test1.test1_3.capacity", "75");
            Configuration conf = CapacitySchedulerConfigGeneratorForTest.createConfiguration(configMap);
            conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
            TestRMWebServicesCapacitySchedDynamicConfig.this.rm = TestWebServiceUtil.createMutableRM(conf, false);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getScheme()).thenReturn((Object)"http");
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            ((InstanceBinding)this.bind((Object)TestRMWebServicesCapacitySchedDynamicConfig.this.rm).to(ResourceManager.class)).named("rm");
            ((InstanceBinding)this.bind(conf).to(Configuration.class)).named("conf");
            this.bind(request).to(HttpServletRequest.class);
            this.bind(response).to(HttpServletResponse.class);
        }
    }
}

