/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.util.Arrays;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServicesAppsModification;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestWebServiceUtil;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.reader.ApplicationSubmissionContextInfoReader;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.writer.ApplicationSubmissionContextInfoWriter;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class TestRMWebServicesCapacitySched
extends JerseyTestBase {
    private final boolean legacyQueueMode;
    private MockRM rm;
    private ResourceConfig config;

    @Parameterized.Parameters(name="{index}: legacy-queue-mode={0}")
    public static Collection<Boolean> getParameters() {
        return Arrays.asList(true, false);
    }

    protected Application configure() {
        this.config = new ResourceConfig();
        this.config.register(RMWebServices.class);
        this.config.register((Object)new JerseyBinder());
        this.config.register(GenericExceptionHandler.class);
        this.config.register(ApplicationSubmissionContextInfoWriter.class);
        this.config.register(ApplicationSubmissionContextInfoReader.class);
        this.config.register(TestRMWebServicesAppsModification.TestRMCustomAuthFilter.class);
        this.config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        return this.config;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    public TestRMWebServicesCapacitySched(boolean legacyQueueMode) {
        this.legacyQueueMode = legacyQueueMode;
        TestWebServiceUtil.backupSchedulerConfigFileInTarget();
    }

    @AfterClass
    public static void afterClass() {
        TestWebServiceUtil.restoreSchedulerConfigFileInTarget();
    }

    @Test
    public void testClusterScheduler() throws Exception {
        this.rm.registerNode("h1:1234", 32768, 32);
        TestWebServiceUtil.assertJsonResponse((Response)this.target().path("ws/v1/cluster/scheduler").request(new String[]{"application/json"}).get(Response.class), "webapp/scheduler-response.json");
        TestWebServiceUtil.assertJsonResponse((Response)this.target().path("ws/v1/cluster/scheduler/").request(new String[]{"application/json"}).get(Response.class), "webapp/scheduler-response.json");
        TestWebServiceUtil.assertJsonResponse((Response)this.target().path("ws/v1/cluster/scheduler").request().get(Response.class), "webapp/scheduler-response.json");
        TestWebServiceUtil.assertXmlResponse((Response)this.target().path("ws/v1/cluster/scheduler/").request(new String[]{"application/xml"}).get(Response.class), "webapp/scheduler-response.xml");
    }

    @Test
    public void testPerUserResources() throws Exception {
        this.rm.registerNode("h1:1234", 32768, 32);
        MockRMAppSubmitter.submit(this.rm, MockRMAppSubmissionData.Builder.createWithMemory(32L, this.rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("a").withUnmanagedAM(false).build());
        MockRMAppSubmitter.submit(this.rm, MockRMAppSubmissionData.Builder.createWithMemory(64L, this.rm).withAppName("app2").withUser("user2").withAcls(null).withQueue("b").withUnmanagedAM(false).build());
        TestWebServiceUtil.assertXmlResponse((Response)this.target().path("ws/v1/cluster/scheduler").request(new String[]{"application/xml"}).get(Response.class), "webapp/scheduler-response-PerUserResources.xml");
        TestWebServiceUtil.assertJsonResponse((Response)this.target().path("ws/v1/cluster/scheduler").request(new String[]{"application/json"}).get(Response.class), "webapp/scheduler-response-PerUserResources.json");
    }

    @Test
    public void testClusterSchedulerOverviewCapacity() throws Exception {
        this.rm.registerNode("h1:1234", 32768, 32);
        Response response = (Response)this.targetWithJsonObject().path("ws/v1/cluster/scheduler-overview").request(new String[]{"application/json"}).get(Response.class);
        TestWebServiceUtil.assertJsonType(response);
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        JSONObject scheduler = json.getJSONObject("scheduler");
        TestRMWebServices.verifyClusterSchedulerOverView(scheduler, "Capacity Scheduler");
    }

    @Test
    public void testResourceInfo() {
        Resource res = Resources.createResource((int)10, (int)1);
        Assert.assertEquals((Object)"<memory:10, vCores:1>", (Object)res.toString());
    }

    private Configuration createConfig() {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.capacity.legacy-queue-mode.enabled", String.valueOf(this.legacyQueueMode));
        conf.set("yarn.scheduler.capacity.root.queues", "a, b, c");
        conf.set("yarn.scheduler.capacity.root.a.capacity", "12.5");
        conf.set("yarn.scheduler.capacity.root.a.accessible-node-labels", "root-a-default-label");
        conf.set("yarn.scheduler.capacity.root.a.maximum-capacity", "50");
        conf.set("yarn.scheduler.capacity.root.a.max-parallel-app", "42");
        conf.set("yarn.scheduler.capacity.root.b.capacity", "50");
        conf.set("yarn.scheduler.capacity.root.c.capacity", "37.5");
        conf.set("yarn.scheduler.capacity.schedule-asynchronously.enable", "false");
        return conf;
    }

    private class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            Configuration conf = TestRMWebServicesCapacitySched.this.createConfig();
            conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
            conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
            conf.set("yarn.resourcemanager.cluster-id", "subCluster1");
            TestRMWebServicesCapacitySched.this.rm = TestWebServiceUtil.createRM(conf);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getScheme()).thenReturn((Object)"http");
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            ((InstanceBinding)this.bind((Object)TestRMWebServicesCapacitySched.this.rm).to(ResourceManager.class)).named("rm");
            ((InstanceBinding)this.bind(conf).to(Configuration.class)).named("conf");
            this.bind(request).to(HttpServletRequest.class);
            this.bind(response).to(HttpServletResponse.class);
        }
    }
}

