/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.util.XMLUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ApplicationTimeoutType;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileWriter;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppPriority;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppQueue;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppState;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppTimeoutInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ApplicationSubmissionContextInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CredentialsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.LocalResourceInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.LogAggregationContextInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.reader.AppStateReader;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.reader.ApplicationSubmissionContextInfoReader;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.writer.ApplicationSubmissionContextInfoWriter;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.jettison.JettisonJaxbContext;
import org.glassfish.jersey.jettison.JettisonMarshaller;
import org.glassfish.jersey.jettison.internal.entity.JettisonObjectProvider;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@RunWith(value=Parameterized.class)
public class TestRMWebServicesAppsModification
extends JerseyTestBase {
    private static MockRM rm;
    private static final int CONTAINER_MB = 1024;
    private String webserviceUserName = "testuser";
    private boolean setAuthFilter = false;
    private static final String TEST_DIR;
    private static final String FS_ALLOC_FILE;
    private static final QueuePath ROOT;
    private static final QueuePath DEFAULT;
    private static final QueuePath TEST;
    private static final QueuePath TEST_QUEUE;
    private ResourceConfig config;
    private HttpServletRequest hsRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
    private HttpServletResponse hsResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
    private static final JettisonMarshaller APP_STATE_WRITER;
    private static final JettisonMarshaller APP_PRIORITY_WRITER;
    private static final JettisonMarshaller APP_QUEUE_WRITER;
    private static final JettisonMarshaller APP_TIMEOUT_WRITER;

    protected Application configure() {
        this.config = new ResourceConfig();
        this.config.register(RMWebServices.class);
        this.config.register(GenericExceptionHandler.class);
        this.config.register(ApplicationSubmissionContextInfoWriter.class);
        this.config.register(ApplicationSubmissionContextInfoReader.class);
        this.config.register(TestRMCustomAuthFilter.class);
        this.config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        this.forceSet("jersey.config.test.container.port", "0");
        return this.config;
    }

    private CapTestServletModule getNoAuthInjectorCap() {
        this.setAuthFilter = false;
        return new CapTestServletModule(false);
    }

    private CapTestServletModule getSimpleAuthInjectorCap() {
        this.setAuthFilter = true;
        Principal principal = () -> "testuser";
        Mockito.when((Object)this.hsRequest.getUserPrincipal()).thenReturn((Object)principal);
        return new CapTestServletModule(true);
    }

    private FairTestServletModule getNoAuthInjectorFair() {
        this.setAuthFilter = false;
        return new FairTestServletModule(false);
    }

    private FairTestServletModule getSimpleAuthInjectorFair() {
        this.setAuthFilter = true;
        Principal principal = () -> "testuser";
        Mockito.when((Object)this.hsRequest.getUserPrincipal()).thenReturn((Object)principal);
        return new FairTestServletModule(true);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> guiceConfigs() {
        return Arrays.asList({0}, {1}, {2}, {3});
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    public TestRMWebServicesAppsModification(int run) throws JAXBException {
        switch (run) {
            default: {
                this.config.register((Object)this.getNoAuthInjectorCap());
                break;
            }
            case 1: {
                this.config.register((Object)this.getSimpleAuthInjectorCap());
                break;
            }
            case 2: {
                this.config.register((Object)this.getNoAuthInjectorFair());
                break;
            }
            case 3: {
                this.config.register((Object)this.getSimpleAuthInjectorFair());
            }
        }
    }

    private boolean isAuthenticationEnabled() {
        return this.setAuthFilter;
    }

    private WebTarget constructWebResource(WebTarget r, String ... paths) {
        WebTarget rt = r;
        for (String path : paths) {
            rt = rt.path(path);
        }
        if (this.isAuthenticationEnabled()) {
            rt = rt.queryParam("user.name", new Object[]{this.webserviceUserName});
        }
        return rt;
    }

    private WebTarget constructWebResource(String ... paths) {
        WebTarget r = (WebTarget)((WebTarget)((WebTarget)((WebTarget)this.target().register(JettisonObjectProvider.App.class)).register(AppStateReader.class)).register(ApplicationSubmissionContextInfoReader.class)).register(ApplicationSubmissionContextInfoWriter.class);
        WebTarget ws = r.path("ws").path("v1").path("cluster");
        return this.constructWebResource(ws, paths);
    }

    @Test
    public void testSingleAppState() throws Exception {
        String[] mediaTypes;
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        for (String mediaType : mediaTypes = new String[]{"application/json", "application/xml"}) {
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("").withUser(this.webserviceUserName).build();
            RMApp app = MockRMAppSubmitter.submit(rm, data);
            amNodeManager.nodeHeartbeat(true);
            Response response = (Response)this.constructWebResource("apps", app.getApplicationId().toString(), "state").request(new String[]{mediaType}).get(Response.class);
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
            if (mediaType.contains("application/json")) {
                TestRMWebServicesAppsModification.verifyAppStateJson(response, RMAppState.ACCEPTED);
                continue;
            }
            if (!mediaType.contains("application/xml")) continue;
            TestRMWebServicesAppsModification.verifyAppStateXML(response, RMAppState.ACCEPTED);
        }
        rm.stop();
    }

    @Test(timeout=120000L)
    public void testSingleAppKill() throws Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        String[] mediaTypes = new String[]{"application/json", "application/xml"};
        MediaType[] contentTypes = new MediaType[]{MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_XML_TYPE};
        String diagnostic = "message1";
        for (String mediaType : mediaTypes) {
            for (MediaType contentType : contentTypes) {
                MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("").withUser(this.webserviceUserName).build();
                RMApp app = MockRMAppSubmitter.submit(rm, data);
                amNodeManager.nodeHeartbeat(true);
                AppState targetState = new AppState(YarnApplicationState.KILLED.toString());
                targetState.setDiagnostics(diagnostic);
                Object entity = contentType.equals((Object)MediaType.APPLICATION_JSON_TYPE) ? TestRMWebServicesAppsModification.appStateToJSON(targetState) : targetState;
                Response response = (Response)this.constructWebResource("apps", app.getApplicationId().toString(), "state").request(new String[]{mediaType}).put(Entity.entity((Object)entity, (MediaType)contentType), Response.class);
                if (!this.isAuthenticationEnabled()) {
                    WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.UNAUTHORIZED, (Response.StatusType)response.getStatusInfo());
                    continue;
                }
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.ACCEPTED, (Response.StatusType)response.getStatusInfo());
                if (mediaType.contains("application/json")) {
                    TestRMWebServicesAppsModification.verifyAppStateJson(response, RMAppState.FINAL_SAVING, RMAppState.KILLED, RMAppState.KILLING, RMAppState.ACCEPTED);
                } else {
                    TestRMWebServicesAppsModification.verifyAppStateXML(response, RMAppState.FINAL_SAVING, RMAppState.KILLED, RMAppState.KILLING, RMAppState.ACCEPTED);
                }
                String locationHeaderValue = this.constructWebResource("apps", app.getApplicationId().toString(), "state").getUri().toString().replace("?user.name=testuser", "");
                Client c = ClientBuilder.newClient();
                WebTarget tmp = c.target(locationHeaderValue);
                if (this.isAuthenticationEnabled()) {
                    tmp = tmp.queryParam("user.name", new Object[]{this.webserviceUserName});
                }
                response = (Response)tmp.request().get(Response.class);
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
                Assert.assertTrue((boolean)locationHeaderValue.endsWith("/ws/v1/cluster/apps/" + app.getApplicationId().toString() + "/state"));
                do {
                    Thread.sleep(100L);
                    response = (Response)this.constructWebResource("apps", app.getApplicationId().toString(), "state").request(new String[]{mediaType}).put(Entity.entity((Object)entity, (MediaType)contentType), Response.class);
                    Assert.assertTrue((response.getStatusInfo().getStatusCode() == Response.Status.ACCEPTED.getStatusCode() || response.getStatusInfo().getStatusCode() == Response.Status.OK.getStatusCode() ? 1 : 0) != 0);
                } while (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode());
                Assert.assertEquals((Object)RMAppState.KILLED, (Object)app.getState());
                if (mediaType.equals("application/json")) {
                    TestRMWebServicesAppsModification.verifyAppStateJson(response, RMAppState.KILLED);
                } else {
                    TestRMWebServicesAppsModification.verifyAppStateXML(response, RMAppState.KILLED);
                }
                Assert.assertTrue((String)"Diagnostic message is incorrect", (boolean)app.getDiagnostics().toString().contains(diagnostic));
            }
        }
        rm.stop();
    }

    @Test
    public void testSingleAppKillInvalidState() throws Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        String[] mediaTypes = new String[]{"application/json", "application/xml"};
        MediaType[] contentTypes = new MediaType[]{MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_XML_TYPE};
        String[] targetStates = new String[]{YarnApplicationState.FINISHED.toString(), "blah"};
        for (String mediaType : mediaTypes) {
            for (MediaType contentType : contentTypes) {
                for (String targetStateString : targetStates) {
                    MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("").withUser(this.webserviceUserName).build();
                    RMApp app = MockRMAppSubmitter.submit(rm, data);
                    amNodeManager.nodeHeartbeat(true);
                    AppState targetState = new AppState(targetStateString);
                    Object entity = contentType.equals((Object)MediaType.APPLICATION_JSON_TYPE) ? TestRMWebServicesAppsModification.appStateToJSON(targetState) : targetState;
                    Response response = (Response)this.constructWebResource("apps", app.getApplicationId().toString(), "state").request(new String[]{mediaType}).put(Entity.entity((Object)entity, (MediaType)contentType), Response.class);
                    if (!this.isAuthenticationEnabled()) {
                        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.UNAUTHORIZED, (Response.StatusType)response.getStatusInfo());
                        continue;
                    }
                    WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
                }
            }
        }
        rm.stop();
    }

    private static String appStateToJSON(AppState state) throws Exception {
        StringWriter stringWriter = new StringWriter();
        APP_STATE_WRITER.marshallToJSON((Object)state, (Writer)stringWriter);
        return stringWriter.toString();
    }

    protected static void verifyAppStateJson(Response response, RMAppState ... states) throws JSONException {
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        String responseState = json.getJSONObject("appstate").getString("state");
        boolean valid = false;
        for (RMAppState state : states) {
            if (!state.toString().equals(responseState)) continue;
            valid = true;
        }
        String msg = "app state incorrect, got " + responseState;
        Assert.assertTrue((String)msg, (boolean)valid);
    }

    protected static void verifyAppStateXML(Response response, RMAppState ... appStates) throws ParserConfigurationException, IOException, SAXException {
        Assert.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        String xml = (String)response.readEntity(String.class);
        DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("appstate");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        Element element = (Element)nodes.item(0);
        String state = WebServicesTestUtils.getXmlString((Element)element, (String)"state");
        boolean valid = false;
        for (RMAppState appState : appStates) {
            if (!appState.toString().equals(state)) continue;
            valid = true;
        }
        String msg = "app state incorrect, got " + state;
        Assert.assertTrue((String)msg, (boolean)valid);
    }

    @Test(timeout=60000L)
    public void testSingleAppKillUnauthorized() throws Exception {
        String[] mediaTypes;
        boolean isCapacityScheduler = rm.getResourceScheduler() instanceof CapacityScheduler;
        boolean isFairScheduler = rm.getResourceScheduler() instanceof FairScheduler;
        Assume.assumeTrue((String)"This test is only supported on Capacity and Fair Scheduler", (isCapacityScheduler || isFairScheduler ? 1 : 0) != 0);
        if (isCapacityScheduler) {
            CapacitySchedulerConfiguration csconf = new CapacitySchedulerConfiguration();
            csconf.setAcl(ROOT, QueueACL.ADMINISTER_QUEUE, "someuser");
            csconf.setAcl(DEFAULT, QueueACL.ADMINISTER_QUEUE, "someuser");
            rm.getResourceScheduler().reinitialize((Configuration)csconf, rm.getRMContext());
        }
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        for (String mediaType : mediaTypes = new String[]{"application/json", "application/xml"}) {
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("test").withUser("someuser").build();
            RMApp app = MockRMAppSubmitter.submit(rm, data);
            amNodeManager.nodeHeartbeat(true);
            Response response = (Response)this.constructWebResource("apps", app.getApplicationId().toString(), "state").request(new String[]{mediaType}).get(Response.class);
            AppState info = (AppState)response.readEntity(AppState.class);
            info.setState(YarnApplicationState.KILLED.toString());
            response = (Response)this.constructWebResource("apps", app.getApplicationId().toString(), "state").request(new String[]{mediaType}).put(Entity.entity((Object)info, (String)"application/xml"), Response.class);
            this.validateResponseStatus(response, Response.Status.FORBIDDEN);
        }
        rm.stop();
    }

    @Test
    public void testSingleAppKillInvalidId() throws Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        amNodeManager.nodeHeartbeat(true);
        String[] testAppIds = new String[]{"application_1391705042196_0001", "random_string"};
        for (int i = 0; i < testAppIds.length; ++i) {
            AppState info = new AppState("KILLED");
            Response response = (Response)this.constructWebResource("apps", testAppIds[i], "state").request(new String[]{"application/xml"}).put(Entity.xml((Object)info), Response.class);
            if (!this.isAuthenticationEnabled()) {
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.UNAUTHORIZED, (Response.StatusType)response.getStatusInfo());
                continue;
            }
            if (i == 0) {
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
                continue;
            }
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
        }
        rm.stop();
    }

    @After
    public void tearDown() throws Exception {
        if (rm != null) {
            rm.stop();
        }
        super.tearDown();
    }

    public void validateResponseStatus(Response response, Response.Status expectedAuthorizedMode) {
        this.validateResponseStatus(response, Response.Status.UNAUTHORIZED, expectedAuthorizedMode);
    }

    public void validateResponseStatus(Response response, Response.Status expectedUnauthorizedMode, Response.Status expectedAuthorizedMode) {
        if (!this.isAuthenticationEnabled()) {
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)expectedUnauthorizedMode, (Response.StatusType)response.getStatusInfo());
        } else {
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)expectedAuthorizedMode, (Response.StatusType)response.getStatusInfo());
        }
    }

    @Test
    public void testGetNewApplication() throws Exception {
        String[] mediaTypes;
        rm.start();
        for (String acceptMedia : mediaTypes = new String[]{"application/json", "application/xml"}) {
            this.testGetNewApplication(acceptMedia);
        }
        rm.stop();
    }

    protected String testGetNewApplication(String mediaType) throws JSONException, ParserConfigurationException, IOException, SAXException {
        Response response = (Response)this.constructWebResource("apps", "new-application").request(new String[]{mediaType}).post(null, Response.class);
        this.validateResponseStatus(response, Response.Status.OK);
        if (!this.isAuthenticationEnabled()) {
            return "";
        }
        return this.validateGetNewApplicationResponse(response);
    }

    protected String validateGetNewApplicationResponse(Response resp) throws JSONException, ParserConfigurationException, IOException, SAXException {
        String ret = "";
        if (resp.getMediaType().toString().contains("application/json")) {
            JSONObject json = (JSONObject)resp.readEntity(JSONObject.class);
            JSONObject newApplication = json.getJSONObject("NewApplication");
            ret = this.validateGetNewApplicationJsonResponse(newApplication);
        } else if (resp.getMediaType().toString().contains("application/xml")) {
            String xml = (String)resp.readEntity(String.class);
            ret = this.validateGetNewApplicationXMLResponse(xml);
        } else {
            Assert.assertTrue((boolean)false);
        }
        return ret;
    }

    protected String validateGetNewApplicationJsonResponse(JSONObject json) throws JSONException {
        String appId = json.getString("application-id");
        Assert.assertTrue((!appId.isEmpty() ? 1 : 0) != 0);
        JSONObject maxResources = json.getJSONObject("maximum-resource-capability");
        long memory = maxResources.getLong("memory");
        long vCores = maxResources.getLong("vCores");
        Assert.assertTrue((memory != 0L ? 1 : 0) != 0);
        Assert.assertTrue((vCores != 0L ? 1 : 0) != 0);
        return appId;
    }

    protected String validateGetNewApplicationXMLResponse(String response) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(response));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("NewApplication");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        Element element = (Element)nodes.item(0);
        String appId = WebServicesTestUtils.getXmlString((Element)element, (String)"application-id");
        Assert.assertTrue((!appId.isEmpty() ? 1 : 0) != 0);
        NodeList maxResourceNodes = element.getElementsByTagName("maximum-resource-capability");
        Assert.assertEquals((long)1L, (long)maxResourceNodes.getLength());
        Element maxResourceCapability = (Element)maxResourceNodes.item(0);
        long memory = WebServicesTestUtils.getXmlLong((Element)maxResourceCapability, (String)"memory");
        long vCores = WebServicesTestUtils.getXmlLong((Element)maxResourceCapability, (String)"vCores");
        Assert.assertTrue((memory != 0L ? 1 : 0) != 0);
        Assert.assertTrue((vCores != 0L ? 1 : 0) != 0);
        return appId;
    }

    @Test
    public void testGetNewApplicationAndSubmit() throws Exception {
        String[] mediaTypes;
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        amNodeManager.nodeHeartbeat(true);
        for (String acceptMedia : mediaTypes = new String[]{"application/json", "application/xml"}) {
            for (String contentMedia : mediaTypes) {
                this.testAppSubmit(acceptMedia, contentMedia);
                this.testAppSubmitErrors(acceptMedia, contentMedia);
            }
        }
        rm.stop();
    }

    public void testAppSubmit(String acceptMedia, String contentMedia) throws Exception {
        String lrKey = "example";
        Object queueName = "testqueue";
        String[] queues = new String[]{"default", "testqueue"};
        CapacitySchedulerConfiguration csconf = new CapacitySchedulerConfiguration();
        csconf.setQueues(ROOT, queues);
        csconf.setCapacity(DEFAULT, 50.0f);
        csconf.setCapacity(TEST_QUEUE, 50.0f);
        Mockito.when((Object)this.hsRequest.getRequestURL()).thenReturn((Object)new StringBuffer("/apps"));
        rm.getResourceScheduler().reinitialize((Configuration)csconf, rm.getRMContext());
        String appName = "test";
        String appType = "test-type";
        String urlPath = "apps";
        String appId = this.testGetNewApplication(acceptMedia);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("/bin/sleep 5");
        HashMap<String, String> environment = new HashMap<String, String>();
        environment.put("APP_VAR", "ENV_SETTING");
        HashMap<ApplicationAccessType, String> acls = new HashMap<ApplicationAccessType, String>();
        acls.put(ApplicationAccessType.MODIFY_APP, "testuser1, testuser2");
        acls.put(ApplicationAccessType.VIEW_APP, "testuser3, testuser4");
        HashSet<String> tags = new HashSet<String>();
        tags.add("tag1");
        tags.add("tag 2");
        CredentialsInfo credentials = new CredentialsInfo();
        HashMap tokens = new HashMap();
        HashMap<String, String> secrets = new HashMap<String, String>();
        secrets.put("secret1", Base64.encodeBase64String((byte[])"mysecret".getBytes(StandardCharsets.UTF_8)));
        credentials.setSecrets(secrets);
        credentials.setTokens(tokens);
        ApplicationSubmissionContextInfo appInfo = new ApplicationSubmissionContextInfo();
        appInfo.setApplicationId(appId);
        appInfo.setApplicationName(appName);
        appInfo.setMaxAppAttempts(2);
        appInfo.setQueue((String)queueName);
        appInfo.setApplicationType(appType);
        appInfo.setPriority(0);
        HashMap<String, LocalResourceInfo> lr = new HashMap<String, LocalResourceInfo>();
        LocalResourceInfo y = new LocalResourceInfo();
        y.setUrl(new URI("http://www.test.com/file.txt"));
        y.setSize(100L);
        y.setTimestamp(System.currentTimeMillis());
        y.setType(LocalResourceType.FILE);
        y.setVisibility(LocalResourceVisibility.APPLICATION);
        lr.put(lrKey, y);
        appInfo.getContainerLaunchContextInfo().setResources(lr);
        appInfo.getContainerLaunchContextInfo().setCommands(commands);
        appInfo.getContainerLaunchContextInfo().setEnvironment(environment);
        appInfo.getContainerLaunchContextInfo().setAcls(acls);
        appInfo.getContainerLaunchContextInfo().getAuxillaryServiceData().put("test", Base64.encodeBase64URLSafeString((byte[])"value12".getBytes(StandardCharsets.UTF_8)));
        appInfo.getContainerLaunchContextInfo().setCredentials(credentials);
        appInfo.getResource().setMemory(1024);
        appInfo.getResource().setvCores(1);
        appInfo.setApplicationTags(tags);
        String includePattern = "file1";
        String excludePattern = "file2";
        String rolledLogsIncludePattern = "file3";
        String rolledLogsExcludePattern = "file4";
        String className = "policy_class";
        String parameters = "policy_parameter";
        LogAggregationContextInfo logAggregationContextInfo = new LogAggregationContextInfo();
        logAggregationContextInfo.setIncludePattern(includePattern);
        logAggregationContextInfo.setExcludePattern(excludePattern);
        logAggregationContextInfo.setRolledLogsIncludePattern(rolledLogsIncludePattern);
        logAggregationContextInfo.setRolledLogsExcludePattern(rolledLogsExcludePattern);
        logAggregationContextInfo.setLogAggregationPolicyClassName(className);
        logAggregationContextInfo.setLogAggregationPolicyParameters(parameters);
        appInfo.setLogAggregationContextInfo(logAggregationContextInfo);
        long attemptFailuresValidityInterval = 5000L;
        appInfo.setAttemptFailuresValidityInterval(attemptFailuresValidityInterval);
        String reservationId = ReservationId.newInstance((long)System.currentTimeMillis(), (long)1L).toString();
        appInfo.setReservationId(reservationId);
        Response response = (Response)this.constructWebResource(urlPath).request(new String[]{acceptMedia}).post(Entity.entity((Object)appInfo, (String)contentMedia), Response.class);
        if (!this.isAuthenticationEnabled()) {
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.UNAUTHORIZED, (Response.StatusType)response.getStatusInfo());
            return;
        }
        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.ACCEPTED, (Response.StatusType)response.getStatusInfo());
        Assert.assertTrue((response.getHeaders().getFirst((Object)"Location") != null ? 1 : 0) != 0);
        Object locURL = (String)response.getHeaders().getFirst((Object)"Location");
        Assert.assertTrue((boolean)((String)locURL).contains("/apps/application"));
        appId = ((String)locURL).substring(((String)locURL).indexOf("/apps/") + "/apps/".length());
        locURL = "/ws/v1/cluster" + ((String)locURL).substring(((String)locURL).indexOf("/apps/"));
        WebTarget res = this.target((String)locURL);
        res = res.queryParam("user.name", new Object[]{this.webserviceUserName});
        response = res.request().get();
        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
        RMApp app = (RMApp)rm.getRMContext().getRMApps().get(ApplicationId.fromString((String)appId));
        Assert.assertEquals((Object)appName, (Object)app.getName());
        Assert.assertEquals((Object)this.webserviceUserName, (Object)app.getUser());
        Assert.assertEquals((long)2L, (long)app.getMaxAppAttempts());
        if (app.getQueue().contains("root.")) {
            queueName = "root." + (String)queueName;
        }
        Assert.assertEquals((Object)queueName, (Object)app.getQueue());
        Assert.assertEquals((Object)appType, (Object)app.getApplicationType());
        Assert.assertEquals(tags, (Object)app.getApplicationTags());
        ContainerLaunchContext ctx = app.getApplicationSubmissionContext().getAMContainerSpec();
        Assert.assertEquals(commands, (Object)ctx.getCommands());
        Assert.assertEquals(environment, (Object)ctx.getEnvironment());
        Assert.assertEquals(acls, (Object)ctx.getApplicationACLs());
        Map appLRs = ctx.getLocalResources();
        Assert.assertTrue((boolean)appLRs.containsKey(lrKey));
        LocalResource exampleLR = (LocalResource)appLRs.get(lrKey);
        Assert.assertEquals((Object)URL.fromURI((URI)y.getUrl()), (Object)exampleLR.getResource());
        Assert.assertEquals((long)y.getSize(), (long)exampleLR.getSize());
        Assert.assertEquals((long)y.getTimestamp(), (long)exampleLR.getTimestamp());
        Assert.assertEquals((Object)y.getType(), (Object)exampleLR.getType());
        Assert.assertEquals((Object)y.getPattern(), (Object)exampleLR.getPattern());
        Assert.assertEquals((Object)y.getVisibility(), (Object)exampleLR.getVisibility());
        Credentials cs = new Credentials();
        ByteArrayInputStream str = new ByteArrayInputStream(app.getApplicationSubmissionContext().getAMContainerSpec().getTokens().array());
        DataInputStream di = new DataInputStream(str);
        cs.readTokenStorageStream(di);
        Text key = new Text("secret1");
        Assert.assertTrue((String)"Secrets missing from credentials object", (boolean)cs.getAllSecretKeys().contains(key));
        Assert.assertEquals((Object)"mysecret", (Object)new String(cs.getSecretKey(key), StandardCharsets.UTF_8));
        ApplicationSubmissionContext asc = app.getApplicationSubmissionContext();
        LogAggregationContext lac = asc.getLogAggregationContext();
        Assert.assertEquals((Object)includePattern, (Object)lac.getIncludePattern());
        Assert.assertEquals((Object)excludePattern, (Object)lac.getExcludePattern());
        Assert.assertEquals((Object)rolledLogsIncludePattern, (Object)lac.getRolledLogsIncludePattern());
        Assert.assertEquals((Object)rolledLogsExcludePattern, (Object)lac.getRolledLogsExcludePattern());
        Assert.assertEquals((Object)className, (Object)lac.getLogAggregationPolicyClassName());
        Assert.assertEquals((Object)parameters, (Object)lac.getLogAggregationPolicyParameters());
        Assert.assertEquals((long)attemptFailuresValidityInterval, (long)asc.getAttemptFailuresValidityInterval());
        Assert.assertEquals((Object)reservationId, (Object)app.getReservationId().toString());
        response = (Response)this.constructWebResource("apps", appId).request(new String[]{acceptMedia}).get(Response.class);
        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
    }

    public void testAppSubmitErrors(String acceptMedia, String contentMedia) throws Exception {
        String urlPath = "apps";
        ApplicationSubmissionContextInfo appInfo = new ApplicationSubmissionContextInfo();
        Response response = (Response)this.constructWebResource(urlPath).request(new String[]{acceptMedia}).post(Entity.entity((Object)appInfo, (String)contentMedia), Response.class);
        this.validateResponseStatus(response, Response.Status.BAD_REQUEST);
        String appId = "random";
        appInfo.setApplicationId(appId);
        response = (Response)this.constructWebResource(urlPath).request(new String[]{acceptMedia}).post(Entity.entity((Object)appInfo, (String)contentMedia), Response.class);
        this.validateResponseStatus(response, Response.Status.BAD_REQUEST);
        appId = "random_junk";
        appInfo.setApplicationId(appId);
        response = (Response)this.constructWebResource(urlPath).request(new String[]{acceptMedia}).post(Entity.entity((Object)appInfo, (String)contentMedia), Response.class);
        this.validateResponseStatus(response, Response.Status.BAD_REQUEST);
        appInfo.getResource().setMemory(rm.getConfig().getInt("yarn.scheduler.maximum-allocation-mb", 8192) + 1);
        appInfo.getResource().setvCores(1);
        response = (Response)this.constructWebResource(urlPath).request(new String[]{acceptMedia}).post(Entity.entity((Object)appInfo, (String)contentMedia), Response.class);
        this.validateResponseStatus(response, Response.Status.BAD_REQUEST);
        appInfo.getResource().setvCores(rm.getConfig().getInt("yarn.scheduler.maximum-allocation-vcores", 4) + 1);
        appInfo.getResource().setMemory(1024);
        response = (Response)this.constructWebResource(urlPath).request(new String[]{acceptMedia}).post(Entity.entity((Object)appInfo, (String)contentMedia), Response.class);
        this.validateResponseStatus(response, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testAppSubmitBadJsonAndXML() throws Exception {
        String urlPath = "apps";
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        amNodeManager.nodeHeartbeat(true);
        ApplicationSubmissionContextInfo appInfo = new ApplicationSubmissionContextInfo();
        appInfo.setApplicationName("test");
        appInfo.setPriority(3);
        appInfo.setMaxAppAttempts(2);
        appInfo.setQueue("testqueue");
        appInfo.setApplicationType("test-type");
        HashMap<String, LocalResourceInfo> lr = new HashMap<String, LocalResourceInfo>();
        LocalResourceInfo y = new LocalResourceInfo();
        y.setUrl(new URI("http://www.test.com/file.txt"));
        y.setSize(100L);
        y.setTimestamp(System.currentTimeMillis());
        y.setType(LocalResourceType.FILE);
        y.setVisibility(LocalResourceVisibility.APPLICATION);
        lr.put("example", y);
        appInfo.getContainerLaunchContextInfo().setResources(lr);
        appInfo.getResource().setMemory(1024);
        appInfo.getResource().setvCores(1);
        String body = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><blah/>";
        Response response = (Response)this.constructWebResource(urlPath).request(new String[]{"application/xml"}).post(Entity.entity((Object)body, (String)"application/xml"), Response.class);
        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
        ApplicationSubmissionContextInfo aa = new ApplicationSubmissionContextInfo();
        aa.setApplicationId("a");
        aa.setApplicationName("b");
        body = "application-submission-context:\"{\"a\" : \"b\"}\"";
        response = (Response)this.constructWebResource(urlPath).request(new String[]{"application/xml"}).post(Entity.entity((Object)aa, (String)"application/json"), Response.class);
        this.validateResponseStatus(response, Response.Status.BAD_REQUEST);
        rm.stop();
    }

    @Test
    public void testGetAppQueue() throws Exception {
        String[] contentTypes;
        boolean isCapacityScheduler = rm.getResourceScheduler() instanceof CapacityScheduler;
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        for (String contentType : contentTypes = new String[]{"application/json", "application/xml"}) {
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("").withUser(this.webserviceUserName).build();
            RMApp app = MockRMAppSubmitter.submit(rm, data);
            amNodeManager.nodeHeartbeat(true);
            Response response = (Response)this.constructWebResource("apps", app.getApplicationId().toString(), "queue").request(new String[]{contentType}).get(Response.class);
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
            Object expectedQueue = "root.default";
            if (!isCapacityScheduler) {
                expectedQueue = "root." + this.webserviceUserName;
            }
            if (contentType.contains("application/json")) {
                TestRMWebServicesAppsModification.verifyAppQueueJson(response, (String)expectedQueue);
                continue;
            }
            TestRMWebServicesAppsModification.verifyAppQueueXML(response, (String)expectedQueue);
        }
        rm.stop();
    }

    @Test(timeout=90000L)
    public void testUpdateAppPriority() throws Exception {
        if (!(rm.getResourceScheduler() instanceof CapacityScheduler)) {
            return;
        }
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        Configuration conf = new Configuration();
        conf.setInt("yarn.cluster.max-application-priority", 10);
        cs.setClusterMaxPriority(conf);
        CapacitySchedulerConfiguration csconf = new CapacitySchedulerConfiguration();
        String[] queues = new String[]{"default", "test"};
        csconf.setQueues(ROOT, queues);
        csconf.setCapacity(DEFAULT, 50.0f);
        csconf.setCapacity(TEST, 50.0f);
        csconf.setAcl(ROOT, QueueACL.ADMINISTER_QUEUE, "someuser");
        csconf.setAcl(DEFAULT, QueueACL.ADMINISTER_QUEUE, "someuser");
        csconf.setAcl(TEST, QueueACL.ADMINISTER_QUEUE, "someuser");
        rm.getResourceScheduler().reinitialize((Configuration)csconf, rm.getRMContext());
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        String[] mediaTypes = new String[]{"application/json", "application/xml"};
        MediaType[] contentTypes = new MediaType[]{MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_XML_TYPE};
        for (String mediaType : mediaTypes) {
            for (MediaType contentType : contentTypes) {
                MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("").withUser(this.webserviceUserName).build();
                RMApp app = MockRMAppSubmitter.submit(rm, data1);
                amNodeManager.nodeHeartbeat(true);
                int modifiedPriority = 8;
                AppPriority priority2 = new AppPriority(modifiedPriority);
                Object entity = contentType.equals((Object)MediaType.APPLICATION_JSON_TYPE) ? TestRMWebServicesAppsModification.appPriorityToJSON(priority2) : priority2;
                Response response = (Response)this.constructWebResource("apps", app.getApplicationId().toString(), "priority").request(new String[]{mediaType}).put(Entity.entity((Object)entity, (MediaType)contentType), Response.class);
                if (!this.isAuthenticationEnabled()) {
                    WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.UNAUTHORIZED, (Response.StatusType)response.getStatusInfo());
                    continue;
                }
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
                if (mediaType.contains("application/json")) {
                    TestRMWebServicesAppsModification.verifyAppPriorityJson(response, modifiedPriority);
                } else {
                    TestRMWebServicesAppsModification.verifyAppPriorityXML(response, modifiedPriority);
                }
                response = (Response)this.constructWebResource("apps", app.getApplicationId().toString(), "priority").request(new String[]{mediaType}).get(Response.class);
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
                if (mediaType.contains("application/json")) {
                    TestRMWebServicesAppsModification.verifyAppPriorityJson(response, modifiedPriority);
                } else {
                    TestRMWebServicesAppsModification.verifyAppPriorityXML(response, modifiedPriority);
                }
                MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("").withUser("someuser").build();
                app = MockRMAppSubmitter.submit(rm, data);
                amNodeManager.nodeHeartbeat(true);
                response = (Response)this.constructWebResource("apps", app.getApplicationId().toString(), "priority").request(new String[]{mediaType}).put(Entity.entity((Object)entity, (MediaType)contentType), Response.class);
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
            }
        }
        rm.stop();
    }

    @Test(timeout=90000L)
    public void testAppMove() throws Exception {
        boolean isCapacityScheduler = rm.getResourceScheduler() instanceof CapacityScheduler;
        CapacitySchedulerConfiguration csconf = new CapacitySchedulerConfiguration();
        String[] queues = new String[]{"default", "test"};
        csconf.setQueues(ROOT, queues);
        csconf.setCapacity(DEFAULT, 50.0f);
        csconf.setCapacity(TEST, 50.0f);
        csconf.setAcl(ROOT, QueueACL.ADMINISTER_QUEUE, "someuser");
        csconf.setAcl(DEFAULT, QueueACL.ADMINISTER_QUEUE, "someuser");
        csconf.setAcl(TEST, QueueACL.ADMINISTER_QUEUE, "someuser");
        rm.getResourceScheduler().reinitialize((Configuration)csconf, rm.getRMContext());
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        String[] mediaTypes = new String[]{"application/json", "application/xml"};
        MediaType[] contentTypes = new MediaType[]{MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_XML_TYPE};
        for (String mediaType : mediaTypes) {
            for (MediaType contentType : contentTypes) {
                MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("").withUser(this.webserviceUserName).build();
                RMApp app = MockRMAppSubmitter.submit(rm, data1);
                amNodeManager.nodeHeartbeat(true);
                AppQueue targetQueue = new AppQueue("test");
                Object entity = contentType.equals((Object)MediaType.APPLICATION_JSON_TYPE) ? TestRMWebServicesAppsModification.appQueueToJSON(targetQueue) : targetQueue;
                Response response = (Response)this.constructWebResource("apps", app.getApplicationId().toString(), "queue").request(new String[]{mediaType}).put(Entity.entity((Object)entity, (MediaType)contentType), Response.class);
                if (!this.isAuthenticationEnabled()) {
                    WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.UNAUTHORIZED, (Response.StatusType)response.getStatusInfo());
                    continue;
                }
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
                String expectedQueue = "root.test";
                if (mediaType.contains("application/json")) {
                    TestRMWebServicesAppsModification.verifyAppQueueJson(response, expectedQueue);
                } else {
                    TestRMWebServicesAppsModification.verifyAppQueueXML(response, expectedQueue);
                }
                Assert.assertEquals((Object)expectedQueue, (Object)app.getQueue());
                MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("").withUser("someuser").build();
                app = MockRMAppSubmitter.submit(rm, data);
                amNodeManager.nodeHeartbeat(true);
                response = (Response)this.constructWebResource("apps", app.getApplicationId().toString(), "queue").request().put(Entity.entity((Object)entity, (MediaType)contentType), Response.class);
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
                if (isCapacityScheduler) {
                    Assert.assertEquals((Object)"root.default", (Object)app.getQueue());
                    continue;
                }
                Assert.assertEquals((Object)"root.someuser", (Object)app.getQueue());
            }
        }
        rm.stop();
    }

    protected static String appPriorityToJSON(AppPriority targetPriority) throws Exception {
        StringWriter stringWriter = new StringWriter();
        APP_PRIORITY_WRITER.marshallToJSON((Object)targetPriority, (Writer)stringWriter);
        return stringWriter.toString();
    }

    protected static String appQueueToJSON(AppQueue targetQueue) throws Exception {
        StringWriter stringWriter = new StringWriter();
        APP_QUEUE_WRITER.marshallToJSON((Object)targetQueue, (Writer)stringWriter);
        return stringWriter.toString();
    }

    protected static void verifyAppPriorityJson(Response response, int expectedPriority) throws JSONException {
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject applicationpriority = json.getJSONObject("applicationpriority");
        int responsePriority = applicationpriority.getInt("priority");
        Assert.assertEquals((long)expectedPriority, (long)responsePriority);
    }

    protected static void verifyAppPriorityXML(Response response, int expectedPriority) throws ParserConfigurationException, IOException, SAXException {
        Assert.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        String xml = (String)response.readEntity(String.class);
        DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("applicationpriority");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        Element element = (Element)nodes.item(0);
        int responsePriority = WebServicesTestUtils.getXmlInt((Element)element, (String)"priority");
        Assert.assertEquals((long)expectedPriority, (long)responsePriority);
    }

    protected static void verifyAppQueueJson(Response response, String queue) throws JSONException {
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        String responseQueue = json.getJSONObject("appqueue").getString("queue");
        Assert.assertEquals((Object)queue, (Object)responseQueue);
    }

    protected static void verifyAppQueueXML(Response response, String queue) throws ParserConfigurationException, IOException, SAXException {
        Assert.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        String xml = (String)response.readEntity(String.class);
        DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("appqueue");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        Element element = (Element)nodes.item(0);
        String responseQueue = WebServicesTestUtils.getXmlString((Element)element, (String)"queue");
        Assert.assertEquals((Object)queue, (Object)responseQueue);
    }

    @Test(timeout=90000L)
    public void testUpdateAppTimeout() throws Exception {
        rm.start();
        rm.registerNode("127.0.0.1:1234", 2048);
        String[] mediaTypes = new String[]{"application/json", "application/xml"};
        MediaType[] contentTypes = new MediaType[]{MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_XML_TYPE};
        for (String mediaType : mediaTypes) {
            for (MediaType contentType : contentTypes) {
                MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("").withUser(this.webserviceUserName).build();
                RMApp app = MockRMAppSubmitter.submit(rm, data);
                Response response = (Response)this.constructWebResource("apps", app.getApplicationId().toString(), "timeouts").request(new String[]{mediaType}).get(Response.class);
                if (mediaType.contains("application/json")) {
                    Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                    JSONObject js = ((JSONObject)response.readEntity(JSONObject.class)).getJSONObject("timeouts");
                    JSONObject entity = js.getJSONObject("timeout");
                    TestRMWebServicesAppsModification.verifyAppTimeoutJson(entity, ApplicationTimeoutType.LIFETIME, "UNLIMITED", -1L);
                }
                long timeOutFromNow = 60L;
                String expireTime = Times.formatISO8601((long)(System.currentTimeMillis() + timeOutFromNow * 1000L));
                Object entity = this.getAppTimeoutInfoEntity(ApplicationTimeoutType.LIFETIME, contentType, expireTime);
                response = (Response)this.constructWebResource("apps", app.getApplicationId().toString(), "timeout").request(new String[]{mediaType}).put(Entity.entity((Object)entity, (MediaType)contentType), Response.class);
                if (!this.isAuthenticationEnabled()) {
                    WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.UNAUTHORIZED, (Response.StatusType)response.getStatusInfo());
                    continue;
                }
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
                if (mediaType.contains("application/json")) {
                    TestRMWebServicesAppsModification.verifyAppTimeoutJson(response, ApplicationTimeoutType.LIFETIME, expireTime, timeOutFromNow);
                } else {
                    TestRMWebServicesAppsModification.verifyAppTimeoutXML(response, ApplicationTimeoutType.LIFETIME, expireTime, timeOutFromNow);
                }
                entity = this.getAppTimeoutInfoEntity(null, contentType, null);
                response = (Response)this.constructWebResource("apps", app.getApplicationId().toString(), "timeout").request(new String[]{mediaType}).put(Entity.entity((Object)entity, (MediaType)contentType), Response.class);
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
                response = (Response)this.constructWebResource("apps", app.getApplicationId().toString(), "timeouts", ApplicationTimeoutType.LIFETIME.toString()).request(new String[]{mediaType}).get(Response.class);
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
                if (!mediaType.contains("application/json")) continue;
                TestRMWebServicesAppsModification.verifyAppTimeoutJson(response, ApplicationTimeoutType.LIFETIME, expireTime, timeOutFromNow);
            }
        }
        rm.stop();
    }

    private Object getAppTimeoutInfoEntity(ApplicationTimeoutType type, MediaType contentType, String expireTime) throws Exception {
        AppTimeoutInfo timeoutUpdate = new AppTimeoutInfo();
        timeoutUpdate.setTimeoutType(type);
        timeoutUpdate.setExpiryTime(expireTime);
        Object entity = contentType.equals((Object)MediaType.APPLICATION_JSON_TYPE) ? TestRMWebServicesAppsModification.appTimeoutToJSON(timeoutUpdate) : timeoutUpdate;
        return entity;
    }

    protected static void verifyAppTimeoutJson(Response response, ApplicationTimeoutType type, String expireTime, long timeOutFromNow) throws JSONException {
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        JSONObject jsonTimeout = (JSONObject)response.readEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)jsonTimeout.length());
        JSONObject json = jsonTimeout.getJSONObject("timeout");
        TestRMWebServicesAppsModification.verifyAppTimeoutJson(json, type, expireTime, timeOutFromNow);
    }

    protected static void verifyAppTimeoutJson(JSONObject json, ApplicationTimeoutType type, String expireTime, long timeOutFromNow) throws JSONException {
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)json.length());
        Assert.assertEquals((Object)type.toString(), (Object)json.getString("type"));
        Assert.assertEquals((Object)expireTime, (Object)json.getString("expiryTime"));
        Assert.assertTrue((json.getLong("remainingTimeInSeconds") <= timeOutFromNow ? 1 : 0) != 0);
    }

    protected static void verifyAppTimeoutXML(Response response, ApplicationTimeoutType type, String expireTime, long timeOutFromNow) throws ParserConfigurationException, IOException, SAXException {
        Assert.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        String xml = (String)response.readEntity(String.class);
        DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("timeout");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        Element element = (Element)nodes.item(0);
        Assert.assertEquals((Object)type.toString(), (Object)WebServicesTestUtils.getXmlString((Element)element, (String)"type"));
        Assert.assertEquals((Object)expireTime, (Object)WebServicesTestUtils.getXmlString((Element)element, (String)"expiryTime"));
        Assert.assertTrue((WebServicesTestUtils.getXmlLong((Element)element, (String)"remainingTimeInSeconds") < timeOutFromNow ? 1 : 0) != 0);
    }

    protected static String appTimeoutToJSON(AppTimeoutInfo timeout) throws Exception {
        StringWriter stringWriter = new StringWriter();
        APP_TIMEOUT_WRITER.marshallToJSON((Object)timeout, (Writer)stringWriter);
        return stringWriter.toString();
    }

    static {
        JettisonJaxbContext jettisonJaxbContext;
        TEST_DIR = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
        FS_ALLOC_FILE = new File(TEST_DIR, "test-fs-queues.xml").getAbsolutePath();
        ROOT = new QueuePath("root");
        DEFAULT = ROOT.createNewLeaf("default");
        TEST = ROOT.createNewLeaf("test");
        TEST_QUEUE = ROOT.createNewLeaf("testqueue");
        try {
            jettisonJaxbContext = new JettisonJaxbContext(new Class[]{AppState.class});
            APP_STATE_WRITER = jettisonJaxbContext.createJsonMarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        try {
            jettisonJaxbContext = new JettisonJaxbContext(new Class[]{AppPriority.class});
            APP_PRIORITY_WRITER = jettisonJaxbContext.createJsonMarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        try {
            jettisonJaxbContext = new JettisonJaxbContext(new Class[]{AppQueue.class});
            APP_QUEUE_WRITER = jettisonJaxbContext.createJsonMarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        try {
            jettisonJaxbContext = new JettisonJaxbContext(new Class[]{AppTimeoutInfo.class});
            APP_TIMEOUT_WRITER = jettisonJaxbContext.createJsonMarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Singleton
    public static class TestRMCustomAuthFilter
    extends AuthenticationFilter {
        protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
            Properties props = new Properties();
            Enumeration names = filterConfig.getInitParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!name.startsWith(configPrefix)) continue;
                String value = filterConfig.getInitParameter(name);
                props.put(name.substring(configPrefix.length()), value);
            }
            props.put("type", "simple");
            props.put("simple.anonymous.allowed", "false");
            return props;
        }
    }

    private class CapTestServletModule
    extends JerseyBinder {
        CapTestServletModule(boolean flag) {
            if (flag) {
                this.getConf().setBoolean("yarn.acl.enable", true);
                this.getConf().setStrings("yarn.admin.acl", new String[]{"testuser1"});
            }
        }

        @Override
        public void configureScheduler() {
            this.getConf().set("yarn.resourcemanager.scheduler.class", CapacityScheduler.class.getName());
        }
    }

    private class FairTestServletModule
    extends JerseyBinder {
        FairTestServletModule(boolean flag) {
            if (flag) {
                this.getConf().setBoolean("yarn.acl.enable", true);
                this.getConf().setStrings("yarn.admin.acl", new String[]{"testuser1"});
            }
        }

        @Override
        public void configureScheduler() {
            AllocationFileWriter.create().addQueue(new AllocationFileQueue.Builder("root").aclAdministerApps("someuser ").subQueue(new AllocationFileQueue.Builder("default").aclAdministerApps("someuser ").build()).subQueue(new AllocationFileQueue.Builder("test").aclAdministerApps("someuser ").build()).build()).writeToFile(FS_ALLOC_FILE);
            this.getConf().set("yarn.scheduler.fair.allocation.file", FS_ALLOC_FILE);
            this.getConf().set("yarn.resourcemanager.scheduler.class", FairScheduler.class.getName());
        }
    }

    private class JerseyBinder
    extends AbstractBinder {
        private Configuration conf = new YarnConfiguration();

        private JerseyBinder() {
        }

        protected void configure() {
            this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
            this.configureScheduler();
            rm = new MockRM(this.conf);
            ((InstanceBinding)this.bind((Object)rm).to(ResourceManager.class)).named("rm");
            ((InstanceBinding)this.bind(this.conf).to(Configuration.class)).named("conf");
            this.bind(TestRMWebServicesAppsModification.this.hsRequest).to(HttpServletRequest.class);
            this.bind(TestRMWebServicesAppsModification.this.hsResponse).to(HttpServletResponse.class);
        }

        public void configureScheduler() {
        }

        public Configuration getConf() {
            return this.conf;
        }
    }
}

