/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServicesCustomResourceTypesCommons;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.helper.BufferedClientResponse;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.helper.JsonCustomResourceTypeTestcase;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.helper.XmlCustomResourceTypeTestCase;
import org.apache.hadoop.yarn.util.resource.CustomResourceTypesConfigurationProvider;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.w3c.dom.NodeList;

public class TestRMWebServicesAppCustomResourceTypes
extends JerseyTestBase {
    private static MockRM rm;
    private static final int CONTAINER_MB = 1024;

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register((Object)new JerseyBinder());
        config.register(RMWebServices.class);
        config.register(GenericExceptionHandler.class);
        config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        this.forceSet("jersey.config.test.container.port", "0");
        return config;
    }

    private WebTarget getWebResourcePathForApp(RMApp app1, WebTarget r) {
        return r.path("ws").path("v1").path("cluster").path("apps").path(String.valueOf(app1.getApplicationId().toString()));
    }

    @Test
    public void testRunningAppXml() throws Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("testwordcount").withUser("user1").build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, amNodeManager);
        am1.allocate("*", 2048, 1, new ArrayList<ContainerId>());
        amNodeManager.nodeHeartbeat(true);
        WebTarget r = this.target();
        WebTarget path = this.getWebResourcePathForApp(app1, r);
        Response response = (Response)path.request(new String[]{"application/xml"}).get(Response.class);
        XmlCustomResourceTypeTestCase testCase = new XmlCustomResourceTypeTestCase(path, new BufferedClientResponse(response));
        testCase.verify(document -> {
            NodeList appArray = document.getElementsByTagName("app");
            Assert.assertEquals((String)"incorrect number of app elements", (long)1L, (long)appArray.getLength());
            TestRMWebServicesCustomResourceTypesCommons.verifyAppsXML(appArray, app1, rm);
        });
        rm.stop();
    }

    @Test
    public void testRunningAppJson() throws Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("testwordcount").withUser("user1").build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, amNodeManager);
        am1.allocate("*", 2048, 1, new ArrayList<ContainerId>());
        amNodeManager.nodeHeartbeat(true);
        WebTarget r = this.target();
        WebTarget path = this.getWebResourcePathForApp(app1, r);
        Response response = (Response)path.request(new String[]{"application/json"}).get(Response.class);
        JsonCustomResourceTypeTestcase testCase = new JsonCustomResourceTypeTestcase(path, new BufferedClientResponse(response));
        testCase.verify(json -> {
            try {
                Assert.assertEquals((String)"incorrect number of app elements", (long)1L, (long)json.length());
                JSONObject app = json.getJSONObject("app");
                TestRMWebServicesCustomResourceTypesCommons.verifyAppInfoJson(app, app1, rm);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        });
        rm.stop();
    }

    private class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            YarnConfiguration conf = new YarnConfiguration();
            conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
            conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
            this.initResourceTypes((Configuration)conf);
            rm = new MockRM((Configuration)conf);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getScheme()).thenReturn((Object)"http");
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            ((InstanceBinding)this.bind((Object)rm).to(ResourceManager.class)).named("rm");
            ((InstanceBinding)this.bind(conf).to(Configuration.class)).named("conf");
            this.bind(request).to(HttpServletRequest.class);
            this.bind(response).to(HttpServletResponse.class);
        }

        private void initResourceTypes(Configuration conf) {
            conf.set("yarn.resourcemanager.configuration.provider-class", CustomResourceTypesConfigurationProvider.class.getName());
            ResourceUtils.resetResourceTypes((Configuration)conf);
        }
    }
}

