/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.io.StringReader;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.XMLUtils;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.assertj.core.api.Assertions;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestRMWebServicesAppAttempts
extends JerseyTestBase {
    private static MockRM rm;
    private static final int CONTAINER_MB = 1024;

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register((Object)new JerseyBinder());
        config.register(RMWebServices.class);
        config.register(GenericExceptionHandler.class);
        config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        this.forceSet("jersey.config.test.container.port", "0");
        return config;
    }

    @Test
    public void testAppAttempts() throws Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("testwordcount").withUser("user1").build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        amNodeManager.nodeHeartbeat(true);
        this.testAppAttemptsHelper(app1.getApplicationId().toString(), app1, "application/json");
        rm.stop();
    }

    @Test(timeout=20000L)
    public void testCompletedAppAttempt() throws Exception {
        Configuration conf = rm.getConfig();
        String logServerUrl = "http://localhost:19888/jobhistory/logs";
        conf.set("yarn.log.server.url", logServerUrl);
        conf.setInt("yarn.resourcemanager.am.max-attempts", 1);
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 8192);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("testwordcount").withUser("user1").build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        MockAM am = MockRM.launchAndRegisterAM(app1, rm, amNodeManager);
        amNodeManager.nodeHeartbeat(am.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm.waitForState(am.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        rm.waitForState(app1.getApplicationId(), RMAppState.FAILED);
        WebTarget r = this.targetWithJsonObject();
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("apps").path(app1.getApplicationId().toString()).path("appattempts").request(new String[]{"application/json"}).get(Response.class);
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        JSONObject jsonAppAttempts = json.getJSONObject("appAttempts");
        JSONObject jsonAppAttempt = jsonAppAttempts.getJSONObject("appAttempt");
        JSONArray jsonArray = new JSONArray();
        jsonArray.put((Object)jsonAppAttempt);
        JSONObject info = jsonArray.getJSONObject(0);
        String logsLink = info.getString("logsLink");
        String containerId = app1.getCurrentAppAttempt().getMasterContainer().getId().toString();
        Assertions.assertThat((String)logsLink).isEqualTo((Object)(logServerUrl + "/127.0.0.1:1234/" + containerId + "/" + containerId + "/user1"));
        rm.stop();
    }

    @Test(timeout=20000L)
    public void testMultipleAppAttempts() throws Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 8192);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("testwordcount").withUser("user1").build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        MockAM am = MockRM.launchAndRegisterAM(app1, rm, amNodeManager);
        int maxAppAttempts = rm.getConfig().getInt("yarn.resourcemanager.am.max-attempts", 2);
        Assert.assertTrue((maxAppAttempts > 1 ? 1 : 0) != 0);
        int numAttempt = 1;
        while (true) {
            amNodeManager.nodeHeartbeat(am.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
            rm.waitForState(am.getApplicationAttemptId(), RMAppAttemptState.FAILED);
            if (numAttempt == maxAppAttempts) break;
            rm.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
            am = MockRM.launchAndRegisterAM(app1, rm, amNodeManager);
            ++numAttempt;
        }
        rm.waitForState(app1.getApplicationId(), RMAppState.FAILED);
        Assert.assertEquals((String)"incorrect number of attempts", (long)maxAppAttempts, (long)app1.getAppAttempts().values().size());
        this.testAppAttemptsHelper(app1.getApplicationId().toString(), app1, "application/json");
        rm.stop();
    }

    @Test
    public void testAppAttemptsSlash() throws Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(1024L, rm);
        amNodeManager.nodeHeartbeat(true);
        this.testAppAttemptsHelper(app1.getApplicationId().toString() + "/", app1, "application/json");
        rm.stop();
    }

    @Test
    public void testAppAttemptsDefault() throws Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(1024L, rm);
        amNodeManager.nodeHeartbeat(true);
        this.testAppAttemptsHelper(app1.getApplicationId().toString() + "/", app1, "");
        rm.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidAppIdGetAttempts() throws Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app = MockRMAppSubmitter.submitWithMemory(1024L, rm);
        amNodeManager.nodeHeartbeat(true);
        WebTarget r = this.targetWithJsonObject();
        try {
            try {
                Response response = r.path("ws").path("v1").path("cluster").path("apps").path("application_invalid_12").path("appattempts").request(new String[]{"application/json"}).get();
                throw new BadRequestException(response);
            }
            catch (BadRequestException ue) {
                Response response = ue.getResponse();
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
                Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject msg = (JSONObject)response.readEntity(JSONObject.class);
                JSONObject exception = msg.getJSONObject("RemoteException");
                Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
                String message = exception.getString("message");
                String type = exception.getString("exception");
                String classname = exception.getString("javaClassName");
                WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"Invalid ApplicationId: application_invalid_12", (String)message);
                WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"BadRequestException", (String)type);
                WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)classname);
                rm.stop();
            }
        }
        catch (Throwable throwable) {
            rm.stop();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidAppAttemptId() throws Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app = MockRMAppSubmitter.submitWithMemory(1024L, rm);
        amNodeManager.nodeHeartbeat(true);
        WebTarget r = this.targetWithJsonObject();
        try {
            try {
                Response response = r.path("ws").path("v1").path("cluster").path("apps").path(app.getApplicationId().toString()).path("appattempts").path("appattempt_invalid_12_000001").request(new String[]{"application/json"}).get();
                throw new BadRequestException(response);
            }
            catch (BadRequestException ue) {
                Response response = ue.getResponse();
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
                Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject msg = (JSONObject)response.readEntity(JSONObject.class);
                JSONObject exception = msg.getJSONObject("RemoteException");
                Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
                String message = exception.getString("message");
                String type = exception.getString("exception");
                String classname = exception.getString("javaClassName");
                WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"Invalid AppAttemptId: appattempt_invalid_12_000001", (String)message);
                WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"BadRequestException", (String)type);
                WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)classname);
                rm.stop();
            }
        }
        catch (Throwable throwable) {
            rm.stop();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonexistAppAttempts() throws Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("testwordcount").withUser("user1").build();
        MockRMAppSubmitter.submit(rm, data);
        amNodeManager.nodeHeartbeat(true);
        WebTarget r = this.targetWithJsonObject();
        try {
            try {
                Response response = r.path("ws").path("v1").path("cluster").path("apps").path("application_00000_0099").request(new String[]{"application/json"}).get();
                throw new NotFoundException(response);
            }
            catch (NotFoundException ue) {
                Response response = ue.getResponse();
                WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
                Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
                JSONObject msg = (JSONObject)response.readEntity(JSONObject.class);
                JSONObject exception = msg.getJSONObject("RemoteException");
                Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
                String message = exception.getString("message");
                String type = exception.getString("exception");
                String classname = exception.getString("javaClassName");
                WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"app with id: application_00000_0099 not found", (String)message);
                WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
                WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
                rm.stop();
            }
        }
        catch (Throwable throwable) {
            rm.stop();
            throw throwable;
        }
    }

    private void testAppAttemptsHelper(String path, RMApp app, String media) throws Exception {
        WebTarget r = this.targetWithJsonObject();
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("apps").path(path).path("appattempts").request(new String[]{media}).get(Response.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject jsonAppAttempts = json.getJSONObject("appAttempts");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)jsonAppAttempts.length());
        JSONArray jsonArray = this.parseJsonAppAttempt(jsonAppAttempts);
        Collection attempts = app.getAppAttempts().values();
        Assert.assertEquals((String)"incorrect number of elements", (long)attempts.size(), (long)jsonArray.length());
        int i = 0;
        for (RMAppAttempt attempt : attempts) {
            this.verifyAppAttemptsInfo(jsonArray.getJSONObject(i), attempt, app.getUser());
            ++i;
        }
    }

    public JSONArray parseJsonAppAttempt(JSONObject jsonAppAttempts) throws JSONException {
        Object appAttempt = jsonAppAttempts.get("appAttempt");
        if (appAttempt instanceof JSONArray) {
            return jsonAppAttempts.getJSONArray("appAttempt");
        }
        if (appAttempt instanceof JSONObject) {
            JSONObject jsonAppAttempt = jsonAppAttempts.getJSONObject("appAttempt");
            JSONArray jsonArray = new JSONArray();
            jsonArray.put((Object)jsonAppAttempt);
            return jsonArray;
        }
        return null;
    }

    @Test
    public void testAppAttemptsXML() throws Exception {
        rm.start();
        String user = "user1";
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("testwordcount").withUser(user).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        amNodeManager.nodeHeartbeat(true);
        WebTarget r = this.target();
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("apps").path(app1.getApplicationId().toString()).path("appattempts").request(new String[]{"application/xml"}).get(Response.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + ";charset=utf-8"), (Object)response.getMediaType().toString());
        String xml = (String)response.readEntity(String.class);
        DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("appAttempts");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        NodeList attempt = dom.getElementsByTagName("appAttempt");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)attempt.getLength());
        this.verifyAppAttemptsXML(attempt, app1.getCurrentAppAttempt(), user);
        rm.stop();
    }

    private void verifyAppAttemptsXML(NodeList nodes, RMAppAttempt appAttempt, String user) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            this.verifyAppAttemptInfoGeneric(appAttempt, WebServicesTestUtils.getXmlInt((Element)element, (String)"id"), WebServicesTestUtils.getXmlLong((Element)element, (String)"startTime"), WebServicesTestUtils.getXmlString((Element)element, (String)"containerId"), WebServicesTestUtils.getXmlString((Element)element, (String)"nodeHttpAddress"), WebServicesTestUtils.getXmlString((Element)element, (String)"nodeId"), WebServicesTestUtils.getXmlString((Element)element, (String)"logsLink"), user, WebServicesTestUtils.getXmlString((Element)element, (String)"exportPorts"), WebServicesTestUtils.getXmlString((Element)element, (String)"appAttemptState"));
        }
    }

    private void verifyAppAttemptsInfo(JSONObject info, RMAppAttempt appAttempt, String user) throws Exception {
        Assert.assertEquals((String)"incorrect number of elements", (long)12L, (long)info.length());
        this.verifyAppAttemptInfoGeneric(appAttempt, info.getInt("id"), info.getLong("startTime"), info.getString("containerId"), info.getString("nodeHttpAddress"), info.getString("nodeId"), info.getString("logsLink"), user, info.getString("exportPorts"), info.getString("appAttemptState"));
    }

    private void verifyAppAttemptInfoGeneric(RMAppAttempt appAttempt, int id, long startTime, String containerId, String nodeHttpAddress, String nodeId, String logsLink, String user, String exportPorts, String appAttemptState) {
        Assert.assertEquals((String)"id doesn't match", (long)appAttempt.getAppAttemptId().getAttemptId(), (long)id);
        Assert.assertEquals((String)"startedTime doesn't match", (long)appAttempt.getStartTime(), (long)startTime);
        WebServicesTestUtils.checkStringMatch((String)"containerId", (String)appAttempt.getMasterContainer().getId().toString(), (String)containerId);
        WebServicesTestUtils.checkStringMatch((String)"nodeHttpAddress", (String)appAttempt.getMasterContainer().getNodeHttpAddress(), (String)nodeHttpAddress);
        WebServicesTestUtils.checkStringMatch((String)"nodeId", (String)appAttempt.getMasterContainer().getNodeId().toString(), (String)nodeId);
        Assert.assertTrue((String)"logsLink doesn't match ", (boolean)logsLink.startsWith("http://"));
        Assert.assertTrue((String)"logsLink doesn't contain user info", (boolean)logsLink.endsWith("/" + user));
        Assert.assertEquals((String)"appAttemptState doesn't match", (Object)appAttemptState, (Object)appAttempt.getAppAttemptState().toString());
    }

    private class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            YarnConfiguration conf = new YarnConfiguration();
            conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
            conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
            rm = new MockRM((Configuration)conf);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getScheme()).thenReturn((Object)"http");
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            ((InstanceBinding)this.bind((Object)rm).to(ResourceManager.class)).named("rm");
            ((InstanceBinding)this.bind(conf).to(Configuration.class)).named("conf");
            this.bind(request).to(HttpServletRequest.class);
            this.bind(response).to(HttpServletResponse.class);
        }
    }
}

