/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRMWebServiceAppsNodelabel
extends JerseyTestBase {
    private static final int AM_CONTAINER_MB = 1024;
    private static RMNodeLabelsManager nodeLabelManager;
    private static MockRM rm;
    private static CapacitySchedulerConfiguration csConf;
    private static YarnConfiguration conf;

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register((Object)new JerseyBinder());
        config.register(RMWebServices.class);
        config.register(GenericExceptionHandler.class);
        config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        this.forceSet("jersey.config.test.container.port", "0");
        return config;
    }

    private static void setupQueueConfiguration(CapacitySchedulerConfiguration config) {
        QueuePath root = new QueuePath("root");
        QueuePath queueA = root.createNewLeaf("a");
        QueuePath defaultQueue = root.createNewLeaf("default");
        config.setQueues(root, new String[]{"a", "default"});
        config.setCapacity(queueA, 50.0f);
        config.setMaximumCapacity(queueA, 50.0f);
        config.setCapacity(defaultQueue, 50.0f);
        config.setCapacityByLabel(root, "X", 100.0f);
        config.setMaximumCapacityByLabel(root, "X", 100.0f);
        config.setCapacityByLabel(defaultQueue, "X", 100.0f);
        config.setMaximumCapacityByLabel(defaultQueue, "X", 100.0f);
    }

    @Test
    public void testAppsFinished() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        amNodeManager.nodeHeartbeat(true);
        RMApp killedApp = MockRMAppSubmitter.submitWithMemory(1024L, rm);
        rm.killApp(killedApp.getApplicationId());
        WebTarget r = this.targetWithJsonObject();
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("apps").request(new String[]{"application/json"}).get(Response.class);
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        JSONObject apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        try {
            apps.getJSONArray("app").getJSONObject(0).getJSONObject("resourceInfo");
            Assert.fail((String)"resourceInfo object shouldn't be available for finished apps");
        }
        catch (Exception e) {
            Assert.assertTrue((String)"resourceInfo shouldn't be available for finished apps", (boolean)true);
        }
        rm.stop();
    }

    @Test
    public void testAppsRunning() throws JSONException, Exception {
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 2048);
        MockNM nm2 = rm.registerNode("h2:1235", 2048);
        nodeLabelManager.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h2", (int)1235), this.toSet("X")));
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("default").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
        nm1.nodeHeartbeat(true);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "X");
        nm2.nodeHeartbeat(true);
        WebTarget r = this.targetWithJsonObject();
        Response response = (Response)r.path("ws").path("v1").path("cluster").path("apps").request(new String[]{"application/json"}).get(Response.class);
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        JSONObject apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        JSONObject jsonObject = apps.getJSONObject("app").getJSONObject("resourceInfo");
        JSONArray jsonArray = jsonObject.getJSONArray("resourceUsagesByPartition");
        Assert.assertEquals((String)"Partition expected is 2", (long)2L, (long)jsonArray.length());
        JSONObject defaultPartition = jsonArray.getJSONObject(0);
        this.verifyResource(defaultPartition, "", this.getResource(1024, 1), this.getResource(1024, 1), this.getResource(0, 0));
        JSONObject partitionX = jsonArray.getJSONObject(1);
        this.verifyResource(partitionX, "X", this.getResource(0, 0), this.getResource(1024, 1), this.getResource(0, 0));
        rm.stop();
    }

    private String getResource(int memory, int vcore) {
        return "{\"memory\":" + memory + ",\"vCores\":" + vcore + "}";
    }

    private void verifyResource(JSONObject partition, String partitionName, String amused, String used, String reserved) throws JSONException {
        JSONObject amusedObject = (JSONObject)partition.get("amUsed");
        JSONObject usedObject = (JSONObject)partition.get("used");
        JSONObject reservedObject = (JSONObject)partition.get("reserved");
        Assert.assertEquals((String)"Partition expected", (Object)partitionName, (Object)partition.get("partitionName"));
        Assert.assertEquals((String)"partition amused", (Object)amused, (Object)this.getResource((Integer)amusedObject.get("memory"), (Integer)amusedObject.get("vCores")));
        Assert.assertEquals((String)"partition used", (Object)used, (Object)this.getResource((Integer)usedObject.get("memory"), (Integer)usedObject.get("vCores")));
        Assert.assertEquals((String)"partition reserved", (Object)reserved, (Object)this.getResource((Integer)reservedObject.get("memory"), (Integer)reservedObject.get("vCores")));
    }

    private <E> Set<E> toSet(E ... elements) {
        return Sets.newHashSet((Object[])elements);
    }

    private static class JerseyBinder
    extends AbstractBinder {
        private static final String LABEL_X = "X";

        private JerseyBinder() {
        }

        protected void configure() {
            csConf = new CapacitySchedulerConfiguration();
            TestRMWebServiceAppsNodelabel.setupQueueConfiguration(csConf);
            conf = new YarnConfiguration((Configuration)csConf);
            conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
            rm = new MockRM((Configuration)conf);
            HashSet<NodeLabel> labels = new HashSet<NodeLabel>();
            labels.add(NodeLabel.newInstance((String)LABEL_X));
            try {
                nodeLabelManager = rm.getRMContext().getNodeLabelManager();
                nodeLabelManager.addToCluserNodeLabels(labels);
            }
            catch (Exception e) {
                Assert.fail();
            }
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            ((InstanceBinding)this.bind((Object)rm).to(ResourceManager.class)).named("rm");
            ((InstanceBinding)this.bind(conf).to(Configuration.class)).named("conf");
            this.bind(request).to(HttpServletRequest.class);
            this.bind(response).to(HttpServletResponse.class);
        }
    }
}

