/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.applicationsmanager.MockAsm;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.ColumnHeader;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.NodesPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMAppsBlock;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebApp;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RmController;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RmView;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.webapp.WebPageUtils;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.apache.hadoop.yarn.webapp.test.WebAppTests;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestRMWebApp {
    static final int GiB = 1024;

    @Test
    public void testControllerIndex() {
        Injector injector = WebAppTests.createMockInjector(TestRMWebApp.class, (Object)this, (Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                binder.bind(ApplicationACLsManager.class).toInstance((Object)new ApplicationACLsManager(new Configuration()));
            }
        }});
        RmController c = (RmController)injector.getInstance(RmController.class);
        c.index();
        Assert.assertEquals((Object)"Applications", (Object)c.get("title", "unknown"));
    }

    @Test
    public void testView() {
        Injector injector = WebAppTests.createMockInjector(RMContext.class, (Object)TestRMWebApp.mockRMContext(15, 1, 2, 8192), (Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                try {
                    ResourceManager mockRm = TestRMWebApp.mockRm(3, 1, 2, 8192);
                    binder.bind(ResourceManager.class).toInstance((Object)mockRm);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }});
        RmView rmViewInstance = (RmView)injector.getInstance(RmView.class);
        rmViewInstance.set("app.state", YarnApplicationState.RUNNING.toString());
        rmViewInstance.render();
        WebAppTests.flushOutput((Injector)injector);
        rmViewInstance.set("app.state", StringHelper.cjoin((Object[])new Object[]{YarnApplicationState.ACCEPTED.toString(), YarnApplicationState.RUNNING.toString()}));
        rmViewInstance.render();
        WebAppTests.flushOutput((Injector)injector);
        Map moreParams = rmViewInstance.context().requestContext().moreParams();
        String appsTableColumnsMeta = (String)moreParams.get("ui.dataTables.apps.init");
        Assert.assertTrue((appsTableColumnsMeta.indexOf("natural") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testNodesPage() {
        RMContext rmContext = TestRMWebApp.mockRMContext(3, 2, 12, 8192);
        Injector injector = WebAppTests.createMockInjector(RMContext.class, (Object)rmContext, (Module[])new Module[]{binder -> {
            try {
                binder.bind(ResourceManager.class).toInstance((Object)TestRMWebApp.mockRm(rmContext));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }});
        NodesPage instance = (NodesPage)injector.getInstance(NodesPage.class);
        instance.render();
        WebAppTests.flushOutput((Injector)injector);
        instance.moreParams().put("node.state", NodeState.UNHEALTHY.toString());
        instance.render();
        WebAppTests.flushOutput((Injector)injector);
        instance.moreParams().put("node.state", NodeState.LOST.toString());
        instance.render();
        WebAppTests.flushOutput((Injector)injector);
    }

    @Test
    public void testRMAppColumnIndices() {
        LinkedList<Integer> colsId = new LinkedList<Integer>();
        LinkedList<Integer> colsTime = new LinkedList<Integer>();
        LinkedList<Integer> colsProgress = new LinkedList<Integer>();
        for (int i = 0; i < RMAppsBlock.COLUMNS.length; ++i) {
            ColumnHeader col = RMAppsBlock.COLUMNS[i];
            if (col.getCData().contains("ID")) {
                colsId.add(i);
                continue;
            }
            if (col.getCData().contains("Time")) {
                colsTime.add(i);
                continue;
            }
            if (!col.getCData().contains("Progress")) continue;
            colsProgress.add(i);
        }
        String tableInit = WebPageUtils.appsTableInit((boolean)true);
        for (String tableLine : tableInit.split("\\n")) {
            if (tableLine.contains("parseHadoopID")) {
                Assert.assertTrue((String)(tableLine + " should have id " + colsId), (boolean)tableLine.contains(((Object)colsId).toString()));
                continue;
            }
            if (tableLine.contains("renderHadoopDate")) {
                Assert.assertTrue((String)(tableLine + " should have dates " + colsTime), (boolean)tableLine.contains(((Object)colsTime).toString()));
                continue;
            }
            if (!tableLine.contains("parseHadoopProgress")) continue;
            Assert.assertTrue((String)(tableLine + " should have progress " + colsProgress), (boolean)tableLine.contains(((Object)colsProgress).toString()));
        }
    }

    public static RMContext mockRMContext(int numApps, int racks, int numNodes, int mbsPerNode) {
        List<RMApp> apps = MockAsm.newApplications(numApps);
        final ConcurrentMap applicationsMaps = Maps.newConcurrentMap();
        for (RMApp app : apps) {
            applicationsMaps.put(app.getApplicationId(), app);
        }
        List<RMNode> nodes = MockNodes.newNodes(racks, numNodes, MockNodes.newResource(mbsPerNode));
        final ConcurrentMap nodesMap = Maps.newConcurrentMap();
        for (RMNode node : nodes) {
            nodesMap.put(node.getNodeID(), node);
        }
        List<RMNode> deactivatedNodes = MockNodes.deactivatedNodes(racks, numNodes, MockNodes.newResource(mbsPerNode));
        final ConcurrentMap deactivatedNodesMap = Maps.newConcurrentMap();
        for (RMNode node : deactivatedNodes) {
            deactivatedNodesMap.put(node.getNodeID(), node);
        }
        RMContextImpl rmContext = new RMContextImpl(null, null, null, null, null, null, null, null, null, null){

            public ConcurrentMap<ApplicationId, RMApp> getRMApps() {
                return applicationsMaps;
            }

            public ConcurrentMap<NodeId, RMNode> getInactiveRMNodes() {
                return deactivatedNodesMap;
            }

            public ConcurrentMap<NodeId, RMNode> getRMNodes() {
                return nodesMap;
            }
        };
        rmContext.setNodeLabelManager((RMNodeLabelsManager)new NullRMNodeLabelsManager());
        rmContext.setYarnConfiguration((Configuration)new YarnConfiguration());
        return rmContext;
    }

    public static ResourceManager mockRm(int apps, int racks, int nodes, int mbsPerNode) throws IOException {
        RMContext rmContext = TestRMWebApp.mockRMContext(apps, racks, nodes, mbsPerNode);
        return TestRMWebApp.mockRm(rmContext);
    }

    public static ResourceManager mockRm(RMContext rmContext) throws IOException {
        return TestRMWebApp.mockRm(rmContext, false);
    }

    public static ResourceManager mockRm(RMContext rmContext, boolean useDRC) throws IOException {
        ResourceManager rm = (ResourceManager)Mockito.mock(ResourceManager.class);
        CapacityScheduler rs = TestRMWebApp.mockCapacityScheduler(useDRC);
        ApplicationACLsManager aclMgr = TestRMWebApp.mockAppACLsManager();
        ClientRMService clientRMService = TestRMWebApp.mockClientRMService(rmContext);
        Mockito.when((Object)rm.getResourceScheduler()).thenReturn((Object)rs);
        Mockito.when((Object)rm.getRMContext()).thenReturn((Object)rmContext);
        Mockito.when((Object)rm.getApplicationACLsManager()).thenReturn((Object)aclMgr);
        Mockito.when((Object)rm.getClientRMService()).thenReturn((Object)clientRMService);
        return rm;
    }

    public static CapacityScheduler mockCapacityScheduler() throws IOException {
        return TestRMWebApp.mockCapacityScheduler(false);
    }

    public static CapacityScheduler mockCapacityScheduler(boolean useDRC) throws IOException {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        TestRMWebApp.setupQueueConfiguration(conf, useDRC);
        CapacityScheduler cs = new CapacityScheduler();
        YarnConfiguration yarnConf = new YarnConfiguration();
        cs.setConf((Configuration)yarnConf);
        RMContextImpl rmContext = new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)conf), new NMTokenSecretManagerInRM((Configuration)conf), new ClientToAMTokenSecretManagerInRM(), null);
        NullRMNodeLabelsManager labelManager = new NullRMNodeLabelsManager();
        labelManager.init((Configuration)yarnConf);
        rmContext.setNodeLabelManager((RMNodeLabelsManager)labelManager);
        cs.setRMContext((RMContext)rmContext);
        cs.init((Configuration)conf);
        return cs;
    }

    public static ApplicationACLsManager mockAppACLsManager() {
        Configuration conf = new Configuration();
        return new ApplicationACLsManager(conf);
    }

    public static ClientRMService mockClientRMService(RMContext rmContext) {
        ClientRMService clientRMService = (ClientRMService)Mockito.mock(ClientRMService.class);
        ArrayList<ApplicationReport> appReports = new ArrayList<ApplicationReport>();
        for (RMApp app : rmContext.getRMApps().values()) {
            ApplicationReport appReport = ApplicationReport.newInstance((ApplicationId)app.getApplicationId(), (ApplicationAttemptId)null, (String)app.getUser(), (String)app.getQueue(), (String)app.getName(), (String)null, (int)0, (Token)null, (YarnApplicationState)app.createApplicationState(), (String)app.getDiagnostics().toString(), (String)null, (long)app.getStartTime(), (long)app.getLaunchTime(), (long)app.getFinishTime(), (FinalApplicationStatus)app.getFinalApplicationStatus(), (ApplicationResourceUsageReport)null, (String)app.getTrackingUrl(), (float)app.getProgress(), (String)app.getApplicationType(), (Token)null);
            appReports.add(appReport);
        }
        GetApplicationsResponse response = (GetApplicationsResponse)Mockito.mock(GetApplicationsResponse.class);
        Mockito.when((Object)response.getApplicationList()).thenReturn(appReports);
        try {
            Mockito.when((Object)clientRMService.getApplications((GetApplicationsRequest)ArgumentMatchers.any(GetApplicationsRequest.class))).thenReturn((Object)response);
        }
        catch (YarnException e) {
            Assert.fail((String)"Exception is not expected.");
        }
        return clientRMService;
    }

    static void setupQueueConfiguration(CapacitySchedulerConfiguration conf) {
        TestRMWebApp.setupQueueConfiguration(conf, false);
    }

    static void setupQueueConfiguration(CapacitySchedulerConfiguration conf, boolean useDRC) {
        QueuePath root = new QueuePath("root");
        conf.setQueues(root, new String[]{"a", "b", "c"});
        QueuePath a = root.createNewLeaf("a");
        conf.setCapacity(a, 10.0f);
        QueuePath b = root.createNewLeaf("b");
        conf.setCapacity(b, 20.0f);
        QueuePath c = root.createNewLeaf("c");
        conf.setCapacity(c, 70.0f);
        QueuePath a1 = a.createNewLeaf("a1");
        QueuePath a2 = a.createNewLeaf("a2");
        conf.setQueues(a, new String[]{"a1", "a2"});
        conf.setCapacity(a1, 30.0f);
        conf.setCapacity(a2, 70.0f);
        QueuePath b1 = b.createNewLeaf("b1");
        QueuePath b2 = b.createNewLeaf("b2");
        QueuePath b3 = b.createNewLeaf("b3");
        conf.setQueues(b, new String[]{"b1", "b2", "b3"});
        conf.setCapacity(b1, 50.0f);
        conf.setCapacity(b2, 30.0f);
        conf.setCapacity(b3, 20.0f);
        QueuePath c1 = c.createNewLeaf("c1");
        QueuePath c2 = c.createNewLeaf("c2");
        QueuePath c3 = c.createNewLeaf("c3");
        QueuePath c4 = c.createNewLeaf("c4");
        conf.setQueues(c, new String[]{"c1", "c2", "c3", "c4"});
        conf.setCapacity(c1, 50.0f);
        conf.setCapacity(c2, 10.0f);
        conf.setCapacity(c3, 35.0f);
        conf.setCapacity(c4, 5.0f);
        QueuePath c11 = c1.createNewLeaf("c11");
        QueuePath c12 = c1.createNewLeaf("c12");
        QueuePath c13 = c1.createNewLeaf("c13");
        conf.setQueues(c1, new String[]{"c11", "c12", "c13"});
        conf.setCapacity(c11, 15.0f);
        conf.setCapacity(c12, 45.0f);
        conf.setCapacity(c13, 40.0f);
        if (useDRC) {
            conf.set("yarn.scheduler.capacity.resource-calculator", "org.apache.hadoop.yarn.util.resource.DominantResourceCalculator");
        }
    }

    public static ResourceManager mockFifoRm(int apps, int racks, int nodes, int mbsPerNode) throws Exception {
        ResourceManager rm = (ResourceManager)Mockito.mock(ResourceManager.class);
        RMContext rmContext = TestRMWebApp.mockRMContext(apps, racks, nodes, mbsPerNode);
        FifoScheduler rs = TestRMWebApp.mockFifoScheduler(rmContext);
        Mockito.when((Object)rm.getResourceScheduler()).thenReturn((Object)rs);
        Mockito.when((Object)rm.getRMContext()).thenReturn((Object)rmContext);
        return rm;
    }

    public static FifoScheduler mockFifoScheduler(RMContext rmContext) throws Exception {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        TestRMWebApp.setupFifoQueueConfiguration(conf);
        FifoScheduler fs = new FifoScheduler();
        fs.setConf((Configuration)new YarnConfiguration());
        fs.setRMContext(rmContext);
        fs.init((Configuration)conf);
        return fs;
    }

    static void setupFifoQueueConfiguration(CapacitySchedulerConfiguration conf) {
        conf.setQueues(new QueuePath("default"), new String[]{"default"});
        conf.setCapacity(new QueuePath("default"), 100.0f);
    }

    public static void main(String[] args) throws Exception {
        WebApps.$for((String)"yarn", (Object)new TestRMWebApp()).at(8888).inDevMode().start((WebApp)new RMWebApp(TestRMWebApp.mockRm(2500, 8, 8, 8192))).joinThread();
        WebApps.$for((String)"yarn", (Object)new TestRMWebApp()).at(8888).inDevMode().start((WebApp)new RMWebApp(TestRMWebApp.mockFifoRm(10, 1, 4, 8192))).joinThread();
    }
}

