/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.test.MockitoUtil;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.DefaultPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.FSPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PrimaryGroupPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.RejectPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.SecondaryGroupExistingPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.SpecifiedPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.UserPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.placement.schema.MappingRulesDescription;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.placement.schema.Rule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigToCSConfigRuleHandler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.QueuePlacementConverter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestQueuePlacementConverter {
    private static final String DEFAULT_QUEUE = "root.default";
    @Mock
    private PlacementManager placementManager;
    @Mock
    private FSConfigToCSConfigRuleHandler ruleHandler;
    private QueuePlacementConverter converter;
    private CapacitySchedulerConfiguration csConf;

    @Before
    public void setup() {
        this.converter = new QueuePlacementConverter();
        this.csConf = new CapacitySchedulerConfiguration(new Configuration(false));
    }

    @Test
    public void testConvertUserRule() {
        PlacementRule fsRule = (PlacementRule)Mockito.mock(UserPlacementRule.class);
        this.initPlacementManagerMock(fsRule);
        MappingRulesDescription description = this.convert();
        Assert.assertEquals((String)"Number of rules", (long)1L, (long)description.getRules().size());
        this.verifyRule((Rule)description.getRules().get(0), Rule.Policy.USER);
        MockitoUtil.verifyZeroInteractions((Object[])new Object[]{this.ruleHandler});
    }

    @Test
    public void testConvertSpecifiedRule() {
        PlacementRule fsRule = (PlacementRule)Mockito.mock(SpecifiedPlacementRule.class);
        this.initPlacementManagerMock(fsRule);
        MappingRulesDescription description = this.convert();
        Assert.assertEquals((String)"Number of rules", (long)1L, (long)description.getRules().size());
        this.verifyRule((Rule)description.getRules().get(0), Rule.Policy.SPECIFIED);
        MockitoUtil.verifyZeroInteractions((Object[])new Object[]{this.ruleHandler});
    }

    @Test
    public void testConvertPrimaryGroupRule() {
        PlacementRule fsRule = (PlacementRule)Mockito.mock(PrimaryGroupPlacementRule.class);
        this.initPlacementManagerMock(fsRule);
        MappingRulesDescription description = this.convert();
        Assert.assertEquals((String)"Number of rules", (long)1L, (long)description.getRules().size());
        this.verifyRule((Rule)description.getRules().get(0), Rule.Policy.PRIMARY_GROUP);
        MockitoUtil.verifyZeroInteractions((Object[])new Object[]{this.ruleHandler});
    }

    @Test
    public void testConvertSecondaryGroupRule() {
        PlacementRule fsRule = (PlacementRule)Mockito.mock(SecondaryGroupExistingPlacementRule.class);
        this.initPlacementManagerMock(fsRule);
        MappingRulesDescription description = this.convert();
        Assert.assertEquals((String)"Number of rules", (long)1L, (long)description.getRules().size());
        this.verifyRule((Rule)description.getRules().get(0), Rule.Policy.SECONDARY_GROUP);
        MockitoUtil.verifyZeroInteractions((Object[])new Object[]{this.ruleHandler});
    }

    @Test
    public void testConvertDefaultRuleWithQueueName() {
        DefaultPlacementRule fsRule = (DefaultPlacementRule)Mockito.mock(DefaultPlacementRule.class);
        fsRule.defaultQueueName = "abc";
        this.initPlacementManagerMock(new PlacementRule[]{fsRule});
        MappingRulesDescription description = this.convert();
        Assert.assertEquals((String)"Number of rules", (long)1L, (long)description.getRules().size());
        this.verifyRule((Rule)description.getRules().get(0), Rule.Policy.CUSTOM);
        MockitoUtil.verifyZeroInteractions((Object[])new Object[]{this.ruleHandler});
    }

    @Test
    public void testConvertDefaultRule() {
        DefaultPlacementRule fsRule = (DefaultPlacementRule)Mockito.mock(DefaultPlacementRule.class);
        fsRule.defaultQueueName = DEFAULT_QUEUE;
        this.initPlacementManagerMock(new PlacementRule[]{fsRule});
        MappingRulesDescription description = this.convert();
        Assert.assertEquals((String)"Number of rules", (long)1L, (long)description.getRules().size());
        this.verifyRule((Rule)description.getRules().get(0), Rule.Policy.DEFAULT_QUEUE);
        MockitoUtil.verifyZeroInteractions((Object[])new Object[]{this.ruleHandler});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConvertUnsupportedRule() {
        PlacementRule rule = (PlacementRule)Mockito.mock(TestPlacementRule.class);
        this.initPlacementManagerMock(rule);
        this.convert();
    }

    @Test
    public void testConvertRejectRule() {
        PlacementRule rule = (PlacementRule)Mockito.mock(RejectPlacementRule.class);
        this.initPlacementManagerMock(rule);
        MappingRulesDescription description = this.convert();
        Assert.assertEquals((String)"Number of rules", (long)1L, (long)description.getRules().size());
        this.verifyRule((Rule)description.getRules().get(0), Rule.Policy.REJECT);
        MockitoUtil.verifyZeroInteractions((Object[])new Object[]{this.ruleHandler});
    }

    @Test
    public void testConvertNestedPrimaryGroupRule() {
        UserPlacementRule rule = (UserPlacementRule)Mockito.mock(UserPlacementRule.class);
        PrimaryGroupPlacementRule parent = (PrimaryGroupPlacementRule)Mockito.mock(PrimaryGroupPlacementRule.class);
        Mockito.when((Object)rule.getParentRule()).thenReturn((Object)parent);
        this.initPlacementManagerMock(new PlacementRule[]{rule});
        MappingRulesDescription description = this.convert();
        Assert.assertEquals((String)"Number of rules", (long)1L, (long)description.getRules().size());
        this.verifyRule((Rule)description.getRules().get(0), Rule.Policy.PRIMARY_GROUP_USER);
        MockitoUtil.verifyZeroInteractions((Object[])new Object[]{this.ruleHandler});
    }

    @Test
    public void testConvertNestedSecondaryGroupRule() {
        UserPlacementRule rule = (UserPlacementRule)Mockito.mock(UserPlacementRule.class);
        SecondaryGroupExistingPlacementRule parent = (SecondaryGroupExistingPlacementRule)Mockito.mock(SecondaryGroupExistingPlacementRule.class);
        Mockito.when((Object)rule.getParentRule()).thenReturn((Object)parent);
        this.initPlacementManagerMock(new PlacementRule[]{rule});
        MappingRulesDescription description = this.convert();
        Assert.assertEquals((String)"Number of rules", (long)1L, (long)description.getRules().size());
        this.verifyRule((Rule)description.getRules().get(0), Rule.Policy.SECONDARY_GROUP_USER);
        MockitoUtil.verifyZeroInteractions((Object[])new Object[]{this.ruleHandler});
    }

    @Test
    public void testConvertNestedDefaultRule() {
        UserPlacementRule fsRule = (UserPlacementRule)Mockito.mock(UserPlacementRule.class);
        DefaultPlacementRule parent = (DefaultPlacementRule)Mockito.mock(DefaultPlacementRule.class);
        parent.defaultQueueName = "root.abc";
        Mockito.when((Object)fsRule.getParentRule()).thenReturn((Object)parent);
        this.initPlacementManagerMock(new PlacementRule[]{fsRule});
        MappingRulesDescription description = this.convert();
        Assert.assertEquals((String)"Number of rules", (long)1L, (long)description.getRules().size());
        Rule rule = (Rule)description.getRules().get(0);
        this.verifyRule((Rule)description.getRules().get(0), Rule.Policy.USER);
        Assert.assertEquals((String)"Parent path", (Object)"root.abc", (Object)rule.getParentQueue());
        MockitoUtil.verifyZeroInteractions((Object[])new Object[]{this.ruleHandler});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnsupportedNestedParentRule() {
        UserPlacementRule fsRule = (UserPlacementRule)Mockito.mock(UserPlacementRule.class);
        TestPlacementRule parent = (TestPlacementRule)((Object)Mockito.mock(TestPlacementRule.class));
        Mockito.when((Object)fsRule.getParentRule()).thenReturn((Object)parent);
        this.initPlacementManagerMock(new PlacementRule[]{fsRule});
        this.convert();
    }

    @Test
    public void testConvertMultiplePlacementRules() {
        UserPlacementRule rule1 = (UserPlacementRule)Mockito.mock(UserPlacementRule.class);
        PrimaryGroupPlacementRule rule2 = (PrimaryGroupPlacementRule)Mockito.mock(PrimaryGroupPlacementRule.class);
        SecondaryGroupExistingPlacementRule rule3 = (SecondaryGroupExistingPlacementRule)Mockito.mock(SecondaryGroupExistingPlacementRule.class);
        this.initPlacementManagerMock(new PlacementRule[]{rule1, rule2, rule3});
        MappingRulesDescription description = this.convert();
        Assert.assertEquals((String)"Number of rules", (long)3L, (long)description.getRules().size());
        this.verifyRule((Rule)description.getRules().get(0), Rule.Policy.USER);
        this.verifyRule((Rule)description.getRules().get(1), Rule.Policy.PRIMARY_GROUP);
        this.verifyRule((Rule)description.getRules().get(2), Rule.Policy.SECONDARY_GROUP);
        MockitoUtil.verifyZeroInteractions((Object[])new Object[]{this.ruleHandler});
    }

    @Test
    public void testConvertPrimaryGroupRuleWithCreate() {
        FSPlacementRule fsRule = (FSPlacementRule)Mockito.mock(PrimaryGroupPlacementRule.class);
        Mockito.when((Object)fsRule.getCreateFlag()).thenReturn((Object)true);
        this.initPlacementManagerMock(new PlacementRule[]{fsRule});
        this.convert();
        ((FSConfigToCSConfigRuleHandler)Mockito.verify((Object)this.ruleHandler)).handleRuleAutoCreateFlag((String)ArgumentMatchers.eq((Object)"root.<primaryGroup>"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.ruleHandler});
    }

    @Test
    public void testConvertSecondaryGroupRuleWithCreate() {
        FSPlacementRule fsRule = (FSPlacementRule)Mockito.mock(SecondaryGroupExistingPlacementRule.class);
        Mockito.when((Object)fsRule.getCreateFlag()).thenReturn((Object)true);
        this.initPlacementManagerMock(new PlacementRule[]{fsRule});
        this.convert();
        ((FSConfigToCSConfigRuleHandler)Mockito.verify((Object)this.ruleHandler)).handleRuleAutoCreateFlag((String)ArgumentMatchers.eq((Object)"root.<secondaryGroup>"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.ruleHandler});
    }

    @Test
    public void testConvertNestedPrimaryGroupRuleWithCreate() {
        UserPlacementRule fsRule = (UserPlacementRule)Mockito.mock(UserPlacementRule.class);
        PrimaryGroupPlacementRule parent = (PrimaryGroupPlacementRule)Mockito.mock(PrimaryGroupPlacementRule.class);
        Mockito.when((Object)fsRule.getParentRule()).thenReturn((Object)parent);
        Mockito.when((Object)fsRule.getCreateFlag()).thenReturn((Object)true);
        this.initPlacementManagerMock(new PlacementRule[]{fsRule});
        this.convert();
        ((FSConfigToCSConfigRuleHandler)Mockito.verify((Object)this.ruleHandler)).handleRuleAutoCreateFlag((String)ArgumentMatchers.eq((Object)"root.<primaryGroup>"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.ruleHandler});
    }

    @Test
    public void testConvertNestedSecondaryGroupRuleWithCreate() {
        UserPlacementRule fsRule = (UserPlacementRule)Mockito.mock(UserPlacementRule.class);
        SecondaryGroupExistingPlacementRule parent = (SecondaryGroupExistingPlacementRule)Mockito.mock(SecondaryGroupExistingPlacementRule.class);
        Mockito.when((Object)fsRule.getParentRule()).thenReturn((Object)parent);
        Mockito.when((Object)fsRule.getCreateFlag()).thenReturn((Object)true);
        this.initPlacementManagerMock(new PlacementRule[]{fsRule});
        this.convert();
        ((FSConfigToCSConfigRuleHandler)Mockito.verify((Object)this.ruleHandler)).handleRuleAutoCreateFlag((String)ArgumentMatchers.eq((Object)"root.<secondaryGroup>"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.ruleHandler});
    }

    @Test
    public void testConvertNestedDefaultGroupWithCreate() {
        UserPlacementRule fsRule = (UserPlacementRule)Mockito.mock(UserPlacementRule.class);
        DefaultPlacementRule parent = (DefaultPlacementRule)Mockito.mock(DefaultPlacementRule.class);
        parent.defaultQueueName = "root.abc";
        Mockito.when((Object)fsRule.getParentRule()).thenReturn((Object)parent);
        Mockito.when((Object)fsRule.getCreateFlag()).thenReturn((Object)true);
        this.initPlacementManagerMock(new PlacementRule[]{fsRule});
        this.convert();
        ((FSConfigToCSConfigRuleHandler)Mockito.verify((Object)this.ruleHandler)).handleRuleAutoCreateFlag((String)ArgumentMatchers.eq((Object)"root.abc"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.ruleHandler});
    }

    @Test
    public void testConvertNestedRuleCreateFalseFalseInWeightMode() {
        this.testConvertNestedRuleCreateFlagInWeightMode(false, false, false, false);
    }

    @Test
    public void testConvertNestedRuleCreateFalseTrueInWeightMode() {
        this.testConvertNestedRuleCreateFlagInWeightMode(false, true, true, true);
    }

    @Test
    public void testConvertNestedRuleCreateTrueFalseInWeightMode() {
        this.testConvertNestedRuleCreateFlagInWeightMode(true, false, true, true);
    }

    @Test
    public void testConvertNestedRuleCreateTrueTrueInWeightMode() {
        this.testConvertNestedRuleCreateFlagInWeightMode(true, true, true, false);
    }

    private void testConvertNestedRuleCreateFlagInWeightMode(boolean parentCreate, boolean childCreate, boolean expectedFlagOnRule, boolean ruleHandlerShouldBeInvoked) {
        UserPlacementRule fsRule = (UserPlacementRule)Mockito.mock(UserPlacementRule.class);
        PrimaryGroupPlacementRule parent = (PrimaryGroupPlacementRule)Mockito.mock(PrimaryGroupPlacementRule.class);
        Mockito.when((Object)parent.getCreateFlag()).thenReturn((Object)parentCreate);
        Mockito.when((Object)fsRule.getParentRule()).thenReturn((Object)parent);
        Mockito.when((Object)fsRule.getCreateFlag()).thenReturn((Object)childCreate);
        this.initPlacementManagerMock(new PlacementRule[]{fsRule});
        MappingRulesDescription desc = this.convertInWeightMode();
        Rule rule = (Rule)desc.getRules().get(0);
        Assert.assertEquals((String)"Expected create flag", (Object)expectedFlagOnRule, (Object)rule.getCreate());
        if (ruleHandlerShouldBeInvoked) {
            ((FSConfigToCSConfigRuleHandler)Mockito.verify((Object)this.ruleHandler)).handleFSParentAndChildCreateFlagDiff((Rule.Policy)ArgumentMatchers.any(Rule.Policy.class));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.ruleHandler});
        } else {
            MockitoUtil.verifyZeroInteractions((Object[])new Object[]{this.ruleHandler});
        }
    }

    @Test
    public void testParentSetToRootInWeightModeUserPolicy() {
        UserPlacementRule fsRule = (UserPlacementRule)Mockito.mock(UserPlacementRule.class);
        this.testParentSetToRootInWeightMode((FSPlacementRule)fsRule);
    }

    @Test
    public void testParentSetToRootInWeightModePrimaryGroupPolicy() {
        PrimaryGroupPlacementRule fsRule = (PrimaryGroupPlacementRule)Mockito.mock(PrimaryGroupPlacementRule.class);
        this.testParentSetToRootInWeightMode((FSPlacementRule)fsRule);
    }

    @Test
    public void testParentSetToRootInWeightModePrimaryGroupUserPolicy() {
        UserPlacementRule fsRule = (UserPlacementRule)Mockito.mock(UserPlacementRule.class);
        PrimaryGroupPlacementRule parent = (PrimaryGroupPlacementRule)Mockito.mock(PrimaryGroupPlacementRule.class);
        Mockito.when((Object)fsRule.getParentRule()).thenReturn((Object)parent);
        this.testParentSetToRootInWeightMode((FSPlacementRule)fsRule);
    }

    @Test
    public void testParentSetToRootInWeightModeSecondaryGroupPolicy() {
        SecondaryGroupExistingPlacementRule fsRule = (SecondaryGroupExistingPlacementRule)Mockito.mock(SecondaryGroupExistingPlacementRule.class);
        this.testParentSetToRootInWeightMode((FSPlacementRule)fsRule);
    }

    @Test
    public void testParentSetToRootInWeightModeSecondaryGroupUserPolicy() {
        UserPlacementRule fsRule = (UserPlacementRule)Mockito.mock(UserPlacementRule.class);
        SecondaryGroupExistingPlacementRule parent = (SecondaryGroupExistingPlacementRule)Mockito.mock(SecondaryGroupExistingPlacementRule.class);
        Mockito.when((Object)fsRule.getParentRule()).thenReturn((Object)parent);
        this.testParentSetToRootInWeightMode((FSPlacementRule)fsRule);
    }

    private void testParentSetToRootInWeightMode(FSPlacementRule fsRule) {
        this.initPlacementManagerMock(new PlacementRule[]{fsRule});
        MappingRulesDescription desc = this.convertInWeightMode();
        Rule rule = (Rule)desc.getRules().get(0);
        Assert.assertEquals((String)"Parent queue", (Object)"root", (Object)rule.getParentQueue());
    }

    @Test
    public void testConvertNestedPrimaryGroupRuleWithParentCreate() {
        UserPlacementRule fsRule = (UserPlacementRule)Mockito.mock(UserPlacementRule.class);
        PrimaryGroupPlacementRule parent = (PrimaryGroupPlacementRule)Mockito.mock(PrimaryGroupPlacementRule.class);
        Mockito.when((Object)fsRule.getParentRule()).thenReturn((Object)parent);
        Mockito.when((Object)parent.getCreateFlag()).thenReturn((Object)true);
        this.initPlacementManagerMock(new PlacementRule[]{fsRule});
        this.convert();
        ((FSConfigToCSConfigRuleHandler)Mockito.verify((Object)this.ruleHandler)).handleFSParentCreateFlag((String)ArgumentMatchers.eq((Object)"root.<primaryGroup>"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.ruleHandler});
    }

    @Test
    public void testConvertNestedSecondaryGroupRuleWithParentCreate() {
        UserPlacementRule fsRule = (UserPlacementRule)Mockito.mock(UserPlacementRule.class);
        SecondaryGroupExistingPlacementRule parent = (SecondaryGroupExistingPlacementRule)Mockito.mock(SecondaryGroupExistingPlacementRule.class);
        Mockito.when((Object)fsRule.getParentRule()).thenReturn((Object)parent);
        Mockito.when((Object)parent.getCreateFlag()).thenReturn((Object)true);
        this.initPlacementManagerMock(new PlacementRule[]{fsRule});
        this.convert();
        ((FSConfigToCSConfigRuleHandler)Mockito.verify((Object)this.ruleHandler)).handleFSParentCreateFlag((String)ArgumentMatchers.eq((Object)"root.<secondaryGroup>"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.ruleHandler});
    }

    @Test
    public void testConvertNestedDefaultGroupWithParentCreate() {
        UserPlacementRule fsRule = (UserPlacementRule)Mockito.mock(UserPlacementRule.class);
        DefaultPlacementRule parent = (DefaultPlacementRule)Mockito.mock(DefaultPlacementRule.class);
        parent.defaultQueueName = "root.abc";
        Mockito.when((Object)fsRule.getParentRule()).thenReturn((Object)parent);
        Mockito.when((Object)parent.getCreateFlag()).thenReturn((Object)true);
        this.initPlacementManagerMock(new PlacementRule[]{fsRule});
        this.convert();
        ((FSConfigToCSConfigRuleHandler)Mockito.verify((Object)this.ruleHandler)).handleFSParentCreateFlag((String)ArgumentMatchers.eq((Object)"root.abc"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.ruleHandler});
    }

    @Test
    public void testConvertNestedDefaultWithConflictingQueues() {
        UserPlacementRule fsRule = (UserPlacementRule)Mockito.mock(UserPlacementRule.class);
        DefaultPlacementRule parent = (DefaultPlacementRule)Mockito.mock(DefaultPlacementRule.class);
        parent.defaultQueueName = "root.users";
        Mockito.when((Object)fsRule.getParentRule()).thenReturn((Object)parent);
        Mockito.when((Object)fsRule.getCreateFlag()).thenReturn((Object)true);
        this.initPlacementManagerMock(new PlacementRule[]{fsRule});
        this.csConf.setQueues(new QueuePath("root.users"), new String[]{"hadoop"});
        this.convert();
        ((FSConfigToCSConfigRuleHandler)Mockito.verify((Object)this.ruleHandler)).handleRuleAutoCreateFlag((String)ArgumentMatchers.eq((Object)"root.users"));
        ((FSConfigToCSConfigRuleHandler)Mockito.verify((Object)this.ruleHandler)).handleChildStaticDynamicConflict((String)ArgumentMatchers.eq((Object)"root.users"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.ruleHandler});
    }

    private void initPlacementManagerMock(PlacementRule ... rules) {
        ArrayList listOfRules = Lists.newArrayList((Object[])rules);
        Mockito.when((Object)this.placementManager.getPlacementRules()).thenReturn((Object)listOfRules);
    }

    private MappingRulesDescription convert() {
        return this.converter.convertPlacementPolicy(this.placementManager, this.ruleHandler, this.csConf, true);
    }

    private MappingRulesDescription convertInWeightMode() {
        return this.converter.convertPlacementPolicy(this.placementManager, this.ruleHandler, this.csConf, false);
    }

    private void verifyRule(Rule rule, Rule.Policy expectedPolicy) {
        Assert.assertEquals((String)"Policy type", (Object)expectedPolicy, (Object)rule.getPolicy());
        Assert.assertEquals((String)"Match string", (Object)"*", (Object)rule.getMatches());
        Assert.assertEquals((String)"Fallback result", (Object)Rule.FallbackResult.SKIP, (Object)rule.getFallbackResult());
        Assert.assertEquals((String)"Type", (Object)Rule.Type.USER, (Object)rule.getType());
    }

    private class TestPlacementRule
    extends FSPlacementRule {
        private TestPlacementRule() {
        }

        public ApplicationPlacementContext getPlacementForApp(ApplicationSubmissionContext asc, String user) throws YarnException {
            return null;
        }
    }
}

