/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedQueueDeletionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueConfigurationAutoRefreshPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigToCSConfigConverterParams;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSYarnSiteConverter;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFSYarnSiteConverter {
    private Configuration yarnConfig;
    private FSYarnSiteConverter converter;
    private Configuration yarnConvertedConfig;
    private static final String DELETION_POLICY_CLASS = AutoCreatedQueueDeletionPolicy.class.getCanonicalName();

    @Before
    public void setup() {
        this.yarnConfig = new Configuration(false);
        this.yarnConvertedConfig = new Configuration(false);
        this.converter = new FSYarnSiteConverter();
    }

    @Test
    public void testSiteContinuousSchedulingConversion() {
        this.yarnConfig.setBoolean("yarn.scheduler.fair.continuous-scheduling-enabled", true);
        this.yarnConfig.setInt("yarn.scheduler.fair.continuous-scheduling-sleep-ms", 666);
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, false, true, false, null);
        Assert.assertTrue((String)"Cont. scheduling", (boolean)this.yarnConvertedConfig.getBoolean("yarn.scheduler.capacity.schedule-asynchronously.enable", false));
        Assert.assertEquals((String)"Scheduling interval", (long)666L, (long)this.yarnConvertedConfig.getInt("yarn.scheduler.capacity.schedule-asynchronously.scheduling-interval-ms", -1));
    }

    @Test
    public void testSiteQueueConfAutoRefreshConversion() {
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, false, false, false, null);
        Assert.assertTrue((String)this.yarnConvertedConfig.get("yarn.resourcemanager.scheduler.monitor.enable"), (boolean)true);
        Assert.assertTrue((String)"Scheduling Policies contains queue conf auto refresh", (boolean)this.yarnConvertedConfig.get("yarn.resourcemanager.scheduler.monitor.policies").contains(QueueConfigurationAutoRefreshPolicy.class.getCanonicalName()));
    }

    @Test
    public void testSitePreemptionConversion() {
        this.yarnConfig.setBoolean("yarn.scheduler.fair.preemption", true);
        this.yarnConfig.setInt("yarn.scheduler.fair.waitTimeBeforeKill", 123);
        this.yarnConfig.setInt("yarn.scheduler.fair.waitTimeBeforeNextStarvationCheck", 321);
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, false, false, false, null);
        Assert.assertTrue((String)"Preemption enabled", (boolean)this.yarnConvertedConfig.getBoolean("yarn.resourcemanager.scheduler.monitor.enable", false));
        Assert.assertEquals((String)"Wait time before kill", (long)123L, (long)this.yarnConvertedConfig.getInt("yarn.resourcemanager.monitor.capacity.preemption.max_wait_before_kill", -1));
        Assert.assertEquals((String)"Starvation check wait time", (long)321L, (long)this.yarnConvertedConfig.getInt("yarn.resourcemanager.monitor.capacity.preemption.monitoring_interval", -1));
        Assert.assertFalse((String)"Observe_only should be false", (boolean)this.yarnConvertedConfig.getBoolean("yarn.resourcemanager.monitor.capacity.preemption.observe_only", false));
        Assert.assertTrue((String)"Should contain ProportionalCapacityPreemptionPolicy.", (boolean)this.yarnConvertedConfig.get("yarn.resourcemanager.scheduler.monitor.policies").contains(ProportionalCapacityPreemptionPolicy.class.getCanonicalName()));
    }

    @Test
    public void testSiteDisabledPreemptionWithNoPolicyConversion() {
        this.yarnConfig.setBoolean("yarn.scheduler.fair.preemption", false);
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, false, false, false, null);
        Assert.assertFalse((String)"Should not contain ProportionalCapacityPreemptionPolicy.", (boolean)this.yarnConvertedConfig.get("yarn.resourcemanager.scheduler.monitor.policies").contains(ProportionalCapacityPreemptionPolicy.class.getCanonicalName()));
        this.yarnConfig.setBoolean("yarn.scheduler.fair.preemption", false);
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, false, false, false, FSConfigToCSConfigConverterParams.PreemptionMode.NO_POLICY);
        Assert.assertFalse((String)"Should not contain ProportionalCapacityPreemptionPolicy.", (boolean)this.yarnConvertedConfig.get("yarn.resourcemanager.scheduler.monitor.policies").contains(ProportionalCapacityPreemptionPolicy.class.getCanonicalName()));
    }

    @Test
    public void testSiteAssignMultipleConversion() {
        this.yarnConfig.setBoolean("yarn.scheduler.fair.assignmultiple", true);
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, false, false, false, null);
        Assert.assertTrue((String)"Assign multiple", (boolean)this.yarnConvertedConfig.getBoolean("yarn.scheduler.capacity.per-node-heartbeat.multiple-assignments-enabled", false));
    }

    @Test
    public void testSiteMaxAssignConversion() {
        this.yarnConfig.setInt("yarn.scheduler.fair.max.assign", 111);
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, false, false, false, null);
        Assert.assertEquals((String)"Max assign", (long)111L, (long)this.yarnConvertedConfig.getInt("yarn.scheduler.capacity.per-node-heartbeat.maximum-container-assignments", -1));
    }

    @Test
    public void testSiteLocalityThresholdConversion() {
        this.yarnConfig.set("yarn.scheduler.fair.locality.threshold.node", "123.123");
        this.yarnConfig.set("yarn.scheduler.fair.locality.threshold.rack", "321.321");
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, false, false, false, null);
        Assert.assertEquals((String)"Locality threshold node", (Object)"123.123", (Object)this.yarnConvertedConfig.get("yarn.scheduler.capacity.node-locality-delay"));
        Assert.assertEquals((String)"Locality threshold rack", (Object)"321.321", (Object)this.yarnConvertedConfig.get("yarn.scheduler.capacity.rack-locality-additional-delay"));
    }

    @Test
    public void testSiteDrfEnabledConversion() {
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, true, false, false, null);
        Assert.assertEquals((String)"Resource calculator type", DominantResourceCalculator.class, (Object)this.yarnConvertedConfig.getClass("yarn.scheduler.capacity.resource-calculator", null));
    }

    @Test
    public void testSiteDrfDisabledConversion() {
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, false, false, false, null);
        Assert.assertEquals((String)"Resource calculator type", DefaultResourceCalculator.class, (Object)this.yarnConvertedConfig.getClass("yarn.scheduler.capacity.resource-calculator", CapacitySchedulerConfiguration.DEFAULT_RESOURCE_CALCULATOR_CLASS));
    }

    @Test
    public void testAsyncSchedulingEnabledConversion() {
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, true, true, false, null);
        Assert.assertTrue((String)"Asynchronous scheduling", (boolean)this.yarnConvertedConfig.getBoolean("yarn.scheduler.capacity.schedule-asynchronously.enable", true));
    }

    @Test
    public void testAsyncSchedulingDisabledConversion() {
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, false, false, false, null);
        Assert.assertFalse((String)"Asynchronous scheduling", (boolean)this.yarnConvertedConfig.getBoolean("yarn.scheduler.capacity.schedule-asynchronously.enable", false));
    }

    @Test
    public void testSiteQueueAutoDeletionConversionWithWeightMode() {
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, false, false, false, null);
        Assert.assertTrue((String)this.yarnConvertedConfig.get("yarn.resourcemanager.scheduler.monitor.enable"), (boolean)true);
        Assert.assertTrue((String)"Scheduling Policies contain auto deletion policy", (boolean)this.yarnConvertedConfig.get("yarn.resourcemanager.scheduler.monitor.policies").contains(DELETION_POLICY_CLASS));
        this.yarnConvertedConfig.set("yarn.resourcemanager.scheduler.monitor.policies", "testPolicy");
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, false, false, false, null);
        Assert.assertTrue((String)"Scheduling Policies contain auto deletion policy", (boolean)this.yarnConvertedConfig.get("yarn.resourcemanager.scheduler.monitor.policies").contains(DELETION_POLICY_CLASS));
        Assert.assertEquals((String)"Auto deletion policy expired time should be 10s", (long)10L, (long)this.yarnConvertedConfig.getLong("yarn.scheduler.capacity.auto-queue-creation-v2.queue-expiration-time", 300L));
    }

    @Test
    public void testSiteQueueAutoDeletionConversionDisabledForPercentageMode() {
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, false, false, true, null);
        Assert.assertTrue((String)this.yarnConvertedConfig.get("yarn.resourcemanager.scheduler.monitor.enable"), (boolean)true);
        Assert.assertTrue((String)"Scheduling Policies should notcontain auto deletion policy in percentage mode", (this.yarnConvertedConfig.get("yarn.resourcemanager.scheduler.monitor.policies") == null || !this.yarnConvertedConfig.get("yarn.resourcemanager.scheduler.monitor.policies").contains(DELETION_POLICY_CLASS) ? 1 : 0) != 0);
        this.yarnConvertedConfig.set("yarn.resourcemanager.scheduler.monitor.policies", "testPolicy");
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, false, false, true, null);
        Assert.assertFalse((String)"Scheduling Policies should not contain auto deletion policy in percentage mode", (boolean)this.yarnConvertedConfig.get("yarn.resourcemanager.scheduler.monitor.policies").contains(DELETION_POLICY_CLASS));
        Assert.assertNotEquals((String)"Auto deletion policy expired time should not be set in percentage mode", (long)10L, (long)this.yarnConvertedConfig.getLong("yarn.scheduler.capacity.auto-queue-creation-v2.queue-expiration-time", 300L));
    }
}

