/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.ConversionOptions;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.DryRunResultHolder;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigToCSConfigRuleHandler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSQueueConverter;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSQueueConverterBuilder;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.UnsupportedPropertyException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestFSQueueConverter {
    private static final float MAX_AM_SHARE_DEFAULT = 0.16f;
    private static final int MAX_APPS_DEFAULT = 15;
    private static final Resource CLUSTER_RESOURCE = Resource.newInstance((int)16384, (int)16);
    private static final Set<String> ALL_QUEUES = Sets.newHashSet((Object[])new String[]{"root", "root.default", "root.admins", "root.users", "root.admins.alice", "root.admins.bob", "root.users.joe", "root.users.john", "root.misc", "root.misc.a", "root.misc.b"});
    private static final String FILE_PREFIX = "file:";
    private static final String FAIR_SCHEDULER_XML = TestFSQueueConverter.prepareFileName("fair-scheduler-conversion.xml");
    private FSQueueConverter converter;
    private Configuration yarnConfig;
    private CapacitySchedulerConfiguration csConfig;
    private FairScheduler fs;
    private FSQueue rootQueue;
    private ConversionOptions conversionOptions;
    private DryRunResultHolder dryRunResultHolder;
    private FSQueueConverterBuilder builder;
    private String key;
    private static final QueuePath ROOT = new QueuePath("root");
    private static final QueuePath DEFAULT = new QueuePath("root.default");
    private static final QueuePath USERS = new QueuePath("root.users");
    private static final QueuePath USERS_JOE = new QueuePath("root.users.joe");
    private static final QueuePath USERS_JOHN = new QueuePath("root.users.john");
    private static final QueuePath ADMINS = new QueuePath("root.admins");
    private static final QueuePath ADMINS_ALICE = new QueuePath("root.admins.alice");
    private static final QueuePath ADMINS_BOB = new QueuePath("root.admins.bob");
    private static final QueuePath MISC = new QueuePath("root.misc");
    private static final QueuePath MISC_A = new QueuePath("root.misc.a");
    private static final QueuePath MISC_B = new QueuePath("root.misc.b");
    @Mock
    private FSConfigToCSConfigRuleHandler ruleHandler;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    private static String prepareFileName(String f) {
        return FILE_PREFIX + new File("src/test/resources/" + f).getAbsolutePath();
    }

    @Before
    public void setup() {
        this.yarnConfig = new Configuration(false);
        this.yarnConfig.set("yarn.scheduler.fair.allocation.file", FAIR_SCHEDULER_XML);
        this.yarnConfig.setBoolean("yarn.scheduler.fair.migration.mode", true);
        this.csConfig = new CapacitySchedulerConfiguration(new Configuration(false));
        this.dryRunResultHolder = new DryRunResultHolder();
        this.conversionOptions = new ConversionOptions(this.dryRunResultHolder, false);
        this.fs = this.createFairScheduler();
        this.createBuilder();
        this.rootQueue = this.fs.getQueueManager().getRootQueue();
    }

    @After
    public void tearDown() throws IOException {
        if (this.fs != null) {
            this.fs.close();
        }
    }

    private FairScheduler createFairScheduler() {
        RMContextImpl ctx = new RMContextImpl();
        PlacementManager placementManager = new PlacementManager();
        ctx.setQueuePlacementManager(placementManager);
        FairScheduler fairScheduler = new FairScheduler();
        fairScheduler.setRMContext((RMContext)ctx);
        fairScheduler.init(this.yarnConfig);
        return fairScheduler;
    }

    private void createBuilder() {
        this.builder = FSQueueConverterBuilder.create().withRuleHandler(this.ruleHandler).withCapacitySchedulerConfig(this.csConfig).withPreemptionEnabled(false).withSizeBasedWeight(false).withClusterResource(CLUSTER_RESOURCE).withQueueMaxAMShareDefault(0.16f).withQueueMaxAppsDefault(15).withConversionOptions(this.conversionOptions);
    }

    @Test
    public void testConvertQueueHierarchy() {
        this.converter = this.builder.build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        Assert.assertEquals((String)"root children", Arrays.asList("admins", "users", "misc", "default"), (Object)this.csConfig.getQueues(ROOT));
        Assert.assertEquals((String)"root.admins children", Arrays.asList("bob", "alice"), (Object)this.csConfig.getQueues(ADMINS));
        Assert.assertTrue((String)"root.default children", (boolean)this.csConfig.getQueues(DEFAULT).isEmpty());
        Assert.assertEquals((String)"root.users children", Arrays.asList("john", "joe"), (Object)this.csConfig.getQueues(USERS));
        Set leafs = Sets.difference(ALL_QUEUES, (Set)Sets.newHashSet((Object[])new String[]{"root", "root.default", "root.admins", "root.users", "root.misc"}));
        for (String queue : leafs) {
            this.key = "yarn.scheduler.capacity." + queue + ".queues";
            Assert.assertTrue((String)("Key " + this.key + " has value, but it should be empty"), (boolean)this.csConfig.getQueues(new QueuePath(queue)).isEmpty());
        }
    }

    @Test
    public void testQueueMaxAMShare() {
        this.converter = this.builder.build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        Assert.assertEquals((String)"root.admins.bob AM share", (float)1.0f, (float)this.csConfig.getMaximumApplicationMasterResourcePerQueuePercent(ADMINS_BOB), (float)0.0f);
        Assert.assertEquals((String)"root.admins.alice AM share", (float)0.15f, (float)this.csConfig.getMaximumApplicationMasterResourcePerQueuePercent(ADMINS_ALICE), (float)0.0f);
        Set remaining = Sets.difference(ALL_QUEUES, (Set)Sets.newHashSet((Object[])new String[]{"root.admins.bob", "root.admins.alice"}));
        for (String queue : remaining) {
            this.key = "yarn.scheduler.capacity." + queue + ".maximum-am-resource-percent";
            Assert.assertEquals((String)("Key " + this.key + " has different value"), (float)0.1f, (float)this.csConfig.getMaximumApplicationMasterResourcePerQueuePercent(new QueuePath(queue)), (float)0.0f);
        }
    }

    @Test
    public void testQueueMaxParallelApps() {
        this.converter = this.builder.build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        Assert.assertEquals((String)"root.admins.alice max apps", (float)2.0f, (float)this.csConfig.getMaxParallelAppsForQueue(ADMINS_ALICE).intValue(), (float)0.0f);
        Set remaining = Sets.difference(ALL_QUEUES, (Set)Sets.newHashSet((Object[])new String[]{"root.admins.alice"}));
        for (String queue : remaining) {
            this.key = "yarn.scheduler.capacity." + queue + ".max-parallel-apps";
            Assert.assertEquals((String)("Key " + this.key + " has different value"), (float)2.1474836E9f, (float)this.csConfig.getMaxParallelAppsForQueue(new QueuePath(queue)).intValue(), (float)0.0f);
        }
    }

    @Test
    public void testQueueMaxAllocations() {
        this.converter = this.builder.build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        Assert.assertEquals((String)"root.admins max vcores", (long)3L, (long)this.csConfig.getQueueMaximumAllocationVcores(ADMINS));
        Assert.assertEquals((String)"root.admins max memory", (long)4096L, (long)this.csConfig.getQueueMaximumAllocationMb(ADMINS));
        Assert.assertEquals((String)"root.users.john max vcores", (long)2L, (long)this.csConfig.getQueueMaximumAllocationVcores(USERS_JOHN));
        Assert.assertEquals((String)"root.users.john max memory", (long)8192L, (long)this.csConfig.getQueueMaximumAllocationMb(USERS_JOHN));
        Set remaining = Sets.difference(ALL_QUEUES, (Set)Sets.newHashSet((Object[])new String[]{"root.admins", "root.users.john"}));
        for (String queue : remaining) {
            this.key = "yarn.scheduler.capacity." + queue + ".maximum-allocation-vcores";
            Assert.assertEquals((String)("Key " + this.key + " has different value"), (double)-1.0, (double)this.csConfig.getQueueMaximumAllocationVcores(new QueuePath(queue)), (double)0.0);
            this.key = "yarn.scheduler.capacity." + queue + ".maximum-allocation-mb";
            Assert.assertEquals((String)("Key " + this.key + " has different value"), (double)-1.0, (double)this.csConfig.getQueueMaximumAllocationMb(new QueuePath(queue)), (double)0.0);
        }
    }

    @Test
    public void testQueuePreemptionDisabled() {
        this.converter = this.builder.withPreemptionEnabled(true).build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        Assert.assertTrue((String)"root.admins.alice preemption setting", (boolean)this.csConfig.getPreemptionDisabled(ADMINS_ALICE, false));
        Assert.assertTrue((String)"root.users.joe preemption setting", (boolean)this.csConfig.getPreemptionDisabled(USERS_JOE, false));
        Set remaining = Sets.difference(ALL_QUEUES, (Set)Sets.newHashSet((Object[])new String[]{"root.admins.alice", "root.users.joe"}));
        for (String queue : remaining) {
            this.key = "yarn.scheduler.capacity." + queue + ".disable_preemption";
            Assert.assertEquals((String)("Key " + this.key + " has different value"), (Object)false, (Object)this.csConfig.getPreemptionDisabled(new QueuePath(queue), false));
        }
    }

    @Test
    public void testQueuePreemptionDisabledWhenGlobalPreemptionDisabled() {
        this.converter = this.builder.build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        for (String queue : ALL_QUEUES) {
            this.key = "yarn.scheduler.capacity." + queue + ".disable_preemption";
            Assert.assertEquals((String)("Key " + this.key + " has different value"), (Object)false, (Object)this.csConfig.getPreemptionDisabled(new QueuePath(queue), false));
        }
    }

    @Test
    public void testChildCapacityInCapacityMode() {
        this.converter = this.builder.withPercentages(true).build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        Assert.assertEquals((String)"root.default capacity", (float)33.333f, (float)this.csConfig.getNonLabeledQueueCapacity(DEFAULT), (float)0.0f);
        Assert.assertEquals((String)"root.admins capacity", (float)33.333f, (float)this.csConfig.getNonLabeledQueueCapacity(ADMINS), (float)0.0f);
        Assert.assertEquals((String)"root.users capacity", (float)33.334f, (float)this.csConfig.getNonLabeledQueueCapacity(USERS), (float)0.0f);
        Assert.assertEquals((String)"root.users.john capacity", (float)25.0f, (float)this.csConfig.getNonLabeledQueueCapacity(USERS_JOHN), (float)0.0f);
        Assert.assertEquals((String)"root.users.joe capacity", (float)75.0f, (float)this.csConfig.getNonLabeledQueueCapacity(USERS_JOE), (float)0.0f);
        Assert.assertEquals((String)"root.admins.alice capacity", (float)75.0f, (float)this.csConfig.getNonLabeledQueueCapacity(ADMINS_ALICE), (float)0.0f);
        Assert.assertEquals((String)"root.admins.bob capacity", (float)25.0f, (float)this.csConfig.getNonLabeledQueueCapacity(ADMINS_BOB), (float)0.0f);
        Assert.assertEquals((String)"root.misc capacity", (float)0.0f, (float)this.csConfig.getNonLabeledQueueCapacity(MISC), (float)0.0f);
        Assert.assertEquals((String)"root.misc.a capacity", (float)0.0f, (float)this.csConfig.getNonLabeledQueueCapacity(MISC_A), (float)0.0f);
        Assert.assertEquals((String)"root.misc.b capacity", (float)0.0f, (float)this.csConfig.getNonLabeledQueueCapacity(MISC_B), (float)0.0f);
    }

    @Test
    public void testChildCapacityInWeightMode() {
        this.converter = this.builder.withPercentages(false).build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        Assert.assertEquals((String)"root.default weight", (float)1.0f, (float)this.csConfig.getNonLabeledQueueWeight(DEFAULT), (float)0.01f);
        Assert.assertEquals((String)"root.admins weight", (float)1.0f, (float)this.csConfig.getNonLabeledQueueWeight(ADMINS), (float)0.01f);
        Assert.assertEquals((String)"root.users weight", (float)1.0f, (float)this.csConfig.getNonLabeledQueueWeight(USERS), (float)0.01f);
        Assert.assertEquals((String)"root.users.john weight", (float)1.0f, (float)this.csConfig.getNonLabeledQueueWeight(USERS_JOHN), (float)0.01f);
        Assert.assertEquals((String)"root.users.joe weight", (float)3.0f, (float)this.csConfig.getNonLabeledQueueWeight(USERS_JOE), (float)0.01f);
        Assert.assertEquals((String)"root.admins.alice weight", (float)3.0f, (float)this.csConfig.getNonLabeledQueueWeight(ADMINS_ALICE), (float)0.01f);
        Assert.assertEquals((String)"root.admins.bob weight", (float)1.0f, (float)this.csConfig.getNonLabeledQueueWeight(ADMINS_BOB), (float)0.01f);
        Assert.assertEquals((String)"root.misc weight", (float)0.0f, (float)this.csConfig.getNonLabeledQueueWeight(MISC), (float)0.0f);
        Assert.assertEquals((String)"root.misc.a weight", (float)0.0f, (float)this.csConfig.getNonLabeledQueueWeight(MISC_A), (float)0.0f);
        Assert.assertEquals((String)"root.misc.b weight", (float)0.0f, (float)this.csConfig.getNonLabeledQueueWeight(MISC_B), (float)0.0f);
    }

    @Test
    public void testAutoCreateV2FlagsInWeightMode() {
        this.converter = this.builder.withPercentages(false).build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        Assert.assertTrue((String)"root autocreate v2 flag", (boolean)this.csConfig.isAutoQueueCreationV2Enabled(ROOT));
        Assert.assertTrue((String)"root.admins autocreate v2 flag", (boolean)this.csConfig.isAutoQueueCreationV2Enabled(ADMINS));
        Assert.assertTrue((String)"root.admins.alice autocreate v2 flag", (boolean)this.csConfig.isAutoQueueCreationV2Enabled(ADMINS_ALICE));
        Assert.assertTrue((String)"root.users autocreate v2 flag", (boolean)this.csConfig.isAutoQueueCreationV2Enabled(USERS));
        Assert.assertTrue((String)"root.misc autocreate v2 flag", (boolean)this.csConfig.isAutoQueueCreationV2Enabled(MISC));
        Set leafs = Sets.difference(ALL_QUEUES, (Set)Sets.newHashSet((Object[])new String[]{"root", "root.admins", "root.users", "root.misc", "root.admins.alice"}));
        for (String queue : leafs) {
            this.key = "yarn.scheduler.capacity." + queue + ".auto-queue-creation-v2.enabled";
            Assert.assertEquals((String)("Key " + this.key + " has different value"), (Object)false, (Object)this.csConfig.isAutoQueueCreationV2Enabled(new QueuePath(queue)));
        }
    }

    @Test
    public void testZeroSumCapacityValidation() {
        this.converter = this.builder.withPercentages(true).build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        Set noZeroSumAllowedQueues = Sets.difference(ALL_QUEUES, (Set)Sets.newHashSet((Object[])new String[]{"root.misc"}));
        for (String queue : noZeroSumAllowedQueues) {
            this.key = "yarn.scheduler.capacity." + queue + ".allow-zero-capacity-sum";
            Assert.assertEquals((String)("Key " + this.key + " has different value"), (Object)false, (Object)this.csConfig.getAllowZeroCapacitySum(new QueuePath(queue)));
        }
        Assert.assertTrue((String)"root.misc allow zero capacities", (boolean)this.csConfig.getAllowZeroCapacitySum(MISC));
    }

    @Test
    public void testQueueMaximumCapacity() {
        this.converter = this.builder.build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        for (String queue : ALL_QUEUES) {
            this.key = "yarn.scheduler.capacity." + queue + ".maximum-capacity";
            Assert.assertEquals((String)("Key " + this.key + " has different value"), (double)100.0, (double)this.csConfig.getNonLabeledQueueMaximumCapacity(new QueuePath(queue)), (double)0.0);
        }
        ((FSConfigToCSConfigRuleHandler)Mockito.verify((Object)this.ruleHandler, (VerificationMode)Mockito.times((int)3))).handleMaxResources();
    }

    @Test
    public void testQueueMinimumCapacity() {
        this.converter = this.builder.build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        ((FSConfigToCSConfigRuleHandler)Mockito.verify((Object)this.ruleHandler, (VerificationMode)Mockito.times((int)2))).handleMinResources();
    }

    @Test
    public void testQueueWithNoAutoCreateChildQueue() {
        this.converter = this.builder.withCapacitySchedulerConfig(this.csConfig).build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        for (String queue : ALL_QUEUES) {
            this.key = "yarn.scheduler.capacity." + queue + ".auto-create-child-queue.enabled";
            Assert.assertEquals((String)("Key " + this.key + " has different value"), (Object)false, (Object)this.csConfig.isAutoCreateChildQueueEnabled(new QueuePath(queue)));
        }
    }

    @Test
    public void testQueueSizeBasedWeightEnabled() {
        this.converter = this.builder.withSizeBasedWeight(true).build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        for (String queue : ALL_QUEUES) {
            this.key = "yarn.scheduler.capacity." + queue + ".ordering-policy.fair.enable-size-based-weight";
            Assert.assertTrue((String)("Key " + this.key + " has different value"), (boolean)this.csConfig.getBoolean(this.key, false));
        }
    }

    @Test
    public void testQueueSizeBasedWeightDisabled() {
        this.converter = this.builder.build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        for (String queue : ALL_QUEUES) {
            this.key = "yarn.scheduler.capacity." + queue + ".ordering-policy.fair.enable-size-based-weight";
            Assert.assertNull((String)("Key " + this.key + " has different value"), (Object)this.csConfig.get(this.key));
        }
    }

    @Test
    public void testQueueOrderingPolicy() throws Exception {
        this.converter = this.builder.build();
        String absolutePath = new File("src/test/resources/fair-scheduler-orderingpolicy.xml").getAbsolutePath();
        this.yarnConfig.set("yarn.scheduler.fair.allocation.file", FILE_PREFIX + absolutePath);
        this.fs.close();
        this.fs = this.createFairScheduler();
        this.rootQueue = this.fs.getQueueManager().getRootQueue();
        this.converter.convertQueueHierarchy(this.rootQueue);
        Assert.assertEquals((String)"root ordering policy", (Object)"fifo", (Object)this.csConfig.getAppOrderingPolicy(ROOT).getConfigName());
        Assert.assertEquals((String)"root.default ordering policy", (Object)"fair", (Object)this.csConfig.getAppOrderingPolicy(DEFAULT).getConfigName());
        Assert.assertEquals((String)"root.admins ordering policy", (Object)"fifo", (Object)this.csConfig.getAppOrderingPolicy(ADMINS).getConfigName());
        Assert.assertEquals((String)"root.users ordering policy", (Object)"fifo", (Object)this.csConfig.getAppOrderingPolicy(USERS).getConfigName());
        Assert.assertEquals((String)"root.users.joe ordering policy", (Object)"fair", (Object)this.csConfig.getAppOrderingPolicy(USERS_JOE).getConfigName());
        Assert.assertEquals((String)"root.users.john ordering policy", (Object)"fifo", (Object)this.csConfig.getAppOrderingPolicy(USERS_JOHN).getConfigName());
        Assert.assertEquals((String)"root.admins.alice ordering policy", (Object)"fifo", (Object)this.csConfig.getAppOrderingPolicy(ADMINS_ALICE).getConfigName());
        Assert.assertEquals((String)"root.admins.bob ordering policy", (Object)"fair", (Object)this.csConfig.getAppOrderingPolicy(ADMINS_BOB).getConfigName());
    }

    @Test
    public void testQueueUnsupportedMixedOrderingPolicy() throws IOException {
        this.converter = this.builder.withDrfUsed(true).build();
        String absolutePath = new File("src/test/resources/fair-scheduler-orderingpolicy-mixed.xml").getAbsolutePath();
        this.yarnConfig.set("yarn.scheduler.fair.allocation.file", FILE_PREFIX + absolutePath);
        this.fs.close();
        this.fs = this.createFairScheduler();
        this.rootQueue = this.fs.getQueueManager().getRootQueue();
        this.converter.convertQueueHierarchy(this.rootQueue);
        ((FSConfigToCSConfigRuleHandler)Mockito.verify((Object)this.ruleHandler, (VerificationMode)Mockito.times((int)5))).handleFairAsDrf(ArgumentMatchers.anyString());
    }

    @Test
    public void testQueueMaxChildCapacityNotSupported() {
        this.converter = this.builder.build();
        this.expectedException.expect(UnsupportedPropertyException.class);
        this.expectedException.expectMessage("test");
        ((FSConfigToCSConfigRuleHandler)Mockito.doThrow((Throwable[])new Throwable[]{new UnsupportedPropertyException("test")}).when((Object)this.ruleHandler)).handleMaxChildCapacity();
        this.converter.convertQueueHierarchy(this.rootQueue);
    }

    @Test
    public void testReservationSystemNotSupported() {
        this.converter = this.builder.build();
        this.expectedException.expect(UnsupportedPropertyException.class);
        this.expectedException.expectMessage("maxCapacity");
        ((FSConfigToCSConfigRuleHandler)Mockito.doThrow((Throwable[])new Throwable[]{new UnsupportedPropertyException("maxCapacity")}).when((Object)this.ruleHandler)).handleMaxChildCapacity();
        this.yarnConfig.setBoolean("yarn.resourcemanager.reservation-system.enable", true);
        this.converter.convertQueueHierarchy(this.rootQueue);
    }
}

