/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileQueuePlacementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.UserSettings;

public final class AllocationFileWriter {
    private static final String DRF = "drf";
    private static final String FAIR = "fair";
    private static final String FIFO = "fifo";
    private Integer queueMaxAppsDefault;
    private String queueMaxResourcesDefault;
    private Integer userMaxAppsDefault;
    private Double queueMaxAMShareDefault;
    private Integer defaultMinSharePreemptionTimeout;
    private Integer defaultFairSharePreemptionTimeout;
    private Double defaultFairSharePreemptionThreshold;
    private String defaultQueueSchedulingPolicy;
    private List<AllocationFileQueue> queues = new ArrayList<AllocationFileQueue>();
    private UserSettings userSettings;
    private boolean useLegacyTagNameForQueues = false;
    private String reservationAgent;
    private String reservationPolicy;
    private AllocationFileQueuePlacementPolicy queuePlacementPolicy;

    private AllocationFileWriter() {
    }

    public static AllocationFileWriter create() {
        return new AllocationFileWriter();
    }

    public AllocationFileWriter addQueue(AllocationFileQueue queue) {
        this.queues.add(queue);
        return this;
    }

    public AllocationFileWriter queueMaxAppsDefault(int value) {
        this.queueMaxAppsDefault = value;
        return this;
    }

    public AllocationFileWriter queueMaxResourcesDefault(String value) {
        this.queueMaxResourcesDefault = value;
        return this;
    }

    public AllocationFileWriter userMaxAppsDefault(int value) {
        this.userMaxAppsDefault = value;
        return this;
    }

    public AllocationFileWriter queueMaxAMShareDefault(double value) {
        this.queueMaxAMShareDefault = value;
        return this;
    }

    public AllocationFileWriter disableQueueMaxAMShareDefault() {
        this.queueMaxAMShareDefault = -1.0;
        return this;
    }

    public AllocationFileWriter defaultMinSharePreemptionTimeout(int value) {
        this.defaultMinSharePreemptionTimeout = value;
        return this;
    }

    public AllocationFileWriter defaultFairSharePreemptionTimeout(int value) {
        this.defaultFairSharePreemptionTimeout = value;
        return this;
    }

    public AllocationFileWriter defaultFairSharePreemptionThreshold(double value) {
        this.defaultFairSharePreemptionThreshold = value;
        return this;
    }

    public AllocationFileWriter drfDefaultQueueSchedulingPolicy() {
        this.defaultQueueSchedulingPolicy = DRF;
        return this;
    }

    public AllocationFileWriter fairDefaultQueueSchedulingPolicy() {
        this.defaultQueueSchedulingPolicy = FAIR;
        return this;
    }

    public AllocationFileWriter fifoDefaultQueueSchedulingPolicy() {
        this.defaultQueueSchedulingPolicy = FIFO;
        return this;
    }

    public AllocationFileWriter useLegacyTagNameForQueues() {
        this.useLegacyTagNameForQueues = true;
        return this;
    }

    public AllocationFileWriter reservationAgent(String value) {
        this.reservationAgent = value;
        return this;
    }

    public AllocationFileWriter reservationPolicy(String value) {
        this.reservationPolicy = value;
        return this;
    }

    public AllocationFileWriter userSettings(UserSettings settings) {
        this.userSettings = settings;
        return this;
    }

    public AllocationFileWriter queuePlacementPolicy(AllocationFileQueuePlacementPolicy policy) {
        this.queuePlacementPolicy = policy;
        return this;
    }

    static void printQueues(PrintWriter pw, List<AllocationFileQueue> queues, boolean useLegacyTagName) {
        for (AllocationFileQueue queue : queues) {
            String queueStr = useLegacyTagName ? queue.renderWithLegacyTag() : queue.render();
            pw.println(queueStr);
        }
    }

    private void printUserSettings(PrintWriter pw) {
        pw.println(this.userSettings.render());
    }

    private void printQueuePlacementPolicy(PrintWriter pw) {
        pw.println(this.queuePlacementPolicy.render());
    }

    static void addIfPresent(PrintWriter pw, String tag, Object obj) {
        if (obj != null) {
            pw.println("<" + tag + ">" + obj.toString() + "</" + tag + ">");
        }
    }

    private void writeHeader(PrintWriter pw) {
        pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        pw.println("<allocations>");
    }

    private void writeFooter(PrintWriter pw) {
        pw.println("</allocations>");
    }

    public void writeToFile(String filename) {
        PrintWriter pw;
        try {
            pw = new PrintWriter(filename, "UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.writeHeader(pw);
        if (!this.queues.isEmpty()) {
            AllocationFileWriter.printQueues(pw, this.queues, this.useLegacyTagNameForQueues);
        }
        if (this.userSettings != null) {
            this.printUserSettings(pw);
        }
        if (this.queuePlacementPolicy != null) {
            this.printQueuePlacementPolicy(pw);
        }
        AllocationFileWriter.addIfPresent(pw, "queueMaxAppsDefault", this.queueMaxAppsDefault);
        AllocationFileWriter.addIfPresent(pw, "queueMaxResourcesDefault", this.queueMaxResourcesDefault);
        AllocationFileWriter.addIfPresent(pw, "userMaxAppsDefault", this.userMaxAppsDefault);
        AllocationFileWriter.addIfPresent(pw, "queueMaxAMShareDefault", this.queueMaxAMShareDefault);
        AllocationFileWriter.addIfPresent(pw, "defaultMinSharePreemptionTimeout", this.defaultMinSharePreemptionTimeout);
        AllocationFileWriter.addIfPresent(pw, "defaultFairSharePreemptionTimeout", this.defaultFairSharePreemptionTimeout);
        AllocationFileWriter.addIfPresent(pw, "defaultFairSharePreemptionThreshold", this.defaultFairSharePreemptionThreshold);
        AllocationFileWriter.addIfPresent(pw, "defaultQueueSchedulingPolicy", this.defaultQueueSchedulingPolicy);
        AllocationFileWriter.addIfPresent(pw, "reservation-agent", this.reservationAgent);
        AllocationFileWriter.addIfPresent(pw, "reservation-policy", this.reservationPolicy);
        this.writeFooter(pw);
        pw.close();
    }
}

