/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.DefaultPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.FSPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.UserPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.PeriodGroupsMapping;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SimpleGroupsMapping;
import org.apache.hadoop.yarn.util.SystemClock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestQueuePlacementPolicy {
    private static final FairSchedulerConfiguration CONF = new FairSchedulerConfiguration();
    private PlacementManager placementManager;
    private FairScheduler scheduler;
    private QueueManager queueManager;
    private ApplicationSubmissionContext asc;
    private ApplicationPlacementContext context;

    @BeforeClass
    public static void setup() {
        CONF.setClass("hadoop.security.group.mapping", SimpleGroupsMapping.class, GroupMappingServiceProvider.class);
    }

    @Before
    public void initTest() {
        SystemClock clock = SystemClock.getInstance();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.placementManager = new PlacementManager();
        this.scheduler = (FairScheduler)Mockito.mock(FairScheduler.class);
        Mockito.when((Object)this.scheduler.getClock()).thenReturn((Object)clock);
        Mockito.when((Object)this.scheduler.getRMContext()).thenReturn((Object)rmContext);
        Mockito.when((Object)this.scheduler.getConfig()).thenReturn((Object)CONF);
        Mockito.when((Object)this.scheduler.getConf()).thenReturn((Object)CONF);
        Mockito.when((Object)rmContext.getQueuePlacementManager()).thenReturn((Object)this.placementManager);
        AllocationConfiguration allocConf = new AllocationConfiguration(this.scheduler);
        Mockito.when((Object)this.scheduler.getAllocationConfiguration()).thenReturn((Object)allocConf);
        this.queueManager = new QueueManager(this.scheduler);
        this.queueManager.initialize();
        Mockito.when((Object)this.scheduler.getQueueManager()).thenReturn((Object)this.queueManager);
    }

    @After
    public void cleanTest() {
        this.placementManager = null;
        this.queueManager = null;
        this.scheduler = null;
    }

    @Test
    public void testSpecifiedUserPolicy() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' />");
        sb.append("  <rule name='user' />");
        sb.append("</queuePlacementPolicy>");
        this.createPolicy(sb.toString());
        this.asc = this.newAppSubmissionContext("specifiedq");
        this.context = this.placementManager.placeApplication(this.asc, "someuser");
        Assert.assertEquals((Object)"root.specifiedq", (Object)this.context.getQueue());
        this.asc = this.newAppSubmissionContext("default");
        this.context = this.placementManager.placeApplication(this.asc, "someuser");
        Assert.assertEquals((Object)"root.someuser", (Object)this.context.getQueue());
        this.context = this.placementManager.placeApplication(this.asc, "otheruser");
        Assert.assertEquals((Object)"root.otheruser", (Object)this.context.getQueue());
    }

    @Test
    public void testNoCreate() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' />");
        sb.append("  <rule name='user' create=\"false\" />");
        sb.append("  <rule name='default' />");
        sb.append("</queuePlacementPolicy>");
        this.createPolicy(sb.toString());
        this.createQueue(FSQueueType.LEAF, "root.someuser");
        this.asc = this.newAppSubmissionContext("specifiedq");
        this.context = this.placementManager.placeApplication(this.asc, "someuser");
        Assert.assertEquals((Object)"root.specifiedq", (Object)this.context.getQueue());
        this.asc = this.newAppSubmissionContext("default");
        this.context = this.placementManager.placeApplication(this.asc, "someuser");
        Assert.assertEquals((Object)"root.someuser", (Object)this.context.getQueue());
        this.asc = this.newAppSubmissionContext("specifiedq");
        this.context = this.placementManager.placeApplication(this.asc, "otheruser");
        Assert.assertEquals((Object)"root.specifiedq", (Object)this.context.getQueue());
        this.asc = this.newAppSubmissionContext("default");
        this.context = this.placementManager.placeApplication(this.asc, "otheruser");
        Assert.assertEquals((Object)"root.default", (Object)this.context.getQueue());
    }

    @Test
    public void testSpecifiedThenReject() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' />");
        sb.append("  <rule name='reject' />");
        sb.append("</queuePlacementPolicy>");
        this.createPolicy(sb.toString());
        this.asc = this.newAppSubmissionContext("specifiedq");
        this.context = this.placementManager.placeApplication(this.asc, "someuser");
        Assert.assertEquals((Object)"root.specifiedq", (Object)this.context.getQueue());
        this.asc = this.newAppSubmissionContext("default");
        this.context = this.placementManager.placeApplication(this.asc, "someuser");
        Assert.assertNull((String)"Assignment should have been rejected and was not", (Object)this.context);
    }

    @Test
    public void testOmittedTerminalRule() {
        StringBuilder sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' />");
        sb.append("  <rule name='user' create=\"false\" />");
        sb.append("</queuePlacementPolicy>");
        this.assertIfExceptionThrown(sb);
    }

    @Test
    public void testTerminalRuleInMiddle() {
        StringBuilder sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' />");
        sb.append("  <rule name='default' />");
        sb.append("  <rule name='user' />");
        sb.append("</queuePlacementPolicy>");
        this.assertIfExceptionThrown(sb);
    }

    @Test
    public void testTerminals() {
        StringBuilder sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='secondaryGroupExistingQueue' create='true'/>");
        sb.append("  <rule name='default' queue='otherdefault' create='false'/>");
        sb.append("</queuePlacementPolicy>");
        this.assertIfExceptionThrown(sb);
    }

    @Test
    public void testDefaultRuleWithQueueAttribute() throws Exception {
        this.createQueue(FSQueueType.LEAF, "root.someDefaultQueue");
        StringBuilder sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' create='false' />");
        sb.append("  <rule name='default' queue='root.someDefaultQueue'/>");
        sb.append("</queuePlacementPolicy>");
        this.createPolicy(sb.toString());
        this.asc = this.newAppSubmissionContext("default");
        this.context = this.placementManager.placeApplication(this.asc, "user1");
        Assert.assertEquals((Object)"root.someDefaultQueue", (Object)this.context.getQueue());
    }

    @Test
    public void testNestedUserQueueParsingErrors() {
        StringBuilder sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='nestedUserQueue'/>");
        sb.append("</queuePlacementPolicy>");
        this.assertIfExceptionThrown(sb);
        sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='nestedUserQueue'>");
        sb.append("    <rule name='unknownRule'/>");
        sb.append("  </rule>");
        sb.append("</queuePlacementPolicy>");
        this.assertIfExceptionThrown(sb);
        sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='nestedUserQueue'>");
        sb.append("    <rule name='reject'/>");
        sb.append("  </rule>");
        sb.append("</queuePlacementPolicy>");
        this.assertIfExceptionThrown(sb);
        sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='nestedUserQueue'>");
        sb.append("    <rule name='primaryGroup' create='false'/>");
        sb.append("  </rule>");
        sb.append("</queuePlacementPolicy>");
        this.assertIfExceptionThrown(sb);
    }

    @Test
    public void testMultipleParentRules() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='nestedUserQueue'>");
        sb.append("    <rule name='primaryGroup'/>");
        sb.append("    <rule name='default'/>");
        sb.append("  </rule>");
        sb.append("</queuePlacementPolicy>");
        this.createPolicy(sb.toString());
        PlacementRule nested = (PlacementRule)this.placementManager.getPlacementRules().get(0);
        if (nested instanceof UserPlacementRule) {
            PlacementRule parent = ((FSPlacementRule)nested).getParentRule();
            Assert.assertTrue((String)"Nested rule should have been Default rule", (boolean)(parent instanceof DefaultPlacementRule));
        } else {
            Assert.fail((String)"Policy parsing failed: rule with multiple parents not set");
        }
    }

    @Test
    public void testBrokenRules() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule />");
        sb.append("</queuePlacementPolicy>");
        this.assertIfExceptionThrown(sb);
        sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <notarule />");
        sb.append("</queuePlacementPolicy>");
        this.createPolicy(sb.toString());
        sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='user'>");
        sb.append("    <rule />");
        sb.append("  </rule>");
        sb.append("</queuePlacementPolicy>");
        this.assertIfExceptionThrown(sb);
        sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='user'>");
        sb.append("    <notarule />");
        sb.append("  </rule>");
        sb.append("</queuePlacementPolicy>");
        this.createPolicy(sb.toString());
    }

    private void assertIfExceptionThrown(StringBuilder sb) {
        Exception th = null;
        try {
            this.createPolicy(sb.toString());
        }
        catch (Exception e) {
            th = e;
        }
        Assert.assertTrue((boolean)(th instanceof AllocationConfigurationException));
    }

    private void assertIfExceptionThrown(String user) {
        Exception th = null;
        try {
            this.placementManager.placeApplication(this.asc, user);
        }
        catch (Exception e) {
            th = e;
        }
        Assert.assertTrue((boolean)(th instanceof YarnException));
    }

    @Test
    public void testNestedUserQueueParsing() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' />");
        sb.append("  <rule name='nestedUserQueue'>");
        sb.append("       <rule name='primaryGroup'/>");
        sb.append("  </rule>");
        sb.append("</queuePlacementPolicy>");
        this.createPolicy(sb.toString());
    }

    @Test
    public void testNestedUserQueuePrimaryGroup() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' create='false' />");
        sb.append("  <rule name='nestedUserQueue'>");
        sb.append("       <rule name='primaryGroup'/>");
        sb.append("  </rule>");
        sb.append("</queuePlacementPolicy>");
        this.createPolicy(sb.toString());
        this.asc = this.newAppSubmissionContext("default");
        this.context = this.placementManager.placeApplication(this.asc, "user1");
        Assert.assertEquals((Object)"root.user1group.user1", (Object)this.context.getQueue());
        this.createQueue(FSQueueType.LEAF, "root.specifiedq");
        this.asc = this.newAppSubmissionContext("root.specifiedq");
        this.context = this.placementManager.placeApplication(this.asc, "user2");
        Assert.assertEquals((Object)"root.specifiedq", (Object)this.context.getQueue());
        this.createQueue(FSQueueType.LEAF, "root.user3group");
        this.asc = this.newAppSubmissionContext("default");
        this.context = this.placementManager.placeApplication(this.asc, "user3");
        Assert.assertNull((String)"Submission should have failed and did not", (Object)this.context);
    }

    @Test
    public void testNestedUserQueuePrimaryGroupNoCreate() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='nestedUserQueue'>");
        sb.append("       <rule name='primaryGroup' create='false'/>");
        sb.append("  </rule>");
        sb.append("  <rule name='default' />");
        sb.append("</queuePlacementPolicy>");
        this.createPolicy(sb.toString());
        this.asc = this.newAppSubmissionContext("default");
        this.context = this.placementManager.placeApplication(this.asc, "user1");
        Assert.assertEquals((Object)"root.default", (Object)this.context.getQueue());
        this.createQueue(FSQueueType.PARENT, "root.user1group");
        this.context = this.placementManager.placeApplication(this.asc, "user1");
        Assert.assertEquals((Object)"root.user1group.user1", (Object)this.context.getQueue());
        sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='nestedUserQueue' create='false'>");
        sb.append("       <rule name='primaryGroup' create='false'/>");
        sb.append("  </rule>");
        sb.append("  <rule name='default' />");
        sb.append("</queuePlacementPolicy>");
        this.asc = this.newAppSubmissionContext("default");
        this.context = this.placementManager.placeApplication(this.asc, "user2");
        Assert.assertEquals((Object)"root.default", (Object)this.context.getQueue());
        this.createQueue(FSQueueType.LEAF, "root.user2group.user2");
        this.context = this.placementManager.placeApplication(this.asc, "user2");
        Assert.assertEquals((Object)"root.user2group.user2", (Object)this.context.getQueue());
    }

    @Test
    public void testNestedUserQueueSecondaryGroup() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='nestedUserQueue'>");
        sb.append("       <rule name='secondaryGroupExistingQueue'/>");
        sb.append("  </rule>");
        sb.append("  <rule name='default' />");
        sb.append("</queuePlacementPolicy>");
        this.createPolicy(sb.toString());
        this.asc = this.newAppSubmissionContext("default");
        this.context = this.placementManager.placeApplication(this.asc, "user1");
        Assert.assertEquals((Object)"root.default", (Object)this.context.getQueue());
        this.createQueue(FSQueueType.PARENT, "root.user1subgroup1");
        this.createPolicy(sb.toString());
        this.context = this.placementManager.placeApplication(this.asc, "user1");
        Assert.assertEquals((Object)"root.user1subgroup1.user1", (Object)this.context.getQueue());
    }

    @Test
    public void testNestedUserQueueSpecificRule() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='nestedUserQueue'>");
        sb.append("       <rule name='specified' create='false'/>");
        sb.append("  </rule>");
        sb.append("  <rule name='default' />");
        sb.append("</queuePlacementPolicy>");
        this.createQueue(FSQueueType.PARENT, "root.parent1");
        this.createQueue(FSQueueType.PARENT, "root.parent2");
        this.createPolicy(sb.toString());
        this.asc = this.newAppSubmissionContext("root.parent1");
        this.context = this.placementManager.placeApplication(this.asc, "user1");
        Assert.assertEquals((Object)"root.parent1.user1", (Object)this.context.getQueue());
        this.asc = this.newAppSubmissionContext("root.parent2");
        this.context = this.placementManager.placeApplication(this.asc, "user2");
        Assert.assertEquals((Object)"root.parent2.user2", (Object)this.context.getQueue());
    }

    @Test
    public void testNestedUserQueueDefaultRule() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' create='false' />");
        sb.append("  <rule name='nestedUserQueue'>");
        sb.append("       <rule name='default' queue='root.parent'/>");
        sb.append("  </rule>");
        sb.append("</queuePlacementPolicy>");
        this.createPolicy(sb.toString());
        this.asc = this.newAppSubmissionContext("default");
        this.context = this.placementManager.placeApplication(this.asc, "user1");
        Assert.assertEquals((Object)"root.parent.user1", (Object)this.context.getQueue());
        this.createQueue(FSQueueType.PARENT, "root.parent");
        sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' create='false' />");
        sb.append("  <rule name='nestedUserQueue'>");
        sb.append("    <rule name='default' queue='root.parent' create='false'/>");
        sb.append("  </rule>");
        sb.append("  <rule name='default' />");
        sb.append("</queuePlacementPolicy>");
        this.createPolicy(sb.toString());
        this.asc = this.newAppSubmissionContext("default");
        this.context = this.placementManager.placeApplication(this.asc, "user1");
        Assert.assertEquals((Object)"root.parent.user1", (Object)this.context.getQueue());
        this.createQueue(FSQueueType.LEAF, "root.parent");
        sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' create='false' />");
        sb.append("  <rule name='nestedUserQueue'>");
        sb.append("       <rule name='default' queue='root.parent' />");
        sb.append("  </rule>");
        sb.append("</queuePlacementPolicy>");
        this.createPolicy(sb.toString());
        this.asc = this.newAppSubmissionContext("default");
        this.context = this.placementManager.placeApplication(this.asc, "user1");
        Assert.assertNull((String)"Submission should have failed and did not", (Object)this.context);
    }

    @Test
    public void testUserContainsPeriod() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='user' />");
        sb.append("</queuePlacementPolicy>");
        this.createPolicy(sb.toString());
        this.asc = this.newAppSubmissionContext("default");
        this.context = this.placementManager.placeApplication(this.asc, "first.last");
        Assert.assertEquals((Object)"root.first_dot_last", (Object)this.context.getQueue());
        sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' create='false' />");
        sb.append("  <rule name='nestedUserQueue'>");
        sb.append("       <rule name='default'/>");
        sb.append("  </rule>");
        sb.append("</queuePlacementPolicy>");
        this.queueManager.removeLeafQueue("root.default");
        this.createPolicy(sb.toString());
        this.asc = this.newAppSubmissionContext("default");
        this.context = this.placementManager.placeApplication(this.asc, "first_dot_last");
        Assert.assertEquals((Object)"root.default.first_dot_last", (Object)this.context.getQueue());
    }

    @Test
    public void testGroupContainsPeriod() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' create='false' />");
        sb.append("  <rule name='nestedUserQueue'>");
        sb.append("       <rule name='primaryGroup'/>");
        sb.append("  </rule>");
        sb.append("</queuePlacementPolicy>");
        CONF.setClass("hadoop.security.group.mapping", PeriodGroupsMapping.class, GroupMappingServiceProvider.class);
        Groups.getUserToGroupsMappingServiceWithLoadedConfiguration((Configuration)CONF);
        this.createPolicy(sb.toString());
        this.asc = this.newAppSubmissionContext("default");
        this.context = this.placementManager.placeApplication(this.asc, "user1");
        Assert.assertEquals((Object)"root.user1_dot_group.user1", (Object)this.context.getQueue());
        CONF.setClass("hadoop.security.group.mapping", SimpleGroupsMapping.class, GroupMappingServiceProvider.class);
        Groups.getUserToGroupsMappingServiceWithLoadedConfiguration((Configuration)CONF);
    }

    @Test
    public void testEmptyGroupsPrimaryGroupRule() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='primaryGroup' create=\"false\" />");
        sb.append("  <rule name='default' />");
        sb.append("</queuePlacementPolicy>");
        CONF.setStrings("hadoop.user.group.static.mapping.overrides", new String[]{"emptygroupuser="});
        this.createPolicy(sb.toString());
        this.asc = this.newAppSubmissionContext("root.fake");
        this.assertIfExceptionThrown("emptygroupuser");
    }

    @Test
    public void testSpecifiedQueueWithSpaces() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified'/>");
        sb.append("  <rule name='default'/>");
        sb.append("</queuePlacementPolicy>");
        this.createPolicy(sb.toString());
        this.asc = this.newAppSubmissionContext("A ");
        this.assertIfExceptionThrown("user1");
        this.asc = this.newAppSubmissionContext("A\u00a0");
        this.assertIfExceptionThrown("user1");
    }

    private void createPolicy(String str) throws AllocationConfigurationException {
        Element root = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setIgnoringComments(true);
            DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
            Document doc = builder.parse(IOUtils.toInputStream((String)str, (Charset)StandardCharsets.UTF_8));
            root = doc.getDocumentElement();
        }
        catch (Exception exception) {
            // empty catch block
        }
        QueuePlacementPolicy.fromXml(root, (FairScheduler)this.scheduler);
    }

    private ApplicationSubmissionContext newAppSubmissionContext(String queue) {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        Priority prio = Priority.UNDEFINED;
        Resource resource = Resource.newInstance((int)1, (int)1);
        ContainerLaunchContext amContainer = ContainerLaunchContext.newInstance(null, null, null, null, null, null);
        return ApplicationSubmissionContext.newInstance((ApplicationId)appId, (String)"test", (String)queue, (Priority)prio, (ContainerLaunchContext)amContainer, (boolean)false, (boolean)false, (int)1, (Resource)resource, (String)"testing");
    }

    private void createQueue(FSQueueType type, String name) {
        FSQueue queue = this.queueManager.createQueue(name, type);
        Assert.assertNotNull((String)"Queue not created", (Object)queue);
        do {
            queue.setDynamic(false);
        } while ((queue = queue.parent).isDynamic());
    }
}

