/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.DefaultPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.FSPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PrimaryGroupPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.SpecifiedPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.UserPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationFileLoaderService;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileQueuePlacementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileQueuePlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileWriter;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.UserSettings;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.resource.CustomResourceTypesConfigurationProvider;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAllocationFileLoaderService {
    private static final String A_CUSTOM_RESOURCE = "a-custom-resource";
    static final String TEST_DIR = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
    static final String ALLOC_FILE = new File(TEST_DIR, "test-queues").getAbsolutePath();
    private static final String TEST_FAIRSCHED_XML = "test-fair-scheduler.xml";
    private FairScheduler scheduler;
    private Configuration conf;

    @Before
    public void setup() {
        SystemClock clock = SystemClock.getInstance();
        PlacementManager placementManager = new PlacementManager();
        FairSchedulerConfiguration fsConf = new FairSchedulerConfiguration();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getQueuePlacementManager()).thenReturn((Object)placementManager);
        this.scheduler = (FairScheduler)Mockito.mock(FairScheduler.class);
        this.conf = new YarnConfiguration();
        Mockito.when((Object)this.scheduler.getClock()).thenReturn((Object)clock);
        Mockito.when((Object)this.scheduler.getConf()).thenReturn((Object)fsConf);
        Mockito.when((Object)this.scheduler.getConfig()).thenReturn((Object)this.conf);
        Mockito.when((Object)this.scheduler.getRMContext()).thenReturn((Object)rmContext);
    }

    @After
    public void teardown() {
        new File(ALLOC_FILE).delete();
    }

    @Test
    public void testGetAllocationFileFromFileSystem() throws IOException, URISyntaxException {
        File baseDir = new File(TEST_DIR + "/getAllocHDFS").getAbsoluteFile();
        FileUtil.fullyDelete((File)baseDir);
        this.conf.set("hdfs.minidfs.basedir", baseDir.getAbsolutePath());
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(this.conf);
        MiniDFSCluster hdfsCluster = builder.build();
        String fsAllocPath = "hdfs://localhost:" + hdfsCluster.getNameNodePort() + "/test-fair-scheduler.xml";
        URL fschedURL = Thread.currentThread().getContextClassLoader().getResource(TEST_FAIRSCHED_XML);
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        fs.copyFromLocalFile(new Path(fschedURL.toURI()), new Path(fsAllocPath));
        this.conf.set("yarn.scheduler.fair.allocation.file", fsAllocPath);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService(this.scheduler);
        Path allocationFile = allocLoader.getAllocationFile(this.conf);
        Assert.assertEquals((Object)fsAllocPath, (Object)allocationFile.toString());
        Assert.assertTrue((boolean)fs.exists(allocationFile));
        hdfsCluster.shutdown(true);
    }

    @Test(expected=UnsupportedFileSystemException.class)
    public void testDenyGetAllocationFileFromUnsupportedFileSystem() throws UnsupportedFileSystemException {
        this.conf.set("yarn.scheduler.fair.allocation.file", "badfs:///badfile");
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService(this.scheduler);
        allocLoader.getAllocationFile(this.conf);
    }

    @Test
    public void testGetAllocationFileFromClasspath() {
        try {
            FileSystem fs = FileSystem.get((Configuration)this.conf);
            this.conf.set("yarn.scheduler.fair.allocation.file", TEST_FAIRSCHED_XML);
            AllocationFileLoaderService allocLoader = new AllocationFileLoaderService(this.scheduler);
            Path allocationFile = allocLoader.getAllocationFile(this.conf);
            Assert.assertEquals((Object)TEST_FAIRSCHED_XML, (Object)allocationFile.getName());
            Assert.assertTrue((boolean)fs.exists(allocationFile));
        }
        catch (IOException e) {
            Assert.fail((String)("Unable to access allocation file from classpath: " + e));
        }
    }

    @Test(timeout=10000L)
    public void testReload() throws Exception {
        AllocationFileWriter.create().addQueue(new AllocationFileQueue.Builder("queueA").maxRunningApps(1).build()).addQueue(new AllocationFileQueue.Builder("queueB").build()).queuePlacementPolicy(new AllocationFileQueuePlacementPolicy().addRule(new AllocationFileQueuePlacementRule(AllocationFileQueuePlacementRule.RuleName.DEFAULT))).writeToFile(ALLOC_FILE);
        ControlledClock clock = new ControlledClock();
        clock.setTime(0L);
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService((Clock)clock, this.scheduler);
        allocLoader.reloadIntervalMs = 5L;
        allocLoader.init(this.conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
        AllocationConfiguration allocConf = confHolder.allocConf;
        List rules = this.scheduler.getRMContext().getQueuePlacementManager().getPlacementRules();
        Assert.assertEquals((long)1L, (long)rules.size());
        Assert.assertEquals(DefaultPlacementRule.class, ((PlacementRule)rules.get(0)).getClass());
        Assert.assertEquals((long)1L, (long)allocConf.getQueueMaxApps("root.queueA"));
        Assert.assertEquals((long)2L, (long)((Set)allocConf.getConfiguredQueues().get(FSQueueType.LEAF)).size());
        Assert.assertTrue((boolean)((Set)allocConf.getConfiguredQueues().get(FSQueueType.LEAF)).contains("root.queueA"));
        Assert.assertTrue((boolean)((Set)allocConf.getConfiguredQueues().get(FSQueueType.LEAF)).contains("root.queueB"));
        confHolder.allocConf = null;
        AllocationFileWriter.create().addQueue(new AllocationFileQueue.Builder("queueB").maxRunningApps(3).build()).queuePlacementPolicy(new AllocationFileQueuePlacementPolicy().addRule(new AllocationFileQueuePlacementRule(AllocationFileQueuePlacementRule.RuleName.SPECIFIED)).addRule(new AllocationFileQueuePlacementRule(AllocationFileQueuePlacementRule.RuleName.NESTED).addNestedRule(new AllocationFileQueuePlacementRule(AllocationFileQueuePlacementRule.RuleName.PRIMARY_GROUP)))).writeToFile(ALLOC_FILE);
        clock.tickMsec(System.currentTimeMillis() + 5000L + 10000L);
        allocLoader.start();
        while (confHolder.allocConf == null) {
            Thread.sleep(20L);
        }
        allocConf = confHolder.allocConf;
        rules = this.scheduler.getRMContext().getQueuePlacementManager().getPlacementRules();
        Assert.assertEquals((long)2L, (long)rules.size());
        Assert.assertEquals(SpecifiedPlacementRule.class, ((PlacementRule)rules.get(0)).getClass());
        Assert.assertEquals(UserPlacementRule.class, ((PlacementRule)rules.get(1)).getClass());
        Assert.assertEquals(PrimaryGroupPlacementRule.class, ((FSPlacementRule)rules.get(1)).getParentRule().getClass());
        Assert.assertEquals((long)3L, (long)allocConf.getQueueMaxApps("root.queueB"));
        Assert.assertEquals((long)1L, (long)((Set)allocConf.getConfiguredQueues().get(FSQueueType.LEAF)).size());
        Assert.assertTrue((boolean)((Set)allocConf.getConfiguredQueues().get(FSQueueType.LEAF)).contains("root.queueB"));
    }

    @Test
    public void testAllocationFileParsing() throws Exception {
        CustomResourceTypesConfigurationProvider.initResourceTypes((String[])new String[]{A_CUSTOM_RESOURCE});
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService(this.scheduler);
        AllocationFileWriter.create().addQueue(new AllocationFileQueue.Builder("queueA").minResources("1024mb,0vcores").maxResources("2048mb,10vcores").build()).addQueue(new AllocationFileQueue.Builder("queueB").minResources("2048mb,0vcores").maxResources("5120mb,110vcores").aclAdministerApps("alice,bob admins").schedulingPolicy("fair").build()).addQueue(new AllocationFileQueue.Builder("queueC").minResources("5120mb,0vcores").aclSubmitApps("alice,bob admins").build()).addQueue(new AllocationFileQueue.Builder("queueD").maxRunningApps(3).maxAMShare(0.4).build()).addQueue(new AllocationFileQueue.Builder("queueE").minSharePreemptionTimeout(60).build()).addQueue(new AllocationFileQueue.Builder("queueF").parent(true).maxChildResources("2048mb,64vcores").build()).addQueue(new AllocationFileQueue.Builder("queueG").maxChildResources("2048mb,64vcores").fairSharePreemptionTimeout(120).minSharePreemptionTimeout(50).fairSharePreemptionThreshold(0.6).maxContainerAllocation("vcores=16, memory-mb=512, a-custom-resource=10").subQueue(new AllocationFileQueue.Builder("queueH").fairSharePreemptionTimeout(180).minSharePreemptionTimeout(40).fairSharePreemptionThreshold(0.7).maxContainerAllocation("1024mb,8vcores").build()).build()).queueMaxAppsDefault(15).queueMaxResourcesDefault("4096mb,100vcores").userMaxAppsDefault(5).queueMaxAMShareDefault(0.5).defaultMinSharePreemptionTimeout(120).defaultFairSharePreemptionTimeout(300).defaultFairSharePreemptionThreshold(0.4).drfDefaultQueueSchedulingPolicy().userSettings(new UserSettings.Builder("user1").maxRunningApps(10).build()).writeToFile(ALLOC_FILE);
        allocLoader.init(this.conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
        AllocationConfiguration queueConf = confHolder.allocConf;
        Assert.assertEquals((long)6L, (long)((Set)queueConf.getConfiguredQueues().get(FSQueueType.LEAF)).size());
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.default"));
        Assert.assertEquals((Object)Resources.createResource((int)2048, (int)10), (Object)queueConf.getMaxResources("root.queueA").getResource());
        Assert.assertEquals((Object)Resources.createResource((int)5120, (int)110), (Object)queueConf.getMaxResources("root.queueB").getResource());
        Assert.assertEquals((Object)Resources.createResource((int)4096, (int)100), (Object)queueConf.getMaxResources("root.queueC").getResource());
        Assert.assertEquals((Object)Resources.createResource((int)4096, (int)100), (Object)queueConf.getMaxResources("root.queueD").getResource());
        Assert.assertEquals((Object)Resources.createResource((int)4096, (int)100), (Object)queueConf.getMaxResources("root.queueE").getResource());
        Assert.assertEquals((Object)Resources.createResource((int)4096, (int)100), (Object)queueConf.getMaxResources("root.queueF").getResource());
        Assert.assertEquals((Object)Resources.createResource((int)4096, (int)100), (Object)queueConf.getMaxResources("root.queueG").getResource());
        Assert.assertEquals((Object)Resources.createResource((int)4096, (int)100), (Object)queueConf.getMaxResources("root.queueG.queueH").getResource());
        Assert.assertEquals((Object)Resources.createResource((int)1024, (int)0), (Object)queueConf.getMinResources("root.queueA"));
        Assert.assertEquals((Object)Resources.createResource((int)2048, (int)0), (Object)queueConf.getMinResources("root.queueB"));
        Assert.assertEquals((Object)Resources.createResource((int)5120, (int)0), (Object)queueConf.getMinResources("root.queueC"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueD"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueE"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueF"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueG"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueG.queueH"));
        Assert.assertNull((String)"Max child resources unexpectedly set for queue root.queueA", (Object)queueConf.getMaxChildResources("root.queueA"));
        Assert.assertNull((String)"Max child resources unexpectedly set for queue root.queueB", (Object)queueConf.getMaxChildResources("root.queueB"));
        Assert.assertNull((String)"Max child resources unexpectedly set for queue root.queueC", (Object)queueConf.getMaxChildResources("root.queueC"));
        Assert.assertNull((String)"Max child resources unexpectedly set for queue root.queueD", (Object)queueConf.getMaxChildResources("root.queueD"));
        Assert.assertNull((String)"Max child resources unexpectedly set for queue root.queueE", (Object)queueConf.getMaxChildResources("root.queueE"));
        Assert.assertEquals((Object)Resources.createResource((int)2048, (int)64), (Object)queueConf.getMaxChildResources("root.queueF").getResource());
        Assert.assertEquals((Object)Resources.createResource((int)2048, (int)64), (Object)queueConf.getMaxChildResources("root.queueG").getResource());
        Assert.assertNull((String)"Max child resources unexpectedly set for queue root.queueG.queueH", (Object)queueConf.getMaxChildResources("root.queueG.queueH"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.default"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueA"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueB"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueC"));
        Assert.assertEquals((long)3L, (long)queueConf.getQueueMaxApps("root.queueD"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueE"));
        Assert.assertEquals((long)10L, (long)queueConf.getUserMaxApps("user1"));
        Assert.assertEquals((long)5L, (long)queueConf.getUserMaxApps("user2"));
        Assert.assertEquals((double)0.5, (double)queueConf.getQueueMaxAMShare("root.default"), (double)0.01);
        Assert.assertEquals((double)0.5, (double)queueConf.getQueueMaxAMShare("root.queueA"), (double)0.01);
        Assert.assertEquals((double)0.5, (double)queueConf.getQueueMaxAMShare("root.queueB"), (double)0.01);
        Assert.assertEquals((double)0.5, (double)queueConf.getQueueMaxAMShare("root.queueC"), (double)0.01);
        Assert.assertEquals((double)0.4f, (double)queueConf.getQueueMaxAMShare("root.queueD"), (double)0.01);
        Assert.assertEquals((double)0.5, (double)queueConf.getQueueMaxAMShare("root.queueE"), (double)0.01);
        Resource expectedResourceWithCustomType = Resources.createResource((int)512, (int)16);
        expectedResourceWithCustomType.setResourceValue(A_CUSTOM_RESOURCE, 10L);
        Assert.assertEquals((Object)Resources.unbounded(), (Object)queueConf.getQueueMaxContainerAllocation("root.default"));
        Assert.assertEquals((Object)Resources.unbounded(), (Object)queueConf.getQueueMaxContainerAllocation("root.queueA"));
        Assert.assertEquals((Object)Resources.unbounded(), (Object)queueConf.getQueueMaxContainerAllocation("root.queueB"));
        Assert.assertEquals((Object)Resources.unbounded(), (Object)queueConf.getQueueMaxContainerAllocation("root.queueC"));
        Assert.assertEquals((Object)Resources.unbounded(), (Object)queueConf.getQueueMaxContainerAllocation("root.queueD"));
        Assert.assertEquals((Object)Resources.unbounded(), (Object)queueConf.getQueueMaxContainerAllocation("root.queueE"));
        Assert.assertEquals((Object)Resources.unbounded(), (Object)queueConf.getQueueMaxContainerAllocation("root.queueF"));
        Assert.assertEquals((Object)expectedResourceWithCustomType, (Object)queueConf.getQueueMaxContainerAllocation("root.queueG"));
        Assert.assertEquals((Object)Resources.createResource((int)1024, (int)8), (Object)queueConf.getQueueMaxContainerAllocation("root.queueG.queueH"));
        Assert.assertEquals((long)120000L, (long)queueConf.getMinSharePreemptionTimeout("root"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.default"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueA"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueB"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueC"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueD"));
        Assert.assertEquals((long)60000L, (long)queueConf.getMinSharePreemptionTimeout("root.queueE"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueF"));
        Assert.assertEquals((long)50000L, (long)queueConf.getMinSharePreemptionTimeout("root.queueG"));
        Assert.assertEquals((long)40000L, (long)queueConf.getMinSharePreemptionTimeout("root.queueG.queueH"));
        Assert.assertEquals((long)300000L, (long)queueConf.getFairSharePreemptionTimeout("root"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.default"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueA"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueB"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueC"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueD"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueE"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueF"));
        Assert.assertEquals((long)120000L, (long)queueConf.getFairSharePreemptionTimeout("root.queueG"));
        Assert.assertEquals((long)180000L, (long)queueConf.getFairSharePreemptionTimeout("root.queueG.queueH"));
        Assert.assertEquals((double)0.4f, (double)queueConf.getFairSharePreemptionThreshold("root"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.default"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueA"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueB"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueC"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueD"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueE"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueF"), (double)0.01);
        Assert.assertEquals((double)0.6f, (double)queueConf.getFairSharePreemptionThreshold("root.queueG"), (double)0.01);
        Assert.assertEquals((double)0.7f, (double)queueConf.getFairSharePreemptionThreshold("root.queueG.queueH"), (double)0.01);
        Assert.assertTrue((boolean)((Set)queueConf.getConfiguredQueues().get(FSQueueType.PARENT)).contains("root.queueF"));
        Assert.assertTrue((boolean)((Set)queueConf.getConfiguredQueues().get(FSQueueType.PARENT)).contains("root.queueG"));
        Assert.assertTrue((boolean)((Set)queueConf.getConfiguredQueues().get(FSQueueType.LEAF)).contains("root.queueG.queueH"));
        Assert.assertEquals((Object)"DRF", (Object)queueConf.getSchedulingPolicy("root").getName());
        Assert.assertEquals((Object)"DRF", (Object)queueConf.getSchedulingPolicy("root.queueA").getName());
        Assert.assertEquals((Object)"fair", (Object)queueConf.getSchedulingPolicy("root.queueB").getName());
        Assert.assertEquals((Object)"DRF", (Object)queueConf.getSchedulingPolicy("root.newqueue").getName());
    }

    @Test
    public void testBackwardsCompatibleAllocationFileParsing() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService(this.scheduler);
        AllocationFileWriter.create().useLegacyTagNameForQueues().addQueue(new AllocationFileQueue.Builder("queueA").minResources("1024mb,0vcores").build()).addQueue(new AllocationFileQueue.Builder("queueB").minResources("2048mb,0vcores").aclAdministerApps("alice,bob admins").build()).addQueue(new AllocationFileQueue.Builder("queueC").aclAdministerApps("alice,bob admins").build()).addQueue(new AllocationFileQueue.Builder("queueD").maxRunningApps(3).build()).addQueue(new AllocationFileQueue.Builder("queueE").minSharePreemptionTimeout(60).fairSharePreemptionThreshold(0.3).build()).queueMaxAppsDefault(15).userMaxAppsDefault(5).queueMaxResourcesDefault("4096mb,100vcores").queueMaxAMShareDefault(0.5).defaultMinSharePreemptionTimeout(120).defaultFairSharePreemptionTimeout(300).defaultFairSharePreemptionThreshold(0.6).drfDefaultQueueSchedulingPolicy().userSettings(new UserSettings.Builder("user1").maxRunningApps(10).build()).writeToFile(ALLOC_FILE);
        allocLoader.init(this.conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
        AllocationConfiguration queueConf = confHolder.allocConf;
        Assert.assertEquals((long)5L, (long)((Set)queueConf.getConfiguredQueues().get(FSQueueType.LEAF)).size());
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.default"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.default"));
        Assert.assertEquals((Object)Resources.createResource((int)1024, (int)0), (Object)queueConf.getMinResources("root.queueA"));
        Assert.assertEquals((Object)Resources.createResource((int)2048, (int)0), (Object)queueConf.getMinResources("root.queueB"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueC"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueD"));
        Assert.assertEquals((Object)Resources.createResource((int)0), (Object)queueConf.getMinResources("root.queueE"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.default"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueA"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueB"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueC"));
        Assert.assertEquals((long)3L, (long)queueConf.getQueueMaxApps("root.queueD"));
        Assert.assertEquals((long)15L, (long)queueConf.getQueueMaxApps("root.queueE"));
        Assert.assertEquals((long)10L, (long)queueConf.getUserMaxApps("user1"));
        Assert.assertEquals((long)5L, (long)queueConf.getUserMaxApps("user2"));
        Assert.assertEquals((long)120000L, (long)queueConf.getMinSharePreemptionTimeout("root"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.default"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueA"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueB"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueC"));
        Assert.assertEquals((long)-1L, (long)queueConf.getMinSharePreemptionTimeout("root.queueD"));
        Assert.assertEquals((long)60000L, (long)queueConf.getMinSharePreemptionTimeout("root.queueE"));
        Assert.assertEquals((long)300000L, (long)queueConf.getFairSharePreemptionTimeout("root"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.default"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueA"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueB"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueC"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueD"));
        Assert.assertEquals((long)-1L, (long)queueConf.getFairSharePreemptionTimeout("root.queueE"));
        Assert.assertEquals((double)0.6f, (double)queueConf.getFairSharePreemptionThreshold("root"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.default"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueA"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueB"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueC"), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)queueConf.getFairSharePreemptionThreshold("root.queueD"), (double)0.01);
        Assert.assertEquals((double)0.3f, (double)queueConf.getFairSharePreemptionThreshold("root.queueE"), (double)0.01);
    }

    @Test
    public void testSimplePlacementPolicyFromConf() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.conf.setBoolean("yarn.scheduler.fair.allow-undeclared-pools", false);
        this.conf.setBoolean("yarn.scheduler.fair.user-as-default-queue", false);
        AllocationFileWriter.create().writeToFile(ALLOC_FILE);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService(this.scheduler);
        allocLoader.init(this.conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
        List rules = this.scheduler.getRMContext().getQueuePlacementManager().getPlacementRules();
        Assert.assertEquals((long)2L, (long)rules.size());
        Assert.assertEquals(SpecifiedPlacementRule.class, ((PlacementRule)rules.get(0)).getClass());
        Assert.assertFalse((String)"Create flag was not set to false", (boolean)((FSPlacementRule)rules.get(0)).getCreateFlag());
        Assert.assertEquals(DefaultPlacementRule.class, ((PlacementRule)rules.get(1)).getClass());
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testQueueAlongsideRoot() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        AllocationFileWriter.create().addQueue(new AllocationFileQueue.Builder("root").build()).addQueue(new AllocationFileQueue.Builder("other").build()).writeToFile(ALLOC_FILE);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService(this.scheduler);
        allocLoader.init(this.conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testQueueNameContainingPeriods() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        AllocationFileWriter.create().addQueue(new AllocationFileQueue.Builder("parent1.child").build()).writeToFile(ALLOC_FILE);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService(this.scheduler);
        allocLoader.init(this.conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testQueueNameContainingOnlyWhitespace() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        AllocationFileWriter.create().addQueue(new AllocationFileQueue.Builder("      ").build()).writeToFile(ALLOC_FILE);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService(this.scheduler);
        allocLoader.init(this.conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
    }

    @Test
    public void testParentTagWithReservation() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        AllocationFileWriter.create().addQueue(new AllocationFileQueue.Builder("parent").parent(true).reservation().build()).writeToFile(ALLOC_FILE);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService(this.scheduler);
        allocLoader.init(this.conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        try {
            allocLoader.reloadAllocations();
        }
        catch (AllocationConfigurationException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)"The configuration settings for root.parent are invalid. A queue element that contains child queue elements or that has the type='parent' attribute cannot also include a reservation element.");
        }
    }

    @Test
    public void testParentWithReservation() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        AllocationFileWriter.create().addQueue(new AllocationFileQueue.Builder("parent").parent(true).subQueue(new AllocationFileQueue.Builder("child").build()).reservation().build()).writeToFile(ALLOC_FILE);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService(this.scheduler);
        allocLoader.init(this.conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        try {
            allocLoader.reloadAllocations();
        }
        catch (AllocationConfigurationException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)"The configuration settings for root.parent are invalid. A queue element that contains child queue elements or that has the type='parent' attribute cannot also include a reservation element.");
        }
    }

    @Test
    public void testParentTagWithMaxAMShare() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        AllocationFileWriter.create().addQueue(new AllocationFileQueue.Builder("parent").parent(true).maxAMShare(0.75).build()).writeToFile(ALLOC_FILE);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService(this.scheduler);
        allocLoader.init(this.conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        try {
            allocLoader.reloadAllocations();
            Assert.fail((String)"Expect allocation parsing to fail as maxAMShare cannot be set for a parent queue.");
        }
        catch (AllocationConfigurationException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)"The configuration settings for root.parent are invalid. A queue element that contains child queue elements or that has the type='parent' attribute cannot also include a maxAMShare element.");
        }
    }

    @Test
    public void testParentWithMaxAMShare() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        AllocationFileWriter.create().addQueue(new AllocationFileQueue.Builder("parent").parent(false).maxAMShare(0.76).subQueue(new AllocationFileQueue.Builder("child").build()).build()).writeToFile(ALLOC_FILE);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService(this.scheduler);
        allocLoader.init(this.conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        try {
            allocLoader.reloadAllocations();
            Assert.fail((String)"Expect allocation parsing to fail as maxAMShare cannot be set for a parent queue.");
        }
        catch (AllocationConfigurationException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)"The configuration settings for root.parent are invalid. A queue element that contains child queue elements or that has the type='parent' attribute cannot also include a maxAMShare element.");
        }
    }

    @Test
    public void testParentTagWithChild() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        AllocationFileWriter.create().addQueue(new AllocationFileQueue.Builder("parent").parent(true).subQueue(new AllocationFileQueue.Builder("child").build()).build()).writeToFile(ALLOC_FILE);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService(this.scheduler);
        allocLoader.init(this.conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
        AllocationConfiguration queueConf = confHolder.allocConf;
        Assert.assertTrue((boolean)((Set)queueConf.getConfiguredQueues().get(FSQueueType.PARENT)).contains("root.parent"));
        Assert.assertTrue((boolean)((Set)queueConf.getConfiguredQueues().get(FSQueueType.LEAF)).contains("root.parent.child"));
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testQueueNameContainingNBWhitespace() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        AllocationFileWriter.create().addQueue(new AllocationFileQueue.Builder("\u00a0").build()).writeToFile(ALLOC_FILE);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService(this.scheduler);
        allocLoader.init(this.conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testDefaultQueueSchedulingModeIsFIFO() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        AllocationFileWriter.create().fifoDefaultQueueSchedulingPolicy().writeToFile(ALLOC_FILE);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService(this.scheduler);
        allocLoader.init(this.conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
    }

    @Test
    public void testReservableQueue() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        AllocationFileWriter.create().addQueue(new AllocationFileQueue.Builder("reservable").reservation().build()).addQueue(new AllocationFileQueue.Builder("other").build()).reservationAgent("DummyAgentName").reservationPolicy("AnyAdmissionPolicy").writeToFile(ALLOC_FILE);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService(this.scheduler);
        allocLoader.init(this.conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
        AllocationConfiguration allocConf = confHolder.allocConf;
        String reservableQueueName = "root.reservable";
        String nonreservableQueueName = "root.other";
        QueuePath nonreservableQueuePath = new QueuePath(nonreservableQueueName);
        QueuePath reservableQueuePath = new QueuePath(reservableQueueName);
        Assert.assertFalse((boolean)allocConf.isReservable(nonreservableQueuePath));
        Assert.assertTrue((boolean)allocConf.isReservable(reservableQueuePath));
        Map configuredQueues = allocConf.getConfiguredQueues();
        Assert.assertTrue((String)"reservable queue is expected be to a parent queue", (boolean)((Set)configuredQueues.get(FSQueueType.PARENT)).contains(reservableQueueName));
        Assert.assertFalse((String)"reservable queue should not be a leaf queue", (boolean)((Set)configuredQueues.get(FSQueueType.LEAF)).contains(reservableQueueName));
        Assert.assertTrue((boolean)allocConf.getMoveOnExpiry(reservableQueuePath));
        Assert.assertEquals((long)86400000L, (long)allocConf.getReservationWindow(reservableQueuePath));
        Assert.assertEquals((double)100.0, (double)allocConf.getInstantaneousMaxCapacity(reservableQueuePath), (double)1.0E-4);
        Assert.assertEquals((Object)"DummyAgentName", (Object)allocConf.getReservationAgent(reservableQueuePath));
        Assert.assertEquals((double)100.0, (double)allocConf.getAverageCapacity(reservableQueuePath), (double)0.001);
        Assert.assertFalse((boolean)allocConf.getShowReservationAsQueues(reservableQueuePath));
        Assert.assertEquals((Object)"AnyAdmissionPolicy", (Object)allocConf.getReservationAdmissionPolicy(reservableQueuePath));
        Assert.assertEquals((Object)"org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.SimpleCapacityReplanner", (Object)allocConf.getReplanner(reservableQueuePath));
        Assert.assertEquals((long)3600000L, (long)allocConf.getEnforcementWindow(reservableQueuePath));
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testReservableCannotBeCombinedWithDynamicUserQueue() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        AllocationFileWriter.create().addQueue(new AllocationFileQueue.Builder("notboth").parent(true).reservation().build()).writeToFile(ALLOC_FILE);
        AllocationFileLoaderService allocLoader = new AllocationFileLoaderService(this.scheduler);
        allocLoader.init(this.conf);
        ReloadListener confHolder = new ReloadListener();
        allocLoader.setReloadListener((AllocationFileLoaderService.Listener)confHolder);
        allocLoader.reloadAllocations();
    }

    private class ReloadListener
    implements AllocationFileLoaderService.Listener {
        private AllocationConfiguration allocConf;

        private ReloadListener() {
        }

        public void onReload(AllocationConfiguration info) {
            this.allocConf = info;
        }

        public void onCheck() {
        }
    }
}

