/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.curator.ZKCuratorManager;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.ZKRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.MutableConfScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.MutableConfigurationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.MutableCSConfigurationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.PersistentConfigurationStoreBaseTest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfStoreVersionIncompatibleException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.ZKConfigurationStore;
import org.apache.hadoop.yarn.webapp.dao.QueueConfigInfo;
import org.apache.hadoop.yarn.webapp.dao.SchedConfUpdateInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestZKConfigurationStore
extends PersistentConfigurationStoreBaseTest {
    public static final Logger LOG = LoggerFactory.getLogger(TestZKConfigurationStore.class);
    private static final int ZK_TIMEOUT_MS = 10000;
    private static final String DESERIALIZATION_VULNERABILITY_FILEPATH = "/tmp/ZK_DESERIALIZATION_VULNERABILITY";
    private TestingServer curatorTestingServer;
    private CuratorFramework curatorFramework;
    private ResourceManager rm;

    public static TestingServer setupCuratorServer() throws Exception {
        TestingServer curatorTestingServer = new TestingServer();
        curatorTestingServer.start();
        return curatorTestingServer;
    }

    public static CuratorFramework setupCuratorFramework(TestingServer curatorTestingServer) throws Exception {
        CuratorFramework curatorFramework = CuratorFrameworkFactory.builder().connectString(curatorTestingServer.getConnectString()).retryPolicy((RetryPolicy)new RetryNTimes(100, 100)).build();
        curatorFramework.start();
        return curatorFramework;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.curatorTestingServer = TestZKConfigurationStore.setupCuratorServer();
        this.curatorFramework = TestZKConfigurationStore.setupCuratorFramework(this.curatorTestingServer);
        this.conf.set("yarn.resourcemanager.zk-address", this.curatorTestingServer.getConnectString());
        this.rm = new MockRM(this.conf);
        this.rm.start();
        this.rmContext = this.rm.getRMContext();
    }

    @After
    public void cleanup() throws IOException {
        this.rm.stop();
        this.curatorFramework.close();
        this.curatorTestingServer.stop();
    }

    @Test(expected=YarnConfStoreVersionIncompatibleException.class)
    public void testIncompatibleVersion() throws Exception {
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        Version otherVersion = Version.newInstance((int)1, (int)1);
        String zkVersionPath = this.getZkPath("VERSION");
        byte[] versionData = ((VersionPBImpl)otherVersion).getProto().toByteArray();
        ((ZKConfigurationStore)this.confStore).safeCreateZkData(zkVersionPath, versionData);
        Assert.assertEquals((String)"The configuration store should have stored the newversion.", (Object)otherVersion, (Object)this.confStore.getConfStoreVersion());
        this.confStore.checkVersion();
    }

    @Test
    public void testFormatConfiguration() throws Exception {
        this.schedConf.set("key", "val");
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        Assert.assertEquals((Object)"val", (Object)this.confStore.retrieve().get("key"));
        this.confStore.format();
        Assert.assertNull((Object)this.confStore.retrieve());
    }

    @Test(expected=IllegalStateException.class)
    public void testGetConfigurationVersionOnSerializedNullData() throws Exception {
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        String confVersionPath = this.getZkPath("CONF_VERSION");
        ((ZKConfigurationStore)this.confStore).setZkData(confVersionPath, null);
        this.confStore.getConfigVersion();
    }

    @Test(expected=ClassCastException.class)
    public void testLogMutationAfterSerializationError() throws Exception {
        byte[] data = null;
        String logs = "NOT_LINKED_LIST";
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(logs);
            oos.flush();
            baos.flush();
            data = baos.toByteArray();
        }
        String logsPath = this.getZkPath("LOGS");
        ((ZKConfigurationStore)this.confStore).setZkData(logsPath, data);
        HashMap<String, String> update = new HashMap<String, String>();
        update.put("valid_key", "valid_value");
        this.confStore.logMutation(new YarnConfigurationStore.LogMutation(update, "testUser"));
        Assert.assertEquals((Object)data, (Object)((ZKConfigurationStore)this.confStore).getZkData(logsPath));
    }

    @Test
    public void testDisableAuditLogs() throws Exception {
        this.conf.setLong("yarn.scheduler.configuration.store.max-logs", 0L);
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        String logsPath = this.getZkPath("LOGS");
        byte[] data = null;
        ((ZKConfigurationStore)this.confStore).setZkData(logsPath, data);
        this.prepareLogMutation("key1", "val1");
        data = ((ZKConfigurationStore)this.confStore).getZkData(logsPath);
        Assert.assertNull((String)"Failed to Disable Audit Logs", (Object)data);
    }

    public Configuration createRMHAConf(String rmIds, String rmId, int adminPort) {
        YarnConfiguration conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, CapacityScheduler.class);
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", rmIds);
        conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        conf.set("yarn.scheduler.configuration.store.class", "zk");
        conf.set("yarn.resourcemanager.store.class", ZKRMStateStore.class.getName());
        conf.set("yarn.resourcemanager.zk-address", this.curatorTestingServer.getConnectString());
        conf.set("yarn.resourcemanager.ha.id", rmId);
        conf.set("yarn.resourcemanager.webapp.address", "localhost:0");
        conf.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", false);
        for (String rpcAddress : YarnConfiguration.getServiceAddressConfKeys((Configuration)conf)) {
            for (String id : HAUtil.getRMHAIds((Configuration)conf)) {
                conf.set(HAUtil.addSuffix((String)rpcAddress, (String)id), "localhost:0");
            }
        }
        conf.set(HAUtil.addSuffix((String)"yarn.resourcemanager.admin.address", (String)rmId), "localhost:" + adminPort);
        return conf;
    }

    @Test
    public void testFailoverReadsFromUpdatedStore() throws Exception {
        HAServiceProtocol.StateChangeRequestInfo req = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        Configuration conf1 = this.createRMHAConf("rm1,rm2", "rm1", 1234);
        MockRM rm1 = new MockRM(conf1);
        rm1.start();
        rm1.getRMContext().getRMAdminService().transitionToActive(req);
        Assert.assertEquals((String)"RM with ZKStore didn't start", (Object)Service.STATE.STARTED, (Object)rm1.getServiceState());
        Assert.assertEquals((String)"RM should be Active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)rm1.getRMContext().getRMAdminService().getServiceStatus().getState());
        Assert.assertNull((Object)((MutableConfScheduler)rm1.getResourceScheduler()).getConfiguration().get("key"));
        Configuration conf2 = this.createRMHAConf("rm1,rm2", "rm2", 5678);
        MockRM rm2 = new MockRM(conf2);
        rm2.start();
        Assert.assertEquals((String)"RM should be Standby", (Object)HAServiceProtocol.HAServiceState.STANDBY, (Object)rm2.getRMContext().getRMAdminService().getServiceStatus().getState());
        SchedConfUpdateInfo schedConfUpdateInfo = new SchedConfUpdateInfo();
        schedConfUpdateInfo.getGlobalParams().put("key", "val");
        MutableConfigurationProvider confProvider = ((MutableConfScheduler)rm1.getResourceScheduler()).getMutableConfProvider();
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"testUser", (String[])new String[0]);
        YarnConfigurationStore.LogMutation log = confProvider.logAndApplyMutation(user, schedConfUpdateInfo);
        rm1.getResourceScheduler().reinitialize(conf1, rm1.getRMContext());
        Assert.assertEquals((Object)"val", (Object)((MutableConfScheduler)rm1.getResourceScheduler()).getConfiguration().get("key"));
        confProvider.confirmPendingMutation(log, true);
        Assert.assertEquals((Object)"val", (Object)((MutableCSConfigurationProvider)confProvider).getConfStore().retrieve().get("key"));
        schedConfUpdateInfo.getGlobalParams().put("key", "badVal");
        log = confProvider.logAndApplyMutation(user, schedConfUpdateInfo);
        rm2.getRMContext().getRMAdminService().transitionToActive(req);
        Assert.assertEquals((String)"RM with ZKStore didn't start", (Object)Service.STATE.STARTED, (Object)rm2.getServiceState());
        Assert.assertEquals((String)"RM should be Active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)rm2.getRMContext().getRMAdminService().getServiceStatus().getState());
        for (int i = 0; i < 200; ++i) {
            if (HAServiceProtocol.HAServiceState.ACTIVE != rm1.getRMContext().getRMAdminService().getServiceStatus().getState()) continue;
            Thread.sleep(100L);
        }
        Assert.assertEquals((String)"RM should have been fenced", (Object)HAServiceProtocol.HAServiceState.STANDBY, (Object)rm1.getRMContext().getRMAdminService().getServiceStatus().getState());
        Assert.assertEquals((String)"RM should be Active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)rm2.getRMContext().getRMAdminService().getServiceStatus().getState());
        Assert.assertEquals((Object)"val", (Object)((MutableCSConfigurationProvider)((CapacityScheduler)rm2.getResourceScheduler()).getMutableConfProvider()).getConfStore().retrieve().get("key"));
        Assert.assertEquals((Object)"val", (Object)((MutableConfScheduler)rm2.getResourceScheduler()).getConfiguration().get("key"));
        Thread.sleep(10000L);
        rm1.close();
        rm2.close();
    }

    @Test
    public void testFailoverAfterRemoveQueue() throws Exception {
        HAServiceProtocol.StateChangeRequestInfo req = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        Configuration conf1 = this.createRMHAConf("rm1,rm2", "rm1", 1234);
        MockRM rm1 = new MockRM(conf1);
        rm1.start();
        rm1.getRMContext().getRMAdminService().transitionToActive(req);
        Assert.assertEquals((String)"RM with ZKStore didn't start", (Object)Service.STATE.STARTED, (Object)rm1.getServiceState());
        Assert.assertEquals((String)"RM should be Active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)rm1.getRMContext().getRMAdminService().getServiceStatus().getState());
        Configuration conf2 = this.createRMHAConf("rm1,rm2", "rm2", 5678);
        MockRM rm2 = new MockRM(conf2);
        rm2.start();
        Assert.assertEquals((String)"RM should be Standby", (Object)HAServiceProtocol.HAServiceState.STANDBY, (Object)rm2.getRMContext().getRMAdminService().getServiceStatus().getState());
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"testUser", (String[])new String[0]);
        MutableConfigurationProvider confProvider = ((MutableConfScheduler)rm1.getResourceScheduler()).getMutableConfProvider();
        SchedConfUpdateInfo schedConfUpdateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> addParams = new HashMap<String, String>();
        addParams.put("capacity", "100");
        QueueConfigInfo addInfo = new QueueConfigInfo("root.a", addParams);
        schedConfUpdateInfo.getAddQueueInfo().add(addInfo);
        HashMap<String, String> stopParams = new HashMap<String, String>();
        stopParams.put("state", "STOPPED");
        stopParams.put("capacity", "0");
        QueueConfigInfo stopInfo = new QueueConfigInfo("root.default", stopParams);
        schedConfUpdateInfo.getUpdateQueueInfo().add(stopInfo);
        YarnConfigurationStore.LogMutation log = confProvider.logAndApplyMutation(user, schedConfUpdateInfo);
        rm1.getResourceScheduler().reinitialize(conf1, rm1.getRMContext());
        confProvider.confirmPendingMutation(log, true);
        Assert.assertTrue((boolean)Arrays.asList(((MutableConfScheduler)rm1.getResourceScheduler()).getConfiguration().get("yarn.scheduler.capacity.root.queues").split(",")).contains("a"));
        schedConfUpdateInfo.getUpdateQueueInfo().clear();
        schedConfUpdateInfo.getAddQueueInfo().clear();
        schedConfUpdateInfo.getRemoveQueueInfo().add("root.default");
        log = confProvider.logAndApplyMutation(user, schedConfUpdateInfo);
        rm1.getResourceScheduler().reinitialize(conf1, rm1.getRMContext());
        confProvider.confirmPendingMutation(log, true);
        Assert.assertEquals((Object)"a", (Object)((MutableConfScheduler)rm1.getResourceScheduler()).getConfiguration().get("yarn.scheduler.capacity.root.queues"));
        rm2.getRMContext().getRMAdminService().transitionToActive(req);
        Assert.assertEquals((String)"RM with ZKStore didn't start", (Object)Service.STATE.STARTED, (Object)rm2.getServiceState());
        Assert.assertEquals((String)"RM should be Active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)rm2.getRMContext().getRMAdminService().getServiceStatus().getState());
        for (int i = 0; i < 200; ++i) {
            if (HAServiceProtocol.HAServiceState.ACTIVE != rm1.getRMContext().getRMAdminService().getServiceStatus().getState()) continue;
            Thread.sleep(100L);
        }
        Assert.assertEquals((String)"RM should have been fenced", (Object)HAServiceProtocol.HAServiceState.STANDBY, (Object)rm1.getRMContext().getRMAdminService().getServiceStatus().getState());
        Assert.assertEquals((String)"RM should be Active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)rm2.getRMContext().getRMAdminService().getServiceStatus().getState());
        Assert.assertEquals((Object)"a", (Object)((MutableCSConfigurationProvider)((CapacityScheduler)rm2.getResourceScheduler()).getMutableConfProvider()).getConfStore().retrieve().get("yarn.scheduler.capacity.root.queues"));
        Assert.assertEquals((Object)"a", (Object)((MutableConfScheduler)rm2.getResourceScheduler()).getConfiguration().get("yarn.scheduler.capacity.root.queues"));
        Thread.sleep(10000L);
        rm1.close();
        rm2.close();
    }

    @Test(timeout=3000L)
    public void testDeserializationIsNotVulnerable() throws Exception {
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        String confStorePath = this.getZkPath("CONF_STORE");
        File flagFile = new File(DESERIALIZATION_VULNERABILITY_FILEPATH);
        if (flagFile.exists()) {
            Assert.assertTrue((boolean)flagFile.delete());
        }
        ((ZKConfigurationStore)this.confStore).setZkData(confStorePath, Base64.getDecoder().decode("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"));
        Assert.assertNull((Object)this.confStore.retrieve());
        if (!System.getProperty("os.name").startsWith("Windows")) {
            for (int i = 0; i < 20; ++i) {
                if (flagFile.exists()) continue;
                Thread.sleep(100L);
            }
            Assert.assertFalse((String)"The file '/tmp/ZK_DESERIALIZATION_VULNERABILITY' should not have been created by deserialization attack", (boolean)flagFile.exists());
        }
    }

    @Override
    public YarnConfigurationStore createConfStore() {
        return new ZKConfigurationStore();
    }

    private String getZkPath(String nodeName) {
        String znodeParentPath = this.conf.get("yarn.scheduler.configuration.zk-store.parent-path", "/confstore");
        return ZKCuratorManager.getNodePath((String)znodeParentPath, (String)nodeName);
    }

    @Override
    Version getVersion() {
        return ZKConfigurationStore.CURRENT_VERSION_INFO;
    }
}

