/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacityVector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePrefixes;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.QueueCapacityConfigParser;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestQueueCapacityConfigParser {
    private static final String ALL_RESOURCE_TEMPLATE = "[memory-mb=%s, vcores=%s, yarn.io/gpu=%s]";
    private static final String MEMORY_VCORE_TEMPLATE = "[memory-mb=%s, vcores=%s]";
    private static final String MEMORY_ABSOLUTE = "12Gi";
    private static final float VCORE_ABSOLUTE = 6.0f;
    private static final float GPU_ABSOLUTE = 10.0f;
    private static final float PERCENTAGE_VALUE = 50.0f;
    private static final float MEMORY_MIXED = 1024.0f;
    private static final float WEIGHT_VALUE = 6.0f;
    private static final String QUEUE = "root.test";
    private static final QueuePath QUEUE_PATH = new QueuePath("root.test");
    private static final QueuePath ROOT = new QueuePath("root");
    private static final String ABSOLUTE_RESOURCE = String.format("[memory-mb=%s, vcores=%s, yarn.io/gpu=%s]", "12Gi", Float.valueOf(6.0f), Float.valueOf(10.0f));
    private static final String ABSOLUTE_RESOURCE_MEMORY_VCORE = String.format("[memory-mb=%s, vcores=%s]", "12Gi", Float.valueOf(6.0f));
    private static final String MIXED_RESOURCE = String.format("[memory-mb=%s, vcores=%s, yarn.io/gpu=%s]", Float.valueOf(1024.0f), "50.0%", "6.0w");
    private static final String RESOURCE_TYPES = "yarn.io/gpu";
    public static final String NONEXISTINGSUFFIX = "50nonexistingsuffix";
    public static final String EMPTY_BRACKET = "[]";
    public static final String INVALID_CAPACITY_BRACKET = "[invalid]";
    public static final String INVALID_CAPACITY_FORMAT = "[memory-100,vcores-60]";
    private final QueueCapacityConfigParser capacityConfigParser = new QueueCapacityConfigParser();

    @Test
    public void testPercentageCapacityConfig() {
        QueueCapacityVector percentageCapacityVector = this.capacityConfigParser.parse(Float.toString(50.0f), QUEUE_PATH);
        QueueCapacityVector.QueueCapacityVectorEntry memory = percentageCapacityVector.getResource("memory-mb");
        QueueCapacityVector.QueueCapacityVectorEntry vcore = percentageCapacityVector.getResource("vcores");
        Assert.assertEquals((Object)QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE, (Object)memory.getVectorResourceType());
        Assert.assertEquals((double)50.0, (double)memory.getResourceValue(), (double)0.001f);
        Assert.assertEquals((Object)QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE, (Object)vcore.getVectorResourceType());
        Assert.assertEquals((double)50.0, (double)vcore.getResourceValue(), (double)0.001f);
        QueueCapacityVector rootCapacityVector = this.capacityConfigParser.parse(Float.toString(50.0f), ROOT);
        QueueCapacityVector.QueueCapacityVectorEntry memoryRoot = rootCapacityVector.getResource("memory-mb");
        QueueCapacityVector.QueueCapacityVectorEntry vcoreRoot = rootCapacityVector.getResource("vcores");
        Assert.assertEquals((Object)QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE, (Object)memoryRoot.getVectorResourceType());
        Assert.assertEquals((double)100.0, (double)memoryRoot.getResourceValue(), (double)0.001f);
        Assert.assertEquals((Object)QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE, (Object)vcoreRoot.getVectorResourceType());
        Assert.assertEquals((double)100.0, (double)vcoreRoot.getResourceValue(), (double)0.001f);
    }

    @Test
    public void testWeightCapacityConfig() {
        QueueCapacityVector weightCapacityVector = this.capacityConfigParser.parse("6.0w", QUEUE_PATH);
        QueueCapacityVector.QueueCapacityVectorEntry memory = weightCapacityVector.getResource("memory-mb");
        QueueCapacityVector.QueueCapacityVectorEntry vcore = weightCapacityVector.getResource("vcores");
        Assert.assertEquals((Object)QueueCapacityVector.ResourceUnitCapacityType.WEIGHT, (Object)memory.getVectorResourceType());
        Assert.assertEquals((double)6.0, (double)memory.getResourceValue(), (double)0.001f);
        Assert.assertEquals((Object)QueueCapacityVector.ResourceUnitCapacityType.WEIGHT, (Object)vcore.getVectorResourceType());
        Assert.assertEquals((double)6.0, (double)vcore.getResourceValue(), (double)0.001f);
    }

    @Test
    public void testAbsoluteCapacityVectorConfig() {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        conf.set(QueuePrefixes.getQueuePrefix((QueuePath)QUEUE_PATH) + "capacity", ABSOLUTE_RESOURCE);
        conf.set("yarn.resource-types", RESOURCE_TYPES);
        ResourceUtils.resetResourceTypes((Configuration)conf);
        QueueCapacityVector absoluteCapacityVector = this.capacityConfigParser.parse(ABSOLUTE_RESOURCE, QUEUE_PATH);
        Assert.assertEquals((Object)QueueCapacityVector.ResourceUnitCapacityType.ABSOLUTE, (Object)absoluteCapacityVector.getResource("memory-mb").getVectorResourceType());
        Assert.assertEquals((double)12288.0, (double)absoluteCapacityVector.getResource("memory-mb").getResourceValue(), (double)0.001f);
        Assert.assertEquals((Object)QueueCapacityVector.ResourceUnitCapacityType.ABSOLUTE, (Object)absoluteCapacityVector.getResource("vcores").getVectorResourceType());
        Assert.assertEquals((double)6.0, (double)absoluteCapacityVector.getResource("vcores").getResourceValue(), (double)0.001f);
        Assert.assertEquals((Object)QueueCapacityVector.ResourceUnitCapacityType.ABSOLUTE, (Object)absoluteCapacityVector.getResource(RESOURCE_TYPES).getVectorResourceType());
        Assert.assertEquals((double)10.0, (double)absoluteCapacityVector.getResource(RESOURCE_TYPES).getResourceValue(), (double)0.001f);
        QueueCapacityVector withoutGpuVector = this.capacityConfigParser.parse(ABSOLUTE_RESOURCE_MEMORY_VCORE, QUEUE_PATH);
        Assert.assertEquals((long)3L, (long)withoutGpuVector.getResourceCount());
        Assert.assertEquals((double)0.0, (double)withoutGpuVector.getResource(RESOURCE_TYPES).getResourceValue(), (double)0.001f);
    }

    @Test
    public void testMixedCapacityConfig() {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        conf.set("yarn.resource-types", RESOURCE_TYPES);
        ResourceUtils.resetResourceTypes((Configuration)conf);
        QueueCapacityVector mixedCapacityVector = this.capacityConfigParser.parse(MIXED_RESOURCE, QUEUE_PATH);
        Assert.assertEquals((Object)QueueCapacityVector.ResourceUnitCapacityType.ABSOLUTE, (Object)mixedCapacityVector.getResource("memory-mb").getVectorResourceType());
        Assert.assertEquals((double)1024.0, (double)mixedCapacityVector.getResource("memory-mb").getResourceValue(), (double)0.001f);
        Assert.assertEquals((Object)QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE, (Object)mixedCapacityVector.getResource("vcores").getVectorResourceType());
        Assert.assertEquals((double)50.0, (double)mixedCapacityVector.getResource("vcores").getResourceValue(), (double)0.001f);
        Assert.assertEquals((Object)QueueCapacityVector.ResourceUnitCapacityType.WEIGHT, (Object)mixedCapacityVector.getResource(RESOURCE_TYPES).getVectorResourceType());
        Assert.assertEquals((double)6.0, (double)mixedCapacityVector.getResource(RESOURCE_TYPES).getResourceValue(), (double)0.001f);
        QueueCapacityVector mixedCapacityVectorWithGpuUndefined = this.capacityConfigParser.parse(ABSOLUTE_RESOURCE_MEMORY_VCORE, QUEUE_PATH);
        Assert.assertEquals((Object)QueueCapacityVector.ResourceUnitCapacityType.ABSOLUTE, (Object)mixedCapacityVectorWithGpuUndefined.getResource("memory-mb").getVectorResourceType());
        Assert.assertEquals((double)0.0, (double)mixedCapacityVectorWithGpuUndefined.getResource(RESOURCE_TYPES).getResourceValue(), (double)0.001f);
    }

    @Test
    public void testInvalidCapacityConfigs() {
        QueueCapacityVector capacityVectorWithInvalidSuffix = this.capacityConfigParser.parse(NONEXISTINGSUFFIX, QUEUE_PATH);
        ArrayList entriesWithInvalidSuffix = Lists.newArrayList((Iterator)capacityVectorWithInvalidSuffix.iterator());
        Assert.assertEquals((long)0L, (long)entriesWithInvalidSuffix.size());
        QueueCapacityVector invalidDelimiterCapacityVector = this.capacityConfigParser.parse(INVALID_CAPACITY_FORMAT, QUEUE_PATH);
        ArrayList invalidDelimiterEntries = Lists.newArrayList((Iterator)invalidDelimiterCapacityVector.iterator());
        Assert.assertEquals((long)0L, (long)invalidDelimiterEntries.size());
        QueueCapacityVector invalidCapacityVector = this.capacityConfigParser.parse(INVALID_CAPACITY_BRACKET, QUEUE_PATH);
        ArrayList resources = Lists.newArrayList((Iterator)invalidCapacityVector.iterator());
        Assert.assertEquals((long)0L, (long)resources.size());
        QueueCapacityVector emptyBracketCapacityVector = this.capacityConfigParser.parse(EMPTY_BRACKET, QUEUE_PATH);
        ArrayList emptyEntries = Lists.newArrayList((Iterator)emptyBracketCapacityVector.iterator());
        Assert.assertEquals((long)0L, (long)emptyEntries.size());
        QueueCapacityVector emptyCapacity = this.capacityConfigParser.parse("", QUEUE_PATH);
        ArrayList emptyResources = Lists.newArrayList((Iterator)emptyCapacity.iterator());
        Assert.assertEquals((long)emptyResources.size(), (long)0L);
        QueueCapacityVector nonSetCapacity = this.capacityConfigParser.parse(null, QUEUE_PATH);
        ArrayList nonSetResources = Lists.newArrayList((Iterator)nonSetCapacity.iterator());
        Assert.assertEquals((long)nonSetResources.size(), (long)0L);
    }

    @Test
    public void testZeroAbsoluteCapacityConfig() {
        QueueCapacityVector weightCapacityVector = this.capacityConfigParser.parse(String.format(MEMORY_VCORE_TEMPLATE, 0, 0), QUEUE_PATH);
        QueueCapacityVector.QueueCapacityVectorEntry memory = weightCapacityVector.getResource("memory-mb");
        QueueCapacityVector.QueueCapacityVectorEntry vcore = weightCapacityVector.getResource("vcores");
        Assert.assertEquals((Object)QueueCapacityVector.ResourceUnitCapacityType.ABSOLUTE, (Object)memory.getVectorResourceType());
        Assert.assertEquals((double)0.0, (double)memory.getResourceValue(), (double)0.001f);
        Assert.assertEquals((Object)QueueCapacityVector.ResourceUnitCapacityType.ABSOLUTE, (Object)vcore.getVectorResourceType());
        Assert.assertEquals((double)0.0, (double)vcore.getResourceValue(), (double)0.001f);
    }
}

