/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.MutableCSConfigurationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStore;
import org.apache.hadoop.yarn.webapp.dao.QueueConfigInfo;
import org.apache.hadoop.yarn.webapp.dao.SchedConfUpdateInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMutableCSConfigurationProvider {
    private MutableCSConfigurationProvider confProvider;
    private RMContext rmContext;
    private SchedConfUpdateInfo goodUpdate;
    private SchedConfUpdateInfo badUpdate;
    private CapacityScheduler cs;
    private AdminService adminService;
    private static final UserGroupInformation TEST_USER = UserGroupInformation.createUserForTesting((String)"testUser", (String[])new String[0]);

    @Before
    public void setUp() {
        this.cs = (CapacityScheduler)Mockito.mock(CapacityScheduler.class);
        this.rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)this.rmContext.getScheduler()).thenReturn((Object)this.cs);
        Mockito.when((Object)this.cs.getConfiguration()).thenReturn((Object)new CapacitySchedulerConfiguration());
        this.adminService = (AdminService)Mockito.mock(AdminService.class);
        Mockito.when((Object)this.rmContext.getRMAdminService()).thenReturn((Object)this.adminService);
        this.confProvider = new MutableCSConfigurationProvider(this.rmContext);
        this.goodUpdate = new SchedConfUpdateInfo();
        HashMap<String, String> goodUpdateMap = new HashMap<String, String>();
        goodUpdateMap.put("goodKey", "goodVal");
        QueueConfigInfo goodUpdateInfo = new QueueConfigInfo("root.a", goodUpdateMap);
        this.goodUpdate.getUpdateQueueInfo().add(goodUpdateInfo);
        this.badUpdate = new SchedConfUpdateInfo();
        HashMap<String, String> badUpdateMap = new HashMap<String, String>();
        badUpdateMap.put("badKey", "badVal");
        QueueConfigInfo badUpdateInfo = new QueueConfigInfo("root.a", badUpdateMap);
        this.badUpdate.getUpdateQueueInfo().add(badUpdateInfo);
    }

    @Test
    public void testInMemoryBackedProvider() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.configuration.store.class", "memory");
        this.confProvider.init(conf);
        Assert.assertNull((Object)this.confProvider.loadConfiguration(conf).get("yarn.scheduler.capacity.root.a.goodKey"));
        YarnConfigurationStore.LogMutation log = this.confProvider.logAndApplyMutation(TEST_USER, this.goodUpdate);
        this.confProvider.confirmPendingMutation(log, true);
        Assert.assertEquals((Object)"goodVal", (Object)this.confProvider.loadConfiguration(conf).get("yarn.scheduler.capacity.root.a.goodKey"));
        Assert.assertNull((Object)this.confProvider.loadConfiguration(conf).get("yarn.scheduler.capacity.root.a.badKey"));
        log = this.confProvider.logAndApplyMutation(TEST_USER, this.badUpdate);
        this.confProvider.confirmPendingMutation(log, false);
        Assert.assertNull((Object)this.confProvider.loadConfiguration(conf).get("yarn.scheduler.capacity.root.a.badKey"));
        this.confProvider.formatConfigurationInStore(conf);
        Assert.assertNull((Object)this.confProvider.loadConfiguration(conf).get("yarn.scheduler.capacity.root.a.goodKey"));
    }

    @Test
    public void testRemoveQueueConfig() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.configuration.store.class", "memory");
        this.confProvider.init(conf);
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> updateMap = new HashMap<String, String>();
        updateMap.put("testkey1", "testval1");
        updateMap.put("testkey2", "testval2");
        QueueConfigInfo queueConfigInfo = new QueueConfigInfo("root.a", updateMap);
        updateInfo.getUpdateQueueInfo().add(queueConfigInfo);
        YarnConfigurationStore.LogMutation log = this.confProvider.logAndApplyMutation(TEST_USER, updateInfo);
        this.confProvider.confirmPendingMutation(log, true);
        Assert.assertEquals((Object)"testval1", (Object)this.confProvider.loadConfiguration(conf).get("yarn.scheduler.capacity.root.a.testkey1"));
        Assert.assertEquals((Object)"testval2", (Object)this.confProvider.loadConfiguration(conf).get("yarn.scheduler.capacity.root.a.testkey2"));
        updateInfo = new SchedConfUpdateInfo();
        updateMap.put("testkey1", "");
        queueConfigInfo = new QueueConfigInfo("root.a", updateMap);
        updateInfo.getUpdateQueueInfo().add(queueConfigInfo);
        log = this.confProvider.logAndApplyMutation(TEST_USER, updateInfo);
        this.confProvider.confirmPendingMutation(log, true);
        Assert.assertNull((String)"Failed to remove config", (Object)this.confProvider.loadConfiguration(conf).get("yarn.scheduler.capacity.root.a.testkey1"));
        Assert.assertEquals((Object)"testval2", (Object)this.confProvider.loadConfiguration(conf).get("yarn.scheduler.capacity.root.a.testkey2"));
    }

    @Test
    public void testMultipleUpdatesNotLost() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.configuration.store.class", "memory");
        this.confProvider.init(conf);
        SchedConfUpdateInfo updateInfo1 = new SchedConfUpdateInfo();
        HashMap<String, String> updateMap1 = new HashMap<String, String>();
        updateMap1.put("key1", "val1");
        QueueConfigInfo queueConfigInfo1 = new QueueConfigInfo("root.a", updateMap1);
        updateInfo1.getUpdateQueueInfo().add(queueConfigInfo1);
        YarnConfigurationStore.LogMutation log1 = this.confProvider.logAndApplyMutation(TEST_USER, updateInfo1);
        SchedConfUpdateInfo updateInfo2 = new SchedConfUpdateInfo();
        HashMap<String, String> updateMap2 = new HashMap<String, String>();
        updateMap2.put("key2", "val2");
        QueueConfigInfo queueConfigInfo2 = new QueueConfigInfo("root.a", updateMap2);
        updateInfo2.getUpdateQueueInfo().add(queueConfigInfo2);
        YarnConfigurationStore.LogMutation log2 = this.confProvider.logAndApplyMutation(TEST_USER, updateInfo2);
        this.confProvider.confirmPendingMutation(log1, true);
        this.confProvider.confirmPendingMutation(log2, true);
        Assert.assertEquals((Object)"val1", (Object)this.confProvider.loadConfiguration(conf).get("yarn.scheduler.capacity.root.a.key1"));
        Assert.assertEquals((Object)"val2", (Object)this.confProvider.loadConfiguration(conf).get("yarn.scheduler.capacity.root.a.key2"));
    }

    @Test
    public void testHDFSBackedProvider() throws Exception {
        File testSchedulerConfigurationDir = new File(TestMutableCSConfigurationProvider.class.getResource("").getPath() + TestMutableCSConfigurationProvider.class.getSimpleName());
        FileUtils.deleteDirectory((File)testSchedulerConfigurationDir);
        testSchedulerConfigurationDir.mkdirs();
        Configuration conf = new Configuration(false);
        conf.set("yarn.scheduler.configuration.store.class", "fs");
        conf.set("yarn.scheduler.configuration.fs.path", testSchedulerConfigurationDir.getAbsolutePath());
        this.writeConf(conf, testSchedulerConfigurationDir.getAbsolutePath());
        this.confProvider.init(conf);
        Assert.assertNull((Object)this.confProvider.loadConfiguration(conf).get("yarn.scheduler.capacity.root.a.goodKey"));
        YarnConfigurationStore.LogMutation log = this.confProvider.logAndApplyMutation(TEST_USER, this.goodUpdate);
        this.confProvider.confirmPendingMutation(log, true);
        Assert.assertEquals((Object)"goodVal", (Object)this.confProvider.loadConfiguration(conf).get("yarn.scheduler.capacity.root.a.goodKey"));
        Assert.assertNull((Object)this.confProvider.loadConfiguration(conf).get("yarn.scheduler.capacity.root.a.badKey"));
        log = this.confProvider.logAndApplyMutation(TEST_USER, this.badUpdate);
        this.confProvider.confirmPendingMutation(log, false);
        Assert.assertNull((Object)this.confProvider.loadConfiguration(conf).get("yarn.scheduler.capacity.root.a.badKey"));
        this.confProvider.formatConfigurationInStore(conf);
        Assert.assertNull((Object)this.confProvider.loadConfiguration(conf).get("yarn.scheduler.capacity.root.a.goodKey"));
    }

    @Test
    public void testAddRemoveQueueWithSpacesInConfig() throws Exception {
        final CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        QueuePath root = new QueuePath("root");
        QueuePath a = root.createNewLeaf("a");
        QueuePath b = root.createNewLeaf("b");
        QueuePath c = root.createNewLeaf("c");
        csConf.setQueues(root, new String[]{" a   , b, c"});
        csConf.setCapacity(a, 0.0f);
        csConf.setCapacity(b, 50.0f);
        csConf.setCapacity(c, 50.0f);
        this.confProvider = new MutableCSConfigurationProvider(this.rmContext){

            protected Configuration getInitSchedulerConfig() {
                return csConf;
            }
        };
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.configuration.store.class", "memory");
        this.confProvider.init(conf);
        SchedConfUpdateInfo update = new SchedConfUpdateInfo();
        update.getRemoveQueueInfo().add("root.a");
        this.confProvider.logAndApplyMutation(UserGroupInformation.getCurrentUser(), update);
    }

    private void writeConf(Configuration conf, String storePath) throws IOException {
        FileSystem fileSystem = FileSystem.get((Configuration)new Configuration(conf));
        String schedulerConfigurationFile = "capacity-scheduler.xml." + System.currentTimeMillis();
        try (FSDataOutputStream outputStream = fileSystem.create(new Path(storePath, schedulerConfigurationFile));){
            conf.writeXml((OutputStream)outputStream);
        }
    }
}

