/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.ConfigurationUpdateAssembler;
import org.apache.hadoop.yarn.webapp.dao.QueueConfigInfo;
import org.apache.hadoop.yarn.webapp.dao.SchedConfUpdateInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestConfigurationUpdateAssembler {
    private static final String A_PATH = "root.a";
    private static final String B_PATH = "root.b";
    private static final String C_PATH = "root.c";
    private static final String CONFIG_NAME = "testConfigName";
    private static final String A_CONFIG_PATH = "yarn.scheduler.capacity.root.a.testConfigName";
    private static final String B_CONFIG_PATH = "yarn.scheduler.capacity.root.b.testConfigName";
    private static final String C_CONFIG_PATH = "yarn.scheduler.capacity.root.c.testConfigName";
    private static final String ROOT_QUEUES_PATH = "yarn.scheduler.capacity.root.queues";
    private static final String A_INIT_CONFIG_VALUE = "aInitValue";
    private static final String A_CONFIG_VALUE = "aValue";
    private static final String B_INIT_CONFIG_VALUE = "bInitValue";
    private static final String B_CONFIG_VALUE = "bValue";
    private static final String C_CONFIG_VALUE = "cValue";
    private CapacitySchedulerConfiguration csConfig;

    @Before
    public void setUp() {
        this.csConfig = this.crateInitialCSConfig();
    }

    @Test
    public void testAddQueue() throws Exception {
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> updateMap = new HashMap<String, String>();
        updateMap.put(CONFIG_NAME, C_CONFIG_VALUE);
        QueueConfigInfo queueConfigInfo = new QueueConfigInfo(C_PATH, updateMap);
        updateInfo.getAddQueueInfo().add(queueConfigInfo);
        Map configurationUpdate = ConfigurationUpdateAssembler.constructKeyValueConfUpdate((CapacitySchedulerConfiguration)this.csConfig, (SchedConfUpdateInfo)updateInfo);
        Assert.assertEquals((Object)C_CONFIG_VALUE, configurationUpdate.get(C_CONFIG_PATH));
        Assert.assertEquals((Object)"a,b,c", configurationUpdate.get(ROOT_QUEUES_PATH));
    }

    @Test
    public void testAddExistingQueue() {
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> updateMap = new HashMap<String, String>();
        updateMap.put(CONFIG_NAME, A_CONFIG_VALUE);
        QueueConfigInfo queueConfigInfo = new QueueConfigInfo(A_PATH, updateMap);
        updateInfo.getAddQueueInfo().add(queueConfigInfo);
        Assert.assertThrows(IOException.class, () -> ConfigurationUpdateAssembler.constructKeyValueConfUpdate((CapacitySchedulerConfiguration)this.csConfig, (SchedConfUpdateInfo)updateInfo));
    }

    @Test
    public void testAddInvalidQueue() {
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> updateMap = new HashMap<String, String>();
        updateMap.put(CONFIG_NAME, A_CONFIG_VALUE);
        QueueConfigInfo queueConfigInfo = new QueueConfigInfo("invalidPath", updateMap);
        updateInfo.getAddQueueInfo().add(queueConfigInfo);
        Assert.assertThrows(IOException.class, () -> ConfigurationUpdateAssembler.constructKeyValueConfUpdate((CapacitySchedulerConfiguration)this.csConfig, (SchedConfUpdateInfo)updateInfo));
    }

    @Test
    public void testUpdateQueue() throws Exception {
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        HashMap<String, String> updateMap = new HashMap<String, String>();
        updateMap.put(CONFIG_NAME, A_CONFIG_VALUE);
        QueueConfigInfo queueAConfigInfo = new QueueConfigInfo(A_PATH, updateMap);
        updateInfo.getUpdateQueueInfo().add(queueAConfigInfo);
        HashMap<String, String> updateMapQueueB = new HashMap<String, String>();
        updateMapQueueB.put(CONFIG_NAME, B_CONFIG_VALUE);
        QueueConfigInfo queueBConfigInfo = new QueueConfigInfo(B_PATH, updateMapQueueB);
        updateInfo.getUpdateQueueInfo().add(queueBConfigInfo);
        Map configurationUpdate = ConfigurationUpdateAssembler.constructKeyValueConfUpdate((CapacitySchedulerConfiguration)this.csConfig, (SchedConfUpdateInfo)updateInfo);
        Assert.assertEquals((Object)A_CONFIG_VALUE, configurationUpdate.get(A_CONFIG_PATH));
        Assert.assertEquals((Object)B_CONFIG_VALUE, configurationUpdate.get(B_CONFIG_PATH));
    }

    @Test
    public void testRemoveQueue() throws Exception {
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        updateInfo.getRemoveQueueInfo().add(A_PATH);
        Map configurationUpdate = ConfigurationUpdateAssembler.constructKeyValueConfUpdate((CapacitySchedulerConfiguration)this.csConfig, (SchedConfUpdateInfo)updateInfo);
        Assert.assertTrue((boolean)configurationUpdate.containsKey(A_CONFIG_PATH));
        Assert.assertNull(configurationUpdate.get(A_CONFIG_PATH));
        Assert.assertEquals((Object)"b", configurationUpdate.get(ROOT_QUEUES_PATH));
    }

    @Test
    public void testRemoveInvalidQueue() {
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        updateInfo.getRemoveQueueInfo().add("invalidPath");
        Assert.assertThrows(IOException.class, () -> ConfigurationUpdateAssembler.constructKeyValueConfUpdate((CapacitySchedulerConfiguration)this.csConfig, (SchedConfUpdateInfo)updateInfo));
    }

    @Test
    public void testRemoveNonExistingQueue() {
        SchedConfUpdateInfo updateInfo = new SchedConfUpdateInfo();
        updateInfo.getRemoveQueueInfo().add("root.d");
        Assert.assertThrows(IOException.class, () -> ConfigurationUpdateAssembler.constructKeyValueConfUpdate((CapacitySchedulerConfiguration)this.csConfig, (SchedConfUpdateInfo)updateInfo));
    }

    private CapacitySchedulerConfiguration crateInitialCSConfig() {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues(new QueuePath("root"), new String[]{"a, b"});
        csConf.set(A_CONFIG_PATH, A_INIT_CONFIG_VALUE);
        csConf.set(B_CONFIG_PATH, B_INIT_CONFIG_VALUE);
        return csConf;
    }
}

