/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.AllocationTagsManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TestUtils.class);
    private static final String A_PATH = "root.a";
    private static final String B_PATH = "root.b";
    private static final String C_PATH = "root.c";
    private static final String A1_PATH = "root.a.a1";
    private static final String B1_PATH = "root.b.b1";
    private static final String B2_PATH = "root.b.b2";
    private static final String C1_PATH = "root.c.c1";
    private static final QueuePath ROOT = new QueuePath("root");
    private static final QueuePath A = new QueuePath("root.a");
    private static final QueuePath B = new QueuePath("root.b");
    private static final QueuePath C = new QueuePath("root.c");
    private static final QueuePath A1 = new QueuePath("root.a.a1");
    private static final QueuePath B1 = new QueuePath("root.b.b1");
    private static final QueuePath B2 = new QueuePath("root.b.b2");
    private static final QueuePath C1 = new QueuePath("root.c.c1");
    public static SpyHook spyHook = new SpyHook();
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    public static RMContext getMockRMContext() {
        Dispatcher nullDispatcher = new Dispatcher(){
            private final EventHandler handler = new EventHandler(){

                public void handle(Event event) {
                }
            };

            public void register(Class<? extends Enum> eventType, EventHandler handler) {
            }

            public EventHandler<Event> getEventHandler() {
                return this.handler;
            }
        };
        ContainerAllocationExpirer cae = new ContainerAllocationExpirer(nullDispatcher);
        Configuration conf = new Configuration();
        RMApplicationHistoryWriter writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        RMContextImpl rmContext = new RMContextImpl(nullDispatcher, cae, null, null, null, new AMRMTokenSecretManager(conf, null), new RMContainerTokenSecretManager(conf), new NMTokenSecretManagerInRM(conf), new ClientToAMTokenSecretManagerInRM());
        RMNodeLabelsManager nlm = (RMNodeLabelsManager)Mockito.mock(RMNodeLabelsManager.class);
        Mockito.when((Object)nlm.getQueueResource((String)ArgumentMatchers.any(String.class), (Set)ArgumentMatchers.any(Set.class), (Resource)ArgumentMatchers.any(Resource.class))).thenAnswer((Answer)new Answer<Resource>(){

            public Resource answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return (Resource)args[2];
            }
        });
        Mockito.when((Object)nlm.getResourceByLabel((String)ArgumentMatchers.any(), (Resource)ArgumentMatchers.any(Resource.class))).thenAnswer((Answer)new Answer<Resource>(){

            public Resource answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return (Resource)args[1];
            }
        });
        rmContext.setYarnConfiguration(conf);
        rmContext.setNodeLabelManager(nlm);
        rmContext.setSystemMetricsPublisher((SystemMetricsPublisher)Mockito.mock(SystemMetricsPublisher.class));
        rmContext.setRMApplicationHistoryWriter((RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class));
        ResourceScheduler mockScheduler = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        Mockito.when((Object)mockScheduler.getResourceCalculator()).thenReturn((Object)new DefaultResourceCalculator());
        rmContext.setScheduler(mockScheduler);
        AllocationTagsManager ptm = (AllocationTagsManager)Mockito.mock(AllocationTagsManager.class);
        rmContext.setAllocationTagsManager(ptm);
        return rmContext;
    }

    public static Priority createMockPriority(int priority2) {
        Priority p = (Priority)recordFactory.newRecordInstance(Priority.class);
        p.setPriority(priority2);
        return p;
    }

    public static ResourceRequest createResourceRequest(String resourceName, int memory, int numContainers, boolean relaxLocality, Priority priority2, RecordFactory recordFactory, String labelExpression) {
        return TestUtils.createResourceRequest(resourceName, memory, 1, numContainers, relaxLocality, priority2, recordFactory, labelExpression);
    }

    public static ResourceRequest createResourceRequest(String resourceName, int memory, int vcores, int numContainers, boolean relaxLocality, Priority priority2, RecordFactory recordFactory, String labelExpression) {
        ResourceRequest request = (ResourceRequest)recordFactory.newRecordInstance(ResourceRequest.class);
        Resource capability = Resources.createResource((int)memory, (int)vcores);
        request.setNumContainers(numContainers);
        request.setResourceName(resourceName);
        request.setCapability(capability);
        request.setRelaxLocality(relaxLocality);
        request.setPriority(priority2);
        request.setNodeLabelExpression(labelExpression);
        return request;
    }

    public static ResourceRequest createResourceRequest(int memory, int vcores, int numContainers, Priority priority2, long allocationId, ExecutionTypeRequest type, String resourceName) {
        ResourceRequest request = (ResourceRequest)recordFactory.newRecordInstance(ResourceRequest.class);
        Resource capability = Resources.createResource((int)memory, (int)vcores);
        request.setNumContainers(numContainers);
        request.setCapability(capability);
        request.setPriority(priority2);
        request.setAllocationRequestId(allocationId);
        request.setExecutionTypeRequest(type);
        request.setResourceName(resourceName);
        return request;
    }

    public static ResourceRequest createResourceRequest(String resourceName, int memory, int numContainers, boolean relaxLocality, Priority priority2, RecordFactory recordFactory) {
        return TestUtils.createResourceRequest(resourceName, memory, numContainers, relaxLocality, priority2, recordFactory, "");
    }

    public static ApplicationId getMockApplicationId(int appId) {
        return ApplicationId.newInstance((long)0L, (int)appId);
    }

    public static ApplicationAttemptId getMockApplicationAttemptId(int appId, int attemptId) {
        ApplicationId applicationId = BuilderUtils.newApplicationId((long)0L, (int)appId);
        return ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)attemptId);
    }

    public static FiCaSchedulerNode getMockNodeWithAttributes(String host, String rack, int port, int memory, Set<NodeAttribute> attributes) {
        FiCaSchedulerNode node = TestUtils.getMockNode(host, rack, port, memory, 1);
        Mockito.when((Object)node.getNodeAttributes()).thenReturn(attributes);
        return node;
    }

    public static FiCaSchedulerNode getMockNode(String host, String rack, int port, int memory) {
        return TestUtils.getMockNode(host, rack, port, memory, 1);
    }

    public static FiCaSchedulerNode getMockNode(String host, String rack, int port, int memory, int vcores) {
        NodeId nodeId = NodeId.newInstance((String)host, (int)port);
        RMNode rmNode = (RMNode)Mockito.mock(RMNode.class);
        Mockito.when((Object)rmNode.getNodeID()).thenReturn((Object)nodeId);
        Mockito.when((Object)rmNode.getTotalCapability()).thenReturn((Object)Resources.createResource((int)memory, (int)vcores));
        Mockito.when((Object)rmNode.getNodeAddress()).thenReturn((Object)(host + ":" + port));
        Mockito.when((Object)rmNode.getHostName()).thenReturn((Object)host);
        Mockito.when((Object)rmNode.getRackName()).thenReturn((Object)rack);
        Mockito.when((Object)rmNode.getState()).thenReturn((Object)NodeState.RUNNING);
        FiCaSchedulerNode node = (FiCaSchedulerNode)Mockito.spy((Object)new FiCaSchedulerNode(rmNode, false));
        LOG.info("node = " + host + " avail=" + node.getUnallocatedResource());
        Mockito.when((Object)node.getNodeID()).thenReturn((Object)nodeId);
        return node;
    }

    public static ContainerId getMockContainerId(FiCaSchedulerApp application) {
        ContainerId containerId = (ContainerId)Mockito.mock(ContainerId.class);
        ((ContainerId)Mockito.doReturn((Object)application.getApplicationAttemptId()).when((Object)containerId)).getApplicationAttemptId();
        long id = application.getNewContainerId();
        ((ContainerId)Mockito.doReturn((Object)((int)id)).when((Object)containerId)).getId();
        ((ContainerId)Mockito.doReturn((Object)id).when((Object)containerId)).getContainerId();
        return containerId;
    }

    public static ContainerId getMockContainerId(int appId, int containerId) {
        ApplicationAttemptId attemptId = TestUtils.getMockApplicationAttemptId(appId, 1);
        return ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)containerId);
    }

    public static Container getMockContainer(ContainerId containerId, NodeId nodeId, Resource resource, Priority priority2) {
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)containerId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nodeId);
        Mockito.when((Object)container.getResource()).thenReturn((Object)resource);
        Mockito.when((Object)container.getPriority()).thenReturn((Object)priority2);
        return container;
    }

    public static <E> Set<E> toSet(E ... elements) {
        HashSet set = Sets.newHashSet((Object[])elements);
        return set;
    }

    public static Configuration getConfigurationWithQueueLabels(Configuration config) {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration(config);
        conf.setQueues(ROOT, new String[]{"a", "b", "c"});
        conf.setCapacityByLabel(ROOT, "x", 100.0f);
        conf.setCapacityByLabel(ROOT, "y", 100.0f);
        conf.setCapacity(A, 10.0f);
        conf.setMaximumCapacity(A, 15.0f);
        conf.setAccessibleNodeLabels(A, TestUtils.toSet("x"));
        conf.setCapacityByLabel(A, "x", 100.0f);
        conf.setCapacity(B, 20.0f);
        conf.setAccessibleNodeLabels(B, TestUtils.toSet("y"));
        conf.setCapacityByLabel(B, "y", 100.0f);
        conf.setCapacity(C, 70.0f);
        conf.setMaximumCapacity(C, 70.0f);
        conf.setAccessibleNodeLabels(C, RMNodeLabelsManager.EMPTY_STRING_SET);
        conf.setQueues(A, new String[]{"a1"});
        conf.setCapacity(A1, 100.0f);
        conf.setMaximumCapacity(A1, 100.0f);
        conf.setCapacityByLabel(A1, "x", 100.0f);
        conf.setQueues(B, new String[]{"b1"});
        conf.setCapacity(B1, 100.0f);
        conf.setMaximumCapacity(B1, 100.0f);
        conf.setCapacityByLabel(B1, "y", 100.0f);
        conf.setMaximumApplicationMasterResourcePerQueuePercent(B1, 1.0f);
        conf.setQueues(C, new String[]{"c1"});
        conf.setCapacity(C1, 100.0f);
        conf.setMaximumCapacity(C1, 100.0f);
        return conf;
    }

    public static Configuration getComplexConfigurationWithQueueLabels(Configuration config) {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration(config);
        conf.setQueues(ROOT, new String[]{"a", "b"});
        conf.setCapacityByLabel(ROOT, "x", 100.0f);
        conf.setCapacityByLabel(ROOT, "y", 100.0f);
        conf.setCapacityByLabel(ROOT, "z", 100.0f);
        conf.setCapacity(A, 10.0f);
        conf.setMaximumCapacity(A, 10.0f);
        conf.setAccessibleNodeLabels(A, TestUtils.toSet("x", "y"));
        conf.setCapacityByLabel(A, "x", 100.0f);
        conf.setCapacityByLabel(A, "y", 50.0f);
        conf.setCapacity(B, 90.0f);
        conf.setMaximumCapacity(B, 100.0f);
        conf.setAccessibleNodeLabels(B, TestUtils.toSet("y", "z"));
        conf.setCapacityByLabel(B, "y", 50.0f);
        conf.setCapacityByLabel(B, "z", 100.0f);
        conf.setQueues(A, new String[]{"a1"});
        conf.setCapacity(A1, 100.0f);
        conf.setMaximumCapacity(A1, 100.0f);
        conf.setAccessibleNodeLabels(A1, TestUtils.toSet("x", "y"));
        conf.setDefaultNodeLabelExpression(A1, "x");
        conf.setCapacityByLabel(A1, "x", 100.0f);
        conf.setCapacityByLabel(A1, "y", 100.0f);
        conf.setQueues(B, new String[]{"b1", "b2"});
        conf.setCapacity(B1, 50.0f);
        conf.setMaximumCapacity(B1, 50.0f);
        conf.setAccessibleNodeLabels(B1, RMNodeLabelsManager.EMPTY_STRING_SET);
        conf.setCapacity(B2, 50.0f);
        conf.setMaximumCapacity(B2, 50.0f);
        conf.setAccessibleNodeLabels(B2, TestUtils.toSet("y", "z"));
        conf.setCapacityByLabel(B2, "y", 100.0f);
        conf.setCapacityByLabel(B2, "z", 100.0f);
        return conf;
    }

    public static Configuration getConfigurationWithDefaultQueueLabels(Configuration config) {
        CapacitySchedulerConfiguration conf = (CapacitySchedulerConfiguration)TestUtils.getConfigurationWithQueueLabels(config);
        new CapacitySchedulerConfiguration(config);
        conf.setDefaultNodeLabelExpression(A, "x");
        conf.setDefaultNodeLabelExpression(B, "y");
        return conf;
    }

    public static FiCaSchedulerApp getFiCaSchedulerApp(MockRM rm, ApplicationId appId) {
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        return (FiCaSchedulerApp)((SchedulerApplication)cs.getSchedulerApplications().get(appId)).getCurrentAppAttempt();
    }

    public static Configuration getConfigurationWithMultipleQueues(Configuration config) {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration(config);
        conf.setQueues(ROOT, new String[]{"a", "b", "c"});
        conf.setCapacity(A, 10.0f);
        conf.setMaximumCapacity(A, 100.0f);
        conf.setUserLimitFactor(A, 100.0f);
        conf.setCapacity(B, 20.0f);
        conf.setMaximumCapacity(B, 100.0f);
        conf.setUserLimitFactor(B, 100.0f);
        conf.setCapacity(C, 70.0f);
        conf.setMaximumCapacity(C, 100.0f);
        conf.setUserLimitFactor(C, 100.0f);
        return conf;
    }

    public static SchedulerRequestKey toSchedulerKey(Priority pri) {
        return SchedulerRequestKey.create((ResourceRequest)ResourceRequest.newInstance((Priority)pri, null, null, (int)0));
    }

    public static SchedulerRequestKey toSchedulerKey(int pri) {
        return SchedulerRequestKey.create((ResourceRequest)ResourceRequest.newInstance((Priority)Priority.newInstance((int)pri), null, null, (int)0));
    }

    public static SchedulerRequestKey toSchedulerKey(Priority pri, long allocationRequestId) {
        ResourceRequest req = ResourceRequest.newInstance((Priority)pri, null, null, (int)0);
        req.setAllocationRequestId(allocationRequestId);
        return SchedulerRequestKey.create((ResourceRequest)req);
    }

    public static void applyResourceCommitRequest(Resource clusterResource, CSAssignment csAssignment, Map<NodeId, FiCaSchedulerNode> nodes, Map<ApplicationAttemptId, FiCaSchedulerApp> apps) throws IOException {
        TestUtils.applyResourceCommitRequest(clusterResource, csAssignment, nodes, apps, null);
    }

    public static void applyResourceCommitRequest(Resource clusterResource, CSAssignment csAssignment, final Map<NodeId, FiCaSchedulerNode> nodes, final Map<ApplicationAttemptId, FiCaSchedulerApp> apps, CapacitySchedulerConfiguration csConf) throws IOException {
        CapacityScheduler cs = new CapacityScheduler(){

            public FiCaSchedulerNode getNode(NodeId nodeId) {
                return (FiCaSchedulerNode)nodes.get(nodeId);
            }

            public FiCaSchedulerApp getApplicationAttempt(ApplicationAttemptId applicationAttemptId) {
                return (FiCaSchedulerApp)apps.get(applicationAttemptId);
            }
        };
        cs.setAsyncSchedulingConf(new CapacityScheduler.AsyncSchedulingConfiguration(csConf, cs));
        cs.setResourceCalculator((ResourceCalculator)new DefaultResourceCalculator());
        cs.submitResourceCommitRequest(clusterResource, csAssignment);
    }

    static class SpyHook
    extends CapacitySchedulerQueueManager.QueueHook {
        SpyHook() {
        }

        public CSQueue hook(CSQueue queue) {
            return (CSQueue)Mockito.spy((Object)queue);
        }
    }
}

