/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.junit.Assert;
import org.junit.Test;

public class TestQueuePath {
    private static final String TEST_QUEUE = "root.level_1.level_2.level_3";
    private static final QueuePath TEST_QUEUE_PATH = new QueuePath("root.level_1.level_2.level_3");
    private static final QueuePath QUEUE_PATH_WITH_EMPTY_PART = new QueuePath("root..level_2");
    private static final QueuePath QUEUE_PATH_WITH_EMPTY_LEAF = new QueuePath("root.level_1.");
    private static final QueuePath ROOT_PATH = new QueuePath("root");
    private static final QueuePath EMPTY_PATH = new QueuePath("");
    private static final QueuePath ONE_LEVEL_WILDCARDED_TEST_PATH = new QueuePath("root.level_1.level_2.*");
    private static final QueuePath TWO_LEVEL_WILDCARDED_TEST_PATH = new QueuePath("root.level_1.*.*");
    private static final QueuePath THREE_LEVEL_WILDCARDED_TEST_PATH = new QueuePath("root.*.*.*");

    @Test
    public void testCreation() {
        Assert.assertEquals((Object)TEST_QUEUE, (Object)TEST_QUEUE_PATH.getFullPath());
        Assert.assertEquals((Object)"root.level_1.level_2", (Object)TEST_QUEUE_PATH.getParent());
        Assert.assertEquals((Object)"level_3", (Object)TEST_QUEUE_PATH.getLeafName());
        Assert.assertNull((Object)ROOT_PATH.getParent());
        QueuePath appendedPath = TEST_QUEUE_PATH.createNewLeaf("level_4");
        Assert.assertEquals((Object)"root.level_1.level_2.level_3.level_4", (Object)appendedPath.getFullPath());
        Assert.assertEquals((Object)TEST_QUEUE, (Object)appendedPath.getParent());
        Assert.assertEquals((Object)"level_4", (Object)appendedPath.getLeafName());
    }

    @Test
    public void testEmptyPart() {
        Assert.assertTrue((boolean)QUEUE_PATH_WITH_EMPTY_PART.hasEmptyPart());
        Assert.assertTrue((boolean)QUEUE_PATH_WITH_EMPTY_LEAF.hasEmptyPart());
        Assert.assertFalse((boolean)TEST_QUEUE_PATH.hasEmptyPart());
    }

    @Test
    public void testNullPath() {
        QueuePath queuePathWithNullPath = new QueuePath(null);
        Assert.assertNull((Object)queuePathWithNullPath.getParent());
        Assert.assertEquals((Object)"", (Object)queuePathWithNullPath.getLeafName());
        Assert.assertEquals((Object)"", (Object)queuePathWithNullPath.getFullPath());
        Assert.assertFalse((boolean)queuePathWithNullPath.isRoot());
    }

    @Test
    public void testIterator() {
        ImmutableList queuePathCollection = ImmutableList.copyOf((Iterator)TEST_QUEUE_PATH.iterator());
        ImmutableList queuePathWithEmptyPartCollection = ImmutableList.copyOf((Iterator)QUEUE_PATH_WITH_EMPTY_PART.iterator());
        ImmutableList rootPathCollection = ImmutableList.copyOf((Iterator)ROOT_PATH.iterator());
        Assert.assertEquals((long)4L, (long)queuePathCollection.size());
        Assert.assertEquals((Object)"root", queuePathCollection.get(0));
        Assert.assertEquals((Object)"level_3", queuePathCollection.get(3));
        Assert.assertEquals((long)3L, (long)queuePathWithEmptyPartCollection.size());
        Assert.assertEquals((Object)"root", queuePathWithEmptyPartCollection.get(0));
        Assert.assertEquals((Object)"level_2", queuePathWithEmptyPartCollection.get(2));
        Assert.assertEquals((long)1L, (long)rootPathCollection.size());
        Assert.assertEquals((Object)"root", rootPathCollection.get(0));
    }

    @Test
    public void testReversePathIterator() {
        ImmutableList queuePathCollection = ImmutableList.copyOf((Iterator)TEST_QUEUE_PATH.reverseIterator());
        ImmutableList queuePathWithEmptyPartCollection = ImmutableList.copyOf((Iterator)QUEUE_PATH_WITH_EMPTY_PART.reverseIterator());
        ImmutableList rootPathCollection = ImmutableList.copyOf((Iterator)ROOT_PATH.reverseIterator());
        Assert.assertEquals((long)4L, (long)queuePathCollection.size());
        Assert.assertEquals((Object)"root", queuePathCollection.get(3));
        Assert.assertEquals((Object)TEST_QUEUE, queuePathCollection.get(0));
        Assert.assertEquals((long)3L, (long)queuePathWithEmptyPartCollection.size());
        Assert.assertEquals((Object)"root", queuePathWithEmptyPartCollection.get(2));
        Assert.assertEquals((Object)"root..level_2", queuePathWithEmptyPartCollection.get(0));
        Assert.assertEquals((long)1L, (long)rootPathCollection.size());
        Assert.assertEquals((Object)"root", rootPathCollection.get(0));
    }

    @Test
    public void testEquals() {
        QueuePath queuePath = new QueuePath(TEST_QUEUE);
        QueuePath queuePathSame = new QueuePath(TEST_QUEUE);
        QueuePath empty = new QueuePath("");
        QueuePath emptySame = new QueuePath("");
        Assert.assertEquals((Object)queuePath, (Object)queuePathSame);
        Assert.assertEquals((Object)empty, (Object)emptySame);
        Assert.assertNotEquals(null, (Object)queuePath);
    }

    @Test
    public void testInvalidPath() {
        Assert.assertFalse((boolean)TEST_QUEUE_PATH.isInvalid());
        Assert.assertFalse((boolean)ROOT_PATH.isInvalid());
        Assert.assertTrue((boolean)EMPTY_PATH.isInvalid());
        Assert.assertTrue((boolean)new QueuePath("invalidPath").isInvalid());
    }

    @Test
    public void testGetParentObject() {
        Assert.assertEquals((Object)new QueuePath("root.level_1.level_2"), (Object)TEST_QUEUE_PATH.getParentObject());
        Assert.assertEquals((Object)ROOT_PATH, (Object)new QueuePath("root.level_1").getParentObject());
        Assert.assertNull((Object)ROOT_PATH.getParentObject());
    }

    @Test
    public void testGetPathComponents() {
        Assert.assertArrayEquals((Object[])TEST_QUEUE_PATH.getPathComponents(), (Object[])new String[]{"root", "level_1", "level_2", "level_3"});
        Assert.assertArrayEquals((Object[])ROOT_PATH.getPathComponents(), (Object[])new String[]{"root"});
        Assert.assertArrayEquals((Object[])EMPTY_PATH.getPathComponents(), (Object[])new String[]{""});
    }

    @Test
    public void testWildcardedQueuePathsWithOneLevelWildCard() {
        int maxAutoCreatedQueueDepth = 1;
        ArrayList<QueuePath> expectedPaths = new ArrayList<QueuePath>();
        expectedPaths.add(TEST_QUEUE_PATH);
        expectedPaths.add(ONE_LEVEL_WILDCARDED_TEST_PATH);
        List wildcardedPaths = TEST_QUEUE_PATH.getWildcardedQueuePaths(maxAutoCreatedQueueDepth);
        Assert.assertEquals(expectedPaths, (Object)wildcardedPaths);
    }

    @Test
    public void testWildcardedQueuePathsWithTwoLevelWildCard() {
        int maxAutoCreatedQueueDepth = 2;
        ArrayList<QueuePath> expectedPaths = new ArrayList<QueuePath>();
        expectedPaths.add(TEST_QUEUE_PATH);
        expectedPaths.add(ONE_LEVEL_WILDCARDED_TEST_PATH);
        expectedPaths.add(TWO_LEVEL_WILDCARDED_TEST_PATH);
        List wildcardedPaths = TEST_QUEUE_PATH.getWildcardedQueuePaths(maxAutoCreatedQueueDepth);
        Assert.assertEquals(expectedPaths, (Object)wildcardedPaths);
    }

    @Test
    public void testWildcardedQueuePathsWithThreeLevelWildCard() {
        int maxAutoCreatedQueueDepth = 3;
        ArrayList<QueuePath> expectedPaths = new ArrayList<QueuePath>();
        expectedPaths.add(TEST_QUEUE_PATH);
        expectedPaths.add(ONE_LEVEL_WILDCARDED_TEST_PATH);
        expectedPaths.add(TWO_LEVEL_WILDCARDED_TEST_PATH);
        expectedPaths.add(THREE_LEVEL_WILDCARDED_TEST_PATH);
        List wildcardedPaths = TEST_QUEUE_PATH.getWildcardedQueuePaths(maxAutoCreatedQueueDepth);
        Assert.assertEquals(expectedPaths, (Object)wildcardedPaths);
    }

    @Test
    public void testWildcardingWhenMaxACQDepthIsGreaterThanQueuePathDepth() {
        int maxAutoCreatedQueueDepth = 4;
        ArrayList<QueuePath> expectedPaths = new ArrayList<QueuePath>();
        expectedPaths.add(TEST_QUEUE_PATH);
        expectedPaths.add(ONE_LEVEL_WILDCARDED_TEST_PATH);
        expectedPaths.add(TWO_LEVEL_WILDCARDED_TEST_PATH);
        expectedPaths.add(THREE_LEVEL_WILDCARDED_TEST_PATH);
        List wildcardedPaths = TEST_QUEUE_PATH.getWildcardedQueuePaths(maxAutoCreatedQueueDepth);
        Assert.assertEquals(expectedPaths, (Object)wildcardedPaths);
    }

    @Test
    public void testWildcardedQueuePathsWithRootPath() {
        int maxAutoCreatedQueueDepth = 1;
        ArrayList<QueuePath> expectedPaths = new ArrayList<QueuePath>();
        expectedPaths.add(ROOT_PATH);
        List wildcardedPaths = ROOT_PATH.getWildcardedQueuePaths(maxAutoCreatedQueueDepth);
        Assert.assertEquals(expectedPaths, (Object)wildcardedPaths);
    }
}

