/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceOperations;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePrefixes;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.policy.PriorityUtilizationQueueOrderingPolicy;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestQueueParsing {
    private static final Logger LOG = LoggerFactory.getLogger(TestQueueParsing.class);
    private static final String A_PATH = "root.a";
    private static final String B_PATH = "root.b";
    private static final String C_PATH = "root.c";
    private static final String A1_PATH = "root.a.a1";
    private static final String A2_PATH = "root.a.a2";
    private static final String B1_PATH = "root.b.b1";
    private static final String B2_PATH = "root.b.b2";
    private static final String B3_PATH = "root.b.b3";
    private static final String B4_PATH = "root.b.b4";
    private static final String C1_PATH = "root.c.c1";
    private static final String C2_PATH = "root.c.c2";
    private static final String C3_PATH = "root.c.c3";
    private static final String C4_PATH = "root.c.c4";
    private static final String C11_PATH = "root.c.c1.c11";
    private static final String C12_PATH = "root.c.c1.c12";
    private static final String C13_PATH = "root.c.c1.c13";
    private static final String AX_PATH = "root.a.x";
    private static final String AY_PATH = "root.a.y";
    private static final String X_PATH = "root.x";
    private static final QueuePath ROOT = new QueuePath("root");
    private static final QueuePath A = new QueuePath("root.a");
    private static final QueuePath B = new QueuePath("root.b");
    private static final QueuePath C = new QueuePath("root.c");
    private static final QueuePath A1 = new QueuePath("root.a.a1");
    private static final QueuePath A2 = new QueuePath("root.a.a2");
    private static final QueuePath B1 = new QueuePath("root.b.b1");
    private static final QueuePath B2 = new QueuePath("root.b.b2");
    private static final QueuePath B3 = new QueuePath("root.b.b3");
    private static final QueuePath B4 = new QueuePath("root.b.b4");
    private static final QueuePath C1 = new QueuePath("root.c.c1");
    private static final QueuePath C2 = new QueuePath("root.c.c2");
    private static final QueuePath C3 = new QueuePath("root.c.c3");
    private static final QueuePath C4 = new QueuePath("root.c.c4");
    private static final QueuePath C11 = new QueuePath("root.c.c1.c11");
    private static final QueuePath C12 = new QueuePath("root.c.c1.c12");
    private static final QueuePath C13 = new QueuePath("root.c.c1.c13");
    private static final QueuePath AX = new QueuePath("root.a.x");
    private static final QueuePath AY = new QueuePath("root.a.y");
    private static final QueuePath X = new QueuePath("root.x");
    private static final double DELTA = 0.001;
    private static final int GB = 1024;
    private RMNodeLabelsManager nodeLabelManager;

    @Before
    public void setup() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        Resource clusterResource = Resources.createResource((int)16384, (int)32);
        this.nodeLabelManager = new NullRMNodeLabelsManager();
        this.nodeLabelManager.init((Configuration)conf);
        ((NullRMNodeLabelsManager)this.nodeLabelManager).setResourceForLabel("", clusterResource);
    }

    private void setupQueueConfiguration(CapacitySchedulerConfiguration conf) {
        conf.setQueues(ROOT, new String[]{"a", "b", "c"});
        conf.setCapacity(A, 10.0f);
        conf.setMaximumCapacity(A, 15.0f);
        conf.setCapacity(B, 20.0f);
        conf.setCapacity(C, 70.0f);
        conf.setMaximumCapacity(C, 70.0f);
        LOG.info("Setup top-level queues");
        conf.setQueues(A, new String[]{"a1", "a2"});
        conf.setCapacity(A1, 30.0f);
        conf.setMaximumCapacity(A1, 45.0f);
        conf.setCapacity(A2, 70.0f);
        conf.setMaximumCapacity(A2, 85.0f);
        conf.setQueues(B, new String[]{"b1", "b2", "b3"});
        conf.setCapacity(B1, 50.0f);
        conf.setMaximumCapacity(B1, 85.0f);
        conf.setCapacity(B2, 30.0f);
        conf.setMaximumCapacity(B2, 35.0f);
        conf.setCapacity(B3, 20.0f);
        conf.setMaximumCapacity(B3, 35.0f);
        conf.setQueues(C, new String[]{"c1", "c2", "c3", "c4"});
        conf.setCapacity(C1, 50.0f);
        conf.setMaximumCapacity(C1, 55.0f);
        conf.setCapacity(C2, 10.0f);
        conf.setMaximumCapacity(C2, 25.0f);
        conf.setCapacity(C3, 35.0f);
        conf.setMaximumCapacity(C3, 38.0f);
        conf.setCapacity(C4, 5.0f);
        conf.setMaximumCapacity(C4, 5.0f);
        LOG.info("Setup 2nd-level queues");
        conf.setQueues(C1, new String[]{"c11", "c12", "c13"});
        conf.setCapacity(C11, 15.0f);
        conf.setMaximumCapacity(C11, 30.0f);
        conf.setCapacity(C12, 45.0f);
        conf.setMaximumCapacity(C12, 70.0f);
        conf.setCapacity(C13, 40.0f);
        conf.setMaximumCapacity(C13, 40.0f);
        LOG.info("Setup 3rd-level queues");
    }

    private void setupQueueConfigurationWithSpacesShouldBeTrimmed(CapacitySchedulerConfiguration conf) {
        conf.set(QueuePrefixes.getQueuePrefix((QueuePath)ROOT) + "queues", " a ,b, c");
        conf.setCapacity(A, 10.0f);
        conf.setMaximumCapacity(A, 15.0f);
        conf.setCapacity(B, 20.0f);
        conf.setCapacity(C, 70.0f);
        conf.setMaximumCapacity(C, 70.0f);
    }

    private void setupNestedQueueConfigurationWithSpacesShouldBeTrimmed(CapacitySchedulerConfiguration conf) {
        conf.set(QueuePrefixes.getQueuePrefix((QueuePath)ROOT) + "queues", " a ,b, c");
        conf.setCapacity(A, 10.0f);
        conf.setMaximumCapacity(A, 15.0f);
        conf.setCapacity(B, 20.0f);
        conf.setCapacity(C, 70.0f);
        conf.setMaximumCapacity(C, 70.0f);
        conf.set(QueuePrefixes.getQueuePrefix((QueuePath)A) + "queues", "a1, a2 ");
        conf.setCapacity(A1, 60.0f);
        conf.setCapacity(A2, 40.0f);
    }

    private void setupQueueConfigurationWithoutLabels(CapacitySchedulerConfiguration conf) {
        conf.setQueues(ROOT, new String[]{"a", "b"});
        conf.setCapacity(A, 10.0f);
        conf.setMaximumCapacity(A, 15.0f);
        conf.setCapacity(B, 90.0f);
        LOG.info("Setup top-level queues");
        conf.setQueues(A, new String[]{"a1", "a2"});
        conf.setCapacity(A1, 30.0f);
        conf.setMaximumCapacity(A1, 45.0f);
        conf.setCapacity(A2, 70.0f);
        conf.setMaximumCapacity(A2, 85.0f);
        conf.setQueues(B, new String[]{"b1", "b2", "b3"});
        conf.setCapacity(B1, 50.0f);
        conf.setMaximumCapacity(B1, 85.0f);
        conf.setCapacity(B2, 30.0f);
        conf.setMaximumCapacity(B2, 35.0f);
        conf.setCapacity(B3, 20.0f);
        conf.setMaximumCapacity(B3, 35.0f);
    }

    private void setupQueueConfigurationWithLabels(CapacitySchedulerConfiguration conf) {
        conf.setQueues(ROOT, new String[]{"a", "b"});
        conf.setCapacityByLabel(ROOT, "red", 100.0f);
        conf.setCapacityByLabel(ROOT, "blue", 100.0f);
        conf.setCapacity(A, 10.0f);
        conf.setMaximumCapacity(A, 15.0f);
        conf.setCapacity(B, 90.0f);
        LOG.info("Setup top-level queues");
        conf.setQueues(A, new String[]{"a1", "a2"});
        conf.setAccessibleNodeLabels(A, (Set)ImmutableSet.of((Object)"red", (Object)"blue"));
        conf.setCapacityByLabel(A, "red", 50.0f);
        conf.setMaximumCapacityByLabel(A, "red", 50.0f);
        conf.setCapacityByLabel(A, "blue", 50.0f);
        conf.setCapacity(A1, 30.0f);
        conf.setMaximumCapacity(A1, 45.0f);
        conf.setCapacityByLabel(A1, "red", 50.0f);
        conf.setCapacityByLabel(A1, "blue", 100.0f);
        conf.setCapacity(A2, 70.0f);
        conf.setMaximumCapacity(A2, 85.0f);
        conf.setAccessibleNodeLabels(A2, (Set)ImmutableSet.of((Object)"red"));
        conf.setCapacityByLabel(A2, "red", 50.0f);
        conf.setMaximumCapacityByLabel(A2, "red", 60.0f);
        conf.setQueues(B, new String[]{"b1", "b2", "b3"});
        conf.setAccessibleNodeLabels(B, (Set)ImmutableSet.of((Object)"red", (Object)"blue"));
        conf.setCapacityByLabel(B, "red", 50.0f);
        conf.setCapacityByLabel(B, "blue", 50.0f);
        conf.setCapacity(B1, 50.0f);
        conf.setMaximumCapacity(B1, 85.0f);
        conf.setCapacityByLabel(B1, "red", 50.0f);
        conf.setCapacityByLabel(B1, "blue", 50.0f);
        conf.setCapacity(B2, 30.0f);
        conf.setMaximumCapacity(B2, 35.0f);
        conf.setCapacityByLabel(B2, "red", 25.0f);
        conf.setCapacityByLabel(B2, "blue", 25.0f);
        conf.setCapacity(B3, 20.0f);
        conf.setMaximumCapacity(B3, 35.0f);
        conf.setCapacityByLabel(B3, "red", 25.0f);
        conf.setCapacityByLabel(B3, "blue", 25.0f);
    }

    private void setupQueueConfigurationWithLabelsAndReleaseCheck(CapacitySchedulerConfiguration conf) {
        conf.setQueues(ROOT, new String[]{"a", "b"});
        conf.setCapacityByLabel(ROOT, "red", 100.0f);
        conf.setCapacityByLabel(ROOT, "blue", 100.0f);
        conf.setCapacity(A, 50.0f);
        conf.setMaximumCapacity(A, 100.0f);
        conf.setCapacity(B, 50.0f);
        conf.setMaximumCapacity(B, 100.0f);
        LOG.info("Setup top-level queues");
        conf.setQueues(A, new String[]{"a1", "a2"});
        conf.setAccessibleNodeLabels(A, (Set)ImmutableSet.of((Object)"red", (Object)"blue"));
        conf.setCapacityByLabel(A, "red", 50.0f);
        conf.setMaximumCapacityByLabel(A, "red", 100.0f);
        conf.setCapacityByLabel(A, "blue", 30.0f);
        conf.setMaximumCapacityByLabel(A, "blue", 50.0f);
        conf.setCapacity(A1, 60.0f);
        conf.setMaximumCapacity(A1, 60.0f);
        conf.setCapacityByLabel(A1, "red", 60.0f);
        conf.setMaximumCapacityByLabel(A1, "red", 30.0f);
        conf.setCapacityByLabel(A1, "blue", 100.0f);
        conf.setMaximumCapacityByLabel(A1, "blue", 100.0f);
        conf.setCapacity(A2, 40.0f);
        conf.setMaximumCapacity(A2, 85.0f);
        conf.setAccessibleNodeLabels(A2, (Set)ImmutableSet.of((Object)"red"));
        conf.setCapacityByLabel(A2, "red", 40.0f);
        conf.setMaximumCapacityByLabel(A2, "red", 60.0f);
        conf.setQueues(B, new String[]{"b1", "b2", "b3"});
        conf.setAccessibleNodeLabels(B, (Set)ImmutableSet.of((Object)"red", (Object)"blue"));
        conf.setCapacityByLabel(B, "red", 50.0f);
        conf.setMaximumCapacityByLabel(B, "red", 100.0f);
        conf.setCapacityByLabel(B, "blue", 70.0f);
        conf.setMaximumCapacityByLabel(B, "blue", 100.0f);
        conf.setCapacity(B1, 10.0f);
        conf.setMaximumCapacity(B1, 10.0f);
        conf.setCapacityByLabel(B1, "red", 60.0f);
        conf.setMaximumCapacityByLabel(B1, "red", 30.0f);
        conf.setCapacityByLabel(B1, "blue", 50.0f);
        conf.setMaximumCapacityByLabel(B1, "blue", 100.0f);
        conf.setCapacity(B2, 80.0f);
        conf.setMaximumCapacity(B2, 40.0f);
        conf.setCapacityByLabel(B2, "red", 30.0f);
        conf.setCapacityByLabel(B2, "blue", 25.0f);
        conf.setCapacity(B3, 10.0f);
        conf.setMaximumCapacity(B3, 25.0f);
        conf.setCapacityByLabel(B3, "red", 10.0f);
        conf.setCapacityByLabel(B3, "blue", 25.0f);
    }

    private void setupQueueConfigurationWithLabelsInherit(CapacitySchedulerConfiguration conf) {
        conf.setQueues(ROOT, new String[]{"a", "b"});
        conf.setCapacityByLabel(ROOT, "red", 100.0f);
        conf.setCapacityByLabel(ROOT, "blue", 100.0f);
        conf.setCapacity(A, 10.0f);
        conf.setMaximumCapacity(A, 15.0f);
        conf.setQueues(A, new String[]{"a1", "a2"});
        conf.setAccessibleNodeLabels(A, (Set)ImmutableSet.of((Object)"red", (Object)"blue"));
        conf.setCapacityByLabel(A, "red", 100.0f);
        conf.setCapacityByLabel(A, "blue", 100.0f);
        conf.setCapacity(B, 90.0f);
        conf.setAccessibleNodeLabels(B, CommonNodeLabelsManager.EMPTY_STRING_SET);
        conf.setCapacity(A1, 30.0f);
        conf.setMaximumCapacity(A1, 45.0f);
        conf.setCapacityByLabel(A1, "red", 50.0f);
        conf.setCapacityByLabel(A1, "blue", 100.0f);
        conf.setCapacity(A2, 70.0f);
        conf.setMaximumCapacity(A2, 85.0f);
        conf.setAccessibleNodeLabels(A2, (Set)ImmutableSet.of((Object)"red"));
        conf.setCapacityByLabel(A2, "red", 50.0f);
    }

    private void setupQueueConfigurationWithSingleLevel(CapacitySchedulerConfiguration conf) {
        conf.setQueues(ROOT, new String[]{"a", "b"});
        conf.setCapacity(A, 10.0f);
        conf.setMaximumCapacity(A, 15.0f);
        conf.setAccessibleNodeLabels(A, (Set)ImmutableSet.of((Object)"red", (Object)"blue"));
        conf.setCapacityByLabel(A, "red", 90.0f);
        conf.setCapacityByLabel(A, "blue", 90.0f);
        conf.setCapacity(B, 90.0f);
        conf.setAccessibleNodeLabels(B, (Set)ImmutableSet.of((Object)"red", (Object)"blue"));
        conf.setCapacityByLabel(B, "red", 10.0f);
        conf.setCapacityByLabel(B, "blue", 10.0f);
    }

    public MockRM createMockRMWithoutLabels(YarnConfiguration conf) throws Exception {
        return this.createMockRMWithLabels(conf, Collections.emptySet());
    }

    public MockRM createMockRMWithLabels(YarnConfiguration conf, Set<String> nodeLabels) throws Exception {
        this.nodeLabelManager.addToCluserNodeLabelsWithDefaultExclusivity(nodeLabels);
        HashMap<NodeId, Set<String>> nodeIdMap = new HashMap<NodeId, Set<String>>();
        int i = 0;
        for (String label : nodeLabels) {
            nodeIdMap.put(NodeId.newInstance((String)("h" + ++i), (int)0), TestUtils.toSet(label));
        }
        this.nodeLabelManager.addLabelsToNode(nodeIdMap);
        MockRM rm = new MockRM((Configuration)conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return TestQueueParsing.this.nodeLabelManager;
            }
        };
        rm.getRMContext().setNodeLabelManager(this.nodeLabelManager);
        rm.start();
        for (NodeId key : nodeIdMap.keySet()) {
            rm.registerNode(key.toString(), 8192);
        }
        return rm;
    }

    @Test
    public void testQueueParsing() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithoutLabels(conf);
        CapacityScheduler capacityScheduler = (CapacityScheduler)rm.getResourceScheduler();
        CSQueue a = capacityScheduler.getQueue("a");
        Assert.assertEquals((double)0.1, (double)a.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.15, (double)a.getAbsoluteMaximumCapacity(), (double)0.001);
        CSQueue b1 = capacityScheduler.getQueue("b1");
        Assert.assertEquals((double)0.1, (double)b1.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((String)"Parent B has no MAX_CAP", (double)0.85, (double)b1.getAbsoluteMaximumCapacity(), (double)0.001);
        CSQueue c12 = capacityScheduler.getQueue("c12");
        Assert.assertEquals((double)0.1575, (double)c12.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.26949999999999996, (double)c12.getAbsoluteMaximumCapacity(), (double)0.001);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRootQueueParsing() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setCapacity(ROOT, 90.0f);
    }

    @Test
    public void testQueueParsingReinitializeWithLabels() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfigurationWithoutLabels(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithLabels(conf, (Set<String>)ImmutableSet.of((Object)"red", (Object)"blue"));
        CapacityScheduler capacityScheduler = (CapacityScheduler)rm.getResourceScheduler();
        csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfigurationWithLabels(csConf);
        conf = new YarnConfiguration((Configuration)csConf);
        capacityScheduler.reinitialize((Configuration)conf, rm.getRMContext());
        this.checkQueueLabels(capacityScheduler);
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test
    public void testQueueParsingWithLabels() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfigurationWithLabels(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithLabels(conf, (Set<String>)ImmutableSet.of((Object)"red", (Object)"blue"));
        CapacityScheduler capacityScheduler = (CapacityScheduler)rm.getResourceScheduler();
        this.checkQueueLabels(capacityScheduler);
        ServiceOperations.stopQuietly((Service)rm);
    }

    private void checkQueueLabels(CapacityScheduler capacityScheduler) {
        Assert.assertTrue((boolean)capacityScheduler.getQueue("a").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        Assert.assertTrue((boolean)capacityScheduler.getQueue("a1").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        Assert.assertEquals((long)1L, (long)capacityScheduler.getQueue("a2").getAccessibleNodeLabels().size());
        Assert.assertTrue((boolean)capacityScheduler.getQueue("a2").getAccessibleNodeLabels().contains("red"));
        Assert.assertTrue((boolean)capacityScheduler.getQueue("b").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        Assert.assertTrue((boolean)capacityScheduler.getQueue("b2").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        CSQueue qA2 = capacityScheduler.getQueue("a2");
        Assert.assertEquals((double)0.7, (double)qA2.getCapacity(), (double)0.001);
        Assert.assertEquals((double)0.5, (double)qA2.getQueueCapacities().getCapacity("red"), (double)0.001);
        Assert.assertEquals((double)0.07, (double)qA2.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.25, (double)qA2.getQueueCapacities().getAbsoluteCapacity("red"), (double)0.001);
        Assert.assertEquals((double)0.1275, (double)qA2.getAbsoluteMaximumCapacity(), (double)0.001);
        Assert.assertEquals((double)0.3, (double)qA2.getQueueCapacities().getAbsoluteMaximumCapacity("red"), (double)0.001);
        CSQueue qB3 = capacityScheduler.getQueue("b3");
        Assert.assertEquals((double)0.18, (double)qB3.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.125, (double)qB3.getQueueCapacities().getAbsoluteCapacity("red"), (double)0.001);
        Assert.assertEquals((double)0.35, (double)qB3.getAbsoluteMaximumCapacity(), (double)0.001);
        Assert.assertEquals((double)1.0, (double)qB3.getQueueCapacities().getAbsoluteMaximumCapacity("red"), (double)0.001);
    }

    @Test
    public void testQueueParsingWithLeafQueueDisableElasticity() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfigurationWithLabelsAndReleaseCheck(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithLabels(conf, (Set<String>)ImmutableSet.of((Object)"red", (Object)"blue"));
        CapacityScheduler capacityScheduler = (CapacityScheduler)rm.getResourceScheduler();
        this.checkQueueLabelsWithLeafQueueDisableElasticity(capacityScheduler);
        ServiceOperations.stopQuietly((Service)rm);
    }

    private void checkQueueLabelsWithLeafQueueDisableElasticity(CapacityScheduler capacityScheduler) {
        Assert.assertTrue((boolean)capacityScheduler.getQueue("a").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        Assert.assertTrue((boolean)capacityScheduler.getQueue("a1").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        Assert.assertEquals((long)1L, (long)capacityScheduler.getQueue("a2").getAccessibleNodeLabels().size());
        Assert.assertTrue((boolean)capacityScheduler.getQueue("a2").getAccessibleNodeLabels().contains("red"));
        Assert.assertTrue((boolean)capacityScheduler.getQueue("b").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        Assert.assertTrue((boolean)capacityScheduler.getQueue("b2").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        CSQueue qA2 = capacityScheduler.getQueue("a2");
        Assert.assertEquals((double)0.4, (double)qA2.getCapacity(), (double)0.001);
        Assert.assertEquals((double)0.4, (double)qA2.getQueueCapacities().getCapacity("red"), (double)0.001);
        Assert.assertEquals((double)0.2, (double)qA2.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.2, (double)qA2.getQueueCapacities().getAbsoluteCapacity("red"), (double)0.001);
        Assert.assertEquals((double)0.85, (double)qA2.getAbsoluteMaximumCapacity(), (double)0.001);
        Assert.assertEquals((double)0.6, (double)qA2.getQueueCapacities().getAbsoluteMaximumCapacity("red"), (double)0.001);
        CSQueue qB2 = capacityScheduler.getQueue("b2");
        Assert.assertEquals((double)0.4, (double)qB2.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.4, (double)qB2.getAbsoluteMaximumCapacity(), (double)0.001);
        CSQueue qA1 = capacityScheduler.getQueue("a1");
        Assert.assertEquals((double)0.3, (double)qA1.getQueueCapacities().getAbsoluteCapacity("red"), (double)0.001);
        Assert.assertEquals((double)0.3, (double)qA1.getQueueCapacities().getAbsoluteMaximumCapacity("red"), (double)0.001);
        CSQueue qB1 = capacityScheduler.getQueue("b1");
        Assert.assertEquals((double)0.3, (double)qB1.getQueueCapacities().getAbsoluteCapacity("red"), (double)0.001);
        Assert.assertEquals((double)0.3, (double)qB1.getQueueCapacities().getAbsoluteMaximumCapacity("red"), (double)0.001);
        CSQueue qB3 = capacityScheduler.getQueue("b3");
        Assert.assertEquals((double)0.05, (double)qB3.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.175, (double)qB3.getQueueCapacities().getAbsoluteCapacity("blue"), (double)0.001);
        Assert.assertEquals((double)0.25, (double)qB3.getAbsoluteMaximumCapacity(), (double)0.001);
        Assert.assertEquals((double)1.0, (double)qB3.getQueueCapacities().getAbsoluteMaximumCapacity("blue"), (double)0.001);
    }

    @Test
    public void testQueueParsingWithLabelsInherit() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfigurationWithLabelsInherit(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithLabels(conf, (Set<String>)ImmutableSet.of((Object)"red", (Object)"blue"));
        CapacityScheduler capacityScheduler = (CapacityScheduler)rm.getResourceScheduler();
        this.checkQueueLabelsInheritConfig(capacityScheduler);
        ServiceOperations.stopQuietly((Service)rm);
    }

    private void checkQueueLabelsInheritConfig(CapacityScheduler capacityScheduler) {
        Assert.assertTrue((boolean)capacityScheduler.getQueue("a").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        Assert.assertTrue((boolean)capacityScheduler.getQueue("a1").getAccessibleNodeLabels().containsAll((Collection<?>)ImmutableSet.of((Object)"red", (Object)"blue")));
        Assert.assertEquals((long)1L, (long)capacityScheduler.getQueue("a2").getAccessibleNodeLabels().size());
        Assert.assertTrue((boolean)capacityScheduler.getQueue("a2").getAccessibleNodeLabels().contains("red"));
        Assert.assertTrue((boolean)capacityScheduler.getQueue("b").getAccessibleNodeLabels().isEmpty());
    }

    @Test
    public void testQueueParsingWhenLabelsNotExistedInNodeLabelManager() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfigurationWithLabels(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithoutLabels(conf);
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test
    public void testQueueParsingWhenLabelsInheritedNotExistedInNodeLabelManager() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfigurationWithLabelsInherit(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithoutLabels(conf);
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test
    public void testSingleLevelQueueParsingWhenLabelsNotExistedInNodeLabelManager() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfigurationWithSingleLevel(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithoutLabels(conf);
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test
    public void testQueueParsingWhenLabelsNotExist() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfigurationWithLabels(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithoutLabels(conf);
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test
    public void testQueueParsingWithUnusedLabels() throws Exception {
        ImmutableSet labels = ImmutableSet.of((Object)"red", (Object)"blue");
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(csConf);
        csConf.setAccessibleNodeLabels(ROOT, (Set)labels);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithLabels(conf, (Set<String>)labels);
        CapacityScheduler capacityScheduler = (CapacityScheduler)rm.getResourceScheduler();
        capacityScheduler.reinitialize((Configuration)csConf, rm.getRMContext());
        CSQueue root = capacityScheduler.getQueue("root");
        Assert.assertEquals((double)0.0, (double)root.getQueueCapacities().getCapacity("red"), (double)0.001);
        Assert.assertEquals((double)0.0, (double)root.getQueueCapacities().getCapacity("blue"), (double)0.001);
        CSQueue a = capacityScheduler.getQueue("a");
        Assert.assertEquals((double)0.1, (double)a.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.15, (double)a.getAbsoluteMaximumCapacity(), (double)0.001);
        CSQueue b1 = capacityScheduler.getQueue("b1");
        Assert.assertEquals((double)0.1, (double)b1.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((String)"Parent B has no MAX_CAP", (double)0.85, (double)b1.getAbsoluteMaximumCapacity(), (double)0.001);
        CSQueue c12 = capacityScheduler.getQueue("c12");
        Assert.assertEquals((double)0.1575, (double)c12.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.26949999999999996, (double)c12.getAbsoluteMaximumCapacity(), (double)0.001);
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test
    public void testQueueParsingShouldTrimSpaces() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfigurationWithSpacesShouldBeTrimmed(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithoutLabels(conf);
        CapacityScheduler capacityScheduler = (CapacityScheduler)rm.getResourceScheduler();
        CSQueue a = capacityScheduler.getQueue("a");
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((double)0.1, (double)a.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.15, (double)a.getAbsoluteMaximumCapacity(), (double)0.001);
        CSQueue c = capacityScheduler.getQueue("c");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((double)0.7, (double)c.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.7, (double)c.getAbsoluteMaximumCapacity(), (double)0.001);
    }

    @Test
    public void testNestedQueueParsingShouldTrimSpaces() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupNestedQueueConfigurationWithSpacesShouldBeTrimmed(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithoutLabels(conf);
        CapacityScheduler capacityScheduler = (CapacityScheduler)rm.getResourceScheduler();
        CSQueue a = capacityScheduler.getQueue("a");
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((double)0.1, (double)a.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.15, (double)a.getAbsoluteMaximumCapacity(), (double)0.001);
        CSQueue c = capacityScheduler.getQueue("c");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((double)0.7, (double)c.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.7, (double)c.getAbsoluteMaximumCapacity(), (double)0.001);
        CSQueue a1 = capacityScheduler.getQueue("a1");
        Assert.assertNotNull((Object)a1);
        Assert.assertEquals((double)0.06, (double)a1.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.15, (double)a1.getAbsoluteMaximumCapacity(), (double)0.001);
        CSQueue a2 = capacityScheduler.getQueue("a2");
        Assert.assertNotNull((Object)a2);
        Assert.assertEquals((double)0.04000000000000001, (double)a2.getAbsoluteCapacity(), (double)0.001);
        Assert.assertEquals((double)0.15, (double)a2.getAbsoluteMaximumCapacity(), (double)0.001);
    }

    @Test(expected=ServiceStateException.class)
    public void testQueueParsingFailWhenSumOfChildrenNonLabeledCapacityNot100Percent() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        Assume.assumeThat((Object)csConf.isLegacyQueueMode(), (Matcher)CoreMatchers.is((Object)true));
        this.setupQueueConfiguration(csConf);
        csConf.setCapacity(C2, 5.0f);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithLabels(conf, (Set<String>)ImmutableSet.of((Object)"red", (Object)"blue"));
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test(expected=ServiceStateException.class)
    public void testQueueParsingFailWhenSumOfChildrenLabeledCapacityNot100Percent() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        Assume.assumeThat((Object)csConf.isLegacyQueueMode(), (Matcher)CoreMatchers.is((Object)true));
        this.setupQueueConfigurationWithLabels(csConf);
        csConf.setCapacityByLabel(B3, "red", 24.0f);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithLabels(conf, (Set<String>)ImmutableSet.of((Object)"red", (Object)"blue"));
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test(expected=ServiceStateException.class)
    public void testQueueParsingWithSumOfChildLabelCapacityNot100PercentWithWildCard() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        Assume.assumeThat((Object)csConf.isLegacyQueueMode(), (Matcher)CoreMatchers.is((Object)true));
        this.setupQueueConfigurationWithLabels(csConf);
        csConf.setCapacityByLabel(B3, "red", 24.0f);
        csConf.setAccessibleNodeLabels(ROOT, (Set)ImmutableSet.of((Object)"*"));
        csConf.setAccessibleNodeLabels(B, (Set)ImmutableSet.of((Object)"*"));
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithLabels(conf, (Set<String>)ImmutableSet.of((Object)"red", (Object)"blue"));
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test(expected=IOException.class)
    public void testQueueParsingWithMoveQueue() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues(ROOT, new String[]{"a"});
        csConf.setQueues(A, new String[]{"x", "y"});
        csConf.setCapacity(A, 100.0f);
        csConf.setCapacity(AX, 50.0f);
        csConf.setCapacity(AY, 50.0f);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithoutLabels(conf);
        CapacityScheduler capacityScheduler = (CapacityScheduler)rm.getResourceScheduler();
        csConf.setQueues(ROOT, new String[]{"a", "x"});
        csConf.setQueues(A, new String[]{"y"});
        csConf.setCapacity(X, 50.0f);
        csConf.setCapacity(A, 50.0f);
        csConf.setCapacity(AY, 100.0f);
        capacityScheduler.reinitialize((Configuration)csConf, rm.getRMContext());
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test(timeout=60000L, expected=ServiceStateException.class)
    public void testRMStartWrongNodeCapacity() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        ImmutableSet labels = ImmutableSet.of((Object)"x", (Object)"y", (Object)"z");
        Assume.assumeThat((Object)csConf.isLegacyQueueMode(), (Matcher)CoreMatchers.is((Object)true));
        csConf.setQueues(ROOT, new String[]{"a"});
        csConf.setCapacityByLabel(ROOT, "x", 100.0f);
        csConf.setCapacityByLabel(ROOT, "y", 100.0f);
        csConf.setCapacityByLabel(ROOT, "z", 100.0f);
        csConf.setCapacity(A, 100.0f);
        csConf.setAccessibleNodeLabels(A, (Set)labels);
        csConf.setCapacityByLabel(A, "x", 100.0f);
        csConf.setCapacityByLabel(A, "y", 100.0f);
        csConf.setCapacityByLabel(A, "z", 70.0f);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithLabels(conf, (Set<String>)labels);
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test
    public void testQueueOrderingPolicyUpdatedAfterReinitialize() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfigurationWithoutLabels(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithoutLabels(conf);
        CapacityScheduler capacityScheduler = (CapacityScheduler)rm.getResourceScheduler();
        csConf.setQueues(B, new String[]{"b1", "b2", "b3", "b4"});
        csConf.setCapacity(B4, 0.0f);
        ParentQueue bQ = (ParentQueue)capacityScheduler.getQueue("b");
        this.checkEqualsToQueueSet(bQ.getChildQueues(), new String[]{"b1", "b2", "b3"});
        capacityScheduler.reinitialize((Configuration)csConf, rm.getRMContext());
        this.checkEqualsToQueueSet(bQ.getChildQueues(), new String[]{"b1", "b2", "b3", "b4"});
        PriorityUtilizationQueueOrderingPolicy queueOrderingPolicy = (PriorityUtilizationQueueOrderingPolicy)bQ.getQueueOrderingPolicy();
        this.checkEqualsToQueueSet(queueOrderingPolicy.getQueues(), new String[]{"b1", "b2", "b3", "b4"});
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test(timeout=60000L)
    public void testQueueCapacityWithWeight() throws Exception {
        ImmutableSet labels = ImmutableSet.of((Object)"x", (Object)"y", (Object)"z");
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues(ROOT, new String[]{"a"});
        csConf.setLabeledQueueWeight(ROOT, "x", 100.0f);
        csConf.setLabeledQueueWeight(ROOT, "y", 100.0f);
        csConf.setLabeledQueueWeight(ROOT, "z", 100.0f);
        csConf.setNonLabeledQueueWeight(A, 100.0f);
        csConf.setAccessibleNodeLabels(A, (Set)labels);
        csConf.setLabeledQueueWeight(A, "x", 100.0f);
        csConf.setLabeledQueueWeight(A, "y", 100.0f);
        csConf.setLabeledQueueWeight(A, "z", 70.0f);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithLabels(conf, (Set<String>)labels);
        this.verifyQueueAbsCapacity(rm, "root", "", 1.0f);
        this.verifyQueueAbsCapacity(rm, "root", "x", 1.0f);
        this.verifyQueueAbsCapacity(rm, "root", "y", 1.0f);
        this.verifyQueueAbsCapacity(rm, "root", "z", 1.0f);
        this.verifyQueueAbsCapacity(rm, A_PATH, "", 1.0f);
        this.verifyQueueAbsCapacity(rm, A_PATH, "x", 1.0f);
        this.verifyQueueAbsCapacity(rm, A_PATH, "y", 1.0f);
        this.verifyQueueAbsCapacity(rm, A_PATH, "z", 1.0f);
        ServiceOperations.stopQuietly((Service)rm);
    }

    @Test
    public void testQueueParsingWithDefaultUserLimitValues() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        String queueA = A_PATH;
        String queueB = B_PATH;
        csConf.setQueues(ROOT, new String[]{"a", "b"});
        csConf.setDefaultUserLimit(20.0f);
        csConf.setDefaultUserLimitFactor(2.0f);
        csConf.setCapacity(A, 50.0f);
        csConf.setUserLimit(A, 15.0f);
        csConf.setUserLimitFactor(A, 1.5f);
        csConf.setCapacity(B, 50.0f);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        MockRM rm = this.createMockRMWithoutLabels(conf);
        CapacityScheduler capacityScheduler = (CapacityScheduler)rm.getResourceScheduler();
        Assert.assertEquals((double)15.0, (double)((LeafQueue)capacityScheduler.getQueue(A_PATH)).getUserLimit(), (double)0.001);
        Assert.assertEquals((double)1.5, (double)((LeafQueue)capacityScheduler.getQueue(A_PATH)).getUserLimitFactor(), (double)0.001);
        Assert.assertEquals((double)20.0, (double)((LeafQueue)capacityScheduler.getQueue(B_PATH)).getUserLimit(), (double)0.001);
        Assert.assertEquals((double)2.0, (double)((LeafQueue)capacityScheduler.getQueue(B_PATH)).getUserLimitFactor(), (double)0.001);
        csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues(ROOT, new String[]{"a", "b"});
        csConf.setCapacity(A, 50.0f);
        csConf.setUserLimit(A, 15.0f);
        csConf.setUserLimitFactor(A, 1.5f);
        csConf.setCapacity(B, 50.0f);
        capacityScheduler.reinitialize((Configuration)csConf, rm.getRMContext());
        Assert.assertEquals((double)15.0, (double)((LeafQueue)capacityScheduler.getQueue(A_PATH)).getUserLimit(), (double)0.001);
        Assert.assertEquals((double)1.5, (double)((LeafQueue)capacityScheduler.getQueue(A_PATH)).getUserLimitFactor(), (double)0.001);
        Assert.assertEquals((double)100.0, (double)((LeafQueue)capacityScheduler.getQueue(B_PATH)).getUserLimit(), (double)0.001);
        Assert.assertEquals((double)1.0, (double)((LeafQueue)capacityScheduler.getQueue(B_PATH)).getUserLimitFactor(), (double)0.001);
    }

    private void verifyQueueAbsCapacity(MockRM rm, String queuePath, String label, float expectedAbsCapacity) {
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        CSQueue queue = cs.getQueue(queuePath);
        Assert.assertEquals((double)expectedAbsCapacity, (double)queue.getQueueCapacities().getAbsoluteCapacity(label), (double)1.0E-6);
    }

    private void checkEqualsToQueueSet(List<CSQueue> queues, String[] queueNames) {
        HashSet<String> existedQueues = new HashSet<String>();
        for (CSQueue q : queues) {
            existedQueues.add(q.getQueueShortName());
        }
        for (String q : queueNames) {
            Assert.assertTrue((boolean)existedQueues.remove(q));
        }
        Assert.assertTrue((boolean)existedQueues.isEmpty());
    }
}

